/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.operatecenter.pur;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scmc.scmdi.business.helper.PurInfoCalculateHelper;
import kd.scmc.scmdi.form.enumeration.operatecenter.RangeRateEnum;

public class DeliveryTimelyRateCardPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TreeMap rateRangeCounts = new TreeMap();
        Arrays.stream(RangeRateEnum.values()).forEach(rangeRateEnum -> rateRangeCounts.put(rangeRateEnum, 0));
        DataSet timelyReceiptRateData = PurInfoCalculateHelper.getTimelyReceiptRateData();
        while (timelyReceiptRateData.hasNext()) {
            Row next = timelyReceiptRateData.next();
            BigDecimal deliverTimeRate = next.getBigDecimal("delivertimerate");
            Arrays.stream(RangeRateEnum.values()).forEach(rangeRateEnum -> {
                if (rangeRateEnum.applyAlgorithm(deliverTimeRate)) {
                    Integer num = (Integer)rateRangeCounts.get(rangeRateEnum);
                    num = num + 1;
                    rateRangeCounts.put(rangeRateEnum, num);
                }
            });
        }
        List<ItemValue> itemValues = rateRangeCounts.entrySet().stream().map(entry -> new ItemValue(((RangeRateEnum)((Object)((Object)entry.getKey()))).getDescription(), (Number)entry.getValue(), ((RangeRateEnum)((Object)((Object)entry.getKey()))).getColor())).collect(Collectors.toList());
        ItemValue[] itemArray = itemValues.toArray(new ItemValue[0]);
        this.buildPieChart(itemArray);
    }

    private void buildPieChart(ItemValue[] itemValues) {
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        pieChart.clearData();
        pieChart.setMargin(Position.bottom, "0px");
        pieChart.setMargin(Position.left, "0px");
        pieChart.setMargin(Position.right, "0px");
        pieChart.setName(new LocaleString(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u6570%1$s\u5360\u6bd4", (String)"DeliveryTimelyRateCardPlugin_0", (String)"scmc-scmdi-form", (Object[])new Object[0]), "\n")));
        pieChart.setLegendPropValue("right", (Object)0);
        pieChart.setLegendPropValue("top", (Object)"center");
        pieChart.setLegendPropValue("icon", (Object)"circle");
        pieChart.addTooltip("trigger", (Object)"item");
        String triggerTitle = String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u5bb6\u4f9b\u5e94\u5546 | \u5360\u6bd4\uff1a%3$s", (String)"DeliveryTimelyRateCardPlugin_1", (String)"scmc-scmdi-form", (Object[])new Object[0]), "{b}", "<br>{c}", "{d}%");
        pieChart.addTooltip("formatter", (Object)triggerTitle);
        pieChart.setShowTooltip(true);
        pieChart.setTitlePropValue("left", (Object)"center");
        pieChart.setTitlePropValue("top", (Object)"center");
        PieSeries series = pieChart.createSeries("");
        series.setRadius("40%", "60%");
        series.setPropValue("avoidLabelOverlap", (Object)true);
        HashMap labelLine = new HashMap(1);
        HashMap<String, Comparable<Boolean>> normalProperties = new HashMap<String, Comparable<Boolean>>(1);
        normalProperties.put("show", Boolean.valueOf(true));
        normalProperties.put("length", Integer.valueOf(20));
        normalProperties.put("length2", Integer.valueOf(5));
        labelLine.put("normal", normalProperties);
        series.setPropValue("labelLine", labelLine);
        series.setData(itemValues);
    }
}

