/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.operatecenter.pur;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scmc.scmdi.business.helper.PurInfoCalculateHelper;
import kd.scmc.scmdi.common.pojo.AbcAnalysisInfo;

public class MaterialAmountRankingCardPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildBarChart(PurInfoCalculateHelper.queryMaterialABCAnalysisData());
    }

    protected void buildBarChart(List<AbcAnalysisInfo> abcAnalysisInfos) {
        Control barChartAp = this.getView().getControl("barchartap");
        BarChart barChart = null;
        if (barChartAp instanceof BarChart) {
            barChart = (BarChart)barChartAp;
        }
        if (barChart == null) {
            return;
        }
        barChart.clearData();
        List supplierColl = abcAnalysisInfos.stream().limit(10L).collect(Collectors.toList());
        Collections.reverse(supplierColl);
        List materialNameColl = supplierColl.stream().map(AbcAnalysisInfo::getBaseDataName).collect(Collectors.toList());
        List<String> supplierNames = materialNameColl.stream().map(x -> x != null && x.length() > 10 ? x.substring(0, 9) + "..." : x).collect(Collectors.toList());
        this.buildYAxisByNumChart(barChart, supplierNames);
        barChart.setMargin(Position.top, "10%");
        barChart.setMargin(Position.right, "15%");
        barChart.addTooltip("trigger", (Object)"axis");
        HashMap<String, String> axisPointType = new HashMap<String, String>(1);
        axisPointType.put("type", "shadow");
        barChart.addTooltip("axisPointer", axisPointType);
        String format = String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u4e07\u5143", (String)"MaterialAmountRankingCardPlugin_1", (String)"scmc-scmdi-form", (Object[])new Object[0]), "{b}", "<br>{c}");
        barChart.addTooltip("formatter", (Object)format);
        barChart.setShowTooltip(true);
        BarSeries barSeries = barChart.createSeries("");
        for (int i = 0; i < supplierColl.size(); ++i) {
            barSeries.addData(supplierNames.get(i), (Number)((AbcAnalysisInfo)supplierColl.get(i)).getAmount().divide(new BigDecimal(10000), 2, RoundingMode.HALF_UP), null);
        }
        barSeries.setBarWidth("30%");
        int[] radius = new int[]{0, 20, 20, 0};
        HashMap<String, Object> itemStyle = new HashMap<String, Object>(3);
        itemStyle.put("borderRadius", radius);
        HashMap<String, String> colorMap = new HashMap<String, String>(1);
        colorMap.put("color", "new echarts.graphic.LinearGradient(0, 0, 0, 1, [{ \"offset\": 0, \"color\": '#84F2D4' },\n{ \"offset\": 1, \"color\": '#45DAD1' }])");
        itemStyle.put("normal", colorMap);
        ArrayList<String> list = new ArrayList<String>(3);
        list.add("itemStyle");
        list.add("normal");
        list.add("color");
        barSeries.addFuncPath(list);
        barSeries.setPropValue("itemStyle", itemStyle);
        this.buildXAxisByNumChart(barChart);
        Label label = new Label();
        label.setShow(false);
        barSeries.setLabel(label);
    }

    protected void buildYAxisByNumChart(BarChart barChart, List<String> nameColl) {
        String unitName = ResManager.loadKDString((String)"\u4e07\u5143", (String)"MaterialAmountRankingCardPlugin_0", (String)"scmc-scmdi-form", (Object[])new Object[0]);
        Axis yAxis = barChart.createYAxis(unitName, AxisType.category);
        HashMap<String, String> nameTextStyle = new HashMap<String, String>(2);
        nameTextStyle.put("color", "#999999");
        nameTextStyle.put("fontSize", "10");
        nameTextStyle.put("align", "left");
        yAxis.setPropValue("nameTextStyle", nameTextStyle);
        yAxis.setPropValue("show", (Object)Boolean.TRUE);
        yAxis.setCategorys(nameColl.toArray(new String[0]));
        yAxis.setPropValue("splitNumber", (Object)5);
    }

    protected void buildXAxisByNumChart(BarChart barChart) {
        Axis xAxis = barChart.createXAxis("", AxisType.value);
        HashMap<String, String> nameTextStyle = new HashMap<String, String>(2);
        nameTextStyle.put("color", "#999999");
        nameTextStyle.put("fontSize", "12");
        nameTextStyle.put("align", "right");
        xAxis.setPropValue("nameTextStyle", nameTextStyle);
        xAxis.setPropValue("show", (Object)Boolean.TRUE);
        HashMap<String, Boolean> axisShowMap = new HashMap<String, Boolean>(3);
        axisShowMap.put("show", Boolean.FALSE);
        xAxis.setPropValue("axisLine", axisShowMap);
        xAxis.setPropValue("axisTick", axisShowMap);
        LinkedHashMap<String, Object> axisLabelMap = new LinkedHashMap<String, Object>(3);
        axisLabelMap.put("fontSize", 12);
        axisLabelMap.put("color", "#999999");
        axisLabelMap.put("interval", "0");
        xAxis.setPropValue("axisLabel", axisLabelMap);
        xAxis.setPropValue("splitNumber", (Object)3);
    }
}

