/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.operatecenter.pur;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.chart.HistogramChart;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.scmdi.form.plugin.form.operatecenter.chart.ChartBuilder;
import kd.scmc.scmdi.form.plugin.form.operatecenter.chart.HistogramChartBuilder;
import kd.scmc.scmdi.form.plugin.form.operatecenter.tpl.ProcessTplCardPlugin;

public class PurOtcProcessCardPlugin
extends ProcessTplCardPlugin {
    private static final String SCMC = "SCMC";
    public static final String PUR = "PUR";

    @Override
    protected QFilter getProcessDefineFilter() {
        List<Object> processCategory = this.getProcessCategory();
        QFilter qFilter = new QFilter("categoryid", "in", processCategory);
        ArrayList<String> billNumbers = new ArrayList<String>(10);
        billNumbers.add("conm_purcontract");
        billNumbers.add("conm_purendagrt");
        billNumbers.add("conm_pursupagrt");
        billNumbers.add("conm_xpurcontract");
        return qFilter.or("entrabill", "in", billNumbers);
    }

    protected ChartBuilder<HistogramChart> getChartBuilder() {
        HistogramChart chartAp = (HistogramChart)this.getControl("histogramchartap");
        return new HistogramChartBuilder(chartAp);
    }

    private List<Object> getProcessCategory() {
        List<Object> scmcCategory = PurOtcProcessCardPlugin.getScmcCategory();
        List<Object> purCategory = PurOtcProcessCardPlugin.getPurCategory();
        scmcCategory.addAll(purCategory);
        return scmcCategory;
    }

    private static List<Object> getPurCategory() {
        QFilter scmcFilter = new QFilter("number", "=", (Object)PUR);
        DynamicObject scmcCategory = QueryServiceHelper.queryOne((String)"wf_processcagetory", (String)"id", (QFilter[])new QFilter[]{scmcFilter});
        if (scmcCategory == null || scmcCategory.get("id") == null) {
            return new ArrayList<Object>(0);
        }
        Long purAppId = scmcCategory.getLong("id");
        QFilter appIdFilter = new QFilter("id", "=", (Object)purAppId);
        appIdFilter.or("parentid", "=", (Object)purAppId);
        Map appIdColl = BusinessDataServiceHelper.loadFromCache((String)"wf_processcagetory", (String)"id,number", (QFilter[])new QFilter[]{appIdFilter});
        DynamicObject[] dynamicObjects = appIdColl.values().toArray(new DynamicObject[0]);
        return Arrays.stream(dynamicObjects).map(DataEntityBase::getPkValue).collect(Collectors.toList());
    }

    private static List<Object> getScmcCategory() {
        QFilter scmcFilter = new QFilter("number", "=", (Object)SCMC);
        DynamicObject pmCategory = QueryServiceHelper.queryOne((String)"wf_processcagetory", (String)"id", (QFilter[])new QFilter[]{scmcFilter});
        if (pmCategory == null || pmCategory.get("id") == null) {
            return new ArrayList<Object>(0);
        }
        Long pmAppId = pmCategory.getLong("id");
        QFilter appIdFilter = new QFilter("parentid", "=", (Object)pmAppId);
        List appNumbers = Arrays.stream(new String[]{"pm", "pmp", "vmi", "sctm"}).collect(Collectors.toList());
        appIdFilter.and("number", "in", appNumbers);
        Map appIdColl = BusinessDataServiceHelper.loadFromCache((String)"wf_processcagetory", (String)"id,number", (QFilter[])new QFilter[]{appIdFilter});
        DynamicObject[] dynamicObjects = appIdColl.values().toArray(new DynamicObject[0]);
        return Arrays.stream(dynamicObjects).map(DataEntityBase::getPkValue).collect(Collectors.toList());
    }
}

