/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.operatecenter.pur;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scmc.scmdi.business.helper.PurInfoCalculateHelper;
import kd.scmc.scmdi.common.enumeration.AbcSupplierInfoEnum;
import kd.scmc.scmdi.common.pojo.AbcAnalysisInfo;

public class PurSupplierAbcCardPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildChart();
    }

    private void buildChart() {
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        pieChart.clearData();
        pieChart.setMargin(Position.bottom, "0px");
        pieChart.setMargin(Position.left, "0px");
        pieChart.setMargin(Position.right, "0px");
        String name = String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u91d1\u989d%1$s\u5360\u6bd4", (String)"PurSupplierAbcCardPlugin_1", (String)"scmc-scmdi-form", (Object[])new Object[0]), "\n");
        pieChart.setName(new LocaleString(name));
        pieChart.setLegendPropValue("right", (Object)0);
        pieChart.setLegendPropValue("top", (Object)"center");
        pieChart.setLegendPropValue("icon", (Object)"circle");
        pieChart.addTooltip("trigger", (Object)"item");
        String triggerTitle = String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u4e07\u5143%3$s\u5360\u6bd4%4$s ", (String)"PurSupplierAbcCardPlugin_0", (String)"scm-scmdi-form", (Object[])new Object[0]), "{b}", "<br>{c}", "<br>", "{d}%");
        pieChart.addTooltip("formatter", (Object)triggerTitle);
        pieChart.setShowTooltip(true);
        pieChart.setTitlePropValue("left", (Object)"center");
        pieChart.setTitlePropValue("top", (Object)"center");
        PieSeries series = pieChart.createSeries("");
        series.setRadius("40%", "60%");
        series.setPropValue("avoidLabelOverlap", (Object)true);
        HashMap labelLine = new HashMap(1);
        HashMap<String, Comparable<Boolean>> normalProperties = new HashMap<String, Comparable<Boolean>>(1);
        normalProperties.put("show", Boolean.valueOf(true));
        normalProperties.put("length", Integer.valueOf(20));
        normalProperties.put("length2", Integer.valueOf(10));
        labelLine.put("normal", normalProperties);
        series.setPropValue("labelLine", labelLine);
        this.setData(series);
    }

    private void setData(PieSeries series) {
        List abcAnalysisInfos = PurInfoCalculateHelper.querySupplierABCAnalysisData();
        for (AbcSupplierInfoEnum info : AbcSupplierInfoEnum.values()) {
            Optional<BigDecimal> rateOptional = abcAnalysisInfos.stream().filter(sup -> Objects.equals(sup.getGroup(), info.getValue())).map(AbcAnalysisInfo::getAmount).reduce(BigDecimal::add);
            BigDecimal amount = rateOptional.map(bigDecimal -> bigDecimal.divide(new BigDecimal("10000"), 2, RoundingMode.HALF_UP)).orElseGet(() -> new BigDecimal(0));
            series.addData(info.getName(), (Number)amount);
        }
    }
}

