/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.operatecenter.pur;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scmc.scmdi.business.helper.PurInfoCalculateHelper;
import kd.scmc.scmdi.common.pojo.SupplierRankingInfo;
import kd.scmc.scmdi.form.enumeration.operatecenter.SupplierPurTopEnum;
import org.apache.commons.collections.CollectionUtils;

public class SupplierPurRankingCardPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List supplierRankingInfos = PurInfoCalculateHelper.getSupplierPurchaseRanking();
        if (CollectionUtils.isEmpty((Collection)supplierRankingInfos)) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("entryentity", supplierRankingInfos.size());
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        this.getModel().beginInit();
        for (int i = 0; i < supplierRankingInfos.size(); ++i) {
            int rankingNumber = SupplierPurRankingCardPlugin.getRankingNumber(i);
            if (rankingNumber <= 3) {
                SupplierPurTopEnum topEnumByRanking = SupplierPurTopEnum.getTopEnumByRanking(rankingNumber);
                String imageUrl = topEnumByRanking.getImageUrl();
                this.getModel().setValue("top_image", (Object)imageUrl, i);
                cardEntry.setChildVisible(false, i, new String[]{"rank_num"});
            } else {
                this.getModel().setValue("rank_num", (Object)SupplierPurRankingCardPlugin.getRankingNumber(i), i);
                cardEntry.setChildVisible(false, i, new String[]{"top_image"});
            }
            this.getModel().setValue("supplier", (Object)((SupplierRankingInfo)supplierRankingInfos.get(i)).getSupplierName(), i);
            this.getModel().setValue("purchase_amount", (Object)((SupplierRankingInfo)supplierRankingInfos.get(i)).getAmount(), i);
            this.getModel().setValue("delivery_rate", (Object)(((SupplierRankingInfo)supplierRankingInfos.get(i)).getRate() + "%"), i);
        }
        this.getModel().endInit();
        this.getView().updateView("entryetity");
    }

    private static int getRankingNumber(int i) {
        return i + 1;
    }
}

