/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.operatecenter.tpl;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scmc.scmdi.common.pojo.DataCardInfo;
import kd.scmc.scmdi.form.common.pojo.DataCardLabelInfo;
import kd.scmc.scmdi.form.common.utils.LabelStyleUtils;

public abstract class DataCardTplPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildDigitalCard();
    }

    private void buildDigitalCard() {
        DataCardInfo dataCardInfo = this.getDigitalCardInfo();
        this.buildFirstCard(dataCardInfo);
        this.buildSecondCard(dataCardInfo);
        this.buildThirdCard(dataCardInfo);
    }

    protected abstract DataCardInfo getDigitalCardInfo();

    protected DataCardLabelInfo getFirstCardLabelInfo() {
        DataCardLabelInfo dataCardLabelInfo = new DataCardLabelInfo();
        dataCardLabelInfo.setDataField("data_field1");
        dataCardLabelInfo.setYOYField("yoy1");
        dataCardLabelInfo.setYOYIncreaseIcon("yoy_increase1");
        dataCardLabelInfo.setYOYDeclineIcon("yoy_decrease1");
        dataCardLabelInfo.setQOQField("qoq1");
        dataCardLabelInfo.setQOQIncreaseIcon("qoq_increase1");
        dataCardLabelInfo.setQOQDeclineIcon("qoq_decrease1");
        return dataCardLabelInfo;
    }

    protected DataCardLabelInfo getSecondCardLabelInfo() {
        DataCardLabelInfo dataCardLabelInfo = new DataCardLabelInfo();
        dataCardLabelInfo.setDataField("data_field2");
        dataCardLabelInfo.setYOYField("yoy2");
        dataCardLabelInfo.setYOYIncreaseIcon("yoy_increase2");
        dataCardLabelInfo.setYOYDeclineIcon("yoy_decrease2");
        dataCardLabelInfo.setQOQField("qoq2");
        dataCardLabelInfo.setQOQIncreaseIcon("qoq_increase2");
        dataCardLabelInfo.setQOQDeclineIcon("qoq_decrease2");
        return dataCardLabelInfo;
    }

    protected DataCardLabelInfo getThirdCardLabelInfo() {
        DataCardLabelInfo dataCardLabelInfo = new DataCardLabelInfo();
        dataCardLabelInfo.setDataField("data_field3");
        dataCardLabelInfo.setYOYField("yoy3");
        dataCardLabelInfo.setYOYIncreaseIcon("yoy_increase3");
        dataCardLabelInfo.setYOYDeclineIcon("yoy_decrease3");
        dataCardLabelInfo.setQOQField("qoq3");
        dataCardLabelInfo.setQOQIncreaseIcon("qoq_increase3");
        dataCardLabelInfo.setQOQDeclineIcon("qoq_decrease3");
        return dataCardLabelInfo;
    }

    private void buildFirstCard(DataCardInfo dataCardInfo) {
        DataCardLabelInfo firstCardLabelInfo = this.getFirstCardLabelInfo();
        this.buildCardItem(firstCardLabelInfo, dataCardInfo.getFirstData(), dataCardInfo.getFirstDataYoy(), dataCardInfo.getFirstDataQoq());
    }

    private void buildCardItem(DataCardLabelInfo dataCardLabelInfo, BigDecimal dataFieldValue, BigDecimal yoyRate, BigDecimal qoqRate) {
        Label purLabel = (Label)this.getView().getControl(dataCardLabelInfo.getDataField());
        purLabel.setText(dataFieldValue == null ? "--" : dataFieldValue.toPlainString());
        this.setRateField(yoyRate, dataCardLabelInfo.getYOYField(), dataCardLabelInfo.getYOYIncreaseIcon(), dataCardLabelInfo.getYOYDeclineIcon());
        this.setRateField(qoqRate, dataCardLabelInfo.getQOQField(), dataCardLabelInfo.getQOQIncreaseIcon(), dataCardLabelInfo.getQOQDeclineIcon());
    }

    private void buildSecondCard(DataCardInfo dataCardInfo) {
        DataCardLabelInfo secondCardLabelInfo = this.getSecondCardLabelInfo();
        this.buildCardItem(secondCardLabelInfo, dataCardInfo.getSecondData(), dataCardInfo.getSecondDataYoy(), dataCardInfo.getSecondDataQoq());
    }

    private void buildThirdCard(DataCardInfo dataCardInfo) {
        DataCardLabelInfo thirdCardLabelInfo = this.getThirdCardLabelInfo();
        this.buildCardItem(thirdCardLabelInfo, dataCardInfo.getThirdData(), dataCardInfo.getThirdDataYoy(), dataCardInfo.getThirdDataQoq());
    }

    private void setRateField(BigDecimal rate, String labelKey, String increaseKey, String decreasesKey) {
        Map<String, Object> styleMap;
        this.setRateValue(labelKey, rate);
        if (rate == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{increaseKey, decreasesKey});
            return;
        }
        int rateSize = rate.compareTo(BigDecimal.ZERO);
        if (rateSize > 0) {
            styleMap = LabelStyleUtils.getLabelStyle("#F57582", null);
            this.getView().setVisible(Boolean.TRUE, new String[]{increaseKey});
            this.getView().setVisible(Boolean.FALSE, new String[]{decreasesKey});
        } else if (rateSize < 0) {
            styleMap = LabelStyleUtils.getLabelStyle("#29C392", null);
            this.getView().setVisible(Boolean.TRUE, new String[]{decreasesKey});
            this.getView().setVisible(Boolean.FALSE, new String[]{increaseKey});
        } else {
            styleMap = new HashMap<String, Object>(0);
            this.getView().setVisible(Boolean.FALSE, new String[]{increaseKey, decreasesKey});
        }
        this.getView().updateControlMetadata(labelKey, styleMap);
    }

    private void setRateValue(String labelKey, BigDecimal rate) {
        Label label = (Label)this.getView().getControl(labelKey);
        String rateText = rate == null ? "--" : rate.abs().toPlainString() + "%";
        label.setText(rateText);
    }
}

