/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.operatecenter.tpl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.control.Label;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.scmdi.common.pojo.OtcDigitalCardInfo;
import kd.scmc.scmdi.common.utils.HomePageDateUtils;
import kd.scmc.scmdi.form.common.helper.OtcProcessHelper;
import kd.scmc.scmdi.form.common.utils.LabelStyleUtils;
import kd.scmc.scmdi.form.plugin.form.operatecenter.chart.ChartBuilder;
import org.apache.commons.lang3.ArrayUtils;

public abstract class ProcessTplCardPlugin
extends AbstractFormPlugin {
    private static final String BILL_TASK = "BillTask";
    private static final String BIZ_FLOW = "BizFlow";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object[] processDefines = this.getProcessDefines();
        if (ArrayUtils.isEmpty((Object[])processDefines)) {
            this.setDigitalIconVisible();
            return;
        }
        this.buildComboBox((DynamicObject[])processDefines);
        String processIdStr = String.valueOf(this.getModel().getValue("process"));
        Long defaultProcessId = Long.valueOf(processIdStr);
        this.buildDigitalCardAndPieChart(defaultProcessId);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("process".equals(propName)) {
            String processIdStr = (String)newValue;
            if (processIdStr != null) {
                Long processId = Long.valueOf(processIdStr);
                this.buildDigitalCardAndPieChart(processId);
            } else {
                this.setDigitalIconVisible();
            }
        }
    }

    protected abstract QFilter getProcessDefineFilter();

    protected DynamicObject[] getProcessDefines() {
        QFilter qFilter = new QFilter("enable", "=", (Object)"enable");
        qFilter.and(new QFilter("type", "=", (Object)BIZ_FLOW));
        QFilter processDefineFilter = this.getProcessDefineFilter();
        qFilter.and(processDefineFilter);
        Map processDefineColl = BusinessDataServiceHelper.loadFromCache((String)"wf_processdefinition", (String)"id,name,", (QFilter[])new QFilter[]{qFilter}, (String)"businessid");
        if (processDefineColl.isEmpty()) {
            return new DynamicObject[0];
        }
        return processDefineColl.values().toArray(new DynamicObject[0]);
    }

    private void buildComboBox(DynamicObject[] processDefine) {
        ComboEdit processCombo = (ComboEdit)this.getControl("process");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        for (DynamicObject dynamicObject : processDefine) {
            ComboItem comboItem = new ComboItem();
            LocaleString caption = new LocaleString(dynamicObject.getString("name"));
            comboItem.setCaption(caption);
            Object id = dynamicObject.getPkValue();
            comboItem.setValue(String.valueOf(id));
            items.add(comboItem);
        }
        processCombo.setComboItems(items);
        this.setDefaultProcess(processDefine);
    }

    protected void setDefaultProcess(DynamicObject[] processDefine) {
        this.getModel().setValue("process", processDefine[0].getPkValue());
    }

    private void buildDigitalCardAndPieChart(Long processId) {
        this.buildDigitalCard(processId);
        ItemValue[] chartData = this.getChartData(processId);
        ChartBuilder<?> chartBuilder = this.getChartBuilder();
        chartBuilder.build(chartData);
    }

    protected abstract ChartBuilder<?> getChartBuilder();

    private ItemValue[] getChartData(Long processId) {
        Date date = new Date();
        Date dayStartTime = HomePageDateUtils.getDayStartTime((Date)date);
        Date endDate = HomePageDateUtils.getDayEndTime((Date)date);
        Date startDate = HomePageDateUtils.getSixMonthAgoByDate((Date)dayStartTime);
        DataSet actionHistoryData = this.getActionHistoryData(processId, startDate, endDate);
        ArrayList<ItemValue> itemValues = new ArrayList<ItemValue>();
        for (Row row : actionHistoryData) {
            String activityName = row.getString("activityname");
            Integer realDurationMillis = row.getInteger("realdurationinmillis");
            BigDecimal realDurationHours = new BigDecimal(realDurationMillis).divide(new BigDecimal("3600000"), 2, RoundingMode.HALF_UP);
            itemValues.add(new ItemValue(activityName, (Number)realDurationHours, null));
        }
        return itemValues.toArray(new ItemValue[0]);
    }

    private DataSet getActionHistoryData(Long processId, Date startDate, Date enddate) {
        QFilter qFilter = new QFilter("processdefinitionid", "=", (Object)processId);
        qFilter.and(new QFilter("createdate", ">=", (Object)startDate));
        qFilter.and(new QFilter("endtime", "<=", (Object)enddate));
        qFilter.and(new QFilter("activitytype", "=", (Object)BILL_TASK));
        DataSet history = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"wf_hiactinst", (String)"id,processdefinitionid,realdurationinmillis,activityname", (QFilter[])new QFilter[]{qFilter}, null);
        return history.groupBy(new String[]{"activityname"}).sum("realdurationinmillis").finish().orderBy(new String[]{"realdurationinmillis desc"});
    }

    private void buildDigitalCard(Long processId) {
        OtcDigitalCardInfo digitalCardInfo = OtcProcessHelper.getDigitalCardInfo(processId);
        this.buildAvgTimeCard(digitalCardInfo);
        this.buildTotalTimeCard(digitalCardInfo);
        this.buildRunTimeCard(digitalCardInfo);
    }

    private void buildAvgTimeCard(OtcDigitalCardInfo digitalCardInfo) {
        String avgText = digitalCardInfo.getAvgTime() == null ? "--" : digitalCardInfo.getAvgTime().toPlainString();
        this.setUnitVisible("avgtime", avgText, "labelap1");
        BigDecimal yoyAvgTimeRate = digitalCardInfo.getYoyAvgTimeRate();
        this.setRateField("labelap4", yoyAvgTimeRate, "vectorap1", "vectorap2", "labelap5");
        BigDecimal qoqAvgTimeRate = digitalCardInfo.getQoqAvgTimeRate();
        this.setRateField("labelap6", qoqAvgTimeRate, "vectorap3", "vectorap4", "labelap7");
    }

    private void buildTotalTimeCard(OtcDigitalCardInfo digitalCardInfo) {
        String totalText = digitalCardInfo.getTotalTime() == null ? "--" : digitalCardInfo.getTotalTime().toPlainString();
        this.setUnitVisible("totaltime", totalText, "labelap2");
        BigDecimal yoyTotalTimeRate = digitalCardInfo.getYoyTotalTimeRate();
        this.setRateField("labelap8", yoyTotalTimeRate, "vectorap5", "vectorap6", "labelap9");
        BigDecimal qoqTotalTimeRate = digitalCardInfo.getQoqTotalTimeRate();
        this.setRateField("labelap10", qoqTotalTimeRate, "vectorap7", "vectorap8", "labelap11");
    }

    private void buildRunTimeCard(OtcDigitalCardInfo digitalCardInfo) {
        String runText = digitalCardInfo.getRunTime() == null ? "--" : digitalCardInfo.getRunTime().toPlainString();
        this.setUnitVisible("runtime", runText, "labelap3");
        BigDecimal yoyRunTimeRate = digitalCardInfo.getYoyRunTimeRate();
        this.setRateField("labelap12", yoyRunTimeRate, "vectorap9", "vectorap10", "labelap13");
        BigDecimal qoqRunTimeRate = digitalCardInfo.getQoqRunTimeRate();
        this.setRateField("labelap14", qoqRunTimeRate, "vectorap11", "vectorap12", "labelap15");
    }

    private void setUnitVisible(String labelKey, String text, String unit) {
        Label avgLabel = (Label)this.getView().getControl(labelKey);
        avgLabel.setText(text);
        if ("--".equals(text)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{unit});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{unit});
        }
    }

    public boolean isSetRateFieldStyle() {
        return true;
    }

    private void setRateField(String fieldLabelKey, BigDecimal rate, String increaseKey, String decreasesKey, String percent) {
        Map<String, Object> styleMap;
        this.setRateValue(fieldLabelKey, rate);
        if (rate == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{increaseKey, decreasesKey, percent});
            return;
        }
        int rateSize = rate.compareTo(BigDecimal.ZERO);
        if (rateSize > 0) {
            styleMap = LabelStyleUtils.getLabelStyle("#ff6B7A", null);
            this.getView().setVisible(Boolean.TRUE, new String[]{increaseKey, percent});
            this.getView().setVisible(Boolean.FALSE, new String[]{decreasesKey});
        } else if (rateSize < 0) {
            styleMap = LabelStyleUtils.getLabelStyle("#5afFA7", null);
            this.getView().setVisible(Boolean.TRUE, new String[]{decreasesKey, percent});
            this.getView().setVisible(Boolean.FALSE, new String[]{increaseKey});
        } else {
            styleMap = new HashMap<String, Object>(0);
            this.getView().setVisible(Boolean.FALSE, new String[]{increaseKey, decreasesKey, percent});
        }
        if (this.isSetRateFieldStyle()) {
            this.getView().updateControlMetadata(fieldLabelKey, styleMap);
            this.getView().updateControlMetadata(percent, styleMap);
        }
    }

    private void setRateValue(String fieldLabelKey, BigDecimal rate) {
        Label totalYoyLabel = (Label)this.getView().getControl(fieldLabelKey);
        String totalYoyText = rate == null ? "--" : rate.abs().toPlainString();
        totalYoyLabel.setText(totalYoyText);
    }

    private void setDigitalIconVisible() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"vectorap1", "vectorap2", "vectorap3", "vectorap4", "vectorap5", "vectorap6", "vectorap7", "vectorap8", "vectorap9", "vectorap10", "vectorap11", "vectorap12", "labelap5", "labelap7", "labelap9", "labelap11", "labelap13", "labelap15", "labelap1", "labelap2", "labelap3"});
        Label avgLabel = (Label)this.getView().getControl("avgtime");
        Label avgYoyLabel = (Label)this.getView().getControl("labelap4");
        Label avgQoqLabel = (Label)this.getView().getControl("labelap6");
        avgLabel.setText("--");
        avgYoyLabel.setText("--");
        avgQoqLabel.setText("--");
        Label totalLabel = (Label)this.getView().getControl("totaltime");
        Label totalYoyLabel = (Label)this.getView().getControl("labelap8");
        Label totalQoqLabel = (Label)this.getView().getControl("labelap10");
        totalLabel.setText("--");
        totalYoyLabel.setText("--");
        totalQoqLabel.setText("--");
        Label runLabel = (Label)this.getView().getControl("runtime");
        Label runYoyLabel = (Label)this.getView().getControl("labelap12");
        Label runQoqLabel = (Label)this.getView().getControl("labelap14");
        runLabel.setText("--");
        runYoyLabel.setText("--");
        runQoqLabel.setText("--");
    }
}

