/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.solution;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.MainEntityType;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.scmdi.form.enumeration.solution.OperationObjectEnum;
import kd.scmc.scmdi.form.enumeration.solution.SpecificOperationEnum;
import kd.sdk.scmc.scmdi.extpoint.ISolutionOperationObjectExpand;

public class OperationConfigPlugin
extends AbstractFormPlugin {
    public static final String OPERATION_OBJECT = "operationobject";
    public static final String SPECIFIC_OPERATION = "specificoperation";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.buildOperationObject();
        this.buildSpecificOperation();
    }

    private void buildSpecificOperation() {
        List comboItems = Arrays.stream(SpecificOperationEnum.values()).map(value -> {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(value.getOperationName()));
            comboItem.setValue(value.getCode());
            return comboItem;
        }).collect(Collectors.toList());
        ComboEdit operationObjet = (ComboEdit)this.getControl(SPECIFIC_OPERATION);
        operationObjet.setComboItems(comboItems);
    }

    private void buildOperationObject() {
        List comboItems = Arrays.stream(OperationObjectEnum.values()).map(value -> {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(value.getBillName()));
            comboItem.setValue(value.getBillKey());
            return comboItem;
        }).collect(Collectors.toList());
        PluginProxy pluginProxy = PluginProxy.create(ISolutionOperationObjectExpand.class, (String)"SCMC_SCMDI_SOLUTION_SCHEME_OPERATION_SCHEME_EXPAND");
        List expandOperations = pluginProxy.callReplace(ISolutionOperationObjectExpand::addOperationObjects);
        expandOperations.forEach(operations -> operations.forEach(operation -> {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)operation);
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(dataEntityType != null ? dataEntityType.getDisplayName() : new LocaleString(""));
            comboItem.setValue(operation);
            comboItems.add(comboItem);
        }));
        ComboEdit operationObjet = (ComboEdit)this.getControl(OPERATION_OBJECT);
        operationObjet.setComboItems(comboItems);
    }
}

