/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.solution;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.kingdee.bos.qing.modeler.api.exception.ModelException;
import com.kingdee.bos.qing.modeler.api.response.Row;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.scmc.scmdi.business.metric.MetricDataHelper;
import kd.scmc.scmdi.business.metric.MetricServiceHolder;
import kd.scmc.scmdi.business.metric.vo.MetricMapping;
import kd.scmc.scmdi.business.metric.vo.MetricMappingEntry;
import kd.scmc.scmdi.common.vo.bos.FieldTypeEnum;
import kd.scmc.scmdi.form.common.pojo.SolutionSchemeOperation;
import kd.scmc.scmdi.form.enumeration.solution.OperationObjectEnum;
import kd.scmc.scmdi.form.enumeration.solution.ProcessStatusEnum;
import kd.scmc.scmdi.form.enumeration.solution.SpecificOperationEnum;
import kd.scmc.scmdi.form.vo.warning.DynamicField;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class WarningWorkBenchDetailPlugin
extends AbstractFormPlugin
implements TipsListener {
    private static final Log log = LogFactory.getLog(WarningWorkBenchDetailPlugin.class);
    public static final String AFTER_SHOW_SLIDE_BILL = "afterShowSlideBill";
    public static final String SIDESLIPPING_FLEX = "sideslippingFlex";
    public static final String ASYNC_BUILD_WARNING_RESULT = "asyncBuildWarningResult";
    public static final String WARNING_RESULT_FORM_KEY = "warningResultFormKey";
    public static final String SOLUTION_PARENT_FLEX = "solution_parent_flex";
    public static final String SOLUTION_SCHEME_FLEX = "solution_scheme_flex";
    public static final String METRIC_MODULE_FLEX = "metricmoduleflex";
    public static final String PARENT_PAGE_ID = "parentPageId";
    public static final String BILL_ID = "billId";
    public static final String PAGE_ID = "pageId";
    public static final String CLICK_LISTENER_KEYS = "click_listener_Keys";
    public static final String SOLUTION_ENTITY = "entryentity";
    public static final String WARNING_OBJECT = "warning_object";
    public static final String LATEST_METRIC = "latest_metric";
    public static final String LATEST_METRIC_WARNING_RESULT_ID = "latest_metric_warning_result_id";
    public static final int DURATION = 1000;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit textEdit = (TextEdit)this.getControl("duplicated_count");
        textEdit.addTipsListener((TipsListener)this);
    }

    private void initPage(CustomEventArgs e) {
        String eventArgs = e.getEventArgs();
        Map eventParams = (Map)JSON.parseObject((String)eventArgs, Map.class);
        Map params = (Map)eventParams.get("params");
        Object entityKey = params.get(WARNING_RESULT_FORM_KEY);
        Object billId = params.get(BILL_ID);
        this.getPageCache().put(BILL_ID, String.valueOf(billId));
        this.getPageCache().put(PARENT_PAGE_ID, String.valueOf(eventParams.get(PAGE_ID)));
        this.getPageCache().put(WARNING_RESULT_FORM_KEY, String.valueOf(entityKey));
        this.getPageCache().put("mainPageId", String.valueOf(params.get("mainPageId")));
        this.getView().invokeOperation("refresh");
    }

    private List<SolutionSchemeOperation> getRegisterClickOperations() {
        IPageCache pageCache = this.getView().getPageCache();
        String clickListenerKeys = pageCache.get(CLICK_LISTENER_KEYS);
        if (StringUtils.isBlank((String)clickListenerKeys)) {
            return new ArrayList<SolutionSchemeOperation>(0);
        }
        return JSONArray.parseArray((String)clickListenerKeys, SolutionSchemeOperation.class);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        List<SolutionSchemeOperation> operations = this.getRegisterClickOperations();
        if (operations.stream().anyMatch(operation -> operation.getButtonKey().equals(e.getKey()))) {
            Button button = new Button();
            button.setKey(e.getKey());
            button.setView(this.getView());
            button.addClickListener((ClickListener)this);
            e.setControl((Control)button);
        }
    }

    private void addClickListenerKey(SolutionSchemeOperation operation) {
        IPageCache pageCache = this.getView().getPageCache();
        String clickListenerKeys = pageCache.get(CLICK_LISTENER_KEYS);
        ArrayList<SolutionSchemeOperation> operations = StringUtils.isBlank((String)clickListenerKeys) ? new ArrayList<SolutionSchemeOperation>(4) : JSONArray.parseArray((String)clickListenerKeys, SolutionSchemeOperation.class);
        operations.add(operation);
        String clickKeysStr = JSONArray.toJSONString(operations);
        pageCache.put(CLICK_LISTENER_KEYS, clickKeysStr);
    }

    public void click(EventObject e) {
        super.click(e);
        Button button = (Button)e.getSource();
        List<SolutionSchemeOperation> registerClickOperations = this.getRegisterClickOperations();
        registerClickOperations.stream().filter(operation -> button.getKey().equals(operation.getButtonKey())).findAny().ifPresent(item -> {
            FormShowParameter showFormParameter = SpecificOperationEnum.getShowFormParameter(item.getSpecificOperation(), item.getOperationObject());
            showFormParameter.setCustomParam(PAGE_ID, (Object)this.getPageCache().get("mainPageId"));
            IFormView view = this.getView().getView(this.getPageCache().get("mainPageId"));
            view.showForm(showFormParameter);
            this.getView().sendFormAction(view);
            this.closeSidePage();
        });
    }

    private void closeSidePage() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> showParams = new HashMap<String, Object>(4);
        showParams.put("formId", "scmdi_wwb_detail");
        showParams.put("show", false);
        proxy.addAction("showSlideBill", showParams);
    }

    private String getWarningResultFormKey() {
        return this.getPageCache().get(WARNING_RESULT_FORM_KEY);
    }

    private Long getBillId() {
        return StringUtils.isNotBlank((String)this.getPageCache().get(BILL_ID)) ? Long.parseLong(this.getPageCache().get(BILL_ID)) : 0L;
    }

    private String getParentPageId() {
        return this.getPageCache().get(PARENT_PAGE_ID);
    }

    private void buildOtherInfo(DynamicObject warningResult) {
        IDataModel model = this.getModel();
        Object billNo = warningResult.get("billno");
        model.setValue("warning_number", billNo);
        Object warningGroupPk = warningResult.getDynamicObject("warning_config.group") != null ? warningResult.getDynamicObject("warning_config.group").getPkValue() : null;
        model.setValue("warning_group", warningGroupPk);
        Object warningObjectPk = warningResult.getDynamicObject(WARNING_OBJECT) != null ? warningResult.getDynamicObject(WARNING_OBJECT).getPkValue() : null;
        model.setValue(WARNING_OBJECT, warningObjectPk);
        Object processor = warningResult.get("processor");
        model.setValue("processor", processor);
        Object processingDate = warningResult.get("processingtime");
        model.setValue("processingtime", processingDate);
        Object processingWay = warningResult.get("processingway");
        model.setValue("processingway", processingWay);
    }

    private void buildWarningSolutionScheme(DynamicObject[] solutionEntries) {
        FlexPanelAp solutionParentFlex = this.getSpecificScheme(solutionEntries);
        this.buildCustomControl(SOLUTION_SCHEME_FLEX, SOLUTION_PARENT_FLEX, Collections.singletonList(solutionParentFlex.createControl()));
    }

    private FlexPanelAp getSpecificScheme(DynamicObject[] solutionSchemes) {
        if (solutionSchemes.length > 0) {
            FlexPanelAp solutionParentFlex = new FlexPanelAp();
            solutionParentFlex.setKey(SOLUTION_PARENT_FLEX);
            solutionParentFlex.setWidth(new LocaleString("100%"));
            solutionParentFlex.setHeight(new LocaleString("100%"));
            solutionParentFlex.setDirection("column");
            solutionParentFlex.setOverflow("visible");
            solutionParentFlex.getItems().addAll(this.getSchemeSubFlex(Arrays.asList(solutionSchemes)));
            solutionParentFlex.setAlignItems("center");
            return solutionParentFlex;
        }
        String idByNumber = MetadataDao.getIdByNumber((String)this.getModel().getDataEntityType().getName(), (MetaCategory)MetaCategory.Form);
        FormMetadata mainMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)idByNumber, (MetaCategory)MetaCategory.Form);
        String langTag = RequestContext.get().getLang().getLangTag();
        mainMeta.buildDesignMeta(langTag);
        return (FlexPanelAp)mainMeta.getItems().stream().filter(item -> SOLUTION_PARENT_FLEX.equals(item.getKey())).findFirst().orElseGet(FlexPanelAp::new);
    }

    private List<FlexPanelAp> getSchemeSubFlex(List<DynamicObject> solutionSchemes) {
        ArrayList<FlexPanelAp> solutionSchemePanels = new ArrayList<FlexPanelAp>(4);
        for (int i = 0; i < solutionSchemes.size(); ++i) {
            FlexPanelAp schemeFlex = this.getSpecificScheme(solutionSchemes.get(i), i);
            solutionSchemePanels.add(schemeFlex);
        }
        return solutionSchemePanels;
    }

    private void buildCustomControl(String parentFlex, String childFlex, List<Map<String, Object>> items) {
        Container solutionSchemeFlex = (Container)this.getControl(parentFlex);
        solutionSchemeFlex.deleteControls(new String[]{childFlex});
        solutionSchemeFlex.addControls(items);
    }

    private FlexPanelAp getSpecificScheme(DynamicObject solutionScheme, int index) {
        FlexPanelAp schemeFlex = new FlexPanelAp();
        schemeFlex.setKey("scheme_flex" + index);
        schemeFlex.setDirection("column");
        schemeFlex.setBackColor("#F6F6F6");
        schemeFlex.setOverflow("visible");
        Margin margin = new Margin();
        margin.setBottom("12px");
        Padding padding = new Padding();
        padding.setLeft("12px");
        padding.setRight("12px");
        Style style = new Style();
        style.setMargin(margin);
        style.setPadding(padding);
        schemeFlex.setStyle(style);
        schemeFlex.setCollapsible(true);
        schemeFlex.setDefaultcollapse(index != 0);
        schemeFlex.setWidth(new LocaleString("100%"));
        schemeFlex.setName(new LocaleString(solutionScheme.getString("name")));
        LabelAp schemeDescriptionTitle = new LabelAp();
        schemeDescriptionTitle.setStyle(WarningWorkBenchDetailPlugin.getMaringBttomStyle("6px"));
        String descriptionTitle = ResManager.loadKDString((String)"\u89e3\u51b3\u65b9\u6848\u63cf\u8ff0", (String)"WarningWorkBenchPlugin_1", (String)"scmc-scmdi-form", (Object[])new Object[0]);
        schemeDescriptionTitle.setName(new LocaleString(descriptionTitle));
        schemeDescriptionTitle.setKey("scheme_description_title" + index);
        schemeDescriptionTitle.setForeColor("#666666");
        schemeFlex.getItems().add(schemeDescriptionTitle);
        LabelAp schemeDescriptionContent = new LabelAp();
        Style maringBttomStyle = WarningWorkBenchDetailPlugin.getMaringBttomStyle("16px");
        this.setFieldBorder(maringBttomStyle);
        schemeDescriptionContent.setStyle(maringBttomStyle);
        schemeDescriptionContent.setKey("label_content_" + index);
        schemeDescriptionContent.setName(new LocaleString(StringUtils.isBlank((String)solutionScheme.getString("description")) ? "-" : solutionScheme.getString("description")));
        schemeDescriptionContent.setFontSize(14);
        schemeDescriptionContent.setWidth(new LocaleString("100%"));
        schemeDescriptionContent.setHeight(new LocaleString("20px"));
        schemeFlex.getItems().add(schemeDescriptionContent);
        LabelAp stepLabelAp = new LabelAp();
        Style setpStyle = WarningWorkBenchDetailPlugin.getMaringBttomStyle("6px");
        stepLabelAp.setStyle(setpStyle);
        stepLabelAp.setKey("label_step_" + index);
        String stepTitle = ResManager.loadKDString((String)"\u64cd\u4f5c", (String)"WarningWorkBenchPlugin_2", (String)"scmc-scmdi-form", (Object[])new Object[0]);
        stepLabelAp.setName(new LocaleString(stepTitle));
        stepLabelAp.setForeColor("#666666");
        schemeFlex.getItems().add(stepLabelAp);
        List<DynamicObject> solutionOperations = solutionScheme.getDynamicObjectCollection(SOLUTION_ENTITY).stream().filter(entry -> "1".equals(entry.get("operation.enable"))).collect(Collectors.toList());
        List<FlexPanelAp> operationPanelAps = this.getOperationStepFlex(index, solutionOperations);
        schemeFlex.getItems().addAll(operationPanelAps);
        return schemeFlex;
    }

    private Style setFieldBorder(Style style) {
        Border border = new Border();
        border.setBottom("1px solid #E5E5E5");
        style.setBorder(border);
        return style;
    }

    private static Style getMaringBttomStyle(String bottom) {
        Style setpStyle = new Style();
        Margin sterpMargin = new Margin();
        sterpMargin.setBottom(bottom);
        setpStyle.setMargin(sterpMargin);
        return setpStyle;
    }

    private List<FlexPanelAp> getOperationStepFlex(int index, List<DynamicObject> operations) {
        List<DynamicObject> collect = operations.stream().filter(operation -> StringUtils.isNotBlank((String)operation.getString("operation.specificoperation")) || StringUtils.isNotBlank((String)operation.getString("operation.operationobject"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return WarningWorkBenchDetailPlugin.getNoOperationTipFlexAp();
        }
        return this.getSpecificOperationFlexPanelAps(index, collect);
    }

    private List<FlexPanelAp> getSpecificOperationFlexPanelAps(int index, List<DynamicObject> operations) {
        int size = operations.size();
        ArrayList<FlexPanelAp> result = new ArrayList<FlexPanelAp>(size);
        for (int i = 0; i < size; ++i) {
            FlexPanelAp operationFlex = new FlexPanelAp();
            operationFlex.setWidth(new LocaleString("100%"));
            operationFlex.setBackColor("#ffffff");
            operationFlex.setOverflow("visible");
            Style style = WarningWorkBenchDetailPlugin.getMaringBttomStyle("12px");
            Padding padding = new Padding();
            padding.setBottom("12px");
            padding.setTop("12px");
            padding.setLeft("12px");
            padding.setRight("12px");
            style.setPadding(padding);
            operationFlex.setStyle(style);
            operationFlex.setKey("operation_flex" + index + i);
            operationFlex.setDirection("column");
            LabelAp operationName = new LabelAp();
            operationName.setKey("operation_name" + index + i);
            DynamicObject operation = operations.get(i);
            operationName.setName(new LocaleString(operation.getString("operation.name")));
            operationFlex.getItems().add(operationName);
            LabelAp operationDescription = new LabelAp();
            operationDescription.setWidth(new LocaleString("500px"));
            operationDescription.setKey("operation_description" + index + i);
            operationDescription.setName(new LocaleString(operation.getString("operation.description")));
            operationFlex.getItems().add(operationDescription);
            LabelAp specificOperation = new LabelAp();
            String buttonKey = index + i + operation.getString("operation.specificoperation") + operation.getString("operation.operationobject");
            specificOperation.setKey(buttonKey);
            SolutionSchemeOperation solutionSchemeOperation = new SolutionSchemeOperation();
            solutionSchemeOperation.setButtonKey(buttonKey);
            solutionSchemeOperation.setOperationObject(operation.getString("operation.operationobject"));
            solutionSchemeOperation.setSpecificOperation(operation.getString("operation.specificoperation"));
            this.addClickListenerKey(solutionSchemeOperation);
            specificOperation.setForeColor("#5582F3");
            specificOperation.setClickable(true);
            specificOperation.setName(new LocaleString(SpecificOperationEnum.getOperationName(operation.getString("operation.specificoperation")) + OperationObjectEnum.getBillNameByBillKey(operation.getString("operation.operationobject"))));
            operationFlex.getItems().add(specificOperation);
            result.add(operationFlex);
        }
        return result;
    }

    private static ArrayList<FlexPanelAp> getNoOperationTipFlexAp() {
        ArrayList<FlexPanelAp> flexItems = new ArrayList<FlexPanelAp>(1);
        FlexPanelAp noDataTipFlex = new FlexPanelAp();
        noDataTipFlex.setKey("no_data_warning_flex");
        noDataTipFlex.setBKRepeat("default");
        noDataTipFlex.setAlignItems("center");
        noDataTipFlex.setWidth(new LocaleString("100%"));
        noDataTipFlex.setHeight(new LocaleString("150x"));
        noDataTipFlex.setBackColor("#F6F6F6");
        noDataTipFlex.setGrow(1);
        noDataTipFlex.setWrap(false);
        noDataTipFlex.setDirection("column");
        FlexPanelAp nodataTip = new FlexPanelAp();
        nodataTip.setBKFull(true);
        nodataTip.setKey("no_data_image_flex");
        nodataTip.setBKRepeat("default");
        nodataTip.setHeight(new LocaleString("78px"));
        nodataTip.setWidth(new LocaleString("138PX"));
        nodataTip.setDirection("column");
        nodataTip.setAlignItems("center");
        nodataTip.setGrow(1);
        nodataTip.setWrap(false);
        nodataTip.setBackgroundImg("/kingdee/scmc/images/pc/emotion/scmdi_no_warning_solution_tip.png");
        LabelAp labelAp = new LabelAp();
        labelAp.setKey("no_data_operations_tips");
        String noDataTip = ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u7528\u7684\u64cd\u4f5c", (String)"WarningWorkBenchDetailPlugin_0", (String)"scmc-scmdi-form", (Object[])new Object[0]);
        labelAp.setName(new LocaleString(noDataTip));
        Style tipsLabelStyle = new Style();
        Margin margin = new Margin();
        margin.setBottom("12px");
        margin.setTop("6px");
        tipsLabelStyle.setMargin(margin);
        labelAp.setStyle(tipsLabelStyle);
        noDataTipFlex.getItems().add(nodataTip);
        noDataTipFlex.getItems().add(labelAp);
        flexItems.add(noDataTipFlex);
        return flexItems;
    }

    private void buildWarningResultInfo(DynamicObject warningResult) {
        MetricMapping metricMapping = WarningWorkBenchDetailPlugin.getMetricMapping(warningResult);
        this.getView().addClientCallBack(ASYNC_BUILD_WARNING_RESULT, Integer.valueOf(1000));
        ThreadPools.executeOnce((String)((Object)((Object)this)).getClass().getName(), () -> {
            Map<String, String> metricMap = this.convertToMap(metricMapping, warningResult);
            this.getPageCache().put(LATEST_METRIC_WARNING_RESULT_ID, warningResult.getString("id"));
            this.getPageCache().put(LATEST_METRIC, JSON.toJSONString(metricMap));
        });
        FlexPanelAp dimensionFlex = this.getDimensionFlex(warningResult, metricMapping);
        this.buildCustomControl("dimensionmoduleflex", "dimensionflex", Collections.singletonList(dimensionFlex.createControl()));
        this.buildThreshold(warningResult);
    }

    private Map<String, String> convertToMap(MetricMapping metricMapping, DynamicObject warningResult) {
        String metricMetaNumber = metricMapping.getBizEntity().getNumber();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)metricMetaNumber);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        Row latestMetric = MetricServiceHolder.getMetricService().getLatestMetricsByWarningResult(metricMapping, warningResult);
        return metricMapping.getMetricMappingEntry().stream().collect(Collectors.toMap(MetricMappingEntry::getMetricFieldKey, metricMappingEntry -> {
            IDataEntityProperty entityProperty = (IDataEntityProperty)properties.get((Object)metricMappingEntry.getBizEntityFieldKey());
            return this.getLastValue(entityProperty, latestMetric, (MetricMappingEntry)metricMappingEntry);
        }));
    }

    private Map<String, String> getLatestMetric() {
        IPageCache pageCache = this.getPageCache();
        String latestMetric = pageCache.get(LATEST_METRIC);
        if (StringUtils.isNotBlank((String)latestMetric)) {
            return (Map)JSON.parseObject((String)latestMetric, Map.class);
        }
        return new HashMap<String, String>(2);
    }

    private boolean isLoadedLatestMetric(String billId) {
        String isLoaded = this.getPageCache().get(LATEST_METRIC_WARNING_RESULT_ID);
        return StringUtils.isNotBlank((String)isLoaded) && billId.equals(isLoaded);
    }

    public void buildMetricControl() {
        DynamicObject warningResult = this.getWarningResult();
        String id = warningResult.getString("id");
        if (!this.isLoadedLatestMetric(id)) {
            this.getView().addClientCallBack(ASYNC_BUILD_WARNING_RESULT, Integer.valueOf(1000));
        } else {
            this.buildMetricField(warningResult);
        }
    }

    private void buildMetricField(DynamicObject warningResult) {
        MetricMapping metricMapping = WarningWorkBenchDetailPlugin.getMetricMapping(warningResult);
        FlexPanelAp metricFlex = this.getMetricFlex(warningResult, metricMapping);
        this.buildCustomControl(METRIC_MODULE_FLEX, "metricflex", Collections.singletonList(metricFlex.createControl()));
    }

    private static MetricMapping getMetricMapping(DynamicObject warningResult) {
        return MetricDataHelper.getMetricMapping((String)warningResult.getString("warning_object.id"));
    }

    private FlexPanelAp getDimensionFlex(DynamicObject warningResult, MetricMapping metricMapping) {
        FlexPanelAp dimensionFlex = new FlexPanelAp();
        dimensionFlex.setKey("dimensionflex");
        List<DynamicField> metricFields = this.getMetricFields(warningResult);
        List<MetricMappingEntry> displayedMetricEntry = this.getDisplayedFieldEntry(metricFields, metricMapping, FieldTypeEnum.DIMENSION);
        List dimensionItems = displayedMetricEntry.stream().map(dimension -> {
            DynamicField dynamicField = metricFields.stream().filter(field -> dimension.getBizEntityFieldKey().equals(field.getKey())).findFirst().orElseGet(DynamicField::new);
            return this.getDynamicFieldAp(dynamicField, dynamicField.getDisplayValue(), (MetricMappingEntry)dimension);
        }).collect(Collectors.toList());
        dimensionFlex.getItems().addAll(dimensionItems);
        return dimensionFlex;
    }

    private List<DynamicField> getMetricFields(DynamicObject warningResult) {
        String dynamicFieldsTag = warningResult.getString("dynamic_fields_tag");
        Map map = (Map)JSON.parseObject((String)dynamicFieldsTag, (TypeReference)new TypeReference<Map<String, List<DynamicField>>>(){}, (Feature[])new Feature[0]);
        if (map != null) {
            return (List)map.get("fromMetric");
        }
        return new ArrayList<DynamicField>(0);
    }

    private FlexPanelAp getMetricFlex(DynamicObject warningResult, MetricMapping metricMapping) {
        Map<String, String> latestMetricMap = this.getLatestMetric();
        List<DynamicField> metricFields = this.getMetricFields(warningResult);
        List<MetricMappingEntry> displayedFieldEntries = this.getDisplayedFieldEntry(metricFields, metricMapping, FieldTypeEnum.METRIC);
        List metricFlexItems = displayedFieldEntries.stream().map(entry -> {
            DynamicField dynamicField = metricFields.stream().filter(field -> entry.getBizEntityFieldKey().equals(field.getKey())).findFirst().orElseGet(DynamicField::new);
            String lastValue = latestMetricMap.get(entry.getMetricFieldKey()) != null ? (String)latestMetricMap.get(entry.getMetricFieldKey()) : "-";
            String metricValue = dynamicField.getDisplayValue() + " / " + lastValue;
            return this.getDynamicFieldAp(dynamicField, metricValue, (MetricMappingEntry)entry);
        }).collect(Collectors.toList());
        FlexPanelAp metricFlex = new FlexPanelAp();
        metricFlex.setKey("metricflex");
        metricFlex.getItems().addAll(metricFlexItems);
        return metricFlex;
    }

    private List<MetricMappingEntry> getDisplayedFieldEntry(List<DynamicField> dynamicFields, MetricMapping metricMapping, FieldTypeEnum fieldType) {
        Set keySet = dynamicFields.stream().map(DynamicField::getKey).collect(Collectors.toSet());
        return metricMapping.getMetricMappingEntry().stream().filter(metricMappingEntry -> fieldType.getTypeCode().equals(metricMappingEntry.getFieldType().getTypeCode()) && keySet.contains(metricMappingEntry.getBizEntityFieldKey())).collect(Collectors.toList());
    }

    private FlexPanelAp getDynamicFieldAp(DynamicField dynamicField, String fieldText, MetricMappingEntry metricMappingEntry) {
        String metricKey = metricMappingEntry.getBizEntityFieldKey();
        String title = dynamicField.getFieldName();
        LabelAp labelTitle = new LabelAp();
        labelTitle.setForeColor("#666666");
        labelTitle.setName(new LocaleString(title));
        labelTitle.setKey(metricKey + "_title");
        labelTitle.setFontSize(12);
        LabelAp labelText = new LabelAp();
        labelText.setName(new LocaleString(fieldText));
        labelText.setKey(metricKey + "_text");
        labelText.setFontSize(FieldTypeEnum.METRIC == metricMappingEntry.getFieldType() ? 16 : 14);
        String textColor = FieldTypeEnum.METRIC.getTypeCode().equals(metricMappingEntry.getFieldType().getTypeCode()) ? "#ED812B" : "#212121";
        labelText.setForeColor(textColor);
        Style style = FieldTypeEnum.METRIC == metricMappingEntry.getFieldType() ? new Style() : this.setFieldBorder(new Style());
        Padding padding = new Padding();
        padding.setTop("6px");
        padding.setBottom("6px");
        style.setPadding(padding);
        labelText.setStyle(style);
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        labelText.setWidth(new LocaleString("150px"));
        flexPanelAp.setKey(metricKey + "_flex");
        flexPanelAp.setDirection("column");
        flexPanelAp.getItems().add(labelTitle);
        flexPanelAp.getItems().add(labelText);
        return flexPanelAp;
    }

    private void buildThreshold(DynamicObject warningResult) {
        Label thresholdLabel = (Label)this.getView().getControl("threshold_text");
        thresholdLabel.setText(warningResult.getString("filter_condition_read_tag"));
    }

    private String getLastValue(IDataEntityProperty entityProperty, Row row, MetricMappingEntry metric) {
        String displayValue;
        if (row == null) {
            return "-";
        }
        try {
            Object metricValue = row.get(metric.getMetricFieldKey());
            if (entityProperty instanceof BasedataProp) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)metricValue, (String)((BasedataProp)entityProperty).getBaseEntityId());
                displayValue = ((BasedataProp)entityProperty).getDisplayValue((Object)dynamicObject);
            } else {
                displayValue = entityProperty instanceof DecimalProp ? ((BigDecimal)metricValue).stripTrailingZeros().toPlainString() : String.valueOf(row.get(metric.getMetricFieldKey()));
            }
        }
        catch (ModelException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return displayValue;
    }

    private void buildWarningInfo(DynamicObject warningResult) {
        IDataModel model = this.getView().getModel();
        String warningSchemeName = warningResult.getDynamicObject("warning_config") != null ? warningResult.getDynamicObject("warning_config").getString("name") : null;
        Label warningSchemeNameLabel = (Label)this.getControl("warning_scheme_name");
        warningSchemeNameLabel.setText(warningSchemeName);
        String processStatus = warningResult.getString("processingstatus");
        this.setProcessStatus(processStatus);
        Object warningLevel = warningResult.get("warninglevel");
        model.setValue("warninglevel", warningLevel);
        Object warningTitle = warningResult.get("warning_title");
        model.setValue("warning_title", warningTitle);
        Object createTime = warningResult.get("createtime");
        model.setValue("warning_occurrence_time", createTime);
        Object warningContent = warningResult.get("warning_content");
        model.setValue("warning_content", warningContent);
        model.setValue("duplicated_count", warningResult.get("duplicated_count"));
        model.setValue("exec_type", warningResult.get("exec_type"));
    }

    private boolean isAddTips() {
        Long billId = this.getBillId();
        String warningResultFormKey = this.getWarningResultFormKey();
        QFilter qFilter = new QFilter("rdiding_data", "=", (Object)billId);
        qFilter.and("rdiding_data_table", "=", (Object)warningResultFormKey);
        return QueryServiceHelper.exists((String)"scmdi_warn_ridding_log", (QFilter[])qFilter.toArray());
    }

    private void setProcessStatus(String processStatus) {
        ProcessStatusEnum statusEnumByCode = ProcessStatusEnum.getStatusEnumByCode(String.valueOf(processStatus));
        this.setButtonVisible(statusEnumByCode);
        Label processStatusLabel = (Label)this.getControl("process_status");
        processStatusLabel.setText(statusEnumByCode.getStatusText());
        this.getView().updateControlMetadata("process_status", statusEnumByCode.getCustomMap());
    }

    private void setButtonVisible(ProcessStatusEnum processStatus) {
        this.getView().setVisible(Boolean.valueOf(ProcessStatusEnum.UNPROCESSED == processStatus), new String[]{"process_completed"});
        this.getView().setVisible(Boolean.valueOf(ProcessStatusEnum.PROCESSED == processStatus), new String[]{"reprocess"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String customEventName = this.getPageCache().get("custom_event_name");
        if (AFTER_SHOW_SLIDE_BILL.equals(customEventName)) {
            DynamicObject warningResult = this.getWarningResult();
            this.buildWarningInfo(warningResult);
            this.buildWarningResultInfo(warningResult);
            DynamicObject[] warningSolutions = this.getSortedSolutionSchemes(warningResult);
            this.buildWarningSolutionScheme(warningSolutions);
            this.buildOtherInfo(warningResult);
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if (ASYNC_BUILD_WARNING_RESULT.equals(e.getName())) {
            DynamicObject warningResult = this.getWarningResult();
            MetricMapping metricMapping = WarningWorkBenchDetailPlugin.getMetricMapping(warningResult);
            if (metricMapping == null) {
                return;
            }
            this.buildMetricControl();
        }
    }

    private DynamicObject[] getSortedSolutionSchemes(DynamicObject warningResult) {
        DynamicObjectCollection dynamicObjectCollection = warningResult.getDynamicObjectCollection("warning_config.solution_entryentity");
        List<Long> solutionSchemeIds = dynamicObjectCollection.stream().map(dynamicObject -> dynamicObject.getLong("solution_scheme.masterid")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", solutionSchemeIds);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] warningSolutions = BusinessDataServiceHelper.load((String)"scmdi_warning_solution", (String)"name,description,entryentity.operation", (QFilter[])qFilter.toArray());
        this.sortScheme(warningSolutions, solutionSchemeIds);
        return warningSolutions;
    }

    private void sortScheme(DynamicObject[] warningSchemes, List<Long> solutionSchemeIds) {
        Arrays.sort(warningSchemes, Comparator.comparing(p -> solutionSchemeIds.indexOf(p.getLong("id"))));
    }

    private DynamicObject getWarningResult() {
        String entityKey = this.getWarningResultFormKey();
        Long billId = this.getBillId();
        if (StringUtils.isNotBlank((String)entityKey) && billId != 0L) {
            return BusinessDataServiceHelper.loadSingle((Object)billId, (String)entityKey);
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityKey);
        return new DynamicObject((DynamicObjectType)dataEntityType);
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String key = e.getKey();
        if (AFTER_SHOW_SLIDE_BILL.equals(key)) {
            this.getPageCache().put("custom_event_name", AFTER_SHOW_SLIDE_BILL);
            this.initPage(e);
        }
        if (SIDESLIPPING_FLEX.equals(key)) {
            this.getPageCache().put("custom_event_name", SIDESLIPPING_FLEX);
            this.buildCustomControl(METRIC_MODULE_FLEX, "metricflex", Collections.singletonList(new HashMap(0)));
            this.buildCustomControl("dimensionmoduleflex", "dimensionflex", Collections.singletonList(new HashMap(0)));
            this.buildCustomControl(SOLUTION_SCHEME_FLEX, SOLUTION_PARENT_FLEX, Collections.singletonList(new HashMap(0)));
            Label thresholdLabel = (Label)this.getView().getControl("threshold_text");
            thresholdLabel.setText(null);
            this.getPageCache().put(BILL_ID, null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        Object[] ids = new Long[]{this.getBillId()};
        switch (operateKey) {
            case "reprocess": {
                OperationResult reprocess = OperationServiceHelper.executeOperate((String)"reprocess", (String)this.getWarningResultFormKey(), (Object[])ids, (OperateOption)OperateOption.create());
                String reprocessText = ResManager.loadKDString((String)"\u91cd\u65b0\u5904\u7406\u6210\u529f\u3002", (String)"WarningWorkBenchDetailPlugin_1", (String)"scmc-scmdi-form", (Object[])new Object[0]);
                this.afterSucceed(reprocess, reprocessText);
                break;
            }
            case "process_completed": {
                OperationResult processCompleted = OperationServiceHelper.executeOperate((String)"process_completed", (String)this.getWarningResultFormKey(), (Object[])ids, (OperateOption)OperateOption.create());
                String processText = ResManager.loadKDString((String)"\u5904\u7406\u5b8c\u6210\u6210\u529f\u3002", (String)"WarningWorkBenchDetailPlugin_2", (String)"scmc-scmdi-form", (Object[])new Object[0]);
                this.afterSucceed(processCompleted, processText);
                break;
            }
        }
    }

    private void afterSucceed(OperationResult reprocess, String successText) {
        if (reprocess.isSuccess()) {
            QFilter qFilter = new QFilter("id", "=", reprocess.getSuccessPkIds().get(0));
            DynamicObject warningResult = QueryServiceHelper.queryOne((String)this.getWarningResultFormKey(), (String)"processingstatus,processor,processingtime,processingway", (QFilter[])qFilter.toArray());
            this.setProcessStatus(warningResult.getString("processingstatus"));
            this.getView().getModel().setValue("processor", warningResult.getLong("processor") == 0L ? null : Long.valueOf(warningResult.getLong("processor")));
            this.getView().getModel().setValue("processingtime", warningResult.get("processingtime"));
            this.getView().getModel().setValue("processingway", warningResult.get("processingway"));
            this.getView().showSuccessNotification(successText);
            IFormView view = this.getView().getView(this.getParentPageId());
            BillList billList = (BillList)view.getControl("billlistap");
            billList.refresh();
            this.getView().sendFormAction(view);
        }
    }

    public void beforeShowTips(BeforeShowTipsEvent event) {
        if (!this.isAddTips()) {
            event.setCancel(true);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam(WARNING_RESULT_FORM_KEY, (Object)this.getWarningResultFormKey());
        showParameter.setCustomParam(BILL_ID, (Object)this.getBillId());
        event.setFormshowParameter(showParameter);
    }

    public void afterShowTips(AfterShowTipsEvent event) {
    }
}

