/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.solution;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.scmdi.common.utils.CommonUtils;

public class WarningWorkBenchListPlugin
extends AbstractListPlugin {
    public static final String SCMDI_WWB_DETAIL = "scmdi_wwb_detail";
    public static final String BILL_LIST_KEY = "billlistap";
    public static final String WARNING_RESULT_OBJECT = "warning_result_object";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String billTitle = ResManager.loadKDString((String)"\u9884\u8b66\u5904\u7406\u5de5\u4f5c\u53f0", (String)"WarningWorkBenchPlugin_0", (String)"scmc-scmdi-form", (Object[])new Object[0]);
        this.getView().setFormTitle(new LocaleString(billTitle));
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, String> param = new HashMap<String, String>(4);
        param.put("dc", "right");
        param.put("formId", SCMDI_WWB_DETAIL);
        proxy.addAction("setSlideBillFormId", param);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Object warningConfigIdParam = this.getView().getFormShowParameter().getCustomParam("warningConfigIdParam");
        if (!CommonUtils.isNullOrEmpty((Object)warningConfigIdParam)) {
            FilterColumn filterColumn = args.getFilterColumn("warning_config.number");
            filterColumn.setDefaultValue(warningConfigIdParam.toString());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "quick_process": {
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                proxy.removeAction("showSlideBill");
                HashMap<String, Object> showParams = new HashMap<String, Object>(4);
                showParams.put("formId", SCMDI_WWB_DETAIL);
                HashMap<String, String> params = new HashMap<String, String>(4);
                params.put("billId", String.valueOf(this.getFocusRowPkId()));
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"scmdi_warnresult_template", (String)WARNING_RESULT_OBJECT, (QFilter[])new QFilter("id", "=", this.getFocusRowPkId()).toArray());
                if (dynamicObject == null || dynamicObject.getString(WARNING_RESULT_OBJECT) == null) {
                    String message = ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u6570\u636e\u7ed3\u679c\u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"WarningWorkBenchListPlugin_1", (String)"scmc-scmdi-form", (Object[])new Object[0]);
                    throw new KDBizException(message);
                }
                String warningResultObject = dynamicObject.getString(WARNING_RESULT_OBJECT);
                params.put("warningResultFormKey", warningResultObject);
                params.put("mainPageId", this.getAppHomePageId());
                showParams.put("params", params);
                proxy.addAction("showSlideBill", showParams);
                this.cleanedSelectedRow();
                break;
            }
            case "reprocess_op": 
            case "completed_op": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "processlog": {
                BillList billList = (BillList)this.getControl(BILL_LIST_KEY);
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
                if (primaryKeyValues.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u67e5\u770b\u5904\u7406\u65e5\u5fd7\u3002", (String)"WarningWorkBenchListPlugin_2", (String)"scmc-scmdi-form", (Object[])new Object[0]));
                    break;
                }
                Object primaryKeyValue = primaryKeyValues[0];
                QFilter qFilter = new QFilter("warnresult", "=", primaryKeyValue);
                DynamicObject log = BusinessDataServiceHelper.loadSingle((String)"scmdi_warning_process_log", (QFilter[])new QFilter[]{qFilter});
                if (log == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u6ca1\u6709\u5904\u7406\u65e5\u5fd7\u3002", (String)"WarningWorkBenchListPlugin_3", (String)"scmc-scmdi-form", (Object[])new Object[0]));
                    break;
                }
                BillShowParameter billShowParameter = new BillShowParameter();
                billShowParameter.setFormId("scmdi_warning_process_log");
                billShowParameter.setPkId(log.getPkValue());
                billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm((FormShowParameter)billShowParameter);
                break;
            }
        }
    }

    private String getAppHomePageId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter != null) {
            return formShowParameter.getAppId() + formShowParameter.getRootPageId();
        }
        return this.getView().getServiceAppId(this.getView().getPageId()) + this.getView().getMainView().getPageId();
    }

    private void cleanedSelectedRow() {
        BillList billList = (BillList)this.getControl(BILL_LIST_KEY);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        ListSelectedRow focusRow = selectedRows.stream().filter(row -> row.getPrimaryKeyValue().equals(this.getFocusRowPkId())).findFirst().get();
        int[] selectRows = new int[]{focusRow.getRowKey()};
        billList.clearSelection();
        billList.selectRows(selectRows, focusRow.getRowKey());
    }
}

