/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.solution;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.scmdi.common.vo.bos.FieldTypeEnum;
import kd.scmc.scmdi.form.vo.ridding.RiddingLogMetricField;
import kd.scmc.scmdi.form.vo.ridding.WarningMetricRiddingLog;

public class WarningWorkNoiseReduceTipPlugin
extends AbstractFormPlugin
implements ClickListener {
    private List<WarningMetricRiddingLog> warningRiddingMetricColl;
    private static final String ENTRY_ENTITY = "entryentity";
    public static final String FIELD_KEY = "entryentity.field_key";
    public static final String FIELD_VALUE = "entryentity.field_value";
    public static final String FIELD_NAME = "entryentity.field_name";
    public static final String FIELD_CLASS_TYPE = "entryentity.field_class_type";
    public static final String CREATE_TIME = "createtime";
    public static final String BILL_ID = "billId";
    public static final String WARNING_RESULT_FORM_KEY = "warningResultFormKey";
    public static final String METRIC_FIELD_TYPE = "entryentity.metric_field_type";
    public static final String RDIDING_DATA_TABLE = "rdiding_data_table";
    public static final String RDIDING_DATA = "rdiding_data";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        Map customParams = showParameter.getCustomParams();
        Long billId = (Long)customParams.get(BILL_ID);
        String warningResultFormKey = (String)customParams.get(WARNING_RESULT_FORM_KEY);
        EntryAp entryAp = this.createDynamicEntryAp(this.getLogEntryFieldMap(billId, warningResultFormKey));
        HashMap<String, String> mapEntry = new HashMap<String, String>(2);
        mapEntry.put("id", ENTRY_ENTITY);
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        e.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(ENTRY_ENTITY);
        Map<String, String> entryFieldMap = this.getLogEntryFieldMap();
        this.registerDynamicEntryProps(entryType, entryFieldMap);
        e.setNewEntityType(newMainType);
    }

    public void createNewData(BizDataEventArgs e) {
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        this.buildEntryData(dataEntity);
        e.setDataEntity((Object)dataEntity);
    }

    public void beforeBindData(EventObject e) {
        EntryAp dynamicEntryAp = this.createDynamicEntryAp(this.getLogEntryFieldMap());
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        List fieldEdits = ((Container)dynamicEntryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            fieldEdit.setView(this.getView());
            entryGrid.getItems().add(fieldEdit);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        List<WarningMetricRiddingLog> warningMetricRiddingLogColl = this.getLogColl();
        List<RiddingLogMetricField> riddingLogMetricEntries = warningMetricRiddingLogColl.get(0).getRiddingLogMetricFields();
        Set collect = riddingLogMetricEntries.stream().map(RiddingLogMetricField::getFieldKey).collect(Collectors.toSet());
        if (collect.contains(e.getKey())) {
            TextEdit textEdit = new TextEdit();
            textEdit.setKey(e.getKey());
            textEdit.setEntryKey(ENTRY_ENTITY);
            textEdit.setView(this.getView());
            e.setControl((Control)textEdit);
        }
    }

    private void buildEntryData(DynamicObject dataEntity) {
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        List<WarningMetricRiddingLog> warningMetricRiddingLogColl = this.getLogColl();
        warningMetricRiddingLogColl.forEach(warningMetricRiddingLog -> {
            DynamicObject newRow = new DynamicObject(rows.getDynamicObjectType());
            String createTime = warningMetricRiddingLog.getCreateTime();
            String formattedDateTime = this.getDateTimeWithoutMills(createTime);
            newRow.set(CREATE_TIME, (Object)formattedDateTime);
            List<RiddingLogMetricField> riddingLogMetricEntries = warningMetricRiddingLog.getRiddingLogMetricFields();
            riddingLogMetricEntries.forEach(entry -> {
                String fieldClassType = entry.getFiledTypeClass();
                if (this.isBigDecimalType(fieldClassType)) {
                    newRow.set(entry.getFieldKey(), entry.getFieldValue() != null ? new BigDecimal(entry.getFieldValue()).stripTrailingZeros().toPlainString() : null);
                } else {
                    newRow.set(entry.getFieldKey(), (Object)entry.getFieldValue());
                }
            });
            rows.add((Object)newRow);
        });
    }

    private String getDateTimeWithoutMills(String createTime) {
        DateTimeFormatter formatterWithMillis = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true).toFormatter();
        LocalDateTime dateTime = LocalDateTime.parse(createTime, formatterWithMillis);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return dateTime.format(formatter);
    }

    private boolean isBigDecimalType(String fieldClassType) {
        try {
            Class<BigDecimal> aClass = Class.forName(fieldClassType);
            return aClass.isAssignableFrom(BigDecimal.class);
        }
        catch (ClassNotFoundException ex) {
            String format = String.format("\u627e\u4e0d\u5230\u7c7b\u578b\u4e3a%s\u7684\u7c7b", fieldClassType);
            throw new KDBizException(format);
        }
    }

    private List<WarningMetricRiddingLog> getLogColl() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        Long billId = (Long)customParams.get(BILL_ID);
        String warningResultFormKey = (String)customParams.get(WARNING_RESULT_FORM_KEY);
        return this.getLogColl(billId, warningResultFormKey);
    }

    private List<WarningMetricRiddingLog> getLogColl(Long billId, String entityName) {
        if (this.warningRiddingMetricColl != null) {
            return this.warningRiddingMetricColl;
        }
        DynamicObjectCollection warnRiddingLogDynamicColl = this.getLogDynamicObjectCollection(billId, entityName);
        Map<String, List<DynamicObject>> convertMap = warnRiddingLogDynamicColl.stream().collect(Collectors.groupingBy(item -> item.getString(CREATE_TIME)));
        List<WarningMetricRiddingLog> collect = convertMap.entrySet().stream().map(entry -> {
            WarningMetricRiddingLog warningMetricRiddingLog = new WarningMetricRiddingLog();
            warningMetricRiddingLog.setCreateTime((String)entry.getKey());
            List<RiddingLogMetricField> riddingLogMetricEntries = ((List)entry.getValue()).stream().map(item -> {
                RiddingLogMetricField riddingLogMetricField = new RiddingLogMetricField();
                riddingLogMetricField.setFieldKey(item.getString(FIELD_KEY));
                riddingLogMetricField.setFieldName(item.getString(FIELD_NAME));
                riddingLogMetricField.setFieldValue(item.getString(FIELD_VALUE));
                riddingLogMetricField.setFiledTypeClass(item.getString(FIELD_CLASS_TYPE));
                return riddingLogMetricField;
            }).collect(Collectors.toList());
            warningMetricRiddingLog.setRiddingLogMetricFields(riddingLogMetricEntries);
            return warningMetricRiddingLog;
        }).sorted((a, b) -> b.getCreateTime().compareTo(a.getCreateTime())).collect(Collectors.toList());
        this.warningRiddingMetricColl = collect;
        return collect;
    }

    private DynamicObjectCollection getLogDynamicObjectCollection(Long billId, String entityName) {
        QFilter qFilter = new QFilter(RDIDING_DATA, "=", (Object)billId);
        qFilter.and(RDIDING_DATA_TABLE, "=", (Object)entityName);
        qFilter.and(METRIC_FIELD_TYPE, "=", (Object)FieldTypeEnum.METRIC.name());
        return QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"scmdi_warn_ridding_log", (String)"id,createtime,entryentity.field_class_type,entryentity.field_key,entryentity.field_value,entryentity.field_name", (QFilter[])qFilter.toArray(), null);
    }

    private EntryAp createDynamicEntryAp(Map<String, String> entryMap) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entry");
        entryMap.forEach((key, value) -> {
            EntryFieldAp fieldAp = new EntryFieldAp();
            fieldAp.setWidth(new LocaleString("100px"));
            fieldAp.setId(key);
            fieldAp.setKey(key);
            fieldAp.setName(new LocaleString(value));
            fieldAp.setFireUpdEvt(true);
            TextField field = new TextField();
            field.setId(key);
            field.setKey(key);
            fieldAp.setField((Field)field);
            entryAp.getItems().add(fieldAp);
        });
        return entryAp;
    }

    private Map<String, String> getLogEntryFieldMap() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long billId = (Long)customParams.get(BILL_ID);
        String formKey = (String)customParams.get(WARNING_RESULT_FORM_KEY);
        return this.getLogEntryFieldMap(billId, formKey);
    }

    private Map<String, String> getLogEntryFieldMap(Long billId, String entityName) {
        HashMap<String, String> entryMap = new HashMap<String, String>(10);
        String columnName = ResManager.loadKDString((String)"\u521b\u5efa\u65f6\u95f4", (String)"WarningWorkNoiseReduceTipPlugin_0", (String)"scmc-scmdi-form", (Object[])new Object[0]);
        entryMap.put(CREATE_TIME, columnName);
        List<WarningMetricRiddingLog> warningMetricRiddingLogColl = this.getLogColl(billId, entityName);
        List<RiddingLogMetricField> riddingLogMetricEntries = warningMetricRiddingLogColl.get(0).getRiddingLogMetricFields();
        Map<String, String> logMap = riddingLogMetricEntries.stream().collect(Collectors.toMap(RiddingLogMetricField::getFieldKey, RiddingLogMetricField::getFieldName));
        entryMap.putAll(logMap);
        return entryMap;
    }

    private void registerDynamicEntryProps(EntryType entryType, Map<String, String> entryFieldMap) {
        entryFieldMap.forEach((key, value) -> {
            TextProp textProp = new TextProp();
            textProp.setName(key);
            textProp.setDisplayName(new LocaleString(key));
            textProp.setDbIgnore(true);
            textProp.setAlias("");
            entryType.registerSimpleProperty((DynamicSimpleProperty)textProp);
        });
    }
}

