/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.warning;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.scmdi.business.judge.core.RuleEntryEditor;
import kd.scmc.scmdi.common.utils.CommonUtils;
import kd.scmc.scmdi.common.utils.mapper.DynamicDataMapper;
import kd.scmc.scmdi.common.vo.bos.BosEntity;
import kd.scmc.scmdi.common.vo.bos.MessageChannel;
import kd.scmc.scmdi.common.vo.bos.StatusEnum;
import kd.scmc.scmdi.common.vo.bos.WarnMessageSendType;
import kd.scmc.scmdi.form.common.formula.RuleHandler;
import kd.scmc.scmdi.form.common.helper.WarningConfigHelper;
import kd.scmc.scmdi.form.common.utils.DynamicToMapUtils;
import kd.scmc.scmdi.form.enumeration.warning.MonitorSlotEnum;
import kd.scmc.scmdi.form.enumeration.warning.UpgradePolicy;
import kd.scmc.scmdi.form.handler.upgrade.UpgradeRuleProvider;
import kd.scmc.scmdi.form.plugin.form.AbstractPojoPlugin;
import kd.scmc.scmdi.form.vo.warning.WarnConfig;
import kd.scmc.scmdi.form.vo.warning.WarningExecuteResult;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

public class WarningConfigPlugin
extends AbstractPojoPlugin<WarnConfig>
implements TabSelectListener,
BeforeF7SelectListener {
    private static final String CONTENT_EDIT_FORM = "scmdi_monitor_warncontent";
    private static final String TITLE_EDIT_FORM = "scmdi_monitor_warntitle";
    private static final String PARAM_TEXT = "param_text";
    private static final String PARAM_TREE = "param_tree";
    private static final String MSG_CHANNEL = "msg_channel";
    private static final String WARNING_OBJECT = "warning_object";
    private static final String WARNING_RESULT_PERSIST = "warning_result_persist";
    private static final String COMMON_FILTER_CONDITION = "filtergridap";
    public static final String SOLUTION_SCHEME = "solution_scheme";
    public static final String RELATED_QUERY_WARN_RESULT = "related_query_warn_result";
    public static final String ENABLE_WARNING_RIDDING = "enable_warning_ridding";
    public static final String SOLUTION_ENTRYENTITY = "solution_entryentity";
    public static final String TEST_RULE = "test_rule";
    public static final String STATUS = "status";
    public static final String AUDIT = "audit";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"monitor_notify_title", "monitor_notify_text", "filter_condition", AUDIT});
        BasedataEdit warningObj = (BasedataEdit)this.getControl(WARNING_OBJECT);
        warningObj.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit persist = (BasedataEdit)this.getControl(WARNING_RESULT_PERSIST);
        persist.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit solutionScheme = (BasedataEdit)this.getControl(SOLUTION_SCHEME);
        solutionScheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit warningRidding = (BasedataEdit)this.getControl("warning_ridding");
        warningRidding.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        UpgradeRuleProvider.getRuleEntryEditor().registerListener(this.getView());
    }

    private void setElementsVisibilityAndEnable() {
        this.triggerChangeRiddingConfig();
        this.triggerChangeUpGradeEnabled();
        this.triggerChangeUpGradePolicy();
        this.systemPreset();
    }

    private void systemPreset() {
        IFormView view = this.getView();
        WarnConfig pojo = (WarnConfig)this.getPojo();
        Boolean isPreSet = pojo.getSysPreset();
        view.setEnable(Boolean.valueOf(isPreSet == false), new String[]{"number", "name", "group", WARNING_OBJECT, WARNING_RESULT_PERSIST, "description", "rule_entry", "monitor_category", "monitor_slot", "monitor_day", "monitor_date_range", "monitor_time", ENABLE_WARNING_RIDDING, "warning_ridding", "upgrade_enabled", "upgrade_entry", "upgrade_policy", "specified_warning_level", "upgrade_notify_type", "upgrade_notify_user", SOLUTION_SCHEME, SOLUTION_ENTRYENTITY});
        view.setVisible(Boolean.valueOf(isPreSet == false), new String[]{"bar_save", "bar_delete", "bar_disable", "testrule", "bar_modify", "bar_submit", "bar_audit", "unsubmit", "unaudit", RELATED_QUERY_WARN_RESULT, "new_rule_button", "delete_rule_button", "new_upgrade_entry", "delete_upgrade_entry", "add_entry", "delete_entry"});
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        Control control = (Control)e.getSource();
        switch (key = control.getKey()) {
            case "monitor_notify_title": {
                this.showTextEditDialog("monitor_notify_title");
                break;
            }
            case "monitor_notify_text": {
                this.showTextEditDialog("monitor_notify_text");
                break;
            }
            case "filter_condition": {
                this.editRule();
                break;
            }
        }
    }

    private void beforeWarningObjF7Select(ListShowParameter showParameter, String baseEntityNumber) {
        Set<String> formKeys = WarningConfigHelper.getRelatedMetaFormKey(baseEntityNumber);
        QFilter qFilter = new QFilter("number", "in", formKeys);
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void editRule() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("scmdi_warning_rule_edit");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        BosEntity warningObject = ((WarnConfig)this.getPojo()).getWarningObject();
        if (warningObject == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u9884\u8b66\u5bf9\u8c61\u3002", (String)"EarlyWarningConfigPlugin_11", (String)"scmc-scmdi-form", (Object[])new Object[0]));
            return;
        }
        parameter.setCustomParam(WARNING_OBJECT, (Object)warningObject.getNumber());
        IDataModel model = this.getModel();
        int currRowIndex = model.getEntryCurrentRowIndex("rule_entry");
        String value = (String)this.getView().getModel().getValue("filter_condition_json_tag", currRowIndex);
        parameter.setCustomParam("filter_condition_json_tag", (Object)value);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "filter_condition"));
        this.getView().showForm(parameter);
    }

    private void showTextEditDialog(String field) {
        IDataModel model = this.getModel();
        WarnConfig warnConfig = (WarnConfig)this.getPojo();
        BosEntity warnObj = warnConfig.getWarningObject();
        if (warnObj == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u9884\u8b66\u5bf9\u8c61\u3002", (String)"EarlyWarningConfigPlugin_11", (String)"scmc-scmdi-form", (Object[])new Object[0]));
            return;
        }
        List<TreeNode> rootNodes = DynamicToMapUtils.getTreeNodes(warnConfig);
        if (rootNodes == null) {
            return;
        }
        String treeJson = rootNodes == null ? "" : SerializationUtils.toJsonString(rootNodes);
        FormShowParameter parameter = new FormShowParameter();
        if ("monitor_notify_text".equals(field)) {
            parameter.setFormId(CONTENT_EDIT_FORM);
        } else if ("monitor_notify_title".equals(field)) {
            parameter.setFormId(TITLE_EDIT_FORM);
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        int currRowIndex = model.getEntryCurrentRowIndex("rule_entry");
        parameter.setCustomParam(PARAM_TEXT, (Object)((String)model.getValue(field.equals("monitor_notify_text") ? "monitor_notify_content_tag" : field, currRowIndex)));
        parameter.setCustomParam(PARAM_TREE, (Object)treeJson);
        parameter.setCustomParam("type", (Object)field);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, field));
        this.getView().showForm(parameter);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.slotOptionChanged();
        this.setDefaultTime();
        this.generateMonitorDescription();
        this.setMessageType();
        UpgradeRuleProvider.getRuleEntryEditor().beforeBindData(this.getView());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setElementsVisibilityAndEnable();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "test_rule": {
                String billStatus;
                QFilter qFilter = new QFilter("id", "=", this.getModel().getDataEntity().getPkValue());
                DynamicObject status = QueryServiceHelper.queryOne((String)this.getModel().getDataEntityType().getName(), (String)STATUS, (QFilter[])qFilter.toArray());
                String string = billStatus = status == null ? StatusEnum.SAVED.getValue() : status.getString(STATUS);
                if (StatusEnum.AUDITED.getValue().equals(billStatus)) break;
                String message = ResManager.loadKDString((String)"\u65b9\u6848\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u9884\u8b66\u65b9\u6848\u3002", (String)"WarningConfigPlugin_2", (String)"scmc-scmdi-form", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String key;
        super.afterDoOperation(evt);
        switch (key = evt.getOperateKey()) {
            case "batchfillentry": {
                int selectedRowIndex = this.getModel().getEntryCurrentRowIndex("rule_entry");
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("rule_entry");
                String focusField = entryGrid.getEntryState().getFocusField();
                if (!"monitor_notify_text".equals(focusField)) break;
                String monitor_notify_content = (String)this.getView().getModel().getValue("monitor_notify_content", selectedRowIndex);
                String monitor_notify_contentTag = (String)this.getView().getModel().getValue("monitor_notify_content_tag", selectedRowIndex);
                for (int i = selectedRowIndex; i < entryGrid.getEntryData().getEndIndex(); ++i) {
                    this.getView().getModel().setValue("monitor_notify_content", (Object)monitor_notify_content, i);
                    this.getView().getModel().setValue("monitor_notify_content_tag", (Object)monitor_notify_contentTag, i);
                }
                break;
            }
            case "test_rule": {
                OperationResult operationResult = evt.getOperationResult();
                if (operationResult != null && !operationResult.isSuccess()) break;
                Long ruleId = (Long)this.getModel().getDataEntity().getPkValue();
                WarningExecuteResult warningExecuteResult = new RuleHandler(ruleId).executeRule(true);
                String message = String.format(ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210\uff0c\u5171%1$s\u6761\u6570\u636e\uff0c\u89e6\u53d1%2$s\u6761\u9884\u8b66\uff0c\u5176\u4e2d\u53bb\u91cd\u7684\u9884\u8b66%3$s\u6761\u3002\u8017\u65f6%4$s\u79d2\u3002", (String)"EarlyWarningConfigPlugin_warning_count", (String)"scmc-scmdi-form", (Object[])new Object[0]), warningExecuteResult.getTotalDataCount(), warningExecuteResult.getWarningCount(), warningExecuteResult.getDuplicatedCount(), warningExecuteResult.getDurationInSeconds());
                this.getView().showTipNotification(message);
                break;
            }
            case "related_query_warn_result": {
                ListShowParameter showParameter = new ListShowParameter();
                DynamicObject warningResult = (DynamicObject)this.getModel().getValue(WARNING_RESULT_PERSIST);
                if (warningResult == null) {
                    String warningResultNullErrorMessage = ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u9884\u8b66\u7ed3\u679c\u5bf9\u8c61\u3002", (String)"WarningConfigPlugin_1", (String)"scmc-scmdi-form", (Object[])new Object[0]);
                    throw new KDBizException(warningResultNullErrorMessage);
                }
                Object warningResultNumber = this.getModel().getValue("number");
                showParameter.setBillFormId("scmdi_warnresult_template");
                showParameter.setCustomParam("warningConfigIdParam", warningResultNumber);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "monitor_notify_title": {
                this.setWarningResultTextContent("monitor_notify_title", returnData);
                break;
            }
            case "monitor_notify_text": {
                this.setWarningResultTextContent("monitor_notify_text", returnData);
                break;
            }
            case "filter_condition": {
                this.fulfillWarningRule((String)returnData);
                break;
            }
        }
    }

    private void fulfillWarningRule(String returnData) {
        IDataModel model = this.getModel();
        int currRowIndex = model.getEntryCurrentRowIndex("rule_entry");
        if (StringUtils.isNotEmpty((CharSequence)returnData)) {
            String ruleString;
            FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)returnData, FilterCondition.class);
            if (!CommonUtils.isNullOrEmpty((Object)condition.getFilterRow())) {
                FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)((WarnConfig)this.getPojo()).getWarningObject().getNumber()), condition);
                filterBuilder.buildFilter(false);
                String[] scripts = filterBuilder.buildFilterScript();
                ruleString = scripts[1];
            } else {
                ruleString = null;
            }
            ruleString = CommonUtils.subString(ruleString, (int)255);
            this.getView().getModel().setValue("filter_condition", (Object)ruleString, currRowIndex);
            this.getView().getModel().setValue("filter_condition_json_tag", (Object)returnData, currRowIndex);
        }
    }

    private void setWarningResultTextContent(String field, Object returnData) {
        if (returnData == null) {
            return;
        }
        Map map = (Map)returnData;
        String text = map == null ? "" : (String)map.get("text");
        IDataModel model = this.getModel();
        int currRowIndex = model.getEntryCurrentRowIndex("rule_entry");
        if (field.equals("monitor_notify_text")) {
            this.getModel().setValue("monitor_notify_text", (Object)CommonUtils.subString((String)text, (int)255), currRowIndex);
            this.getModel().setValue("monitor_notify_content_tag", (Object)text, currRowIndex);
        } else if (field.equals("monitor_notify_title")) {
            this.getModel().setValue(field, (Object)text, currRowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        RuleEntryEditor ruleEntryEditor = UpgradeRuleProvider.getRuleEntryEditor();
        ruleEntryEditor.propertyChange(this.getView(), e);
        switch (propertyName = e.getProperty().getName()) {
            case "filter_condition": {
                this.onWarningRuleChanged(e);
                break;
            }
            case "warning_object": {
                this.changeWarningObject(e);
                break;
            }
            case "enable_warning_ridding": {
                this.triggerChangeRiddingConfig();
                break;
            }
            case "upgrade_policy": {
                this.getModel().setValue("specified_warning_level", null);
                this.triggerChangeUpGradePolicy();
                break;
            }
            case "upgrade_enabled": {
                this.triggerChangeUpGradeEnabled();
                break;
            }
            case "monitor_time": 
            case "monitor_slot": 
            case "monitor_day": 
            case "monitor_date_range_start": 
            case "monitor_date_range_end": {
                if (propertyName.equals("monitor_slot")) {
                    this.getModel().setValue("monitor_day", null);
                }
                this.slotOptionChanged();
                this.generateMonitorDescription();
                break;
            }
        }
    }

    private void triggerChangeUpGradeEnabled() {
        WarnConfig pojo = (WarnConfig)this.getPojo();
        IFormView view = this.getView();
        Boolean upgradeEnabled = pojo.getUpgradeEnabled();
        view.setVisible(upgradeEnabled, new String[]{"upgrade_panel"});
        FieldEdit fieldEdit = (FieldEdit)this.getView().getControl("upgrade_policy");
        fieldEdit.setMustInput(upgradeEnabled.booleanValue());
        if (!upgradeEnabled.booleanValue()) {
            this.purgeUpgradeSettings();
        }
    }

    private void triggerChangeRiddingConfig() {
        WarnConfig pojo = (WarnConfig)this.getPojo();
        IFormView view = this.getView();
        Boolean enableWarningRidding = pojo.getEnableWarningRidding();
        view.setVisible(enableWarningRidding, new String[]{"warning_ridding"});
        FieldEdit control = (FieldEdit)view.getControl("warning_ridding");
        control.setMustInput(enableWarningRidding.booleanValue());
        if (!enableWarningRidding.booleanValue()) {
            pojo.setWarningRidding(null);
        }
    }

    private void triggerChangeUpGradePolicy() {
        boolean specified = UpgradePolicy.SPECIFIED == ((WarnConfig)this.getPojo()).getUpgradePolicy();
        this.getView().setVisible(Boolean.valueOf(specified), new String[]{"specified_warning_level"});
        IFormView view = this.getView();
        FieldEdit level = (FieldEdit)view.getControl("specified_warning_level");
        level.setMustInput(specified);
    }

    private void changeWarningObject(PropertyChangedArgs e) {
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if (oldValue == null) {
            return;
        }
        String errorMessage = ResManager.loadKDString((String)"\u4ee5\u4e0b\u4fe1\u606f\u5df2\u7ecf\u6e05\u7a7a\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\uff1a\u9884\u8b66\u89c4\u5219\u3001\u9884\u8b66\u964d\u566a\u3001\u9884\u8b66\u5347\u7ea7\u3001\u9884\u8b66\u5904\u7406\u3001\u9884\u8b66\u7ed3\u679c\u5bf9\u8c61\u3002", (String)"WarningConfigPlugin_warning_object", (String)"scmc-scmdi-form", (Object[])new Object[0]);
        this.getView().showTipNotification(errorMessage);
        IDataModel model = this.getModel();
        model.deleteEntryData("rule_entry");
        model.setValue("upgrade_notify_type", null);
        model.setValue("upgrade_notify_user", null);
        model.setValue(ENABLE_WARNING_RIDDING, (Object)"0");
        model.setValue("warning_ridding", null);
        this.purgeUpgradeSettings();
        model.deleteEntryData(SOLUTION_ENTRYENTITY);
        model.setValue(WARNING_RESULT_PERSIST, null);
    }

    private void purgeUpgradeSettings() {
        IDataModel model = this.getModel();
        model.setValue("upgrade_enabled", (Object)"0");
        UpgradeRuleProvider.getRuleEntryEditor().purgeRules(this.getView());
        model.setValue("upgrade_policy", null);
        model.setValue("specified_warning_level", null);
        model.setValue("upgrade_notify_type", null);
        model.setValue("upgrade_notify_user", null);
    }

    private void onWarningRuleChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (CommonUtils.isNullOrEmpty((Object)newValue)) {
            this.getView().getModel().setValue("filter_condition_json_tag", null, changeData.getRowIndex());
        }
    }

    private FilterCondition getFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(COMMON_FILTER_CONDITION);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        return condition;
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        this.getView().setVisible(Boolean.valueOf("basecondition".equals(tabKey)), new String[]{"ruletext"});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter formShowParameter;
        String key = ((BasedataEdit)evt.getSource()).getKey();
        if (WARNING_OBJECT.equals(key)) {
            formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u9884\u8b66\u5bf9\u8c61\u9009\u62e9", (String)"EarlyWarningConfigPlugin_17", (String)"scmc-scmdi-form", (Object[])new Object[0]));
            this.beforeWarningObjF7Select(formShowParameter, "scmdi_metric_template");
        }
        if (WARNING_RESULT_PERSIST.equals(key)) {
            formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u9884\u8b66\u7ed3\u679c\u5b58\u50a8\u8868", (String)"EarlyWarningConfigPlugin_18", (String)"scmc-scmdi-form", (Object[])new Object[0]));
            this.beforeWarningObjF7Select(formShowParameter, "scmdi_warnresult_template");
        }
        if (SOLUTION_SCHEME.equals(key)) {
            formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter qFilter = new QFilter("id", "not in", (Object)this.getModel().getEntryEntity(SOLUTION_ENTRYENTITY).stream().filter(item -> item.getDynamicObject(SOLUTION_SCHEME) != null).map(entry -> entry.getDynamicObject(SOLUTION_SCHEME).getPkValue()).toArray());
            formShowParameter.getListFilterParameter().setFilter(qFilter);
        }
        if ("warning_ridding".equals(key)) {
            DynamicObject warningObject = (DynamicObject)this.getModel().getValue(WARNING_OBJECT);
            if (warningObject == null) {
                String errorMessage = ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u9884\u8b66\u5bf9\u8c61\u3002", (String)"EarlyWarningConfigPlugin_19", (String)"scmc-scmdi-form", (Object[])new Object[0]);
                this.getView().showErrorNotification(errorMessage);
                evt.setCancel(true);
                return;
            }
            Object pkValue = warningObject.getPkValue();
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter qFilter = new QFilter("warning_object.id", "=", pkValue);
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void setMessageType() {
        List<WarnMessageSendType> msgChannelItem = this.getMsgChannelItem();
        ArrayList<ComboItem> comboEditList = new ArrayList<ComboItem>(msgChannelItem.size());
        ComboItem center = new ComboItem();
        center.setValue("message_center");
        String centerType = ResManager.loadKDString((String)"\u6d88\u606f\u4e2d\u5fc3", (String)"WSEditMessageViewHolder_5", (String)"bos-earlywarn", (Object[])new Object[0]);
        center.setCaption(new LocaleString(centerType));
        comboEditList.add(center);
        for (WarnMessageSendType type2 : msgChannelItem) {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(type2.getValue());
            comboItem.setCaption(new LocaleString(type2.getName()));
            comboEditList.add(comboItem);
        }
        msgChannelItem.add(new WarnMessageSendType(null, centerType, "message_center"));
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("monitor_notify_types");
        comboEdit.setComboItems(comboEditList);
        ComboEdit upgradeNotifyType = (ComboEdit)this.getView().getControl("upgrade_notify_type");
        upgradeNotifyType.setComboItems(comboEditList);
        String monitorTypesStr = (String)this.getModel().getValue("monitor_notify_types");
        if (monitorTypesStr == null || monitorTypesStr.isEmpty()) {
            return;
        }
        List comboList = comboEditList.stream().map(ComboItem::getValue).collect(Collectors.toList());
        StringBuilder comboStringBuilder = new StringBuilder();
        List<String> selectedComboList = Arrays.stream(monitorTypesStr.split(",")).filter(type -> type != null && !type.isEmpty() && comboList.contains(type)).collect(Collectors.toList());
        selectedComboList.forEach(combo -> comboStringBuilder.append((String)combo).append(","));
        this.getModel().setValue("monitor_notify_types", (Object)comboStringBuilder.toString());
    }

    private List<WarnMessageSendType> getMsgChannelItem() {
        DynamicObject[] channelArray = BusinessDataServiceHelper.load((String)MSG_CHANNEL, (String)"id, number, name, enable", null);
        return DynamicDataMapper.convertCollection((DynamicObject[])channelArray, MessageChannel.class).stream().filter(c -> c.getEnable() != false && !"sysnotice".equalsIgnoreCase(c.getNumber())).map(c -> {
            WarnMessageSendType msgType = new WarnMessageSendType((Object)c.getId(), c.getName(), c.getNumber());
            return msgType;
        }).collect(Collectors.toList());
    }

    private void setDefaultTime() {
        Date endDate;
        Date startDate;
        WarnConfig warnConfig = (WarnConfig)this.getPojo();
        Integer value = warnConfig.getMonitorTime();
        if (value == null || value == -1) {
            this.getView().getModel().setValue("monitor_time", (Object)0);
        }
        if ((startDate = warnConfig.getMonitorDateRangeStart()) == null) {
            this.getView().getModel().setValue("monitor_date_range_start", (Object)new DateTime().withMillisOfDay(0).toDate());
        }
        if ((endDate = warnConfig.getMonitorDateRangeEnd()) == null) {
            this.getView().getModel().setValue("monitor_date_range_end", (Object)new DateTime((Object)"2099-12-31").toDate());
        }
    }

    private void generateMonitorDescription() {
        String text;
        List<String> selectedDays;
        IFormView view = this.getView();
        WarnConfig warnConfig = (WarnConfig)this.getPojo();
        MonitorSlotEnum monitorSlot = warnConfig.getMonitorSlot();
        String start = new DateTime((Object)warnConfig.getMonitorDateRangeStart()).toString("yyyy-MM-dd");
        String end = new DateTime((Object)warnConfig.getMonitorDateRangeEnd()).toString("yyyy-MM-dd");
        int monitorTime = warnConfig.getMonitorTime();
        DateTime hourMinute = new DateTime().withHourOfDay(monitorTime / 60 / 60).withMinuteOfHour(monitorTime / 60 % 60);
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)view.getEntityId());
        ComboProp comboProp = (ComboProp)type.findProperty("monitor_slot");
        List comboItems = comboProp.getComboItems();
        String text3 = comboItems.stream().filter(c -> c.getValue().equals(monitorSlot.name())).findAny().get().getName().getLocaleValue();
        String text4 = "";
        if (monitorSlot.isShowMonitorDayField()) {
            selectedDays = warnConfig.getMonitorDay();
            if (!CommonUtils.isNullOrEmpty(selectedDays)) {
                text4 = String.format("\u3010%1$s\u3011", this.getSelectedText("monitor_day", selectedDays).stream().collect(Collectors.joining(",")));
            }
        } else {
            selectedDays = null;
        }
        if (monitorSlot.isShowMonitorDayField() && StringUtils.isEmpty((CharSequence)text4)) {
            text = "";
        } else {
            String text5 = hourMinute.toString("HH:mm");
            text = String.format(ResManager.loadKDString((String)"\u4ece\u3010%1$s\u3011\u5f00\u59cb\uff0c\u81f3\u3010%2$s\u3011\u6b62\uff0c\u6bcf%3$s%4$s%5$s\u5f00\u59cb\u6267\u884c\u9884\u8b66\u76d1\u63a7\u3002", (String)"MonitorPlanConfigEditPlugin_0", (String)"scmc-scmdi-form", (Object[])new Object[0]), start, end, text3, text4, text5);
        }
        ((WarnConfig)this.getPojo()).setMonitorDescription(text);
        String cron = monitorSlot.getCron(hourMinute, selectedDays);
        ((WarnConfig)this.getPojo()).setMonitorCron(cron);
    }

    private List<String> getSelectedText(String control, List<String> values) {
        ClientViewProxy service = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        Map controlMetaState = service.getControlMetaState(control);
        if (!ObjectUtils.isEmpty((Object)controlMetaState)) {
            ArrayList metaState = (ArrayList)controlMetaState.get("st");
            return metaState.stream().map(comboItem -> {
                List var8;
                if (comboItem instanceof List && (var8 = (List)comboItem).size() > 1 && values.contains(var8.get(0))) {
                    return (String)((Map)var8.get(1)).get(RequestContext.get().getLang().toString());
                }
                return null;
            }).filter(i -> i != null).collect(Collectors.toList());
        }
        return new ArrayList<String>(0);
    }

    private void slotOptionChanged() {
        IFormView view = this.getView();
        MonitorSlotEnum monitorSlotEnum = Enum.valueOf(MonitorSlotEnum.class, (String)view.getModel().getValue("monitor_slot"));
        monitorSlotEnum.onOptionSelected(view);
    }
}

