/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.warning;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;

public class WarningContentEditPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
IConfirmCallBack {
    private static final String TXT_TEXT = "text";
    private static final String TREE_VIEW = "tree_view";
    private static final String BTN_OK = "btn_ok";
    private static final String PARAM_TEXT = "param_text";
    private static final String PARAM_TREE = "param_tree";
    public static final String KEY_SPECIAL_FIELD = "special_field";
    private static final int MAX_TITLE_LENGTH = 255;
    private static final int MAX_CONTENT_LENGTH = 2000;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        if (BTN_OK.equals(control.getKey())) {
            IFormView view = this.getView();
            view.returnDataToParent(this.getReturnData());
            view.close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equalsIgnoreCase((CharSequence)KEY_SPECIAL_FIELD, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            IFormView view = this.getView();
            view.returnDataToParent(this.getReturnData());
            view.close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        List<TreeNode> root = this.getRootNodes();
        if (null != root) {
            TreeView treeView = this.getTreeView();
            treeView.addNodes(root);
        }
        FormShowParameter param = this.getView().getFormShowParameter();
        String text = (String)param.getCustomParam(PARAM_TEXT);
        this.getModel().setValue(TXT_TEXT, (Object)text);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return;
        }
        List<TreeNode> rootNodes = this.getRootNodes();
        if (null == rootNodes || rootNodes.isEmpty()) {
            return;
        }
        TreeNode selectedNode = null;
        for (TreeNode treeNode : rootNodes) {
            TreeNode find = treeNode.getTreeNode(nodeId, 16);
            if (null == find) continue;
            selectedNode = find;
            break;
        }
        if (selectedNode == null) {
            return;
        }
        Map data = (Map)selectedNode.getData();
        if (data == null) {
            return;
        }
        String expressionText = (String)data.get("expressionText");
        if (StringUtils.isEmpty((CharSequence)expressionText)) {
            return;
        }
        IDataModel model = this.getModel();
        String text = this.getModel().getDataEntity().getString(TXT_TEXT);
        int cursorFocusIndex = this.getCursorFocusIndex(this.getView(), TREE_VIEW, TXT_TEXT);
        String postText = text.substring(cursorFocusIndex);
        String preText = text.substring(0, cursorFocusIndex);
        StringBuilder showText = new StringBuilder().append(preText).append(" ").append(expressionText).append(" ").append(postText);
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        if (showText.length() > ("monitor_notify_title".equals(type) ? 255 : 2000)) {
            this.getView().showTipNotification("\u6587\u672c\u957f\u5ea6\u5df2\u8fbe\u4e0a\u9650");
            return;
        }
        model.setValue(TXT_TEXT, (Object)showText);
    }

    private int getCursorFocusIndex(IFormView view, String buttonKey, String textFieldKey) {
        String textValue = (String)view.getModel().getValue(textFieldKey);
        int cursorIndex = StringUtils.isBlank((CharSequence)textValue) ? 0 : textValue.length();
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        Object listPostData = proxy.getViewState(buttonKey);
        if (listPostData instanceof Map) {
            Map map = (Map)listPostData;
            if (map.get("focus") != null) {
                Map focus = (Map)map.get("focus");
                if (focus.get(textFieldKey) != null && focus.get(textFieldKey) instanceof Integer) {
                    cursorIndex = (Integer)focus.get(textFieldKey);
                }
            } else if (map.get(textFieldKey) != null) {
                cursorIndex = (Integer)map.get(textFieldKey);
            }
        }
        return cursorIndex;
    }

    private TreeView getTreeView() {
        return (TreeView)this.getView().getControl(TREE_VIEW);
    }

    private List<TreeNode> getRootNodes() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String json = (String)param.getCustomParam(PARAM_TREE);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            return SerializationUtils.fromJsonStringToList((String)json, TreeNode.class);
        }
        return new ArrayList<TreeNode>();
    }

    private Map<String, Object> getReturnData() {
        HashMap<String, Object> returnDataMap = new HashMap<String, Object>(16);
        String text = this.getModel().getDataEntity().getString(TXT_TEXT);
        returnDataMap.put(TXT_TEXT, text);
        return returnDataMap;
    }
}

