/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.form.warning.rule;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.GetFilterFieldsParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class WarningRuleEditPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.bindCondition();
    }

    private void bindCondition() {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("warning_object");
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.SetValue(new ArrayList());
        if (StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            GetFilterFieldsParameter getFilterFieldsParameter = new GetFilterFieldsParameter((IDataEntityType)mainEntityType);
            getFilterFieldsParameter.setbCompatibleProductMode(false);
            getFilterFieldsParameter.setNeedFieldCompareType(true);
            List columns = EntityTypeUtil.createFilterColumns((GetFilterFieldsParameter)getFilterFieldsParameter);
            filterGrid.setEntityNumber(mainEntityType.getName());
            filterGrid.setFilterColumns(columns);
        } else {
            filterGrid.setEntityNumber(null);
            filterGrid.setFilterColumns(new ArrayList());
        }
        this.getView().updateView("filtergridap");
        String json = (String)this.getView().getFormShowParameter().getCustomParam("filter_condition_json_tag");
        FilterCondition condition = StringUtils.isEmpty((CharSequence)json) ? null : (FilterCondition)SerializationUtils.fromJsonString((String)json, FilterCondition.class);
        filterGrid.SetValue(condition);
    }

    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        if ("btnok".equals(control.getKey())) {
            this.returnFilterJson();
        }
    }

    private void returnFilterJson() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition condition = filterGridState.getFilterCondition();
        String filterConditionTextJson = null;
        if (condition != null) {
            filterConditionTextJson = SerializationUtils.toJsonString((Object)condition);
        }
        IFormView view = this.getView();
        view.returnDataToParent((Object)filterConditionTextJson);
        view.close();
    }
}

