/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.op.mapping;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.scmdi.form.plugin.op.mapping.validator.MetricMappingDuplicationValidator;
import kd.scmc.scmdi.form.plugin.op.mapping.validator.MetricMappingFieldSaveValidator;

public class MetricMappingSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("metricdefid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new MetricMappingDuplicationValidator());
        e.addValidator((AbstractValidator)new MetricMappingFieldSaveValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] metrics;
        super.afterExecuteOperationTransaction(e);
        HashSet<Long> set = new HashSet<Long>(16);
        for (DynamicObject dataEntity : e.getDataEntities()) {
            long metricId = dataEntity.getLong("metricdefid");
            if (metricId == 0L) continue;
            set.add(metricId);
        }
        QFilter qFilter = new QFilter("id", "in", set);
        for (DynamicObject metric : metrics = BusinessDataServiceHelper.load((String)"scmdi_metrics_def", (String)"id,metricmappingstatus", (QFilter[])new QFilter[]{qFilter})) {
            metric.set("metricmappingstatus", (Object)"B");
        }
        SaveServiceHelper.save((DynamicObject[])metrics);
    }
}

