/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.op.mapping.validator;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.scmdi.business.metric.MetricServiceHolder;
import kd.scmc.scmdi.business.metric.vo.MetricMapping;
import kd.scmc.scmdi.common.utils.mapper.DynamicDataMapper;
import kd.scmc.scmdi.common.vo.bos.UseStatusEnum;

public class MetricMappingDuplicationValidator
extends AbstractValidator {
    public void validate() {
        this.validateEntity();
    }

    private void validateEntity() {
        boolean duplicated;
        long longPk;
        MetricMapping metricMapping;
        ArrayList<String> bizEntityPkIds = new ArrayList<String>();
        ArrayList<String> metricEntityPkIds = new ArrayList<String>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            MetricMapping metricMapping2 = (MetricMapping)DynamicDataMapper.convert((DynamicObject)dataEntity.getDataEntity(), MetricMapping.class);
            UseStatusEnum enable = metricMapping2.getEnable();
            if (enable == UseStatusEnum.DISABLED) continue;
            bizEntityPkIds.add(metricMapping2.getBizEntity().getId());
            metricEntityPkIds.add(metricMapping2.getMetricEntityIdentity());
        }
        QFilter qFilter = new QFilter("biz_entity", "in", bizEntityPkIds);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        List results = DynamicDataMapper.convertCollection((DynamicObjectCollection)QueryServiceHelper.query((String)"scmdi_metrics_mapping", (String)"id", (QFilter[])new QFilter[]{qFilter}), MetricMapping.class);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            metricMapping = (MetricMapping)DynamicDataMapper.convert((DynamicObject)dataEntity.getDataEntity(), MetricMapping.class);
            longPk = metricMapping.getId() == null ? -1L : metricMapping.getId();
            duplicated = results.stream().filter(result -> longPk != result.getId()).findAny().isPresent();
            if (!duplicated) continue;
            String errMsg = String.format(ResManager.loadKDString((String)"\u201c\u4f9b\u5e94\u94fe\u6307\u6807\u201d\u503c\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"MetricDefinitionEditPlugin_4", (String)"scmc-scmdi-form", (Object[])new Object[0]), metricMapping.getBizEntity().getName());
            throw new KDBizException(errMsg);
        }
        qFilter = new QFilter("metric_entity_identity", "in", metricEntityPkIds);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        results = DynamicDataMapper.convertCollection((DynamicObjectCollection)QueryServiceHelper.query((String)"scmdi_metrics_mapping", (String)"id", (QFilter[])new QFilter[]{qFilter}), MetricMapping.class);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            metricMapping = (MetricMapping)DynamicDataMapper.convert((DynamicObject)dataEntity.getDataEntity(), MetricMapping.class);
            longPk = metricMapping.getId() == null ? -1L : metricMapping.getId();
            duplicated = results.stream().filter(result -> longPk != result.getId()).findAny().isPresent();
            if (!duplicated) continue;
            String errMsg = String.format(ResManager.loadKDString((String)"\u201c\u8f7b\u5efa\u6a21\u6307\u6807\u201d\u503c\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"MetricDefinitionEditPlugin_5", (String)"scmc-scmdi-form", (Object[])new Object[0]), MetricServiceHolder.getMetricService().getModelMeta(metricMapping.getMetricEntityIdentity()).getModelName());
            throw new KDBizException(errMsg);
        }
    }
}

