/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.op.mapping.validator;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.scmc.scmdi.common.utils.CommonUtils;

public class MetricMappingFieldSaveValidator
extends AbstractValidator {
    public void validate() {
        this.validateDuplicateFields();
    }

    private void validateDuplicateFields() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject entityObj = dataEntity.getDataEntity();
            DynamicObjectCollection entry = entityObj.getDynamicObjectCollection("metric_mapping_entry");
            if (entry == null) continue;
            List bizKeys = entry.stream().map(d -> d.getString("biz_entity_field_name")).collect(Collectors.toList());
            List duplicateElements = CommonUtils.getDuplicateElements(bizKeys);
            if (duplicateElements != null && !duplicateElements.isEmpty()) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u201c\u4f9b\u5e94\u94fe\u6307\u6807\u5b57\u6bb5\u201d\u503c\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"MetricDefinitionEditPlugin_1", (String)"scmc-scmdi-form", (Object[])new Object[0]), duplicateElements.stream().collect(Collectors.joining(",")));
                throw new KDBizException(errMsg);
            }
            bizKeys = entry.stream().map(d -> d.getString("metric_field_name")).collect(Collectors.toList());
            duplicateElements = CommonUtils.getDuplicateElements(bizKeys);
            if (duplicateElements == null || duplicateElements.isEmpty()) continue;
            String errMsg = String.format(ResManager.loadKDString((String)"\u201c\u8f7b\u5efa\u6a21\u6307\u6807\u5b57\u6bb5\u201d\u503c\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"MetricDefinitionEditPlugin_3", (String)"scmc-scmdi-form", (Object[])new Object[0]), duplicateElements.stream().collect(Collectors.joining(",")));
            throw new KDBizException(errMsg);
        }
    }
}

