/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.op.solution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.scmdi.form.enumeration.solution.ProcessWayEnum;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractProcessStatusOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("orient_result_identity");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        Consumer<? super DynamicObject> orientResultAction = this.getOrientResultAction();
        this.handleOrientResult(dataEntities, orientResultAction);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject data : dataEntities = e.getDataEntities()) {
            data.set("processingway", (Object)ProcessWayEnum.MAN_HANDLER.getValue());
        }
    }

    protected abstract Consumer<? super DynamicObject> getOrientResultAction();

    private void handleOrientResult(DynamicObject[] dataEntities, Consumer<? super DynamicObject> action) {
        List<Object> pkIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        List<Object> currentOrientPks = Arrays.stream(dataEntities).map(data -> data.get("orient_result_identity")).collect(Collectors.toList());
        ArrayList<Object> idsFromPkToOrient = new ArrayList<Object>();
        ArrayList<Object> idsFromOrientToPk = new ArrayList<Object>();
        String entityName = dataEntities[0].getDataEntityType().getName();
        this.buildIdsFromPkToOrient(entityName, idsFromPkToOrient, pkIds);
        this.buildIdsFromOrientToPk(entityName, idsFromOrientToPk, currentOrientPks);
        HashSet<Object> allPkIds = new HashSet<Object>();
        allPkIds.addAll(idsFromPkToOrient);
        allPkIds.addAll(idsFromOrientToPk);
        DynamicObject[] loads = BusinessDataServiceHelper.load((Object[])allPkIds.toArray(new Object[0]), (DynamicObjectType)dataEntities[0].getDynamicObjectType());
        Arrays.stream(loads).forEach(action);
        SaveServiceHelper.save((DynamicObject[])loads);
        this.handleLog(allPkIds);
    }

    public void handleLog(Collection<?> pkIds) {
        QFilter qFilter = new QFilter("warnresult", "in", pkIds);
        DynamicObject[] processLogData = BusinessDataServiceHelper.load((String)"scmdi_warning_process_log", (String)"id,warnresult,entryentity.operateway,entryentity.processtime,entryentity.processby,entryentity.processway", (QFilter[])new QFilter[]{qFilter});
        ArrayList<DynamicObject> orientData = new ArrayList<DynamicObject>(pkIds.size());
        ArrayList<DynamicObject> buildData = new ArrayList<DynamicObject>(10);
        for (Object pkId : pkIds) {
            boolean flag = false;
            for (DynamicObject processLog : processLogData) {
                Long warningResult = processLog.getLong("warnresult");
                if (warningResult.compareTo((Long)pkId) != 0) continue;
                this.recordProcessLog(processLog);
                orientData.add(processLog);
                flag = true;
                break;
            }
            if (flag) continue;
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"scmdi_warning_process_log");
            log.set("warnresult", pkId);
            this.recordProcessLog(log);
            buildData.add(log);
        }
        SaveServiceHelper.save((DynamicObject[])orientData.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])buildData.toArray(new DynamicObject[0]));
    }

    protected abstract void recordProcessLog(DynamicObject var1);

    private void buildIdsFromPkToOrient(String entityName, List<Object> idsFromPkToOrient, List<Object> currentPks) {
        QFilter qFilter = new QFilter("orient_result_identity", "in", currentPks);
        List resultPks = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])qFilter.toArray(), null, (int)-1);
        if (CollectionUtils.isNotEmpty((Collection)resultPks)) {
            idsFromPkToOrient.addAll(resultPks);
            this.buildIdsFromPkToOrient(entityName, idsFromPkToOrient, resultPks);
        }
    }

    private void buildIdsFromOrientToPk(String entityName, List<Object> idsFromOrientToPk, List<Object> currentOrientPks) {
        QFilter qFilter = new QFilter("id", "in", currentOrientPks);
        DynamicObjectCollection orientResultIdentity = QueryServiceHelper.query((String)entityName, (String)"id,orient_result_identity", (QFilter[])qFilter.toArray(), null, (int)-1);
        if (CollectionUtils.isNotEmpty((Collection)orientResultIdentity)) {
            List<Object> orientResultIdentityList = orientResultIdentity.stream().map(entity -> entity.get("orient_result_identity")).collect(Collectors.toList());
            List collect = orientResultIdentity.stream().map(entity -> entity.get("id")).collect(Collectors.toList());
            idsFromOrientToPk.addAll(collect);
            this.buildIdsFromOrientToPk(entityName, idsFromOrientToPk, orientResultIdentityList);
        }
    }
}

