/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.op.solution;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.scmdi.form.enumeration.solution.ProcessWayEnum;
import kd.scmc.scmdi.form.plugin.op.solution.AbstractProcessStatusOpPlugin;
import kd.scmc.scmdi.form.plugin.op.solution.validator.SolutionReProcessValidator;

public class ReprocessOp
extends AbstractProcessStatusOpPlugin {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new SolutionReProcessValidator());
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("processor");
        e.getFieldKeys().add("processingtime");
        e.getFieldKeys().add("processingway");
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject data : dataEntities = e.getDataEntities()) {
            data.set("processor", null);
            data.set("processingtime", null);
            data.set("processingway", (Object)ProcessWayEnum.NOT_HAVE.getValue());
        }
        List pkIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        this.handleLog(pkIds);
    }

    @Override
    protected void recordProcessLog(DynamicObject processLog) {
        DynamicObjectCollection logEntry = processLog.getDynamicObjectCollection("entryentity");
        DynamicObject logRow = logEntry.addNew();
        logRow.set("operateway", (Object)"1");
        logRow.set("processtime", (Object)new Date());
        logRow.set("processby", (Object)RequestContext.get().getCurrUserId());
        logRow.set("processway", (Object)"0");
    }

    @Override
    protected Consumer<? super DynamicObject> getOrientResultAction() {
        return bill -> {
            bill.set("processingstatus", (Object)"0");
            bill.set("processor", null);
            bill.set("processingtime", null);
            bill.set("processingway", (Object)ProcessWayEnum.NOT_HAVE.getValue());
        };
    }
}

