/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.plugin.op.warning;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.scmc.scmdi.common.utils.mapper.DynamicDataMapper;
import kd.scmc.scmdi.common.vo.bos.StatusEnum;
import kd.scmc.scmdi.common.vo.bos.UseStatusEnum;
import kd.scmc.scmdi.form.task.MonitorTask;
import kd.scmc.scmdi.form.vo.warning.WarnConfig;
import kd.scmc.scmdi.form.vo.warning.WarningRule;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

public class WarningOpPlugin
extends AbstractOperationServicePlugIn {
    private static final JobDispatcherProxy proxy = new JobDispatcherProxy();
    private static final String appId = "scmoc";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("monitor_job");
        e.getFieldKeys().add("monitor_plan");
        e.getFieldKeys().add("monitor_date_range_start");
        e.getFieldKeys().add("monitor_date_range_end");
        e.getFieldKeys().add("monitor_time");
        e.getFieldKeys().add("monitor_day");
        e.getFieldKeys().add("monitor_slot");
        e.getFieldKeys().add("monitor_cron");
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("rule_entry.filter_condition_json_tag");
        e.getFieldKeys().add("rule_entry.filter_condition_read_tag");
        e.getFieldKeys().add("rule_entry.filter_condition_formula_tag");
        e.getFieldKeys().add("warning_object");
        e.getFieldKeys().add("status");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        block11: for (DynamicObject earlyWarning : dataEntities = e.getDataEntities()) {
            WarnConfig warnConfig = (WarnConfig)DynamicDataMapper.convert((DynamicObject)earlyWarning, WarnConfig.class);
            switch (operationKey) {
                case "audit": 
                case "enable": {
                    UseStatusEnum useStatus = warnConfig.getEnable();
                    StatusEnum status = warnConfig.getStatus();
                    if (useStatus == UseStatusEnum.DISABLED || status != StatusEnum.AUDITED) {
                        return;
                    }
                    this.getJudgeExpression(warnConfig, earlyWarning);
                    this.addScheduledMonitor(warnConfig);
                    continue block11;
                }
                case "disable": 
                case "delete": 
                case "unaudit": {
                    this.deletePlan(warnConfig);
                    continue block11;
                }
            }
        }
    }

    private void getJudgeExpression(WarnConfig warnConfig, DynamicObject earlyWarning) {
        String warningObjectEntityNumber = warnConfig.getWarningObject().getNumber();
        List<WarningRule> ruleEntry = warnConfig.getRuleEntry();
        for (int i = 0; i < ruleEntry.size(); ++i) {
            WarningRule ruleRow = ruleEntry.get(i);
            if (ruleRow.getDeserializedFilterCondition() == null) {
                return;
            }
            FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)warningObjectEntityNumber), ruleRow.getDeserializedFilterCondition());
            filterBuilder.buildFilter(false);
            String[] scripts = filterBuilder.buildFilterScript();
            String expression = scripts[0];
            String advExpression = "";
            if (StringUtils.isNotBlank((CharSequence)expression) && StringUtils.isNotBlank((CharSequence)advExpression)) {
                expression = expression + " and (" + advExpression + ")";
            } else if (StringUtils.isBlank((CharSequence)expression) && StringUtils.isNotBlank((CharSequence)advExpression)) {
                expression = advExpression;
            }
            DynamicObject ruleRowObject = (DynamicObject)earlyWarning.getDynamicObjectCollection("rule_entry").get(i);
            ruleRowObject.set("filter_condition_read_tag", (Object)scripts[1]);
            ruleRowObject.set("filter_condition_formula_tag", (Object)expression);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
    }

    private void addScheduledMonitor(WarnConfig warnConfig) {
        String jobId = warnConfig.getMonitorJob();
        proxy.deleteJob(jobId);
        JobInfo jobInfo = new JobInfo();
        jobInfo.setNumber("WARNING_" + warnConfig.getNumber());
        jobInfo.setName("WARNING_" + warnConfig.getName());
        jobInfo.setAppId(appId);
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setTaskClassname(MonitorTask.class.getName());
        jobInfo.setEnable(true);
        jobInfo.setRunByLang(Lang.zh_CN);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        HashMap<String, Long> parameterMap = new HashMap<String, Long>();
        parameterMap.put("monitor_pk_value", warnConfig.getId());
        jobInfo.setParams(parameterMap);
        jobId = proxy.createJob(jobInfo);
        warnConfig.getDynamicObject().set("monitor_job", (Object)Long.valueOf(jobId));
        String planId = warnConfig.getMonitorPlan();
        proxy.deletePlan(planId);
        PlanInfo planInfo = new PlanInfo();
        planInfo.setJobId(jobId);
        planInfo.setNumber("WARNING_" + warnConfig.getNumber());
        planInfo.setName("WARNING_" + warnConfig.getName());
        Calendar start = Calendar.getInstance();
        start.setTime(warnConfig.getMonitorDateRangeStart());
        planInfo.setStartTime(start);
        Calendar end = Calendar.getInstance();
        end.setTime(new DateTime((Object)warnConfig.getMonitorDateRangeEnd()).withMillisOfDay(0).plusDays(1).toDate());
        planInfo.setEndTime(end);
        planInfo.setRepeatMode(RepeatModeEnum.NONE);
        planInfo.setCronExpression(warnConfig.getMonitorCron());
        planInfo.setEnable(true);
        planId = proxy.createPlan(planInfo);
        warnConfig.getDynamicObject().set("monitor_plan", (Object)planId);
    }

    private void deletePlan(WarnConfig warnConfig) {
        String planId = warnConfig.getMonitorPlan();
        String jobId = warnConfig.getMonitorJob();
        if (StringUtils.isNotEmpty((CharSequence)planId)) {
            proxy.deletePlan(planId);
            proxy.deleteJob(jobId);
        }
    }
}

