/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.form.task;

import java.util.Arrays;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.scmdi.common.utils.mapper.DynamicDataMapper;
import kd.scmc.scmdi.common.vo.bos.BosEntity;
import kd.scmc.scmdi.form.common.helper.WarningResultHandler;
import kd.scmc.scmdi.form.enumeration.solution.ProcessStatusEnum;
import kd.scmc.scmdi.form.enumeration.warning.UpgradeStatus;
import kd.scmc.scmdi.form.vo.warning.WarnConfig;

public class UpgradeTask
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObject[] warningConfigIds = BusinessDataServiceHelper.load((String)"scmdi_early_warning", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("upgrade_enabled", "=", (Object)"1")});
        Arrays.stream(warningConfigIds).map(id -> {
            DynamicObject earlyWarning = BusinessDataServiceHelper.loadSingle((Object)id.getPkValue(), (String)"scmdi_early_warning");
            return (WarnConfig)DynamicDataMapper.convert((DynamicObject)earlyWarning, WarnConfig.class);
        }).forEach(warnConfig -> {
            BosEntity warningResultPersist = warnConfig.getWarningResultPersist();
            WarningResultHandler warningResultHandler = new WarningResultHandler((WarnConfig)warnConfig);
            QFilter[] filters = new QFilter[]{new QFilter("processingstatus", "=", (Object)ProcessStatusEnum.UNPROCESSED.getStatusCode()), new QFilter("upgrade_status", "=", (Object)UpgradeStatus.N.name()), new QFilter("warning_config", "=", (Object)warnConfig.getId())};
            String selectedFields = "id,duplicated_count,createtime,upgrade_status,warninglevel,orient_result_identity";
            String[] fields = selectedFields.split(",");
            String warningResultMetaNumber = warningResultPersist.getNumber();
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)UpgradeTask.class.getName(), (String)warningResultMetaNumber, (String)selectedFields, (QFilter[])filters, (String)"");){
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    DynamicObject warningResult = BusinessDataServiceHelper.newDynamicObject((String)warningResultMetaNumber);
                    for (String field : fields) {
                        warningResult.set(field, next.get(field));
                    }
                    warningResultHandler.upgrade(warningResult);
                }
            }
        });
    }
}

