/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scmc.scmdi.business.helper.HomePageOrgHelper;
import kd.scmc.scmdi.common.pojo.AbcAnalysisInfo;
import kd.scmc.scmdi.common.pojo.SupplierRankingInfo;
import kd.scmc.scmdi.common.utils.HomePageDateUtils;

public class PurInfoCalculateHelper {
    private static final String[] BIZTYPE = new String[]{"110", "130"};

    public static List<AbcAnalysisInfo> querySupplierABCAnalysisData() {
        DataSet purOrderDataSet = PurInfoCalculateHelper.getPurOrderGroupBySupplier();
        ArrayList<AbcAnalysisInfo> list = new ArrayList<AbcAnalysisInfo>();
        BigDecimal purProportion = BigDecimal.ZERO;
        for (Row row : purOrderDataSet) {
            AbcAnalysisInfo supplierAbcInfo = new AbcAnalysisInfo();
            supplierAbcInfo.setBaseData(row.getLong("supplier"));
            supplierAbcInfo.setBaseDataName(row.getString("suppliername"));
            supplierAbcInfo.setAmount(row.getBigDecimal("amount"));
            supplierAbcInfo.setPurProportion(row.getBigDecimal("purproportion"));
            supplierAbcInfo.setCurrency(row.getLong("currency"));
            purProportion = purProportion.add(row.getBigDecimal("purproportion"));
            BigDecimal rowPurProportion = row.getBigDecimal("purproportion");
            PurInfoCalculateHelper.setAbcInfoGroup(supplierAbcInfo, purProportion, rowPurProportion);
            list.add(supplierAbcInfo);
        }
        return list;
    }

    private static void setAbcInfoGroup(AbcAnalysisInfo abcAnalysisInfo, BigDecimal purProportion, BigDecimal rowPurProportion) {
        BigDecimal rankARate = new BigDecimal("70");
        BigDecimal rankBRate = new BigDecimal("20");
        if (purProportion.compareTo(rankARate) < 0) {
            abcAnalysisInfo.setGroup("A");
        } else if (purProportion.compareTo(rankARate) >= 0 && purProportion.subtract(rowPurProportion).compareTo(rankARate) < 0) {
            abcAnalysisInfo.setGroup("A");
        } else if (purProportion.compareTo(rankARate) >= 0 && purProportion.subtract(rowPurProportion).compareTo(rankBRate.add(rankARate)) < 0) {
            abcAnalysisInfo.setGroup("B");
        } else {
            abcAnalysisInfo.setGroup("C");
        }
    }

    private static DataSet getPurOrderGroupBySupplier() {
        BigDecimal allAmount = PurInfoCalculateHelper.getAllAmount();
        String supplierSelectField = PurInfoCalculateHelper.getSupplierSelectField();
        DataSet purOrderData = QueryServiceHelper.queryDataSet((String)PurInfoCalculateHelper.class.getName(), (String)"pm_purorderbill", (String)supplierSelectField, (QFilter[])new QFilter[]{PurInfoCalculateHelper.getPurCommonFilter()}, null);
        DataSet purOrderGroupBySupplier = purOrderData.groupBy(new String[]{"supplier", "suppliername", "currency", "currencynum", "sign"}).sum("amount").finish().orderBy(new String[]{"amount desc"});
        String supplierShowField = "supplier,suppliername,amount, currency,currencynum,sign, amount / " + allAmount + " * 100  as purproportion";
        return purOrderGroupBySupplier.select(supplierShowField);
    }

    private static BigDecimal getAllAmount() {
        BigDecimal allAmount = new BigDecimal(0);
        DataSet allAmountData = QueryServiceHelper.queryDataSet((String)PurInfoCalculateHelper.class.getName(), (String)"pm_purorderbill", (String)"billentry.curamountandtax as allamount", (QFilter[])new QFilter[]{PurInfoCalculateHelper.getPurCommonFilter()}, null).groupBy().sum("allamount").finish();
        for (Row row : allAmountData) {
            allAmount = row.getBigDecimal("allamount");
        }
        return allAmount;
    }

    public static String getSupplierSelectField() {
        ArrayList<String> selectorSet = new ArrayList<String>(6);
        selectorSet.add("supplier");
        selectorSet.add("supplier.name as suppliername");
        selectorSet.add("billentry.curamountandtax as amount");
        selectorSet.add("currency");
        selectorSet.add("currency.number as currencynum");
        selectorSet.add("currency.sign as sign");
        return String.join((CharSequence)",", selectorSet);
    }

    public static List<AbcAnalysisInfo> queryMaterialABCAnalysisData() {
        DataSet copy = PurInfoCalculateHelper.getPurOrderByMaterial();
        ArrayList<AbcAnalysisInfo> list = new ArrayList<AbcAnalysisInfo>(16);
        BigDecimal purProportion = BigDecimal.ZERO;
        for (Row row : copy) {
            AbcAnalysisInfo materialAbcInfo = new AbcAnalysisInfo();
            materialAbcInfo.setBaseData(row.getLong("material"));
            materialAbcInfo.setBaseDataName(row.getString("materialname"));
            materialAbcInfo.setCurrency(row.getLong("currency"));
            materialAbcInfo.setCurrencyName(row.getString("currencyname"));
            BigDecimal purAmount = row.getBigDecimal("amount");
            materialAbcInfo.setAmount(purAmount);
            materialAbcInfo.setPurProportion(row.getBigDecimal("purproportion"));
            purProportion = purProportion.add(row.getBigDecimal("purproportion"));
            BigDecimal rowPurProportion = row.getBigDecimal("purproportion");
            PurInfoCalculateHelper.setAbcInfoGroup(materialAbcInfo, purProportion, rowPurProportion);
            list.add(materialAbcInfo);
        }
        return list;
    }

    private static DataSet getPurOrderByMaterial() {
        QFilter qFilter = PurInfoCalculateHelper.getPurCommonFilter();
        String selectField = PurInfoCalculateHelper.getMaterialSelectField();
        DataSet purOrder = QueryServiceHelper.queryDataSet((String)PurInfoCalculateHelper.class.getName(), (String)"pm_purorderbill", (String)selectField, (QFilter[])new QFilter[]{qFilter}, null);
        DataSet dataSet = purOrder.groupBy(new String[]{"material", "materialname", "currency", "currencyname"}).sum("amount").finish().orderBy(new String[]{"amount desc"});
        BigDecimal allAmount = PurInfoCalculateHelper.getAllAmount();
        String materialShowField = "material,materialname,amount,currency,currencyname,amount / " + allAmount + " * 100  as purproportion";
        return dataSet.select(materialShowField);
    }

    private static String getMaterialSelectField() {
        ArrayList<String> selectorSet = new ArrayList<String>(6);
        selectorSet.add("billentry.material.masterid as material");
        selectorSet.add("billentry.material.masterid.name as materialname");
        selectorSet.add("billentry.curamountandtax as amount");
        selectorSet.add("currency as currency");
        selectorSet.add("currency.name as currencyname");
        return String.join((CharSequence)",", selectorSet);
    }

    public static List<SupplierRankingInfo> getSupplierPurchaseRanking() {
        DataSet timelyReceiptRateData = PurInfoCalculateHelper.getTimelyReceiptRateData();
        DataSet purOrderGroupBySupplier = PurInfoCalculateHelper.getAmountGroupBySupplier();
        DataSet dataSet = timelyReceiptRateData.join(purOrderGroupBySupplier).on("entry_supplier", "supplier").select(new String[]{"suppliername", "amount", "delivertimerate"}).finish().orderBy(new String[]{"amount desc"}).limit(0, 5);
        DataSet copy = dataSet.copy();
        int dataCount = copy.count("suppliername", true);
        ArrayList<SupplierRankingInfo> supplierRankingInfos = new ArrayList<SupplierRankingInfo>(dataCount);
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            SupplierRankingInfo supplierRankingInfo = new SupplierRankingInfo();
            supplierRankingInfo.setSupplierName(next.getString("suppliername"));
            supplierRankingInfo.setAmount(next.getBigDecimal("amount").divide(new BigDecimal(10000), 2, RoundingMode.HALF_UP).toPlainString());
            supplierRankingInfo.setRate(next.getBigDecimal("delivertimerate").setScale(2, RoundingMode.HALF_UP).toPlainString());
            supplierRankingInfos.add(supplierRankingInfo);
        }
        return supplierRankingInfos;
    }

    public static DataSet getTimelyReceiptRateData() {
        List<Long> purOrgs = HomePageOrgHelper.getPurOrgByUserPermission();
        Date date = new Date();
        Date dayStartTime = HomePageDateUtils.getDayStartTime((Date)date);
        Date endDate = HomePageDateUtils.getDayEndTime((Date)date);
        Date startDate = HomePageDateUtils.getSixMonthAgoByDate((Date)dayStartTime);
        return PurInfoCalculateHelper.getTimelyReceiptRateData(purOrgs, startDate, endDate);
    }

    private static DataSet getAmountGroupBySupplier() {
        String selectField = PurInfoCalculateHelper.getSupplierSelectField();
        DataSet purOrderData = QueryServiceHelper.queryDataSet((String)PurInfoCalculateHelper.class.getName(), (String)"pm_purorderbill", (String)selectField, (QFilter[])new QFilter[]{PurInfoCalculateHelper.getPurCommonFilter()}, null);
        return purOrderData.groupBy(new String[]{"supplier", "suppliername"}).sum("amount").finish().orderBy(new String[]{"amount desc"});
    }

    public static DataSet getTimelyReceiptRateData(List<Long> orgIds, Date startDate, Date endDate) {
        QFilter expireFilter = PurInfoCalculateHelper.getExpireFilter(orgIds, startDate, endDate);
        QFilter todayFilter = PurInfoCalculateHelper.getTodayFilter(orgIds);
        DataSet purOrder = QueryServiceHelper.queryDataSet((String)PurInfoCalculateHelper.class.getName(), (String)"pm_purorderbill", (String)"id,billentry.id as entryid,billentry.deliverdate as deliverydate,billentry.invqty as invqty,billentry.qty as qty,billentry.rowclosestatus as rowclosestatus,billentry.rowterminatestatus as rowterminatestatus,supplier as entry_supplier,supplier.name as suppliername,org as entry_purorg,closestatus", (QFilter[])new QFilter[]{expireFilter}, null);
        DataSet expireDataSet = purOrder.executeSql("select case when to_char(deliverydate,'yyyy-MM-dd') >= '" + PurInfoCalculateHelper.getStringDate(startDate) + "' and to_char(deliverydate,'yyyy-MM-dd') <= '" + PurInfoCalculateHelper.getStringDate(endDate) + "' then 1 else 0 end as expireordernum,entry_supplier,suppliername,entry_purorg");
        DataSet expireordernum = expireDataSet.groupBy(new String[]{"entry_supplier", "suppliername"}).sum("expireordernum").finish();
        DataSet today = QueryServiceHelper.queryDataSet((String)PurInfoCalculateHelper.class.getName(), (String)"pm_purorderbill", (String)PurInfoCalculateHelper.getSelectField(), (QFilter[])new QFilter[]{todayFilter}, null);
        DataSet todayNum = today.groupBy(new String[]{"entry_supplier", "suppliername"}).sum("todaynum").finish();
        String imSalOutSelectField = PurInfoCalculateHelper.getImSalOutSelectField();
        QFilter billStatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter biztype = new QFilter("biztype.number", "in", (Object)new String[]{"110", "130"});
        DataSet purInBill = QueryServiceHelper.queryDataSet((String)PurInfoCalculateHelper.class.getName(), (String)"im_purinbill", (String)imSalOutSelectField, (QFilter[])new QFilter[]{billStatus.and(biztype)}, null);
        DataSet purOrderBill = QueryServiceHelper.queryDataSet((String)PurInfoCalculateHelper.class.getName(), (String)"pm_purorderbill", (String)"id,billentry.id as entryid,billentry.deliverdate as deliverydate,billentry.invqty as invqty,billentry.qty as qty,billentry.rowclosestatus as rowclosestatus,billentry.rowterminatestatus as rowterminatestatus,supplier as entry_supplier,supplier.name as suppliername,org as entry_purorg,closestatus", (QFilter[])new QFilter[]{expireFilter}, null);
        DataSet finish1 = purOrderBill.join(purInBill, JoinType.LEFT).on("id", "srcbillid").on("entryid", "srcbillentryid").select(new String[]{"biztime", "entryid", "srcbillentryid"}).finish();
        DataSet biztime = finish1.groupBy(new String[]{"srcbillentryid"}).max("biztime").finish();
        finish1 = purOrderBill.join(biztime, JoinType.LEFT).on("entryid", "srcbillentryid").select(new String[]{"entry_supplier", "suppliername", "entry_purorg", "deliverydate", "invqty", "qty", "rowclosestatus", "rowterminatestatus", "biztime", "closestatus", "entryid", "srcbillentryid"}).finish();
        DataSet overdue = finish1.executeSql("select case when rowclosestatus = 'A' and rowterminatestatus = 'A' and invqty < qty and closestatus = 'A' then 1 else 0 end as overduenum,entry_supplier,suppliername,entry_purorg");
        overdue = overdue.groupBy(new String[]{"entry_supplier", "suppliername"}).sum("overduenum").finish();
        expireordernum = expireordernum.join(overdue, JoinType.LEFT).on("entry_supplier", "entry_supplier").select(new String[]{"entry_supplier", "suppliername", "expireordernum", "overduenum"}).finish();
        DataSet select = finish1.executeSql("select case when (deliverydate >= biztime and invqty >= qty) or (deliverydate >= biztime and invqty < qty and rowclosestatus = 'B') or (deliverydate >= biztime and invqty < qty and rowterminatestatus = 'B') or (closestatus = 'B' and invqty = 0) or (closestatus = 'B' and rowclosestatus = 'A' and rowterminatestatus = 'A' and invqty < qty and deliverydate >= biztime) then 1 else 0 end as ontimenum,entry_supplier,suppliername,biztime,deliverydate");
        select = select.groupBy(new String[]{"entry_supplier", "suppliername"}).sum("ontimenum").finish();
        DataSet select1 = finish1.executeSql("select case when (deliverydate < biztime and invqty >= qty) or (deliverydate < biztime and invqty < qty and rowclosestatus = 'B')  or (deliverydate < biztime and invqty < qty and rowterminatestatus = 'B')  or (closestatus = 'B' and rowclosestatus = 'A' and rowterminatestatus = 'A' and invqty < qty and deliverydate < biztime) then 1 else 0 end as overnum,entry_supplier,suppliername");
        select1 = select1.groupBy(new String[]{"entry_supplier", "suppliername"}).sum("overnum").finish();
        DataSet finish2 = select.join(select1, JoinType.LEFT).on("entry_supplier", "entry_supplier").select(new String[]{"ontimenum", "overnum", "entry_supplier", "suppliername"}).finish();
        DataSet finish3 = expireordernum.join(finish2, JoinType.LEFT).on("entry_supplier", "entry_supplier").select(new String[]{"entry_supplier", "suppliername", "expireordernum", "overduenum", "ontimenum", "overnum"}).finish();
        DataSet bothSet = finish3.copy().join(todayNum.copy(), JoinType.INNER).on("entry_supplier", "entry_supplier").select(new String[]{"entry_supplier", "suppliername", "expireordernum", "overduenum", "ontimenum", "overnum"}, new String[]{"todaynum"}).finish();
        bothSet = bothSet.addField("'1'", "both");
        DataSet leftSet = finish3.join(bothSet, JoinType.LEFT).on("entry_supplier", "entry_supplier").select(new String[]{"entry_supplier", "suppliername", "expireordernum", "overduenum", "ontimenum", "overnum"}, new String[]{"both", "todaynum"}).finish().where("both is null");
        leftSet = leftSet.where("expireordernum > 0 or overduenum > 0 or ontimenum > 0 or overnum > 0");
        DataSet rightSet = todayNum.join(bothSet, JoinType.LEFT).on("entry_supplier", "entry_supplier").select(new String[]{"entry_supplier", "suppliername", "todaynum"}, new String[]{"both"}).finish().where("both is null and todaynum > 0");
        leftSet = leftSet.select(new String[]{"entry_supplier", "suppliername", "expireordernum", "overduenum", "ontimenum", "overnum", "0 as todaynum", "'0' as both"});
        rightSet = rightSet.select(new String[]{"entry_supplier", "suppliername", "0 as expireordernum", "0 as overduenum", "0 as ontimenum", "0 as overnum", "todaynum", "'0' as both"});
        DataSet totalSet = leftSet.union(bothSet).union(rightSet);
        return totalSet.select(PurInfoCalculateHelper.getShowFields()).orderBy(new String[]{"delivertimerate desc,entry_supplier"});
    }

    private static QFilter getExpireFilter(List<Long> orgId, Date startDate, Date endDate) {
        QFilter expireFilter = new QFilter("org", "in", orgId);
        expireFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        expireFilter.and(new QFilter("changestatus", "!=", (Object)"B"));
        expireFilter.and(new QFilter("biztype.number", "in", (Object)BIZTYPE));
        expireFilter.and(new QFilter("billentry.deliverdate", ">=", (Object)startDate));
        expireFilter.and(new QFilter("billentry.deliverdate", "<=", (Object)endDate));
        expireFilter.and(new QFilter("billentry.deliverdate", "<=", (Object)TimeServiceHelper.today()));
        return expireFilter;
    }

    private static QFilter getTodayFilter(List<Long> orgId) {
        QFilter todayFilter = new QFilter("org", "in", orgId);
        todayFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        todayFilter.and(new QFilter("changestatus", "!=", (Object)"B"));
        todayFilter.and(new QFilter("biztype.number", "in", (Object)BIZTYPE));
        todayFilter.and(new QFilter("billentry.deliverdate", "=", (Object)HomePageDateUtils.getDayStartTime((Date)TimeServiceHelper.today())));
        todayFilter.and(new QFilter("billentry.deliverdate", "<=", (Object)TimeServiceHelper.today()));
        return todayFilter;
    }

    public static String getStringDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public static String getSelectField() {
        ArrayList<String> select = new ArrayList<String>(16);
        select.add("supplier as entry_supplier");
        select.add("supplier.name as suppliername");
        select.add("org as entry_purorg");
        select.add("id");
        select.add("closestatus");
        select.add("billentry.id as entryid");
        select.add("billentry.deliverdate as deliverydate");
        select.add("billentry.invqty as invqty");
        select.add("billentry.qty as qty");
        select.add("billentry.rowclosestatus as rowclosestatus");
        select.add("billentry.rowterminatestatus as rowterminatestatus");
        select.add("case when billentry.invqty < billentry.qty and billentry.rowclosestatus = 'A' and billentry.rowterminatestatus = 'A' and closestatus = 'A' then 1 else 0 end as todaynum");
        select.add("case when closestatus = 'A' and billentry.rowclosestatus = 'A' and billentry.rowterminatestatus = 'A' and billentry.invqty < billentry.qty then 1 else 0 end as overduenum");
        return String.join((CharSequence)",", select);
    }

    public static String getImSalOutSelectField() {
        ArrayList<String> select = new ArrayList<String>(16);
        select.add("biztime");
        select.add("billentry.mainbillid as srcbillid");
        select.add("billentry.mainbillentryid as srcbillentryid");
        return String.join((CharSequence)",", select);
    }

    private static String getShowFields() {
        return "entry_supplier,suppliername,expireordernum,todaynum,overduenum,ontimenum,overnum,case when expireordernum != 0 then ontimenum * 1.0 / expireordernum * 100.0 end as delivertimerate";
    }

    public static QFilter getPurCommonFilter() {
        List<Long> purOrg = HomePageOrgHelper.getPurOrgByUserPermission();
        Date date = new Date();
        Date dayStartTime = HomePageDateUtils.getDayStartTime((Date)date);
        Date endDate = HomePageDateUtils.getDayEndTime((Date)date);
        Date startDate = HomePageDateUtils.getSixMonthAgoByDate((Date)dayStartTime);
        return PurInfoCalculateHelper.buildFilter(purOrg, startDate, endDate);
    }

    private static QFilter buildFilter(List<Long> orgId, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("org", "in", orgId);
        qFilter.and(new QFilter("biztime", ">=", (Object)startDate));
        qFilter.and(new QFilter("biztime", "<=", (Object)endDate));
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        qFilter.and(new QFilter("billentry.curamountandtax", "<>", (Object)BigDecimal.ZERO));
        return qFilter;
    }
}

