/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.business.judge.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ISuportClick;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.scmc.scmdi.business.judge.core.CompareContext;
import kd.scmc.scmdi.business.judge.core.CompareSymbol;
import kd.scmc.scmdi.business.judge.core.CompareSymbolText;
import kd.scmc.scmdi.business.judge.core.JudgeRuleHandler;
import kd.scmc.scmdi.business.judge.core.LogicalOperator;
import kd.scmc.scmdi.business.judge.core.RuleEntryEditorValueEditCloseCallBack;
import kd.scmc.scmdi.business.judge.core.RuleField;
import kd.scmc.scmdi.common.utils.JsonUtils;

public class RuleEntryEditor {
    private String entry;
    private String leftBracket = "left_bracket";
    private String rightBracket = "right_bracket";
    private String fieldSelect = "field_select";
    private String comparator = "comparator";
    private String valueSelect = "value_select";
    private String logicalOperator = "logical_operator";
    private List<RuleField> fieldList;
    private String optionJsonTag = "option_json_tag";

    public void beforeBindData(IFormView view) {
        List metricDefinitionsSelect = this.fieldList.stream().map(m -> {
            ComboItem center = new ComboItem();
            center.setValue(m.getKey());
            center.setCaption(new LocaleString(m.getText()));
            return center;
        }).collect(Collectors.toList());
        ComboEdit comboEdit = (ComboEdit)view.getControl(this.fieldSelect);
        comboEdit.setComboItems(metricDefinitionsSelect);
        this.bindComparators(view);
    }

    private void bindComparators(IFormView view) {
        Method[] methods = CompareSymbol.class.getMethods();
        Map<String, String> textMap = CompareSymbolText.getTextMap();
        List metricDefinitionsSelect = Arrays.stream(methods).map(m -> {
            ComboItem center = new ComboItem();
            String name = m.getName();
            center.setValue(name);
            center.setCaption(new LocaleString((String)textMap.get(name)));
            return center;
        }).collect(Collectors.toList());
        ComboEdit comboEdit = (ComboEdit)view.getControl(this.comparator);
        comboEdit.setComboItems(metricDefinitionsSelect);
    }

    public void registerListener(IFormView view) {
        ISuportClick control = (ISuportClick)view.getControl(this.getValueSelect());
        view.getPageCache().putBigObject("RuleEntryEditor." + this.entry + ".ruleEntryEditor", JsonUtils.toJson((Object)this));
        control.addClickListener(new ClickListener(){

            public void click(EventObject evt) {
                IFormView view = ((TextEdit)evt.getSource()).getView();
                IDataModel model = view.getModel();
                model.getEntryCurrentRowIndex(RuleEntryEditor.this.getEntry());
                int currRowIndex = model.getEntryCurrentRowIndex(RuleEntryEditor.this.entry);
                String selectedField = (String)model.getValue(RuleEntryEditor.this.getFieldSelect(), currRowIndex);
                String optionJsonTag = (String)model.getValue(RuleEntryEditor.this.getOptionJsonTag(), currRowIndex);
                Optional<RuleField> any = RuleEntryEditor.this.getFieldList().stream().filter(ruleField -> ruleField.getKey().equals(selectedField)).findAny();
                if (any.isPresent()) {
                    String valueEditPage = any.get().getValueEditPage();
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setFormId(valueEditPage);
                    showParameter.getCustomParams().put("optionJsonTag", optionJsonTag);
                    showParameter.setCloseCallBack(new CloseCallBack(RuleEntryEditorValueEditCloseCallBack.class.getName(), RuleEntryEditor.this.getEntry()));
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    view.showForm(showParameter);
                } else {
                    String message = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6761\u4ef6\u5bf9\u8c61\u3002", (String)"RuleEntryEditor_0", (String)"scmc-scmoc-business", (Object[])new Object[0]);
                    view.showTipNotification(message);
                }
            }
        });
    }

    public void propertyChange(IFormView view, PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (propertyName.equals(this.getFieldSelect())) {
            int index = view.getModel().getEntryCurrentRowIndex(this.getEntry());
            view.getModel().setValue(this.getValueSelect(), null, index);
            view.getModel().setValue(this.getOptionJsonTag(), null);
        }
    }

    public String getOptionJsonTag() {
        return this.optionJsonTag;
    }

    public void setOptionJsonTag(String optionJsonTag) {
        this.optionJsonTag = optionJsonTag;
    }

    public List<RuleField> getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(List<RuleField> fieldList) {
        this.fieldList = fieldList;
    }

    public String getEntry() {
        return this.entry;
    }

    public void setEntry(String entry) {
        this.entry = entry;
    }

    public String getLeftBracket() {
        return this.leftBracket;
    }

    public void setLeftBracket(String leftBracket) {
        this.leftBracket = leftBracket;
    }

    public String getRightBracket() {
        return this.rightBracket;
    }

    public void setRightBracket(String rightBracket) {
        this.rightBracket = rightBracket;
    }

    public String getFieldSelect() {
        return this.fieldSelect;
    }

    public void setFieldSelect(String fieldSelect) {
        this.fieldSelect = fieldSelect;
    }

    public String getComparator() {
        return this.comparator;
    }

    public void setComparator(String comparator) {
        this.comparator = comparator;
    }

    public String getValueSelect() {
        return this.valueSelect;
    }

    public void setValueSelect(String valueSelect) {
        this.valueSelect = valueSelect;
    }

    public String getLogicalOperator() {
        return this.logicalOperator;
    }

    public void setLogicalOperator(String logicalOperator) {
        this.logicalOperator = logicalOperator;
    }

    public boolean judge(DynamicObject config, DynamicObject testingData) {
        DynamicObjectCollection ruleEntry = config.getDynamicObjectCollection(this.entry);
        CompareContext compareContext = new CompareContext();
        compareContext.setDefaultContextObject(testingData);
        AtomicBoolean matchResult = new AtomicBoolean(true);
        AtomicReference<LogicalOperator> logicalOperator = new AtomicReference<LogicalOperator>(LogicalOperator.AND);
        ruleEntry.forEach(warningUpgradeRule -> {
            JudgeRuleHandler judgeRuleHandler;
            try {
                judgeRuleHandler = (JudgeRuleHandler)Class.forName(this.getFieldList().stream().filter(ruleField -> ruleField.getKey().equals(warningUpgradeRule.getString(this.getFieldSelect()))).findFirst().get().getRuleHandlerClassName()).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            String comparator = warningUpgradeRule.getString(this.getComparator());
            String optionJsonTag = warningUpgradeRule.getString(this.getOptionJsonTag());
            Map valueSet = (Map)JsonUtils.fromJson((String)optionJsonTag, HashMap.class);
            try {
                Method method = CompareSymbol.class.getMethod(comparator, CompareContext.class, Map.class);
                boolean matched = (Boolean)method.invoke((Object)judgeRuleHandler, compareContext, valueSet);
                matchResult.set(((LogicalOperator)((Object)((Object)logicalOperator.get()))).judge(matchResult.get(), matched));
                logicalOperator.set(LogicalOperator.valueOf(warningUpgradeRule.getString(this.getLogicalOperator())));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
        return matchResult.get();
    }

    public void purgeRules(IFormView view) {
        view.getModel().deleteEntryData(this.getEntry());
    }
}

