/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.business.metric;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.kingdee.bos.qing.modeler.api.ApiResponse;
import com.kingdee.bos.qing.modeler.api.request.DimMemberGroup;
import com.kingdee.bos.qing.modeler.api.request.Dimension;
import com.kingdee.bos.qing.modeler.api.request.ModelFilterItem;
import com.kingdee.bos.qing.modeler.api.request.QueryMetricParams;
import com.kingdee.bos.qing.modeler.api.response.AbstractNode;
import com.kingdee.bos.qing.modeler.api.response.FieldType;
import com.kingdee.bos.qing.modeler.api.response.FolderNode;
import com.kingdee.bos.qing.modeler.api.response.ModelDataCount;
import com.kingdee.bos.qing.modeler.api.response.ModelDataSet;
import com.kingdee.bos.qing.modeler.api.response.ModelField;
import com.kingdee.bos.qing.modeler.api.response.ModelMeta;
import com.kingdee.bos.qing.modeler.api.response.Row;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scmc.scmdi.business.metric.DataType;
import kd.scmc.scmdi.business.metric.IMetricService;
import kd.scmc.scmdi.business.metric.MetricDefinition;
import kd.scmc.scmdi.business.metric.vo.MetricMapping;
import kd.scmc.scmdi.business.metric.vo.MetricMappingEntry;
import kd.scmc.scmdi.common.vo.bos.FieldTypeEnum;
import org.apache.commons.collections.CollectionUtils;

public class DefaultMetricServiceImpl
implements IMetricService {
    private static Log log = LogFactory.getLog(DefaultMetricServiceImpl.class);
    private static final int pageSize = 1000;

    @Override
    public List<MetricDefinition> getMetricDefinitions() {
        FolderNode data = (FolderNode)this.getUsableModelList();
        if (data == null) {
            return new ArrayList<MetricDefinition>();
        }
        List children = data.getChildren();
        List allMetricRootNodes = children.stream().map(c -> (FolderNode)c).filter(c -> DataType.valueOf((AbstractNode)c) == DataType.MODELSET).collect(Collectors.toList());
        ArrayList<MetricDefinition> metricDefinitionList = new ArrayList<MetricDefinition>();
        this.getMetricsRecursively(allMetricRootNodes, metricDefinitionList, null, new ArrayList<String>());
        return metricDefinitionList;
    }

    private void getMetricsRecursively(List<? extends AbstractNode> allMetricRootNodes, List<MetricDefinition> metricDefinitionList, AbstractNode modelSetNode, List<String> directories) {
        allMetricRootNodes.forEach(c -> {
            AbstractNode rootNode;
            ArrayList newDirectories = Lists.newArrayList((Iterable)directories);
            DataType dataType = DataType.valueOf(c);
            AbstractNode abstractNode = rootNode = modelSetNode == null ? c : modelSetNode;
            if (dataType == DataType.METRIC_MODEL) {
                metricDefinitionList.add(new MetricDefinition((AbstractNode)c, rootNode, newDirectories));
                return;
            }
            if (c instanceof FolderNode) {
                FolderNode folderNode = (FolderNode)c;
                if (dataType != DataType.MODELSET) {
                    newDirectories.add(folderNode.getName());
                }
                this.getMetricsRecursively(folderNode.getChildren(), metricDefinitionList, rootNode, newDirectories);
            }
        });
    }

    private AbstractNode getUsableModelList() {
        ApiResponse response;
        try {
            response = (ApiResponse)DispatchServiceHelper.invokeBOSService((String)"qing_modeler", (String)"QingModelerExternalService", (String)"getUsableModelList", (Object[])new Object[0]);
        }
        catch (Exception e) {
            log.error("kd.scmc.scmdi.common.metric.DefaultMetricServiceImpl#getUsableModelList", (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6570\u636e\u5931\u8d25\uff0c\u83b7\u53d6\u3010\u8f7b\u5efa\u6a21\u6307\u6807\u3011\u65f6\u53d1\u751f\u9519\u8bef\u3002", (String)"DefaultMetricServiceImpl_0", (String)"scmc-scmdi-form", (Object[])new Object[0]), new Object[0]));
        }
        if (ApiResponse.ApiCode.SUCCESS.getCode() != response.getCode()) {
            log.error("kd.scmc.scmdi.common.metric.DefaultMetricServiceImpl.getUsableModelList:" + response.getMessage());
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6570\u636e\u5931\u8d25\uff0c\u83b7\u53d6\u3010\u8f7b\u5efa\u6a21\u6307\u6807\u3011\u65f6\u53d1\u751f\u9519\u8bef\u3002", (String)"DefaultMetricServiceImpl_0", (String)"scmc-scmdi-form", (Object[])new Object[0]), new Object[0]));
        }
        return (AbstractNode)response.getData();
    }

    private void getMetricData(QueryMetricParams params, Consumer<ModelDataSet> dataSetConsumer) {
        log.info("QingModelerExternalService.getmetricdataset,param:" + JSON.toJSONString((Object)params));
        ApiResponse response = (ApiResponse)DispatchServiceHelper.invokeBOSService((String)"qing_modeler", (String)"QingModelerExternalService", (String)"getmetricdataset", (Object[])new Object[]{params});
        if (ApiResponse.ApiCode.SUCCESS.getCode() != response.getCode()) {
            throw new KDBizException("getMetricDataSet:" + response.getMessage());
        }
        ModelDataSet previewData = (ModelDataSet)response.getData();
        log.info("QingModelerExternalService.getmetricdataset,result:key-" + previewData.getKey() + ",isFinish-" + previewData.isFinish());
        this.getCount(previewData.getKey());
        dataSetConsumer.accept(previewData);
        if (!previewData.isFinish()) {
            DefaultMetricServiceImpl.getNextRows(previewData, 1, dataSetConsumer);
        }
    }

    private void getCount(String key) {
        ApiResponse response = (ApiResponse)DispatchServiceHelper.invokeBOSService((String)"qing_modeler", (String)"QingModelerExternalService", (String)"getRowCount", (Object[])new Object[]{key});
        if (ApiResponse.ApiCode.SUCCESS.getCode() != response.getCode()) {
            throw new KDBizException("getRowCount:" + response.getMessage());
        }
        ModelDataCount modelDataCount = (ModelDataCount)response.getData();
        log.info("QingModelerExternalService.getRowCount,result:key-" + key + ",count-" + modelDataCount.getCount());
    }

    @Override
    public Row getLatestMetricsByWarningResult(MetricMapping metricMapping, DynamicObject warningResult) {
        String modelId = metricMapping.getMetricEntityIdentity();
        QueryMetricParams params = new QueryMetricParams();
        params.setModelId(modelId);
        List<MetricMappingEntry> metricMappingEntry = metricMapping.getMetricMappingEntry();
        ModelMeta modelMeta = this.getModelMeta(modelId);
        this.buildDefaultDimensions(modelMeta, params, metricMappingEntry);
        this.buildDefaultDimGroupMembers(modelMeta, params, metricMappingEntry);
        params.setFilters(this.getModelFilterItem(metricMappingEntry, warningResult));
        log.info("getLastedMetricsByWarningResult,param:" + JSON.toJSONString((Object)params));
        ApiResponse response = (ApiResponse)DispatchServiceHelper.invokeBOSService((String)"qing_modeler", (String)"QingModelerExternalService", (String)"getmetricdataset", (Object[])new Object[]{params});
        if (ApiResponse.ApiCode.SUCCESS.getCode() != response.getCode()) {
            throw new KDBizException("getLastedMetricsByWarningResult:" + response.getMessage());
        }
        ModelDataSet previewData = (ModelDataSet)response.getData();
        if (previewData == null || CollectionUtils.isEmpty((Collection)previewData.getDatas())) {
            return null;
        }
        log.info("getLastedMetricsByWarningResult,result:key-" + previewData.getKey() + ",isFinish-" + previewData.isFinish());
        return (Row)previewData.getDatas().get(0);
    }

    private List<ModelFilterItem> getModelFilterItem(List<MetricMappingEntry> metricMappingEntry, DynamicObject warningResult) {
        DataEntityPropertyCollection properties = warningResult.getDynamicObjectType().getProperties();
        return metricMappingEntry.stream().filter(row -> FieldTypeEnum.DIMENSION.getTypeCode().equals(row.getFieldType().getTypeCode()) && properties.containsKey((Object)row.getBizEntityFieldKey())).map(entry -> {
            String property = this.getDimensionFilterValue(warningResult.get(entry.getBizEntityFieldKey()));
            ModelFilterItem modelFilterItem = new ModelFilterItem();
            modelFilterItem.setFieldName(entry.getMetricFieldKey());
            if (property == null) {
                modelFilterItem.setCompareOp(ModelFilterItem.CompareOp.NULL);
            } else {
                modelFilterItem.setCompareOp(ModelFilterItem.CompareOp.EQUAL);
            }
            modelFilterItem.setValue(this.getDimensionFilterValue(warningResult.get(entry.getBizEntityFieldKey())));
            return modelFilterItem;
        }).collect(Collectors.toList());
    }

    private String getDimensionFilterValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof DynamicObject) {
            return String.valueOf(((DynamicObject)value).getPkValue());
        }
        return String.valueOf(value);
    }

    @Override
    public ModelMeta getModelMeta(String modelId) {
        ApiResponse response;
        log.info("QingModelerExternalService.getModelMeta,param:" + modelId);
        try {
            response = (ApiResponse)DispatchServiceHelper.invokeBOSService((String)"qing_modeler", (String)"QingModelerExternalService", (String)"getModelMeta", (Object[])new Object[]{modelId});
        }
        catch (Exception e) {
            log.error("kd.scmc.scmdi.common.metric.DefaultMetricServiceImpl#getModelMeta", (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6570\u636e\u5931\u8d25\uff0c\u83b7\u53d6\u3010\u8f7b\u5efa\u6a21\u6307\u6807\u3011\u65f6\u53d1\u751f\u9519\u8bef\u3002", (String)"DefaultMetricServiceImpl_0", (String)"scmc-scmdi-form", (Object[])new Object[0]), new Object[0]));
        }
        if (ApiResponse.ApiCode.SUCCESS.getCode() != response.getCode()) {
            log.error("kd.scmc.scmdi.common.metric.DefaultMetricServiceImpl.getModelMeta:" + response.getMessage());
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6570\u636e\u5931\u8d25\uff0c\u83b7\u53d6\u3010\u8f7b\u5efa\u6a21\u6307\u6807\u3011\u65f6\u53d1\u751f\u9519\u8bef\u3002", (String)"DefaultMetricServiceImpl_0", (String)"scmc-scmdi-form", (Object[])new Object[0]), new Object[0]));
        }
        ModelMeta modelMeta = (ModelMeta)response.getData();
        log.info("QingModelerExternalService.getModelMeta,result:" + JSON.toJSONString((Object)modelMeta));
        return modelMeta;
    }

    @Override
    public void getMetricDataSet(MetricMapping metricMapping, Consumer<ModelDataSet> dataSetConsumer) {
        String modelId = metricMapping.getMetricEntityIdentity();
        QueryMetricParams params = new QueryMetricParams();
        params.setModelId(modelId);
        List<MetricMappingEntry> metricMappingEntry = metricMapping.getMetricMappingEntry();
        ModelMeta modelMeta = this.getModelMeta(modelId);
        this.buildDefaultDimensions(modelMeta, params, metricMappingEntry);
        this.buildDefaultDimGroupMembers(modelMeta, params, metricMappingEntry);
        params.setLimit(1000);
        this.getMetricData(params, dataSetConsumer);
    }

    private void buildDefaultDimensions(ModelMeta modelMeta, QueryMetricParams params, List<MetricMappingEntry> metricMappingEntry) {
        params.setDimensions(metricMappingEntry.stream().filter(row -> modelMeta.getFields().stream().filter(f -> f.getFieldType() == FieldType.dimension).map(ModelField::getFieldName).filter(s -> s.equals(row.getMetricFieldKey())).findAny().isPresent()).map(row -> {
            Dimension dimension = new Dimension();
            dimension.setDimensionName(row.getMetricFieldKey());
            return dimension;
        }).collect(Collectors.toList()));
    }

    private void buildDefaultDimGroupMembers(ModelMeta modelMeta, QueryMetricParams params, List<MetricMappingEntry> metricMappingEntry) {
        params.setDimGroupMembers(metricMappingEntry.stream().filter(row -> modelMeta.getFields().stream().filter(f -> f.getFieldType() == FieldType.metric).map(ModelField::getFieldName).filter(s -> s.equals(row.getMetricFieldKey())).findAny().isPresent()).map(row -> {
            DimMemberGroup dimMemberGroup = new DimMemberGroup();
            dimMemberGroup.setAlias(row.getMetricFieldKey());
            dimMemberGroup.setFieldName(row.getMetricFieldKey());
            return dimMemberGroup;
        }).collect(Collectors.toList()));
    }

    private static void getNextRows(ModelDataSet dataSet, int pageIndex, Consumer<ModelDataSet> dataSetConsumer) {
        String key = dataSet.getKey();
        while (!dataSet.isFinish()) {
            dataSet = DefaultMetricServiceImpl.getRows(pageIndex, key);
            dataSetConsumer.accept(dataSet);
            ++pageIndex;
        }
    }

    private static ModelDataSet getRows(int pageIndex, String key) {
        log.info("QingModelerExternalService.getmetricdataset,getNextRows:key-" + JSON.toJSONString((Object)key));
        ApiResponse response = (ApiResponse)DispatchServiceHelper.invokeBOSService((String)"qing_modeler", (String)"QingModelerExternalService", (String)"getNextRows", (Object[])new Object[]{key, pageIndex * 1000, 1000});
        if (ApiResponse.ApiCode.SUCCESS.getCode() != response.getCode()) {
            throw new KDBizException("getNextRows:" + response.getMessage());
        }
        List datas = ((ModelDataSet)response.getData()).getDatas();
        log.info("QingModelerExternalService.getNextRows,result:key-" + ((ModelDataSet)response.getData()).getKey() + ",isFinish-" + ((ModelDataSet)response.getData()).isFinish() + ",dataSize-" + (datas == null ? 0 : datas.size()));
        return (ModelDataSet)response.getData();
    }
}

