/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.business.metric;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.kingdee.bos.qing.modeler.api.exception.ModelException;
import com.kingdee.bos.qing.modeler.api.response.ModelDataSet;
import com.kingdee.bos.qing.modeler.api.response.ModelField;
import com.kingdee.bos.qing.modeler.api.response.Row;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.scmdi.business.metric.MetricServiceHolder;
import kd.scmc.scmdi.business.metric.vo.MetricMapping;
import kd.scmc.scmdi.business.metric.vo.MetricMappingEntry;
import kd.scmc.scmdi.common.utils.mapper.DynamicDataMapper;
import org.apache.commons.lang3.StringUtils;

public class MetricDataHelper {
    private static Log log = LogFactory.getLog(MetricDataHelper.class);

    public static void getMetricsData(MetricMapping metricMapping, Consumer<List<DynamicObject>> listConsumer) {
        if (metricMapping == null) {
            return;
        }
        List<MetricMappingEntry> metricMappingEntry = metricMapping.getMetricMappingEntry();
        MainEntityType warningObjectEntityType = MetadataServiceHelper.getDataEntityType((String)metricMapping.getBizEntity().getNumber());
        HashBasedTable baseDataTable = HashBasedTable.create();
        MetricServiceHolder.getMetricService().getMetricDataSet(metricMapping, arg_0 -> MetricDataHelper.lambda$getMetricsData$1(metricMapping, metricMappingEntry, warningObjectEntityType, (Table)baseDataTable, listConsumer, arg_0));
    }

    public static MetricMapping getMetricMapping(String scmMetricEntityNumber) {
        if (StringUtils.isEmpty((CharSequence)scmMetricEntityNumber)) {
            return null;
        }
        QFilter[] filters = new QFilter[]{new QFilter("biz_entity", "=", (Object)scmMetricEntityNumber), new QFilter("enable", "=", (Object)"1")};
        DynamicObject metricMappingObject = BusinessDataServiceHelper.loadSingle((String)"scmdi_metrics_mapping", (String)"biz_entity,metric_entity_identity,metric_mapping_entry.biz_entity_field_key,metric_mapping_entry.biz_entity_field_name,metric_mapping_entry.metric_field_key,metric_mapping_entry.field_type", (QFilter[])filters);
        if (metricMappingObject == null) {
            return null;
        }
        MetricMapping metricMapping = (MetricMapping)DynamicDataMapper.convert((DynamicObject)metricMappingObject, MetricMapping.class);
        return metricMapping;
    }

    private static /* synthetic */ void lambda$getMetricsData$1(MetricMapping metricMapping, List metricMappingEntry, MainEntityType warningObjectEntityType, Table baseDataTable, Consumer listConsumer, ModelDataSet metricDataSet) {
        try {
            int size = metricDataSet.getDatas().size();
            ArrayList<DynamicObject> returnResults = new ArrayList<DynamicObject>(size);
            for (Row resultRow : metricDataSet.getDatas()) {
                DynamicObject warningObject = BusinessDataServiceHelper.newDynamicObject((String)metricMapping.getBizEntity().getNumber());
                for (ModelField metricResultField : metricDataSet.getFields()) {
                    Optional<MetricMappingEntry> first = metricMappingEntry.stream().filter(row -> row.getMetricFieldKey().equals(metricResultField.getFieldName())).findFirst();
                    if (!first.isPresent()) continue;
                    MetricMappingEntry matchedRow = first.get();
                    IDataEntityProperty property = (IDataEntityProperty)warningObjectEntityType.getAllFields().get(matchedRow.getBizEntityFieldKey());
                    Object metricFieldReturnValue = resultRow.get(matchedRow.getMetricFieldKey());
                    if (metricFieldReturnValue == null) continue;
                    if (property instanceof BasedataProp) {
                        BasedataProp basedataProp = (BasedataProp)property;
                        String baseEntityId = basedataProp.getBaseEntityId();
                        DynamicObject baseData = (DynamicObject)baseDataTable.get((Object)baseEntityId, metricFieldReturnValue);
                        if (baseData == null) {
                            try {
                                baseData = BusinessDataServiceHelper.loadSingle((Object)metricFieldReturnValue, (String)baseEntityId);
                            }
                            catch (KDException e) {
                                if (metricFieldReturnValue.equals(0) || metricFieldReturnValue.equals(0L)) continue;
                                throw e;
                            }
                            baseDataTable.put((Object)baseEntityId, metricFieldReturnValue, (Object)baseData);
                        }
                        warningObject.set(matchedRow.getBizEntityFieldKey(), (Object)baseData);
                        continue;
                    }
                    warningObject.set(matchedRow.getBizEntityFieldKey(), metricFieldReturnValue);
                }
                returnResults.add(warningObject);
            }
            listConsumer.accept(returnResults);
        }
        catch (ModelException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

