/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scmc.scmdi.business.helper.PeriodHelper;
import kd.scmc.scmdi.common.entity.FromToCol;
import kd.scmc.scmdi.common.entity.GroupCol;
import kd.scmc.scmdi.common.enums.BillStatusEnum;
import kd.scmc.scmdi.common.enums.EnableStatusEnum;

public class BeforeF7SelectHelper {
    private static final String APP_SCMDI_ID = "0TLZMQRB88SC";
    public static final long STANDARD_MATERIAL_GROUP = 730148448254487552L;
    public static final String _NO = ".number";

    public static void beforeF7Select4CalOrg(BeforeF7SelectEvent evt) {
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"10", (String)APP_SCMDI_ID, (String)"scmdi_itoanalysis", (String)"47150e89000000ac", (boolean)true);
        List hasPermOrgs = rs.getHasPermOrgs();
        if (hasPermOrgs != null) {
            QFilter q = new QFilter("id", "in", (Object)hasPermOrgs);
            ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(q);
        }
    }

    public static void beforeF7Select4Period(BeforeF7SelectEvent evt, DynamicObject costAccount) {
        QFilter q = PeriodHelper.getCostAccountNextPeriodQf(costAccount);
        ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    public static void beforeF7Select4MaterialGroup(BeforeF7SelectEvent evt, DynamicObject materialGroupStandard, DynamicObject calOrg) {
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        QFilter qFilter = new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue());
        ArrayList<Long> orgId = new ArrayList<Long>();
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        if (calOrg != null) {
            orgId.add(calOrg.getLong("id"));
            QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", orgId, materialGroupStandard.getPkValue(), true});
            qFilter.and(serviceResponse);
            params.put("useOrgs", orgId);
            listShowParameter.setCustomParams(params);
        } else {
            params.put("isShowAllNoOrg", "true");
            listShowParameter.setCustomParams(params);
            qFilter.and("standard", "=", materialGroupStandard.getPkValue());
            qFilter.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        }
        filters.add(qFilter);
        listShowParameter.setCustomParam("groupStandard", materialGroupStandard.getPkValue());
    }

    public static void beforeF7Select4MaterialGroupTo(BeforeF7SelectEvent evt, DynamicObjectCollection materialGroupFrom, DynamicObject materialGroupStandard, DynamicObject calOrg) {
        BeforeF7SelectHelper.beforeF7Select4MaterialGroup(evt, materialGroupStandard, calOrg);
        if (materialGroupFrom != null && !materialGroupFrom.isEmpty()) {
            Object selectedNumberValue = ((DynamicObject)materialGroupFrom.get(0)).getDynamicObject(1).get("number");
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            filters.add(new QFilter("number", ">=", selectedNumberValue));
        }
    }

    public static void beforeF7Select4Material(BeforeF7SelectEvent evt, DynamicObject materialGroupStandard, DynamicObject calOrg, DynamicObjectCollection materialGroupFrom, DynamicObject materialGroupTo) {
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("groupStandard", materialGroupStandard.getPkValue());
        if (calOrg == null) {
            params.put("isShowAllNoOrg", "true");
        } else {
            ArrayList<Long> orgId = new ArrayList<Long>();
            orgId.add(calOrg.getLong("id"));
            params.put("useOrgs", orgId);
        }
        listShowParameter.setCustomParams(params);
        List treeFs = listShowParameter.getTreeFilterParameter().getQFilters();
        QFilter groupFs = BeforeF7SelectHelper.getGroupFs(materialGroupStandard, materialGroupFrom, materialGroupTo);
        if (groupFs != null) {
            treeFs.add(groupFs);
        }
        QFilter fs = BeforeF7SelectHelper.getMaterialFsByGroup(materialGroupStandard, materialGroupFrom, materialGroupTo);
        listShowParameter.getListFilterParameter().setFilter(fs);
    }

    public static void beforeF7Select4MaterialGroupStandard(BeforeF7SelectEvent evt, DynamicObject calOrg) {
        Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandard", (Object[])new Object[]{"bd_material", calOrg.getPkValue(), Boolean.TRUE});
        ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("id", "in", (Object)ids));
    }

    private static QFilter getGroupFs(DynamicObject materialGroupStandard, DynamicObjectCollection materialGroupFrom, DynamicObject materialGroupTo) {
        GroupCol info = BeforeF7SelectHelper.getGroupCol(materialGroupStandard, materialGroupFrom, materialGroupTo);
        return info.buildFromToFs("id", "number");
    }

    private static GroupCol getGroupCol(DynamicObject materialGroupStandard, DynamicObjectCollection materialGroupFrom, DynamicObject materialGroupTo) {
        FromToCol fsInfo = BeforeF7SelectHelper.getFromToCol(materialGroupFrom, materialGroupTo);
        GroupCol info = new GroupCol();
        info.setGroupStandardId(materialGroupStandard == null ? 730148448254487552L : materialGroupStandard.getLong("id"));
        info.setNoFrom(fsInfo.getNoFrom());
        info.setNoTo(fsInfo.getNoTo());
        info.setIds(fsInfo.getIds());
        return info;
    }

    private static FromToCol getFromToCol(DynamicObjectCollection materialGroupFrom, DynamicObject materialGroupTo) {
        FromToCol info = new FromToCol();
        ArrayList<Object> ids = new ArrayList<Object>(materialGroupFrom.size());
        DynamicObject from = null;
        int i = 0;
        for (DynamicObject baseData : materialGroupFrom) {
            DynamicObject tempBaseData = baseData.getDynamicObject("fbasedataid");
            ids.add(tempBaseData.getPkValue());
            if (i++ != 0) continue;
            from = tempBaseData;
        }
        info.setNoFrom(from != null ? from.getString("number") : null);
        info.setNoTo(materialGroupTo != null ? materialGroupTo.getString("number") : null);
        if (ids.size() == 1 && info.getNoTo() == null || ids.size() == 1 && materialGroupTo != null && !ids.get(0).equals(materialGroupTo.getPkValue())) {
            ids.clear();
        }
        info.setIds(ids);
        return info;
    }

    private static QFilter getMaterialFsByGroup(DynamicObject materialGroupStandard, DynamicObjectCollection materialGroupFrom, DynamicObject materialGroupTo) {
        GroupCol info = BeforeF7SelectHelper.getGroupCol(materialGroupStandard, materialGroupFrom, materialGroupTo);
        QFilter fs = BeforeF7SelectHelper.buildGroupFs(info);
        if (fs != null && "group".equals(fs.getProperty())) {
            fs.__setProperty("group.id");
        }
        if (fs == null || info.isGroupStandardId()) {
            return fs;
        }
        int maxRowCount = 5000;
        DataSet idData = QueryServiceHelper.queryDataSet((String)"getMaterialFsByGroup", (String)"bd_materialgroupdetail", (String)"material", (QFilter[])fs.toArray(), null, (int)maxRowCount);
        ArrayList<Long> ids = new ArrayList<Long>(maxRowCount);
        for (Row idInfo : idData) {
            ids.add(idInfo.getLong("material"));
        }
        if (ids.size() >= maxRowCount) {
            return null;
        }
        return new QFilter("id", "in", ids);
    }

    private static QFilter buildGroupFs(GroupCol info) {
        QFilter fs;
        if (info.isGroupStandardId()) {
            fs = info.buildFromToFs("group", "group.number");
        } else {
            fs = new QFilter("standard", "=", (Object)info.getGroupStandardId());
            QFilter groupFs = info.buildFromToFs("group", "group.number");
            if (groupFs != null) {
                fs.and(groupFs);
            }
        }
        return fs;
    }
}

