/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.business.helper;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class DullMaterialHelper {
    private static final String PERIOD_UPDATED = "period_updated";
    private static final IAppCache CACHE = AppCache.get((String)"im");

    public static boolean isNewPeriodBal() {
        String tb = (String)CACHE.get(PERIOD_UPDATED, String.class);
        boolean isNew = true;
        if (tb == null) {
            String sql = "select fid from T_IM_INVDBPARAM where fkey  = 'period_updated'";
            try (DataSet data = DB.queryDataSet((String)"kd.scmc.im.business.balance.BalanceUpdateHandle.isNewPeriodBal", (DBRoute)new DBRoute("scm"), (String)sql);){
                isNew = data.hasNext();
            }
            tb = String.valueOf(isNew);
            CACHE.put(PERIOD_UPDATED, (Object)tb);
        } else {
            isNew = "true".equalsIgnoreCase(tb);
        }
        return isNew;
    }

    private static String getAlgoKey() {
        return "scmc-scmdi-themeanalysis";
    }

    public static QFilter addCommonDataQFilter(FilterInfo filterInfo) {
        QFilter tracknumberFilter;
        QFilter configuredCodeFilter;
        QFilter projectFilter;
        QFilter locationFilter;
        QFilter warehouseFilter;
        QFilter materialFilter;
        DynamicObjectCollection invstatusheads;
        DynamicObjectCollection ivntypeheads;
        DynamicObject org = filterInfo.getDynamicObject("orghead");
        QFilter commDataQFilter = new QFilter("org", "=", org.getPkValue());
        String ownerTypehead = filterInfo.getString("ownertypehead");
        QFilter ownerTypeFilter = null;
        if (ownerTypehead != null && !ownerTypehead.trim().equals("")) {
            ownerTypeFilter = new QFilter("ownertype", "=", (Object)ownerTypehead);
            commDataQFilter.and(ownerTypeFilter);
        }
        if ((ivntypeheads = filterInfo.getDynamicObjectCollection("ivntypehead")) != null && ivntypeheads.size() > 0) {
            HashSet<Object> ivntypeIds = new HashSet<Object>();
            for (Iterator ivntype : ivntypeheads) {
                ivntypeIds.add(ivntype.getPkValue());
            }
            QFilter ivntypeheadFilter = new QFilter("invtype", "in", ivntypeIds);
            commDataQFilter.and(ivntypeheadFilter);
        }
        if ((invstatusheads = filterInfo.getDynamicObjectCollection("invstatushead")) != null && invstatusheads.size() > 0) {
            HashSet<Object> invstatusIds = new HashSet<Object>();
            for (DynamicObject invstatus : invstatusheads) {
                invstatusIds.add(invstatus.getPkValue());
            }
            QFilter invstatusheadFilter = new QFilter("invstatus", "in", invstatusIds);
            commDataQFilter.and(invstatusheadFilter);
        }
        if ((materialFilter = DullMaterialHelper.getMaterialFromToFilter(filterInfo)) != null) {
            commDataQFilter.and(materialFilter);
        }
        if ((warehouseFilter = DullMaterialHelper.getDynamicObjectFromToFilter(filterInfo, "warehouse.number", "warehousefrom", "warehouseto")) != null) {
            commDataQFilter.and(warehouseFilter);
        }
        if ((locationFilter = DullMaterialHelper.getDynamicObjectFromToFilter(filterInfo, "location.number", "locationfrom", "locationto")) != null) {
            commDataQFilter.and(locationFilter);
        }
        if ((projectFilter = DullMaterialHelper.getDynamicObjectFromToFilter(filterInfo, "project.number", "projectfrom", "projectto")) != null) {
            commDataQFilter.and(projectFilter);
        }
        if ((configuredCodeFilter = DullMaterialHelper.getDynamicObjectFromToFilter(filterInfo, "configuredcode.number", "configuredcodefrom", "configuredcodeto")) != null) {
            commDataQFilter.and(configuredCodeFilter);
        }
        if ((tracknumberFilter = DullMaterialHelper.getDynamicObjectFromToFilter(filterInfo, "tracknumber.number", "tracknumberfrom", "tracknumberto")) != null) {
            commDataQFilter.and(tracknumberFilter);
        }
        return commDataQFilter;
    }

    protected static QFilter getMaterialFromToFilter(FilterInfo filterInfo) {
        String filterColomn = "number";
        String materialLogo = "material";
        DynamicObjectCollection materialFroms = filterInfo.getDynamicObjectCollection("materialnumberfrom");
        if (materialFroms != null && !materialFroms.isEmpty()) {
            if (materialFroms.size() > 1) {
                ArrayList<Object> materialNums = new ArrayList<Object>();
                for (DynamicObject materialFrom : materialFroms) {
                    Object materialNum = materialFrom.get(filterColomn);
                    materialNums.add(materialNum);
                }
                return new QFilter(materialLogo + "." + filterColomn, "in", materialNums);
            }
            DynamicObject materialFrom = (DynamicObject)materialFroms.get(0);
            if (materialFrom == null) {
                return null;
            }
            Object materialNumFrom = materialFrom.get(filterColomn);
            QFilter fromFilter = new QFilter(materialLogo + "." + filterColomn, ">=", materialNumFrom);
            DynamicObject materialTo = filterInfo.getDynamicObject("materialnumberto");
            if (materialTo == null) {
                return fromFilter;
            }
            Object materialNumTo = materialTo.get(filterColomn);
            QFilter toFilter = new QFilter(materialLogo + "." + filterColomn, "<=", materialNumTo);
            return fromFilter.and(toFilter);
        }
        DynamicObject materialTo = filterInfo.getDynamicObject("materialnumberto");
        if (materialTo == null) {
            return null;
        }
        Object materialNumTo = materialTo.get(filterColomn);
        QFilter toFilter = new QFilter(materialLogo + "." + filterColomn, "<=", materialNumTo);
        return toFilter;
    }

    public static QFilter getTextFromToFilter(FilterInfo filterInfo, String queryFiled, String fromKey, String toKey) {
        String from = filterInfo.getString(fromKey);
        String to = filterInfo.getString(toKey);
        if (from != null && from.replaceAll(" ", "").length() != from.length()) {
            String[] froms = from.split("\\s+");
            return new QFilter(queryFiled, "in", (Object)froms);
        }
        if (from != null && from.replaceAll(",", "").length() != from.length()) {
            String[] froms = from.split(",");
            return new QFilter(queryFiled, "in", (Object)froms);
        }
        QFilter filter = null;
        if (from != null && !from.trim().equals("")) {
            filter = new QFilter(queryFiled, ">=", (Object)from.trim());
        }
        if (to != null && !to.trim().equals("")) {
            QFilter toFilter = new QFilter(queryFiled, "<=", (Object)to.trim());
            if (filter == null) {
                filter = toFilter;
            } else {
                filter.and(toFilter);
            }
        }
        return filter;
    }

    public static <T> String collectionToStr(Collection<T> collection) {
        StringBuilder sbf = new StringBuilder();
        int size = collection.size();
        int index = 0;
        for (T t : collection) {
            sbf.append(t);
            if (index++ >= size - 1) continue;
            sbf.append(',');
        }
        return sbf.toString();
    }

    public static String[] collectionToStrArr(Collection<String> collection) {
        return DullMaterialHelper.collectionToTypeArr(collection);
    }

    public static <T> T[] collectionToTypeArr(Collection<T> collection) {
        return collection.toArray((Object[])Array.newInstance(collection.iterator().next().getClass(), collection.size()));
    }

    public static String[] getDataSetFieldStrs(DataSet dataSet) {
        return DullMaterialHelper.collectionToStrArr(DullMaterialHelper.getDataSetFields(dataSet));
    }

    public static String[] getDataSetFieldStrs(DataSet dataSet, String ... newFields) {
        String[] dataSetFields = DullMaterialHelper.getDataSetFieldStrs(dataSet);
        return DullMaterialHelper.addNewValsToSrcArr(dataSetFields, newFields);
    }

    public static Set<String> getDataSetFields(DataSet dataSet) {
        Field[] fields = dataSet.getRowMeta().getFields();
        LinkedHashSet<String> fs = new LinkedHashSet<String>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            String fieldName = fields[i].getName();
            fs.add(fieldName);
        }
        return fs;
    }

    public static QFilter getIdentEqQFilter() {
        return new QFilter("1", "=", (Object)1);
    }

    public static QFilter getIdentNotEqQFilter() {
        return new QFilter("1", "!=", (Object)1);
    }

    public static QFilter getEnableAvaliableQFilter() {
        return new QFilter("enable", "=", (Object)"1");
    }

    public static QFilter getAuditedStatusQFilter() {
        return new QFilter("status", "=", (Object)"C");
    }

    public static QFilter getAuditedDataQFilter() {
        return DullMaterialHelper.getEnableAvaliableQFilter().and(DullMaterialHelper.getAuditedStatusQFilter());
    }

    public static String[] addNewValsToSrcArr(String[] srcArr, String ... newVal) {
        int newECount = newVal.length;
        int srcArrsLen = srcArr.length;
        int newArrsLen = newECount + srcArrsLen;
        String[] newArr = new String[newArrsLen];
        System.arraycopy(srcArr, 0, newArr, 0, srcArrsLen);
        System.arraycopy(newVal, 0, newArr, srcArrsLen, newECount);
        return newArr;
    }

    public static DataSet handleOtherFilter(FilterInfo filterInfo, String[] billSelectFields, DataSet unionBillDataSet) {
        unionBillDataSet = DullMaterialHelper.handleMaterialFilter(filterInfo, billSelectFields, unionBillDataSet);
        unionBillDataSet = DullMaterialHelper.handleProjectFilter(filterInfo, billSelectFields, unionBillDataSet);
        unionBillDataSet = DullMaterialHelper.handleWarehouseFilter(filterInfo, billSelectFields, unionBillDataSet);
        unionBillDataSet = DullMaterialHelper.handleLocationFilter(filterInfo, billSelectFields, unionBillDataSet);
        return unionBillDataSet;
    }

    public static DataSet handleLocationFilter(FilterInfo filterInfo, String[] billSelectFields, DataSet unionBillDataSet) {
        QFilter searchLocatFilter = DullMaterialHelper.getDynamicObjectFromToFilter(filterInfo, "locationNumber", "locationfrom", "locationto");
        if (searchLocatFilter != null) {
            QFilter locatQFilter = DullMaterialHelper.getAuditedDataQFilter();
            DataSet locatDataSet = QueryServiceHelper.queryDataSet((String)DullMaterialHelper.getAlgoKey(), (String)"bd_location", (String)"id as locationId,number as locationNumber", (QFilter[])locatQFilter.toArray(), (String)"");
            unionBillDataSet = unionBillDataSet.join(locatDataSet, JoinType.INNER).select(billSelectFields, new String[]{"locationId", "locationNumber"}).on("location", "locationId").finish().filter(searchLocatFilter.toString());
        }
        return unionBillDataSet;
    }

    public static DataSet handleWarehouseFilter(FilterInfo filterInfo, String[] billSelectFields, DataSet unionBillDataSet) {
        QFilter searchWhouseFilter = DullMaterialHelper.getDynamicObjectFromToFilter(filterInfo, "warehouseNumber", "warehousefrom", "warehouseto");
        if (searchWhouseFilter != null) {
            QFilter whouseQFilter = DullMaterialHelper.getAuditedDataQFilter();
            DataSet locatDataSet = QueryServiceHelper.queryDataSet((String)DullMaterialHelper.getAlgoKey(), (String)"bd_warehouse", (String)"id as warehouseId,number as warehouseNumber", (QFilter[])whouseQFilter.toArray(), (String)"");
            unionBillDataSet = unionBillDataSet.join(locatDataSet, JoinType.INNER).select(billSelectFields, new String[]{"warehouseId", "warehouseNumber"}).on("warehouse", "warehouseId").finish().filter(searchWhouseFilter.toString());
        }
        return unionBillDataSet;
    }

    public static DataSet handleProjectFilter(FilterInfo filterInfo, String[] billSelectFields, DataSet unionBillDataSet) {
        QFilter searchProFilter = DullMaterialHelper.getDynamicObjectFromToFilter(filterInfo, "projectNumber", "projectfrom", "projectto");
        if (searchProFilter != null) {
            QFilter proQFilter = DullMaterialHelper.getAuditedDataQFilter();
            DataSet projectDataSet = QueryServiceHelper.queryDataSet((String)DullMaterialHelper.getAlgoKey(), (String)"bd_project", (String)"id as projectId,number as projectNumber", (QFilter[])proQFilter.toArray(), (String)"");
            unionBillDataSet = unionBillDataSet.join(projectDataSet, JoinType.INNER).select(billSelectFields, new String[]{"projectId", "projectNumber"}).on("project", "projectId").finish().filter(searchProFilter.toString());
        }
        return unionBillDataSet;
    }

    public static DataSet handleMaterialFilter(FilterInfo filterInfo, String[] billSelectFields, DataSet unionBillDataSet) {
        QFilter searchMaterFilter = DullMaterialHelper.getMaterialNumFromToFilter(filterInfo, "number");
        if (searchMaterFilter != null) {
            QFilter materQFilter = DullMaterialHelper.getAuditedDataQFilter();
            DataSet materialDataSet = QueryServiceHelper.queryDataSet((String)DullMaterialHelper.getAlgoKey(), (String)"bd_material", (String)"id as materialId,number as materialNumber", (QFilter[])materQFilter.toArray(), (String)"");
            unionBillDataSet = unionBillDataSet.join(materialDataSet, JoinType.INNER).select(billSelectFields, new String[]{"materialId", "materialNumber"}).on("material", "materialId").finish().filter(searchMaterFilter.toString());
        }
        return unionBillDataSet;
    }

    public static QFilter getMaterialNumFromToFilter(FilterInfo filterInfo, String filterColomn) {
        DynamicObjectCollection materialFroms = filterInfo.getDynamicObjectCollection("materialnumberfrom");
        if (materialFroms != null && !materialFroms.isEmpty()) {
            if (materialFroms.size() > 1) {
                ArrayList<String> materialNums = new ArrayList<String>();
                for (DynamicObject materialFrom : materialFroms) {
                    String materialNum = materialFrom.getString(filterColomn);
                    materialNums.add(materialNum);
                }
                return new QFilter("materialNumber", "in", materialNums);
            }
            DynamicObject materialFrom = (DynamicObject)materialFroms.get(0);
            if (materialFrom == null) {
                return null;
            }
            String materialNumFrom = materialFrom.getString(filterColomn);
            QFilter fromFilter = new QFilter("materialNumber", ">=", (Object)materialNumFrom);
            DynamicObject materialTo = filterInfo.getDynamicObject("materialnumberto");
            if (materialTo == null) {
                return fromFilter;
            }
            String materialNumTo = materialTo.getString(filterColomn);
            QFilter toFilter = new QFilter("materialNumber", "<=", (Object)materialNumTo);
            return fromFilter.and(toFilter);
        }
        DynamicObject materialTo = filterInfo.getDynamicObject("materialnumberto");
        if (materialTo == null) {
            return null;
        }
        String materialNumTo = materialTo.getString(filterColomn);
        QFilter toFilter = new QFilter("materialNumber", "<=", (Object)materialNumTo);
        return toFilter;
    }

    public static QFilter getDynamicObjectFromToFilter(FilterInfo filterInfo, String queryFiled, String fromKey, String toKey) {
        DynamicObject to;
        QFilter bfilter = null;
        DynamicObjectCollection froms = filterInfo.getDynamicObjectCollection(fromKey);
        if (froms != null && froms.size() != 0) {
            if (froms.size() > 1) {
                HashSet<Object> idSet = new HashSet<Object>();
                for (DynamicObject from : froms) {
                    idSet.add(from.get("number"));
                }
                return new QFilter(queryFiled, "in", idSet);
            }
            DynamicObject from = (DynamicObject)froms.get(0);
            bfilter = new QFilter(queryFiled, ">=", from.get("number"));
        }
        if ((to = filterInfo.getDynamicObject(toKey)) != null) {
            QFilter toFilter = new QFilter(queryFiled, "<=", to.get("number"));
            bfilter = bfilter != null ? bfilter.and(toFilter) : toFilter;
        }
        return bfilter;
    }
}

