/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.business.helper;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.scmdi.common.enums.BillRangeType;
import kd.scmc.scmdi.common.utils.DateUtils;

public class DullTypeBuilder {
    public static DataSet buildDullTypeDataSet(FilterInfo filterInfo) {
        DataSet inInvRangeDataSet = DullTypeBuilder.buildInInvBillRangeDataSet(filterInfo);
        DataSet outInvRangeDataSet = DullTypeBuilder.buildOutInvBillRangeDataSet(filterInfo);
        String materStgyQueryFields = "id as materialInvStrategy,masterid as material";
        QFilter materStgyQFilter = new QFilter("enable", "=", (Object)"1");
        materStgyQFilter.and("status", "=", (Object)"C");
        DataSet materialStrategySet = QueryServiceHelper.queryDataSet((String)DullTypeBuilder.getAlgoKey(), (String)"bd_materialinventoryinfo", (String)materStgyQueryFields, (QFilter[])materStgyQFilter.toArray(), (String)"");
        String selectFields = "org,material,dulltype as dullTypeSum";
        inInvRangeDataSet = inInvRangeDataSet.join(materialStrategySet, JoinType.INNER).on("materialInvStrategy", "materialInvStrategy").select(new String[]{"org", "material"}).finish();
        outInvRangeDataSet = outInvRangeDataSet.join(materialStrategySet, JoinType.INNER).on("materialInvStrategy", "materialInvStrategy").select(new String[]{"org", "material"}).finish();
        inInvRangeDataSet = inInvRangeDataSet.groupBy(new String[]{"org", "material"}).finish().addField("1", "dulltype");
        outInvRangeDataSet = outInvRangeDataSet.groupBy(new String[]{"org", "material"}).finish().addField("2", "dulltype");
        DataSet billRangeDataSet = inInvRangeDataSet.union(outInvRangeDataSet);
        billRangeDataSet = billRangeDataSet.select(selectFields).groupBy(new String[]{"org", "material"}).sum("dullTypeSum").finish();
        return billRangeDataSet;
    }

    private static DataSet buildInInvBillRangeDataSet(FilterInfo filterInfo) {
        Map inBillToInvschemes = (Map)filterInfo.getValue("inBillToInvschemes");
        return DullTypeBuilder.buildBillRangeDataSet(filterInfo, inBillToInvschemes, BillRangeType.BILLRANGE_IN);
    }

    private static DataSet buildOutInvBillRangeDataSet(FilterInfo filterInfo) {
        Map outBillToInvschemes = (Map)filterInfo.getValue("outBillToInvschemes");
        return DullTypeBuilder.buildBillRangeDataSet(filterInfo, outBillToInvschemes, BillRangeType.BILLRANGE_OUT);
    }

    private static DataSet buildBillRangeDataSet(FilterInfo filterInfo, Map<String, Set<Long>> billToInvSchemes, BillRangeType billRangeType) {
        DataSet billSet = null;
        for (Map.Entry<String, Set<Long>> billToInvScheme : billToInvSchemes.entrySet()) {
            String billType = billToInvScheme.getKey();
            Set<Long> invSchemesSet = billToInvScheme.getValue();
            QFilter invSchemeQFilter = null;
            if (!invSchemesSet.isEmpty()) {
                invSchemeQFilter = new QFilter("invscheme", "in", invSchemesSet);
            }
            DataSet dataSet = null;
            switch (billType) {
                case "im_adjustbill": {
                    dataSet = DullTypeBuilder.handleAdjustBillDataSet(filterInfo, billType, invSchemeQFilter, billRangeType);
                    break;
                }
                case "im_assembbill": {
                    dataSet = DullTypeBuilder.handleAssembBillDataSet(filterInfo, billType, invSchemeQFilter, billRangeType);
                    break;
                }
                case "im_disassemblebill": {
                    dataSet = DullTypeBuilder.handleDisassBillDataSet(filterInfo, billType, invSchemeQFilter, billRangeType);
                    break;
                }
                case "im_locationtransfer": {
                    dataSet = DullTypeBuilder.handleLocatTransferBillDataSet(filterInfo, billType, invSchemeQFilter);
                    break;
                }
                case "im_transdirbill": {
                    dataSet = DullTypeBuilder.handleTransDirBillDataSet(filterInfo, billType, invSchemeQFilter, billRangeType);
                    break;
                }
                default: {
                    dataSet = DullTypeBuilder.handleGeneralBillDataSet(filterInfo, billType, invSchemeQFilter);
                }
            }
            if (billSet == null) {
                billSet = dataSet;
                continue;
            }
            billSet = billSet.union(dataSet);
        }
        return billSet;
    }

    private static DataSet handleTransDirBillDataSet(FilterInfo filterInfo, String billType, QFilter invSchemeQFilter, BillRangeType billRangeType) {
        QFilter billFilter = DullTypeBuilder.buildBillQFilter(filterInfo, billType);
        if (invSchemeQFilter != null) {
            billFilter.and(invSchemeQFilter);
        }
        DataSet billDataSet = null;
        if (BillRangeType.BILLRANGE_IN == billRangeType) {
            String inInvFields = DullTypeBuilder.getTransDirBillInInvCols();
            billDataSet = QueryServiceHelper.queryDataSet((String)DullTypeBuilder.getAlgoKey(), (String)billType, (String)inInvFields, (QFilter[])billFilter.toArray(), (String)"");
        } else {
            String outInvFields = DullTypeBuilder.getTransDirBillOutInvCols();
            billDataSet = QueryServiceHelper.queryDataSet((String)DullTypeBuilder.getAlgoKey(), (String)billType, (String)outInvFields, (QFilter[])billFilter.toArray(), (String)"");
        }
        return billDataSet;
    }

    private static DataSet handleGeneralBillDataSet(FilterInfo filterInfo, String billType, QFilter invSchemeQFilter) {
        return DullTypeBuilder.handleBillDataSet(filterInfo, billType, invSchemeQFilter);
    }

    private static DataSet handleBillDataSet(FilterInfo filterInfo, String billType, QFilter invSchemeQFilter) {
        QFilter billFilter = DullTypeBuilder.buildBillQFilter(filterInfo, billType);
        if (invSchemeQFilter != null) {
            billFilter.and(invSchemeQFilter);
        }
        String selectedFields = DullTypeBuilder.getInvBillCols();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)DullTypeBuilder.getAlgoKey(), (String)billType, (String)selectedFields, (QFilter[])billFilter.toArray(), (String)"");
        return dataSet;
    }

    private static DataSet handleLocatTransferBillDataSet(FilterInfo filterInfo, String billType, QFilter invSchemeQFilter) {
        return DullTypeBuilder.handleBillDataSet(filterInfo, billType, invSchemeQFilter);
    }

    private static DataSet handleAdjustBillDataSet(FilterInfo filterInfo, String billType, QFilter invSchemeQFilter, BillRangeType billRangeType) {
        QFilter billFilter = DullTypeBuilder.buildBillQFilter(filterInfo, billType);
        if (invSchemeQFilter != null) {
            billFilter.and(invSchemeQFilter);
        }
        DataSet billDataSet = null;
        billDataSet = BillRangeType.BILLRANGE_IN == billRangeType ? DullTypeBuilder.handleAfterEntityDataSet(billType, billFilter) : DullTypeBuilder.handleBillEntryDataSet(billType, billFilter);
        return billDataSet;
    }

    private static DataSet handleDisassBillDataSet(FilterInfo filterInfo, String billType, QFilter invSchemeQFilter, BillRangeType billRangeType) {
        QFilter billFilter = DullTypeBuilder.buildBillQFilter(filterInfo, billType);
        if (invSchemeQFilter != null) {
            billFilter.and(invSchemeQFilter);
        }
        DataSet billDataSet = null;
        billDataSet = BillRangeType.BILLRANGE_IN == billRangeType ? DullTypeBuilder.handleAfterEntityDataSet(billType, billFilter) : DullTypeBuilder.handleBillEntryDataSet(billType, billFilter);
        return billDataSet;
    }

    private static DataSet handleAfterEntityDataSet(String billType, QFilter billFilter) {
        String afterEntityFields = DullTypeBuilder.getAfterEntityCols();
        DataSet billDataSet = QueryServiceHelper.queryDataSet((String)DullTypeBuilder.getAlgoKey(), (String)billType, (String)afterEntityFields, (QFilter[])billFilter.toArray(), (String)"");
        return billDataSet;
    }

    private static DataSet handleBillEntryDataSet(String billType, QFilter billFilter) {
        String billentryFields = DullTypeBuilder.getBillEntryCols();
        DataSet billDataSet = QueryServiceHelper.queryDataSet((String)DullTypeBuilder.getAlgoKey(), (String)billType, (String)billentryFields, (QFilter[])billFilter.toArray(), (String)"");
        return billDataSet;
    }

    private static DataSet handleAssembBillDataSet(FilterInfo filterInfo, String billType, QFilter invSchemeQFilter, BillRangeType billRangeType) {
        QFilter billFilter = DullTypeBuilder.buildBillQFilter(filterInfo, billType);
        if (invSchemeQFilter != null) {
            billFilter.and(invSchemeQFilter);
        }
        DataSet billDataSet = null;
        billDataSet = BillRangeType.BILLRANGE_IN == billRangeType ? DullTypeBuilder.handleBillEntryDataSet(billType, billFilter) : DullTypeBuilder.handleAfterEntityDataSet(billType, billFilter);
        return billDataSet;
    }

    private static QFilter buildBillQFilter(FilterInfo filterInfo, String billType) {
        QFilter billFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter notInitFilter = DullTypeBuilder.getNotInitBillFilter(billType);
        if (notInitFilter != null) {
            billFilter.and(notInitFilter);
        }
        return billFilter.and(DullTypeBuilder.getDullTimeFilter(filterInfo));
    }

    private static QFilter getDullTimeFilter(FilterInfo filterInfo) {
        String dullAnalyseobj = filterInfo.getString("dullanalyseobj");
        int dullDays = filterInfo.getInt("dulldays");
        Date startDate = null;
        Date endDate = null;
        endDate = filterInfo.getDate("deadline");
        startDate = dullDays == 0 ? endDate : DateUtils.addDay(endDate, -1 * dullDays);
        QFilter billTypeFilter = new QFilter("bookdate", ">=", (Object)startDate);
        return billTypeFilter.and("bookdate", "<=", (Object)endDate);
    }

    private static QFilter getNotInitBillFilter(String billtype) {
        switch (billtype) {
            case "im_saloutbill": 
            case "im_purinbill": {
                return new QFilter("isinitbill", "=", (Object)Boolean.FALSE);
            }
        }
        return null;
    }

    private static String getTransDirBillInInvCols() {
        return "org,billentry.material as materialInvStrategy";
    }

    private static String getTransDirBillOutInvCols() {
        return "outorg as org,billentry.material as materialInvStrategy";
    }

    private static String getInvBillCols() {
        return "org,billentry.material as materialInvStrategy";
    }

    private static String getBillEntryCols() {
        return DullTypeBuilder.getInvBillCols();
    }

    private static String getAfterEntityCols() {
        return "org,billentry.afterentity.material1 as materialInvStrategy";
    }

    private static String getAlgoKey() {
        return DullTypeBuilder.class.getName();
    }
}

