/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class InvBillAgeHelper {
    public static QFilter getBillInvAcOrInvBalancecQFilter(FilterInfo filterInfo, boolean isMaterialNumber) {
        QFilter projectFilter;
        QFilter locationFilter;
        QFilter materialFilter;
        QFilter warehouseFilter;
        DynamicObjectCollection ivntypeheads;
        DynamicObject org = filterInfo.getDynamicObject("orghead");
        QFilter filter = new QFilter("org", "=", org.getPkValue());
        String ownerTypehead = filterInfo.getString("ownertypehead");
        if (ownerTypehead != null && !ownerTypehead.trim().equals("")) {
            QFilter ownerTypeFilter = new QFilter("ownertype", "=", (Object)ownerTypehead);
            filter = filter.and(ownerTypeFilter);
        }
        if ((ivntypeheads = filterInfo.getDynamicObjectCollection("ivntypehead")) != null && ivntypeheads.size() > 0) {
            HashSet<Object> ivntypeIds = new HashSet<Object>();
            for (DynamicObject ivntype : ivntypeheads) {
                ivntypeIds.add(ivntype.getPkValue());
            }
            QFilter ivntypeheadFilter = new QFilter("invtype", "in", ivntypeIds);
            filter = filter.and(ivntypeheadFilter);
        }
        if ((warehouseFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "warehouse.number", "warehousefrom", "warehouseto")) != null) {
            filter.and(warehouseFilter);
        }
        if ((materialFilter = InvBillAgeHelper.getMaterialFromToFilter(filterInfo, "material", isMaterialNumber)) != null) {
            filter.and(materialFilter);
        }
        if ((locationFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "location.number", "locationfrom", "locationto")) != null) {
            filter.and(locationFilter);
        }
        if ((projectFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "project.number", "projectfrom", "projectto")) != null) {
            filter.and(projectFilter);
        }
        return filter;
    }

    public static QFilter getDynamicObjectFromToFilter(FilterInfo filterInfo, String queryFiled, String fromKey, String toKey) {
        DynamicObject to;
        QFilter bfilter = null;
        DynamicObjectCollection froms = filterInfo.getDynamicObjectCollection(fromKey);
        if (froms != null && froms.size() != 0) {
            if (froms.size() > 1) {
                HashSet<Object> idSet = new HashSet<Object>();
                for (DynamicObject from : froms) {
                    idSet.add(from.get("number"));
                }
                return new QFilter(queryFiled, "in", idSet);
            }
            DynamicObject from = (DynamicObject)froms.get(0);
            bfilter = new QFilter(queryFiled, ">=", from.get("number"));
        }
        if ((to = filterInfo.getDynamicObject(toKey)) != null) {
            QFilter toFilter = new QFilter(queryFiled, "<=", to.get("number"));
            bfilter = bfilter != null ? bfilter.and(toFilter) : toFilter;
        }
        return bfilter;
    }

    public static QFilter getMaterialFromToFilter(FilterInfo filterInfo, String materialKey, boolean isMaterialNumber) {
        Object materialfrom = filterInfo.getValue("materialnumberfrom");
        String materialNumber = "masterid.number";
        String numField = "number";
        QFilter materialFilter = null;
        if (isMaterialNumber) {
            materialNumber = "number";
        }
        if (materialfrom instanceof DynamicObject) {
            DynamicObject from = (DynamicObject)materialfrom;
            DynamicObject to = filterInfo.getDynamicObject("materialnumberto");
            materialFilter = new QFilter(numField, ">=", from.get(materialNumber));
            if (to != null) {
                QFilter tofilter = new QFilter(numField, "<=", to.get(materialNumber));
                materialFilter = materialFilter.and(tofilter);
            }
        } else if (materialfrom instanceof DynamicObjectCollection) {
            DynamicObjectCollection froms = (DynamicObjectCollection)materialfrom;
            if (froms == null || froms.size() == 0) {
                return null;
            }
            if (froms.size() > 1) {
                HashSet<Object> idSet = new HashSet<Object>();
                for (DynamicObject from : froms) {
                    idSet.add(from.get(materialNumber));
                }
                materialFilter = new QFilter(numField, "in", idSet);
            } else {
                DynamicObject from = (DynamicObject)froms.get(0);
                DynamicObject to = filterInfo.getDynamicObject("materialnumberto");
                materialFilter = new QFilter(numField, ">=", from.get(materialNumber));
                if (to != null) {
                    materialFilter = materialFilter.and(numField, "<=", to.get(materialNumber));
                }
            }
        } else {
            DynamicObject to = filterInfo.getDynamicObject("materialnumberto");
            if (to != null) {
                materialFilter = new QFilter(numField, "<=", to.get(materialNumber));
            }
        }
        if (materialFilter == null) {
            return null;
        }
        Map materials = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id", (QFilter[])materialFilter.toArray());
        return new QFilter(materialKey, "in", materials.keySet());
    }

    public static Set<String> getDataSetField(DataSet dataSet) {
        Field[] fields = dataSet.getRowMeta().getFields();
        LinkedHashSet<String> fs = new LinkedHashSet<String>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            String fieldName = fields[i].getName();
            fs.add(fieldName);
        }
        return fs;
    }

    public static String[] getDataSetFieldArray(DataSet dataSet) {
        Set<String> fileds = InvBillAgeHelper.getDataSetField(dataSet);
        return fileds.toArray(new String[fileds.size()]);
    }

    public static DataSet filterNoUpdateField(DataSet billSet, FilterInfo filterInfo) {
        ArrayList<Object[]> lineData = new ArrayList<Object[]>();
        DataSet copyBillSet = billSet.copy();
        billSet.close();
        RowMeta rowMeta = copyBillSet.getRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        for (Row row : copyBillSet) {
            ArrayList<Object> tempData = new ArrayList<Object>(rowMeta.getFieldCount());
            String noUpdateInvFields = row.getString("noupdateinvfields");
            Boolean updateField = null != noUpdateInvFields && !noUpdateInvFields.isEmpty();
            Set<String> noUpdateInvNumFieldSet = InvBillAgeHelper.getNoUpdateInvNumFieldSet(noUpdateInvFields);
            for (String fieldName : fieldNames) {
                Object value = row.get(fieldName);
                if (updateField.booleanValue() && noUpdateInvNumFieldSet.contains(fieldName)) {
                    value = fieldName.contains(".number") ? "" : Long.valueOf(0L);
                }
                tempData.add(value);
            }
            lineData.add(tempData.toArray());
        }
        CollectionInput inputs = new CollectionInput(rowMeta, lineData);
        DataSet filterDataSet = Algo.create((String)Thread.currentThread().getStackTrace()[2].toString()).createDataSet(new Input[]{inputs});
        return filterDataSet;
    }

    private static Set<String> getNoUpdateInvNumFieldSet(String noUpdateInvFields) {
        HashSet<String> getNoUpdateInvNumFieldSet = new HashSet<String>(4);
        if (null == noUpdateInvFields || noUpdateInvFields.isEmpty()) {
            return getNoUpdateInvNumFieldSet;
        }
        List<String> updateInvFieldsList = InvBillAgeHelper.getNoUpdateFieldsList(noUpdateInvFields);
        for (String noUpdateInvField : updateInvFieldsList) {
            getNoUpdateInvNumFieldSet.add(noUpdateInvField);
            getNoUpdateInvNumFieldSet.add(noUpdateInvField + ".number");
        }
        return getNoUpdateInvNumFieldSet;
    }

    public static List<String> getNoUpdateFieldsList(String noUpdateInvFields) {
        List<String> updateInvFieldsList = new ArrayList<String>(4);
        boolean jsonType = InvBillAgeHelper.getJSONType(noUpdateInvFields);
        if (!jsonType) {
            return updateInvFieldsList;
        }
        Map updateInvFieldsMap = (Map)SerializationUtils.fromJsonString((String)noUpdateInvFields, Map.class);
        updateInvFieldsList = (List)updateInvFieldsMap.get("setnull");
        if (null == updateInvFieldsList) {
            updateInvFieldsList = new ArrayList(4);
        }
        return updateInvFieldsList;
    }

    private static boolean getJSONType(String str) {
        boolean result = false;
        if (StringUtils.isNotBlank((CharSequence)str)) {
            if ((str = str.trim()).startsWith("{") && str.endsWith("}")) {
                result = true;
            } else if (str.startsWith("[") && str.endsWith("]")) {
                result = true;
            }
        }
        return result;
    }

    public static String[] addFileds(String[] source, String ... addFiled) {
        return (String[])ArrayUtils.addAll((Object[])source, (Object[])addFiled);
    }

    public static String[] removeFiled(String[] source, String ... removeFileds) {
        HashSet<String> removeFiledSet = new HashSet<String>(removeFileds.length);
        for (String removeFiled : removeFileds) {
            removeFiledSet.add(removeFiled);
        }
        ArrayList<String> fileds = new ArrayList<String>(source.length);
        for (String string : source) {
            if (removeFiledSet.contains(string)) continue;
            fileds.add(string);
        }
        return fileds.toArray(new String[fileds.size()]);
    }

    public static String arraysToString(String[] sourceFileds) {
        String arrayS = Arrays.toString(sourceFileds);
        return arrayS.substring(1, arrayS.length() - 1);
    }

    public static String[] mapperFileds(String[] sourceFileds, Map<String, String> mapper, String ... excludeField) {
        if (sourceFileds == null || sourceFileds.length == 0) {
            return new String[0];
        }
        boolean isNeedMapper = true;
        if (mapper == null || mapper.size() == 0) {
            isNeedMapper = false;
        }
        HashSet<String> excludes = new HashSet<String>(excludeField.length);
        for (String exclude : excludeField) {
            excludes.add(exclude);
        }
        ArrayList<String> list = new ArrayList<String>(sourceFileds.length);
        for (String filed : sourceFileds) {
            if (excludes.contains(filed)) continue;
            if (mapper != null) {
                String mapFiled = mapper.get(filed);
                if (isNeedMapper && mapFiled != null) {
                    filed = mapFiled + " as " + filed;
                }
            }
            list.add(filed);
        }
        return list.toArray(new String[list.size()]);
    }

    public static DataSet addInitBillRecAndSend(FilterInfo filterInfo, QFilter timefilter) {
        LinkedHashMap<String, Object> inmapper = new LinkedHashMap<String, Object>(21);
        inmapper.put("org", "org");
        inmapper.put("invtype", "billentry.invtype");
        inmapper.put("ownertype", "billentry.ownertype");
        inmapper.put("owner", "billentry.owner");
        inmapper.put("material", "billentry.material.masterid");
        inmapper.put("baseunit", "billentry.baseunit");
        inmapper.put("unit", "billentry.unit");
        inmapper.put("warehouse", "billentry.warehouse");
        inmapper.put("location", "billentry.location");
        inmapper.put("invscheme", 0);
        inmapper.put("biztype", "biztype");
        inmapper.put("lotnumber", "billentry.lotnumber");
        inmapper.put("auxpty", "billentry.auxpty");
        inmapper.put("project", "billentry.project");
        inmapper.put("project.number", "billentry.project.number");
        inmapper.put("configuredcode", "billentry.configuredcode");
        inmapper.put("tracknumber", "billentry.tracknumber");
        inmapper.put("tracknumber.number", "billentry.tracknumber.number");
        inmapper.put("noupdateinvfields", "billentry.noupdateinvfields");
        inmapper.put("bookdate", "case when billentry.stockindate is Null then bookdate else billentry.stockindate end");
        inmapper.put("billType", "'im_initbill'");
        inmapper.put("outbaseqty", "0");
        inmapper.put("inbaseqty", "billentry.baseqty");
        inmapper.put("outqty", "0");
        inmapper.put("inqty", "billentry.qty");
        inmapper.put("transceiver", "'0'");
        inmapper.put("transnumber", "'locationtransferrec'");
        ArrayList<String> listIn = new ArrayList<String>(inmapper.size());
        for (Map.Entry entry : inmapper.entrySet()) {
            listIn.add(entry.getValue() + " as " + (String)entry.getKey());
        }
        String inbillCommonSelectedFields = InvBillAgeHelper.arraysToString(listIn.toArray(new String[listIn.size()]));
        QFilter inFilter = InvBillAgeHelper.getBillPartQFilter(filterInfo).and(timefilter);
        DataSet indataSet = QueryServiceHelper.queryDataSet((String)"scmc.scmdi.themeanalysis", (String)"im_initbill", (String)inbillCommonSelectedFields, (QFilter[])inFilter.toArray(), (String)"");
        return indataSet;
    }

    public static QFilter getBillPartQFilter(FilterInfo filterInfo) {
        QFilter projectFilter;
        QFilter locationFilter;
        DynamicObject org = filterInfo.getDynamicObject("orghead");
        QFilter filter = new QFilter("org", "=", org.getPkValue());
        filter.and("billstatus", "=", (Object)"C");
        QFilter warehouseFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "billentry.warehouse.number", "warehousefrom", "warehouseto");
        if (warehouseFilter != null) {
            filter.and(warehouseFilter);
        }
        if ((locationFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "billentry.location.number", "locationfrom", "locationto")) != null) {
            filter.and(locationFilter);
        }
        if ((projectFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "billentry.project.number", "projectfrom", "projectto")) != null) {
            filter.and(projectFilter);
        }
        return filter;
    }

    public static DataSet addAdjustBillRecAndSend(FilterInfo filterInfo, QFilter timefilter) {
        LinkedHashMap<String, Object> inmapper = new LinkedHashMap<String, Object>(21);
        inmapper.put("org", "org");
        inmapper.put("invtype", "billentry.afterentity.invtype1");
        inmapper.put("ownertype", "billentry.afterentity.ownertype1");
        inmapper.put("owner", "billentry.afterentity.owner1");
        inmapper.put("material", "billentry.afterentity.material1.masterid");
        inmapper.put("baseunit", "billentry.afterentity.baseunit1");
        inmapper.put("unit", "billentry.afterentity.unit1");
        inmapper.put("warehouse", "billentry.afterentity.warehouse1");
        inmapper.put("location", "billentry.afterentity.location1");
        inmapper.put("invscheme", 0);
        inmapper.put("biztype", "biztype");
        inmapper.put("lotnumber", "billentry.afterentity.lotnumber1");
        inmapper.put("auxpty", "billentry.afterentity.auxpty1");
        inmapper.put("project", "billentry.afterentity.project1");
        inmapper.put("project.number", "billentry.afterentity.project1.number");
        inmapper.put("configuredcode", "billentry.afterentity.configuredcode1");
        inmapper.put("tracknumber", "billentry.afterentity.tracknumber1");
        inmapper.put("tracknumber.number", "billentry.afterentity.tracknumber1.number");
        inmapper.put("noupdateinvfields", "billentry.afterentity.noupdateinvfields1");
        inmapper.put("bookdate", "bookdate");
        inmapper.put("billType", "'im_adjustbill'");
        inmapper.put("outbaseqty", "0");
        inmapper.put("inbaseqty", "billentry.afterentity.baseqty1");
        inmapper.put("outqty", "0");
        inmapper.put("inqty", "billentry.afterentity.qty1");
        inmapper.put("transceiver", "'0'");
        inmapper.put("transnumber", "'adjustbillsendrec'");
        ArrayList<String> listIn = new ArrayList<String>(inmapper.size());
        for (Map.Entry entry : inmapper.entrySet()) {
            listIn.add(entry.getValue() + " as " + (String)entry.getKey());
        }
        String inbillCommonSelectedFields = InvBillAgeHelper.arraysToString(listIn.toArray(new String[listIn.size()]));
        QFilter inFilter = InvBillAgeHelper.getRecAdjustQFilter(filterInfo).and(timefilter);
        DataSet indataSet = QueryServiceHelper.queryDataSet((String)"scmc.scmdi.themeanalysis", (String)"im_adjustbill", (String)inbillCommonSelectedFields, (QFilter[])inFilter.toArray(), (String)"");
        LinkedHashMap<String, Object> outmapper = new LinkedHashMap<String, Object>(21);
        outmapper.put("org", "org");
        outmapper.put("invtype", "billentry.invtype");
        outmapper.put("ownertype", "billentry.ownertype");
        outmapper.put("owner", "billentry.owner");
        outmapper.put("material", "billentry.material.masterid");
        outmapper.put("baseunit", "billentry.baseunit");
        outmapper.put("unit", "billentry.unit");
        outmapper.put("warehouse", "billentry.warehouse");
        outmapper.put("location", "billentry.location");
        outmapper.put("invscheme", 0);
        outmapper.put("biztype", "biztype");
        outmapper.put("lotnumber", "billentry.lotnumber");
        outmapper.put("auxpty", "billentry.auxpty");
        outmapper.put("project", "billentry.project");
        outmapper.put("project.number", "billentry.project.number");
        outmapper.put("configuredcode", "billentry.configuredcode");
        outmapper.put("tracknumber", "billentry.tracknumber");
        outmapper.put("tracknumber.number", "billentry.tracknumber.number");
        outmapper.put("noupdateinvfields", "billentry.noupdateinvfields");
        outmapper.put("bookdate", "bookdate");
        outmapper.put("billType", "'im_adjustbill'");
        outmapper.put("outbaseqty", "billentry.baseqty");
        outmapper.put("inbaseqty", "0");
        outmapper.put("outqty", "billentry.qty");
        outmapper.put("inqty", "0");
        outmapper.put("transceiver", "'1'");
        outmapper.put("transnumber", "'adjustbillsend'");
        ArrayList<String> listOut = new ArrayList<String>(outmapper.size());
        for (Map.Entry entry : outmapper.entrySet()) {
            listOut.add(entry.getValue() + " as " + (String)entry.getKey());
        }
        String outbillCommonSelectedFields = InvBillAgeHelper.arraysToString(listOut.toArray(new String[listOut.size()]));
        QFilter outFilter = InvBillAgeHelper.getBillPartQFilter(filterInfo).and(timefilter);
        DataSet outdataSet = QueryServiceHelper.queryDataSet((String)"scmc.scmdi.themeanalysis", (String)"im_adjustbill", (String)outbillCommonSelectedFields, (QFilter[])outFilter.toArray(), (String)"");
        return indataSet.union(outdataSet);
    }

    public static QFilter getRecAdjustQFilter(FilterInfo filterInfo) {
        QFilter projectFilter;
        QFilter locationFilter;
        DynamicObject org = filterInfo.getDynamicObject("orghead");
        QFilter filter = new QFilter("org", "=", org.getPkValue());
        filter.and("billstatus", "=", (Object)"C");
        QFilter warehouseFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "billentry.afterentity.warehouse1.number", "warehousefrom", "warehouseto");
        if (warehouseFilter != null) {
            filter.and(warehouseFilter);
        }
        if ((locationFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "billentry.afterentity.location1.number", "locationfrom", "locationto")) != null) {
            filter.and(locationFilter);
        }
        if ((projectFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "billentry.afterentity.project1.number", "projectfrom", "projectto")) != null) {
            filter.and(projectFilter);
        }
        return filter;
    }

    public static DataSet addAssembBillRecAndSend(FilterInfo filterInfo, QFilter timefilter) {
        LinkedHashMap<String, Object> inmapper = new LinkedHashMap<String, Object>(21);
        inmapper.put("org", "org");
        inmapper.put("invtype", "billentry.invtype");
        inmapper.put("ownertype", "billentry.ownertype");
        inmapper.put("owner", "billentry.owner");
        inmapper.put("material", "billentry.material.masterid");
        inmapper.put("baseunit", "billentry.baseunit");
        inmapper.put("unit", "billentry.unit");
        inmapper.put("warehouse", "billentry.warehouse");
        inmapper.put("location", "billentry.location");
        inmapper.put("invscheme", 0);
        inmapper.put("biztype", "biztype");
        inmapper.put("lotnumber", "billentry.lotnumber");
        inmapper.put("auxpty", "billentry.auxpty");
        inmapper.put("project", "billentry.project");
        inmapper.put("project.number", "billentry.project.number");
        inmapper.put("configuredcode", "billentry.configuredcode");
        inmapper.put("tracknumber", "billentry.tracknumber");
        inmapper.put("tracknumber.number", "billentry.tracknumber.number");
        inmapper.put("noupdateinvfields", "billentry.noupdateinvfields");
        inmapper.put("bookdate", "bookdate");
        inmapper.put("billType", "'im_assembbill'");
        inmapper.put("outbaseqty", "0");
        inmapper.put("inbaseqty", "billentry.baseqty");
        inmapper.put("outqty", "0");
        inmapper.put("inqty", "billentry.qty");
        inmapper.put("transceiver", "'0'");
        inmapper.put("transnumber", "'assembbillrec'");
        ArrayList<String> listIn = new ArrayList<String>(inmapper.size());
        for (Map.Entry entry : inmapper.entrySet()) {
            listIn.add(entry.getValue() + " as " + (String)entry.getKey());
        }
        String inbillCommonSelectedFields = InvBillAgeHelper.arraysToString(listIn.toArray(new String[listIn.size()]));
        QFilter inFilter = InvBillAgeHelper.getBillPartQFilter(filterInfo).and(timefilter);
        DataSet indataSet = QueryServiceHelper.queryDataSet((String)"scmc.scmdi.themeanalysis", (String)"im_assembbill", (String)inbillCommonSelectedFields, (QFilter[])inFilter.toArray(), (String)"");
        LinkedHashMap<String, Object> outmapper = new LinkedHashMap<String, Object>(21);
        outmapper.put("org", "org");
        outmapper.put("invtype", "billentry.afterentity.invtype1");
        outmapper.put("ownertype", "billentry.afterentity.ownertype1");
        outmapper.put("owner", "billentry.afterentity.owner1");
        outmapper.put("material", "billentry.afterentity.material1.masterid");
        outmapper.put("baseunit", "billentry.afterentity.baseunit1");
        outmapper.put("unit", "billentry.afterentity.unit1");
        outmapper.put("warehouse", "billentry.afterentity.warehouse1");
        outmapper.put("location", "billentry.afterentity.location1");
        outmapper.put("invscheme", 0);
        outmapper.put("biztype", "biztype");
        outmapper.put("lotnumber", "billentry.afterentity.lotnumber1");
        outmapper.put("auxpty", "billentry.afterentity.auxpty1");
        outmapper.put("project", "billentry.afterentity.project1");
        outmapper.put("project.number", "billentry.afterentity.project1.number");
        outmapper.put("configuredcode", "billentry.afterentity.configuredcode1");
        outmapper.put("tracknumber", "billentry.afterentity.tracknumber1");
        outmapper.put("tracknumber.number", "billentry.afterentity.tracknumber1.number");
        outmapper.put("noupdateinvfields", "billentry.afterentity.noupdateinvfields1");
        outmapper.put("bookdate", "bookdate");
        outmapper.put("billType", "'im_assembbill'");
        outmapper.put("outbaseqty", "billentry.afterentity.baseqty1");
        outmapper.put("inbaseqty", "0");
        outmapper.put("outqty", "billentry.afterentity.qty1");
        outmapper.put("inqty", "0");
        outmapper.put("transceiver", "'1'");
        outmapper.put("transnumber", "'assembbillsend'");
        ArrayList<String> listOut = new ArrayList<String>(outmapper.size());
        for (Map.Entry entry : outmapper.entrySet()) {
            listOut.add(entry.getValue() + " as " + (String)entry.getKey());
        }
        String outbillCommonSelectedFields = InvBillAgeHelper.arraysToString(listOut.toArray(new String[listOut.size()]));
        QFilter outFilter = InvBillAgeHelper.getRecAssembQFilter(filterInfo).and(timefilter);
        DataSet outdataSet = QueryServiceHelper.queryDataSet((String)"scmc.scmdi.themeanalysis", (String)"im_assembbill", (String)outbillCommonSelectedFields, (QFilter[])outFilter.toArray(), (String)"");
        return indataSet.union(outdataSet);
    }

    public static QFilter getRecAssembQFilter(FilterInfo filterInfo) {
        QFilter projectFilter;
        QFilter locationFilter;
        DynamicObject org = filterInfo.getDynamicObject("orghead");
        QFilter filter = new QFilter("org", "=", org.getPkValue());
        filter.and("billstatus", "=", (Object)"C");
        QFilter warehouseFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "billentry.afterentity.warehouse1.number", "warehousefrom", "warehouseto");
        if (warehouseFilter != null) {
            filter.and(warehouseFilter);
        }
        if ((locationFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "billentry.afterentity.location1.number", "locationfrom", "locationto")) != null) {
            filter.and(locationFilter);
        }
        if ((projectFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "billentry.afterentity.project1.number", "projectfrom", "projectto")) != null) {
            filter.and(projectFilter);
        }
        return filter;
    }

    public static DataSet addDisassBillRecAndSend(FilterInfo filterInfo, QFilter timefilter) {
        LinkedHashMap<String, Object> inmapper = new LinkedHashMap<String, Object>(21);
        inmapper.put("org", "org");
        inmapper.put("invtype", "billentry.afterentity.invtype1");
        inmapper.put("ownertype", "billentry.afterentity.ownertype1");
        inmapper.put("owner", "billentry.afterentity.owner1");
        inmapper.put("material", "billentry.afterentity.material1.masterid");
        inmapper.put("baseunit", "billentry.afterentity.baseunit1");
        inmapper.put("unit", "billentry.afterentity.unit1");
        inmapper.put("warehouse", "billentry.afterentity.warehouse1");
        inmapper.put("location", "billentry.afterentity.location1");
        inmapper.put("invscheme", 0);
        inmapper.put("biztype", "biztype");
        inmapper.put("lotnumber", "billentry.afterentity.lotnumber1");
        inmapper.put("auxpty", "billentry.afterentity.auxpty1");
        inmapper.put("project", "billentry.afterentity.project1");
        inmapper.put("project.number", "billentry.afterentity.project1.number");
        inmapper.put("configuredcode", "billentry.afterentity.configuredcode1");
        inmapper.put("tracknumber", "billentry.afterentity.tracknumber1");
        inmapper.put("tracknumber.number", "billentry.afterentity.tracknumber1.number");
        inmapper.put("noupdateinvfields", "billentry.afterentity.noupdateinvfields1");
        inmapper.put("bookdate", "bookdate");
        inmapper.put("billType", "'im_disassemblebill'");
        inmapper.put("outbaseqty", "0");
        inmapper.put("inbaseqty", "billentry.afterentity.baseqty1");
        inmapper.put("outqty", "0");
        inmapper.put("inqty", "billentry.afterentity.qty1");
        inmapper.put("transceiver", "'0'");
        inmapper.put("transnumber", "'disassemblebillrec'");
        ArrayList<String> listIn = new ArrayList<String>(inmapper.size());
        for (Map.Entry entry : inmapper.entrySet()) {
            listIn.add(entry.getValue() + " as " + (String)entry.getKey());
        }
        String inbillCommonSelectedFields = InvBillAgeHelper.arraysToString(listIn.toArray(new String[listIn.size()]));
        QFilter inFilter = InvBillAgeHelper.getRecDisassQFilter(filterInfo).and(timefilter);
        DataSet indataSet = QueryServiceHelper.queryDataSet((String)"scmc.scmdi.themeanalysis", (String)"im_disassemblebill", (String)inbillCommonSelectedFields, (QFilter[])inFilter.toArray(), (String)"");
        LinkedHashMap<String, Object> outmapper = new LinkedHashMap<String, Object>(21);
        outmapper.put("org", "org");
        outmapper.put("invtype", "billentry.invtype");
        outmapper.put("ownertype", "billentry.ownertype");
        outmapper.put("owner", "billentry.owner");
        outmapper.put("material", "billentry.material.masterid");
        outmapper.put("baseunit", "billentry.baseunit");
        outmapper.put("unit", "billentry.unit");
        outmapper.put("warehouse", "billentry.warehouse");
        outmapper.put("location", "billentry.location");
        outmapper.put("invscheme", 0);
        outmapper.put("biztype", "biztype");
        outmapper.put("lotnumber", "billentry.lotnumber");
        outmapper.put("auxpty", "billentry.auxpty");
        outmapper.put("project", "billentry.project");
        outmapper.put("project.number", "billentry.project.number");
        outmapper.put("configuredcode", "billentry.configuredcode");
        outmapper.put("tracknumber", "billentry.tracknumber");
        outmapper.put("tracknumber.number", "billentry.tracknumber.number");
        outmapper.put("noupdateinvfields", "billentry.noupdateinvfields");
        outmapper.put("bookdate", "bookdate");
        outmapper.put("billType", "'im_disassemblebill'");
        outmapper.put("outbaseqty", "billentry.baseqty");
        outmapper.put("inbaseqty", "0");
        outmapper.put("outqty", "billentry.qty");
        outmapper.put("inqty", "0");
        outmapper.put("transceiver", "'1'");
        outmapper.put("transnumber", "'disassemblebillsend'");
        ArrayList<String> listOut = new ArrayList<String>(outmapper.size());
        for (Map.Entry entry : outmapper.entrySet()) {
            listOut.add(entry.getValue() + " as " + (String)entry.getKey());
        }
        String outbillCommonSelectedFields = InvBillAgeHelper.arraysToString(listOut.toArray(new String[listOut.size()]));
        QFilter outFilter = InvBillAgeHelper.getBillPartQFilter(filterInfo).and(timefilter);
        DataSet outdataSet = QueryServiceHelper.queryDataSet((String)"scmc.scmdi.themeanalysis", (String)"im_disassemblebill", (String)outbillCommonSelectedFields, (QFilter[])outFilter.toArray(), (String)"");
        return indataSet.union(outdataSet);
    }

    public static QFilter getRecDisassQFilter(FilterInfo filterInfo) {
        QFilter projectFilter;
        QFilter locationFilter;
        DynamicObject org = filterInfo.getDynamicObject("orghead");
        QFilter filter = new QFilter("org", "=", org.getPkValue());
        filter.and("billstatus", "=", (Object)"C");
        QFilter warehouseFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "billentry.afterentity.warehouse1.number", "warehousefrom", "warehouseto");
        if (warehouseFilter != null) {
            filter.and(warehouseFilter);
        }
        if ((locationFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "billentry.afterentity.location1.number", "locationfrom", "locationto")) != null) {
            filter.and(locationFilter);
        }
        if ((projectFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "billentry.afterentity.project1.number", "projectfrom", "projectto")) != null) {
            filter.and(projectFilter);
        }
        return filter;
    }

    public static DataSet addLocationtransferRecAndSend(FilterInfo filterInfo, QFilter timefilter) {
        LinkedHashMap<String, Object> inmapper = new LinkedHashMap<String, Object>(21);
        inmapper.put("org", "org");
        inmapper.put("invtype", "billentry.invtype");
        inmapper.put("ownertype", "billentry.ownertype");
        inmapper.put("owner", "billentry.owner");
        inmapper.put("material", "billentry.material.masterid");
        inmapper.put("baseunit", "billentry.baseunit");
        inmapper.put("unit", "billentry.unit");
        inmapper.put("warehouse", "billentry.warehouse");
        inmapper.put("location", "billentry.location");
        inmapper.put("invscheme", 0);
        inmapper.put("biztype", "biztype");
        inmapper.put("lotnumber", "billentry.lotnumber");
        inmapper.put("auxpty", "billentry.auxpty");
        inmapper.put("project", "billentry.project");
        inmapper.put("project.number", "billentry.project.number");
        inmapper.put("configuredcode", "billentry.configuredcode");
        inmapper.put("tracknumber", "billentry.tracknumber");
        inmapper.put("tracknumber.number", "billentry.tracknumber.number");
        inmapper.put("noupdateinvfields", "billentry.noupdateinvfields");
        inmapper.put("bookdate", "bookdate");
        inmapper.put("billType", "'im_locationtransfer'");
        inmapper.put("outbaseqty", "0");
        inmapper.put("inbaseqty", "billentry.baseqty");
        inmapper.put("outqty", "0");
        inmapper.put("inqty", "billentry.qty");
        inmapper.put("transceiver", "'0'");
        inmapper.put("transnumber", "'locationtransferrec'");
        ArrayList<String> listIn = new ArrayList<String>(inmapper.size());
        for (Map.Entry entry : inmapper.entrySet()) {
            listIn.add(entry.getValue() + " as " + (String)entry.getKey());
        }
        String inbillCommonSelectedFields = InvBillAgeHelper.arraysToString(listIn.toArray(new String[listIn.size()]));
        QFilter inFilter = InvBillAgeHelper.getBillPartQFilter(filterInfo).and(timefilter);
        DataSet indataSet = QueryServiceHelper.queryDataSet((String)"scmc.scmdi.themeanalysis", (String)"im_locationtransfer", (String)inbillCommonSelectedFields, (QFilter[])inFilter.toArray(), (String)"");
        LinkedHashMap<String, Object> outmapper = new LinkedHashMap<String, Object>(21);
        outmapper.put("org", "org");
        outmapper.put("invtype", "billentry.invtype");
        outmapper.put("ownertype", "billentry.ownertype");
        outmapper.put("owner", "billentry.owner");
        outmapper.put("material", "billentry.material.masterid");
        outmapper.put("baseunit", "billentry.baseunit");
        outmapper.put("unit", "billentry.unit");
        outmapper.put("warehouse", "billentry.warehouse");
        outmapper.put("location", "billentry.outlocation");
        outmapper.put("invscheme", 0);
        outmapper.put("biztype", "biztype");
        outmapper.put("lotnumber", "billentry.lotnumber");
        outmapper.put("auxpty", "billentry.auxpty");
        outmapper.put("project", "billentry.project");
        outmapper.put("project.number", "billentry.project.number");
        outmapper.put("configuredcode", "billentry.configuredcode");
        outmapper.put("tracknumber", "billentry.tracknumber");
        outmapper.put("tracknumber.number", "billentry.tracknumber.number");
        outmapper.put("noupdateinvfields", "billentry.noupdateinvfields");
        outmapper.put("bookdate", "bookdate");
        outmapper.put("billType", "'im_locationtransfer'");
        outmapper.put("outbaseqty", "billentry.baseqty");
        outmapper.put("inbaseqty", "0");
        outmapper.put("outqty", "billentry.qty");
        outmapper.put("inqty", "0");
        outmapper.put("transceiver", "'1'");
        outmapper.put("transnumber", "'locationtransferrec'");
        ArrayList<String> listOut = new ArrayList<String>(outmapper.size());
        for (Map.Entry entry : outmapper.entrySet()) {
            listOut.add(entry.getValue() + " as " + (String)entry.getKey());
        }
        String outbillCommonSelectedFields = InvBillAgeHelper.arraysToString(listOut.toArray(new String[listOut.size()]));
        QFilter outFilter = InvBillAgeHelper.getSendLocationtransferQFilter(filterInfo).and(timefilter);
        DataSet outdataSet = QueryServiceHelper.queryDataSet((String)"scmc.scmdi.themeanalysis", (String)"im_locationtransfer", (String)outbillCommonSelectedFields, (QFilter[])outFilter.toArray(), (String)"");
        return indataSet.union(outdataSet);
    }

    public static QFilter getSendLocationtransferQFilter(FilterInfo filterInfo) {
        QFilter projectFilter;
        QFilter locationFilter;
        DynamicObject org = filterInfo.getDynamicObject("orghead");
        QFilter filter = new QFilter("org", "=", org.getPkValue());
        filter.and("billstatus", "=", (Object)"C");
        QFilter warehouseFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "billentry.warehouse.number", "warehousefrom", "warehouseto");
        if (warehouseFilter != null) {
            filter.and(warehouseFilter);
        }
        if ((locationFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "billentry.outlocation.number", "locationfrom", "locationto")) != null) {
            filter.and(locationFilter);
        }
        if ((projectFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "billentry.project.number", "projectfrom", "projectto")) != null) {
            filter.and(projectFilter);
        }
        return filter;
    }

    public static DataSet addTransdirBillRecAndSend(FilterInfo filterInfo, QFilter timefilter) {
        LinkedHashMap<String, String> inmapper = new LinkedHashMap<String, String>(21);
        inmapper.put("org", "org");
        inmapper.put("invtype", "billentry.invtype");
        inmapper.put("ownertype", "billentry.ownertype");
        inmapper.put("owner", "billentry.owner");
        inmapper.put("material", "billentry.material.masterid");
        inmapper.put("baseunit", "billentry.baseunit");
        inmapper.put("unit", "billentry.unit");
        inmapper.put("warehouse", "billentry.warehouse");
        inmapper.put("location", "billentry.location");
        inmapper.put("invscheme", "invscheme");
        inmapper.put("biztype", "biztype");
        inmapper.put("lotnumber", "billentry.inlotnumber");
        inmapper.put("auxpty", "billentry.auxpty");
        inmapper.put("project", "billentry.inproject");
        inmapper.put("project.number", "billentry.inproject.number");
        inmapper.put("configuredcode", "billentry.configuredcode");
        inmapper.put("tracknumber", "billentry.tracknumber");
        inmapper.put("tracknumber.number", "billentry.tracknumber.number");
        inmapper.put("noupdateinvfields", "billentry.noupdateinvfields");
        inmapper.put("bookdate", "bookdate");
        inmapper.put("billType", "'im_transdirbill'");
        inmapper.put("outbaseqty", "0");
        inmapper.put("inbaseqty", "billentry.baseqty");
        inmapper.put("outqty", "0");
        inmapper.put("inqty", "billentry.qty");
        inmapper.put("transceiver", "'0'");
        inmapper.put("transnumber", "'assembbillrec'");
        ArrayList<String> listIn = new ArrayList<String>(inmapper.size());
        for (Map.Entry entry : inmapper.entrySet()) {
            listIn.add(entry.getValue() + " as " + (String)entry.getKey());
        }
        String inbillCommonSelectedFields = InvBillAgeHelper.arraysToString(listIn.toArray(new String[listIn.size()]));
        QFilter inFilter = InvBillAgeHelper.getTransdirBillInQFilter(filterInfo).and(timefilter);
        DataSet indataSet = QueryServiceHelper.queryDataSet((String)"scmc.scmdi.themeanalysis", (String)"im_transdirbill", (String)inbillCommonSelectedFields, (QFilter[])inFilter.toArray(), (String)"");
        LinkedHashMap<String, String> outmapper = new LinkedHashMap<String, String>(21);
        outmapper.put("org", "outorg");
        outmapper.put("invtype", "billentry.outinvtype");
        outmapper.put("ownertype", "billentry.outownertype");
        outmapper.put("owner", "billentry.outowner");
        outmapper.put("material", "billentry.material.masterid");
        outmapper.put("baseunit", "billentry.baseunit");
        outmapper.put("unit", "billentry.unit");
        outmapper.put("warehouse", "billentry.outwarehouse");
        outmapper.put("location", "billentry.outlocation");
        outmapper.put("invscheme", "invscheme");
        outmapper.put("biztype", "biztype");
        outmapper.put("lotnumber", "billentry.lotnumber");
        outmapper.put("auxpty", "billentry.auxpty");
        outmapper.put("project", "billentry.project");
        outmapper.put("project.number", "billentry.project.number");
        outmapper.put("configuredcode", "billentry.configuredcode");
        outmapper.put("tracknumber", "billentry.tracknumber");
        outmapper.put("tracknumber.number", "billentry.tracknumber.number");
        outmapper.put("noupdateinvfields", "billentry.noupdateinvfields");
        outmapper.put("bookdate", "bookdate");
        outmapper.put("billType", "'im_transdirbill'");
        outmapper.put("outbaseqty", "billentry.baseqty");
        outmapper.put("inbaseqty", "0");
        outmapper.put("outqty", "billentry.qty");
        outmapper.put("inqty", "0");
        outmapper.put("transceiver", "'1'");
        outmapper.put("transnumber", "'assembbillsend'");
        ArrayList<String> listOut = new ArrayList<String>(outmapper.size());
        for (Map.Entry entry : outmapper.entrySet()) {
            listOut.add(entry.getValue() + " as " + (String)entry.getKey());
        }
        String outbillCommonSelectedFields = InvBillAgeHelper.arraysToString(listOut.toArray(new String[listOut.size()]));
        QFilter outFilter = InvBillAgeHelper.getTransdirBillOutQFilter(filterInfo).and(timefilter);
        DataSet outdataSet = QueryServiceHelper.queryDataSet((String)"scmc.scmdi.themeanalysis", (String)"im_transdirbill", (String)outbillCommonSelectedFields, (QFilter[])outFilter.toArray(), (String)"");
        return indataSet.union(outdataSet);
    }

    public static QFilter getTransdirBillInQFilter(FilterInfo filterInfo) {
        QFilter projectFilter;
        QFilter locationFilter;
        DynamicObject org = filterInfo.getDynamicObject("orghead");
        QFilter filter = new QFilter("org", "=", org.getPkValue());
        filter.and("billstatus", "=", (Object)"C");
        QFilter warehouseFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "billentry.warehouse.number", "warehousefrom", "warehouseto");
        if (warehouseFilter != null) {
            filter.and(warehouseFilter);
        }
        if ((locationFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "billentry.location.number", "locationfrom", "locationto")) != null) {
            filter.and(locationFilter);
        }
        if ((projectFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "billentry.inproject.number", "projectfrom", "projectto")) != null) {
            filter.and(projectFilter);
        }
        return filter;
    }

    public static QFilter getTransdirBillOutQFilter(FilterInfo filterInfo) {
        QFilter projectFilter;
        QFilter locationFilter;
        DynamicObject org = filterInfo.getDynamicObject("orghead");
        QFilter filter = new QFilter("outorg", "=", org.getPkValue());
        filter.and("billstatus", "=", (Object)"C");
        QFilter warehouseFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "billentry.outwarehouse.number", "warehousefrom", "warehouseto");
        if (warehouseFilter != null) {
            filter.and(warehouseFilter);
        }
        if ((locationFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "billentry.outlocation.number", "locationfrom", "locationto")) != null) {
            filter.and(locationFilter);
        }
        if ((projectFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "billentry.project.number", "projectfrom", "projectto")) != null) {
            filter.and(projectFilter);
        }
        return filter;
    }

    public static DataSet addInitBillRec(FilterInfo filterInfo) {
        LinkedHashMap<String, Object> inmapper = new LinkedHashMap<String, Object>(17);
        inmapper.put("org", "org");
        inmapper.put("invtype", "billentry.invtype");
        inmapper.put("ownertype", "billentry.ownertype");
        inmapper.put("owner", "billentry.owner");
        inmapper.put("material", "billentry.material.masterid");
        inmapper.put("baseunit", "billentry.baseunit");
        inmapper.put("baseqty", "billentry.baseqty");
        inmapper.put("unit", "billentry.unit");
        inmapper.put("qty", "billentry.qty");
        inmapper.put("warehouse", "billentry.warehouse");
        inmapper.put("location", "billentry.location");
        inmapper.put("invscheme", 0);
        inmapper.put("biztype", 0);
        inmapper.put("lotnumber", "billentry.lotnumber");
        inmapper.put("auxpty", "billentry.auxpty");
        inmapper.put("project", "billentry.project");
        inmapper.put("project.number", "billentry.project.number");
        inmapper.put("configuredcode", "billentry.configuredcode");
        inmapper.put("tracknumber", "billentry.tracknumber");
        inmapper.put("tracknumber.number", "billentry.tracknumber.number");
        inmapper.put("noupdateinvfields", "billentry.noupdateinvfields");
        inmapper.put("bookdate", "case when billentry.stockindate is Null then bookdate else billentry.stockindate end");
        inmapper.put("billType", "'im_initbill'");
        ArrayList<String> listIn = new ArrayList<String>(inmapper.size());
        for (Map.Entry entry : inmapper.entrySet()) {
            listIn.add(entry.getValue() + " as " + (String)entry.getKey());
        }
        String inbillCommonSelectedFields = InvBillAgeHelper.arraysToString(listIn.toArray(new String[listIn.size()]));
        QFilter inFilter = InvBillAgeHelper.getBillPartQFilter(filterInfo);
        DataSet indataSet = QueryServiceHelper.queryDataSet((String)"scmc.scmdi.themeanalysis", (String)"im_initbill", (String)inbillCommonSelectedFields, (QFilter[])inFilter.toArray(), (String)"");
        return indataSet;
    }

    public static DataSet addLocationtransferRec(FilterInfo filterInfo) {
        LinkedHashMap<String, Object> inmapper = new LinkedHashMap<String, Object>(17);
        inmapper.put("org", "org");
        inmapper.put("invtype", "billentry.invtype");
        inmapper.put("ownertype", "billentry.ownertype");
        inmapper.put("owner", "billentry.owner");
        inmapper.put("material", "billentry.material.masterid");
        inmapper.put("baseunit", "billentry.baseunit");
        inmapper.put("baseqty", "billentry.baseqty");
        inmapper.put("unit", "billentry.unit");
        inmapper.put("qty", "billentry.qty");
        inmapper.put("warehouse", "billentry.warehouse");
        inmapper.put("location", "billentry.location");
        inmapper.put("invscheme", 0);
        inmapper.put("biztype", "biztype");
        inmapper.put("lotnumber", "billentry.lotnumber");
        inmapper.put("auxpty", "billentry.auxpty");
        inmapper.put("project", "billentry.project");
        inmapper.put("project.number", "billentry.project.number");
        inmapper.put("configuredcode", "billentry.configuredcode");
        inmapper.put("tracknumber", "billentry.tracknumber");
        inmapper.put("tracknumber.number", "billentry.tracknumber.number");
        inmapper.put("noupdateinvfields", "billentry.noupdateinvfields");
        inmapper.put("bookdate", "bookdate");
        inmapper.put("billType", "'im_locationtransfer'");
        ArrayList<String> listIn = new ArrayList<String>(inmapper.size());
        for (Map.Entry entry : inmapper.entrySet()) {
            listIn.add(entry.getValue() + " as " + (String)entry.getKey());
        }
        String inbillCommonSelectedFields = InvBillAgeHelper.arraysToString(listIn.toArray(new String[listIn.size()]));
        QFilter inFilter = InvBillAgeHelper.getBillPartQFilter(filterInfo);
        DataSet indataSet = QueryServiceHelper.queryDataSet((String)"scmc.scmdi.themeanalysis", (String)"im_locationtransfer", (String)inbillCommonSelectedFields, (QFilter[])inFilter.toArray(), (String)"");
        return indataSet;
    }

    public static DataSet addAdjustBillRec(FilterInfo filterInfo) {
        LinkedHashMap<String, Object> inmapper = new LinkedHashMap<String, Object>(17);
        inmapper.put("org", "org");
        inmapper.put("invtype", "billentry.afterentity.invtype1");
        inmapper.put("ownertype", "billentry.afterentity.ownertype1");
        inmapper.put("owner", "billentry.afterentity.owner1");
        inmapper.put("material", "billentry.afterentity.material1.masterid");
        inmapper.put("baseunit", "billentry.afterentity.baseunit1");
        inmapper.put("baseqty", "billentry.afterentity.baseqty1");
        inmapper.put("unit", "billentry.afterentity.unit1");
        inmapper.put("qty", "billentry.afterentity.qty1");
        inmapper.put("warehouse", "billentry.afterentity.warehouse1");
        inmapper.put("location", "billentry.afterentity.location1");
        inmapper.put("invscheme", 0);
        inmapper.put("biztype", "biztype");
        inmapper.put("lotnumber", "billentry.afterentity.lotnumber1");
        inmapper.put("auxpty", "billentry.afterentity.auxpty1");
        inmapper.put("project", "billentry.afterentity.project1");
        inmapper.put("project.number", "billentry.afterentity.project1.number");
        inmapper.put("configuredcode", "billentry.afterentity.configuredcode1");
        inmapper.put("tracknumber", "billentry.afterentity.tracknumber1");
        inmapper.put("tracknumber.number", "billentry.afterentity.tracknumber1.number");
        inmapper.put("noupdateinvfields", "billentry.afterentity.noupdateinvfields1");
        inmapper.put("bookdate", "bookdate");
        inmapper.put("billType", "'im_assembbill'");
        ArrayList<String> listIn = new ArrayList<String>(inmapper.size());
        for (Map.Entry entry : inmapper.entrySet()) {
            listIn.add(entry.getValue() + " as " + (String)entry.getKey());
        }
        String inbillCommonSelectedFields = InvBillAgeHelper.arraysToString(listIn.toArray(new String[listIn.size()]));
        QFilter inFilter = InvBillAgeHelper.getRecAdjustQFilter(filterInfo);
        DataSet indataSet = QueryServiceHelper.queryDataSet((String)"scmc.scmdi.themeanalysis", (String)"im_adjustbill", (String)inbillCommonSelectedFields, (QFilter[])inFilter.toArray(), (String)"");
        return indataSet;
    }

    public static DataSet addAssembBillRec(FilterInfo filterInfo) {
        LinkedHashMap<String, Object> inmapper = new LinkedHashMap<String, Object>(17);
        inmapper.put("org", "org");
        inmapper.put("invtype", "billentry.invtype");
        inmapper.put("ownertype", "billentry.ownertype");
        inmapper.put("owner", "billentry.owner");
        inmapper.put("material", "billentry.material.masterid");
        inmapper.put("baseunit", "billentry.baseunit");
        inmapper.put("baseqty", "billentry.baseqty");
        inmapper.put("unit", "billentry.unit");
        inmapper.put("qty", "billentry.qty");
        inmapper.put("warehouse", "billentry.warehouse");
        inmapper.put("location", "billentry.location");
        inmapper.put("invscheme", 0);
        inmapper.put("biztype", "biztype");
        inmapper.put("lotnumber", "billentry.lotnumber");
        inmapper.put("auxpty", "billentry.auxpty");
        inmapper.put("project", "billentry.project");
        inmapper.put("project.number", "billentry.project.number");
        inmapper.put("configuredcode", "billentry.configuredcode");
        inmapper.put("tracknumber", "billentry.tracknumber");
        inmapper.put("tracknumber.number", "billentry.tracknumber.number");
        inmapper.put("noupdateinvfields", "billentry.noupdateinvfields");
        inmapper.put("bookdate", "bookdate");
        inmapper.put("billType", "'im_assembbill'");
        ArrayList<String> list = new ArrayList<String>(inmapper.size());
        for (Map.Entry entry : inmapper.entrySet()) {
            list.add(entry.getValue() + " as " + (String)entry.getKey());
        }
        String inbillCommonSelectedFields = InvBillAgeHelper.arraysToString(list.toArray(new String[list.size()]));
        QFilter inFilter = InvBillAgeHelper.getBillPartQFilter(filterInfo);
        DataSet indataSet = QueryServiceHelper.queryDataSet((String)"scmc.scmdi.themeanalysis", (String)"im_assembbill", (String)inbillCommonSelectedFields, (QFilter[])inFilter.toArray(), (String)"");
        return indataSet;
    }

    public static DataSet addDisassBillRec(FilterInfo filterInfo) {
        LinkedHashMap<String, Object> inmapper = new LinkedHashMap<String, Object>(17);
        inmapper.put("org", "org");
        inmapper.put("invtype", "billentry.afterentity.invtype1");
        inmapper.put("ownertype", "billentry.afterentity.ownertype1");
        inmapper.put("owner", "billentry.afterentity.owner1");
        inmapper.put("material", "billentry.afterentity.material1.masterid");
        inmapper.put("baseunit", "billentry.afterentity.baseunit1");
        inmapper.put("baseqty", "billentry.afterentity.baseqty1");
        inmapper.put("unit", "billentry.afterentity.unit1");
        inmapper.put("qty", "billentry.afterentity.qty1");
        inmapper.put("warehouse", "billentry.afterentity.warehouse1");
        inmapper.put("location", "billentry.afterentity.location1");
        inmapper.put("invscheme", 0);
        inmapper.put("biztype", "biztype");
        inmapper.put("lotnumber", "billentry.afterentity.lotnumber1");
        inmapper.put("auxpty", "billentry.afterentity.auxpty1");
        inmapper.put("project", "billentry.afterentity.project1");
        inmapper.put("project.number", "billentry.afterentity.project1.number");
        inmapper.put("configuredcode", "billentry.afterentity.configuredcode1");
        inmapper.put("tracknumber", "billentry.afterentity.tracknumber1");
        inmapper.put("tracknumber.number", "billentry.afterentity.tracknumber1.number");
        inmapper.put("noupdateinvfields", "billentry.afterentity.noupdateinvfields1");
        inmapper.put("bookdate", "bookdate");
        inmapper.put("billType", "'im_disassemblebill'");
        ArrayList<String> list = new ArrayList<String>(inmapper.size());
        for (Map.Entry entry : inmapper.entrySet()) {
            list.add(entry.getValue() + " as " + (String)entry.getKey());
        }
        String inbillCommonSelectedFields = InvBillAgeHelper.arraysToString(list.toArray(new String[list.size()]));
        QFilter inFilter = InvBillAgeHelper.getRecDisassQFilter(filterInfo);
        DataSet indataSet = QueryServiceHelper.queryDataSet((String)"scmc.scmdi.themeanalysis", (String)"im_disassemblebill", (String)inbillCommonSelectedFields, (QFilter[])inFilter.toArray(), (String)"");
        return indataSet;
    }

    public static DataSet addTransdirBillRec(FilterInfo filterInfo) {
        LinkedHashMap<String, String> inmapper = new LinkedHashMap<String, String>(17);
        inmapper.put("org", "org");
        inmapper.put("invtype", "billentry.invtype");
        inmapper.put("ownertype", "billentry.ownertype");
        inmapper.put("owner", "billentry.owner");
        inmapper.put("material", "billentry.material.masterid");
        inmapper.put("baseunit", "billentry.baseunit");
        inmapper.put("baseqty", "billentry.baseqty");
        inmapper.put("unit", "billentry.unit");
        inmapper.put("qty", "billentry.qty");
        inmapper.put("warehouse", "billentry.warehouse");
        inmapper.put("location", "billentry.location");
        inmapper.put("invscheme", "invscheme");
        inmapper.put("biztype", "biztype");
        inmapper.put("lotnumber", "billentry.inlotnumber");
        inmapper.put("auxpty", "billentry.auxpty");
        inmapper.put("project", "billentry.inproject");
        inmapper.put("project.number", "billentry.inproject.number");
        inmapper.put("configuredcode", "billentry.configuredcode");
        inmapper.put("tracknumber", "billentry.tracknumber");
        inmapper.put("tracknumber.number", "billentry.tracknumber.number");
        inmapper.put("noupdateinvfields", "billentry.noupdateinvfields");
        inmapper.put("bookdate", "bookdate");
        inmapper.put("billType", "'im_transdirbill'");
        ArrayList<String> listIn = new ArrayList<String>(inmapper.size());
        for (Map.Entry entry : inmapper.entrySet()) {
            listIn.add(entry.getValue() + " as " + (String)entry.getKey());
        }
        String inbillCommonSelectedFields = InvBillAgeHelper.arraysToString(listIn.toArray(new String[listIn.size()]));
        QFilter inFilter = InvBillAgeHelper.getTransdirBillInQFilter(filterInfo);
        DataSet indataSet = QueryServiceHelper.queryDataSet((String)"scmc.scmdi.themeanalysis", (String)"im_transdirbill", (String)inbillCommonSelectedFields, (QFilter[])inFilter.toArray(), (String)"");
        return indataSet;
    }
}

