/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.business.helper;

import java.util.Collections;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.scmdi.common.enums.EnableStatusEnum;

public class OrgHelper {
    public static DynamicObject getCostAccountByCalOrg(Long calOrgId) {
        QFilter filter = new QFilter("calorg", "=", (Object)calOrgId).and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,name,calorg,calsystem,calpolicy,calpolicy.currency,dividebasis,ismainaccount,enable", (QFilter[])filter.toArray());
        if (costAccounts == null || costAccounts.isEmpty()) {
            return null;
        }
        DynamicObject mainCostAccount = (DynamicObject)costAccounts.get(0);
        for (DynamicObject costAccount : costAccounts) {
            if (!costAccount.getBoolean("ismainaccount")) continue;
            mainCostAccount = costAccount;
            break;
        }
        return mainCostAccount;
    }

    public static Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        Map map;
        Map mapOrg;
        if (orgId != null && (mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)) != null && mapOrg.get("id") != null && (map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")))) != null && map.size() != 0) {
            return map;
        }
        return Collections.emptyMap();
    }

    public static DynamicObject getCurrency(Long orgId) {
        Map<String, Long> map;
        Long currencyId;
        if (orgId != 0L && (currencyId = (map = OrgHelper.getCurrencyAndExRateTable(orgId)).get("baseCurrencyID")) != null && currencyId != 0L) {
            return BusinessDataServiceHelper.loadSingle((Object)currencyId, (String)"bd_currency");
        }
        return null;
    }
}

