/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.business.helper;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PeriodHelper {
    public static boolean isStartBigThanEndPeriod(DynamicObject startPeriod, DynamicObject endPeriod) {
        Date endPeriodDate;
        Date startPeriodDate = startPeriod.getDate("begindate");
        int i = startPeriodDate.compareTo(endPeriodDate = endPeriod.getDate("begindate"));
        return i <= 0;
    }

    public static boolean isBeforeAYearAgo(DynamicObject startPeriod, DynamicObject endPeriod) {
        Date startPeriodDate = startPeriod.getDate("begindate");
        Date endPeriodDate = endPeriod.getDate("begindate");
        LocalDateTime endPeriodDateTime = LocalDateTime.ofInstant(endPeriodDate.toInstant(), ZoneId.systemDefault());
        LocalDateTime startPeriodDateTime = LocalDateTime.ofInstant(startPeriodDate.toInstant(), ZoneId.systemDefault());
        LocalDateTime aYearAgoBeforeEnd = endPeriodDateTime.minusMonths(11L);
        return aYearAgoBeforeEnd.isAfter(startPeriodDateTime);
    }

    public static boolean isBeforeStartPeriod(DynamicObject startPeriod, DynamicObject currentPeriod) {
        Date startPeriodDate = startPeriod.getDate("begindate");
        Date currentPeriodDate = currentPeriod.getDate("begindate");
        LocalDateTime currentPeriodDateTime = LocalDateTime.ofInstant(currentPeriodDate.toInstant(), ZoneId.systemDefault());
        LocalDateTime startPeriodDateTime = LocalDateTime.ofInstant(startPeriodDate.toInstant(), ZoneId.systemDefault());
        LocalDateTime sixMonthAgoBeforeCurrent = currentPeriodDateTime.minusMonths(5L);
        boolean isBeforeStartPeriod = sixMonthAgoBeforeCurrent.isBefore(startPeriodDateTime);
        return isBeforeStartPeriod;
    }

    public static DynamicObject getSixMonthAgoPeriod(DynamicObject currentPeriod) {
        DynamicObject periodType = currentPeriod.getDynamicObject("periodtype");
        Date currentPeriodDate = currentPeriod.getDate("begindate");
        LocalDateTime currentPeriodDateTime = LocalDateTime.ofInstant(currentPeriodDate.toInstant(), ZoneId.systemDefault());
        LocalDateTime sixMonthAgoBeforeCurrent = currentPeriodDateTime.minusMonths(5L);
        Date date = Date.from(sixMonthAgoBeforeCurrent.atZone(ZoneId.systemDefault()).toInstant());
        QFilter qFilter = new QFilter("begindate", "=", (Object)date);
        qFilter.and(new QFilter("periodtype", "=", periodType.getPkValue()));
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter[]{qFilter});
        return period;
    }

    public static QFilter getCostAccountNextPeriodQf(DynamicObject costAccount) {
        if (costAccount == null) {
            return new QFilter("id", "=", (Object)-1L);
        }
        Long beginPeriodId = PeriodHelper.getBeginPeriod(costAccount);
        return PeriodHelper.getNextPeriodQf(beginPeriodId);
    }

    public static Map<String, DynamicObject> getStartAndCurrentPeriod(Long costAccountId) {
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(2);
        DynamicObject sysCtrl = PeriodHelper.getSysCtrlEntity(costAccountId);
        if (sysCtrl != null) {
            DynamicObject startPeriod = sysCtrl.getDynamicObject("startperiod");
            DynamicObject currentPeriod = sysCtrl.getDynamicObject("currentperiod");
            map.put("startPeriod", startPeriod);
            map.put("currentPeriod", currentPeriod);
        }
        return map;
    }

    public static Map<Object, DynamicObject> getCollByStartPeriodAndEndPeriod(DynamicObject startPeriod, DynamicObject endPeriod) {
        if (startPeriod == null || endPeriod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6bd4\u671f\u95f4\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"PeriodHelper_0", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
        }
        DynamicObject periodType = startPeriod.getDynamicObject("periodtype");
        QFilter filter = new QFilter("periodtype", "=", (Object)periodType.getLong("id"));
        filter.and(new QFilter("isadjustperiod", "=", (Object)"0"));
        filter.and("id", ">=", (Object)startPeriod.getLong("id"));
        filter.and("id", "<=", (Object)endPeriod.getLong("id"));
        Map period = BusinessDataServiceHelper.loadFromCache((String)"bd_period", (String)"id,name,enddate", (QFilter[])new QFilter[]{filter});
        return period;
    }

    public static Map<String, DynamicObject> getQOQPeriod(DynamicObject startPeriod, DynamicObject endPeriod) {
        if (startPeriod == null || endPeriod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u73af\u6bd4\u671f\u95f4\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"PeriodHelper_0", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
        }
        DynamicObject periodType = startPeriod.getDynamicObject("periodtype");
        QFilter filter = new QFilter("periodtype", "=", (Object)periodType.getLong("id"));
        filter.and(new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE));
        filter.and("id", ">=", (Object)startPeriod.getLong("id"));
        filter.and("id", "<=", (Object)endPeriod.getLong("id"));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])new QFilter[]{filter}, (String)"periodyear asc,periodnumber asc");
        int size = coll.size();
        Date startPeriodDate = startPeriod.getDate("begindate");
        LocalDateTime startPeriodDateTime = LocalDateTime.ofInstant(startPeriodDate.toInstant(), ZoneId.systemDefault());
        LocalDateTime qoqStartPeriodDateTime = startPeriodDateTime.minusMonths(size);
        Date startDate = Date.from(qoqStartPeriodDateTime.atZone(ZoneId.systemDefault()).toInstant());
        QFilter startFilter = new QFilter("begindate", "=", (Object)startDate);
        startFilter.and(new QFilter("periodtype", "=", periodType.getPkValue()));
        DynamicObject qoqStartPeriod = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter[]{startFilter});
        Date endPeriodDate = endPeriod.getDate("begindate");
        LocalDateTime endPeriodDateTime = LocalDateTime.ofInstant(endPeriodDate.toInstant(), ZoneId.systemDefault());
        LocalDateTime qoqEndPeriodDateTime = endPeriodDateTime.minusMonths(size);
        Date endDate = Date.from(qoqEndPeriodDateTime.atZone(ZoneId.systemDefault()).toInstant());
        QFilter endFilter = new QFilter("begindate", "=", (Object)endDate);
        endFilter.and(new QFilter("periodtype", "=", periodType.getPkValue()));
        DynamicObject qoqEndPeriod = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter[]{endFilter});
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(2);
        map.put("startPeriod", qoqStartPeriod);
        map.put("endPeriod", qoqEndPeriod);
        return map;
    }

    public static Map<String, DynamicObject> getYOYPeriod(DynamicObject startPeriod, DynamicObject endPeriod) {
        if (startPeriod == null || endPeriod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6bd4\u671f\u95f4\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"PeriodHelper_0", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
        }
        DynamicObject periodType = startPeriod.getDynamicObject("periodtype");
        Date startPeriodDate = startPeriod.getDate("begindate");
        LocalDateTime startPeriodDateTime = LocalDateTime.ofInstant(startPeriodDate.toInstant(), ZoneId.systemDefault());
        LocalDateTime qoqStartPeriodDateTime = startPeriodDateTime.minusYears(1L);
        Date startDate = Date.from(qoqStartPeriodDateTime.atZone(ZoneId.systemDefault()).toInstant());
        QFilter startFilter = new QFilter("begindate", "=", (Object)startDate);
        startFilter.and(new QFilter("periodtype", "=", periodType.getPkValue()));
        DynamicObject yoyStartPeriod = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter[]{startFilter});
        Date endPeriodDate = endPeriod.getDate("begindate");
        LocalDateTime endPeriodDateTime = LocalDateTime.ofInstant(endPeriodDate.toInstant(), ZoneId.systemDefault());
        LocalDateTime qoqEndPeriodDateTime = endPeriodDateTime.minusYears(1L);
        Date endDate = Date.from(qoqEndPeriodDateTime.atZone(ZoneId.systemDefault()).toInstant());
        QFilter endFilter = new QFilter("begindate", "=", (Object)endDate);
        endFilter.and(new QFilter("periodtype", "=", periodType.getPkValue()));
        DynamicObject yoyEndPeriod = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter[]{endFilter});
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(2);
        map.put("startPeriod", yoyStartPeriod);
        map.put("endPeriod", yoyEndPeriod);
        return map;
    }

    private static Long getBeginPeriod(DynamicObject costAccount) {
        if (costAccount == null) {
            return null;
        }
        DynamicObject startPeriod = PeriodHelper.getSysCtrlEntity(costAccount.getLong("id"));
        Long startPeriodId = null;
        if (startPeriod != null) {
            startPeriodId = startPeriod.getLong("startperiod.id");
        }
        return startPeriodId;
    }

    public static QFilter getNextPeriodQf(Object curPeriodId) {
        if (curPeriodId == null || curPeriodId.equals(0L)) {
            return null;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bd_period");
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (DynamicObjectType)type);
        Object periodTypeId = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filterType = new QFilter("periodtype.id", "=", periodTypeId);
        QFilter filterYear = new QFilter("periodyear", "=", (Object)currPeriod.getInt("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", ">=", (Object)currPeriod.getInt("periodnumber"));
        QFilter filter = filterYear.and(filterNum);
        QFilter pYear = new QFilter("periodyear", ">", (Object)currPeriod.getInt("periodyear"));
        filter.or(pYear);
        QFilter adjust = new QFilter("isadjustperiod", "=", (Object)Character.valueOf('0'));
        return filterType.and(filter).and(adjust);
    }

    private static DynamicObject getSysCtrlEntity(Long costAccountId) {
        DynamicObject retValue = null;
        QFilter filter = new QFilter("entry.costaccount.id", "=", (Object)costAccountId);
        String fields = "org,entry.currentperiod,entry.startperiod,entry.costaccount,entry.currentperiod.begindate,entry.currentperiod.enddate,entry.currentperiod.periodyear,entry.currentperiod.periodnumber,entry.startperiod.id,entry.startperiod.begindate,entry.startperiod.enddate,entry.calpolicy,entry.calpolicy.periodtype,entry.isenabled";
        DynamicObject sysPeriod = BusinessDataServiceHelper.loadSingle((String)"cal_sysctrlentity", (String)fields, (QFilter[])new QFilter[]{filter});
        if (sysPeriod == null) {
            return null;
        }
        DynamicObjectCollection entrys = sysPeriod.getDynamicObjectCollection("entry");
        for (DynamicObject entryInfo : entrys) {
            long recordCostAccountId = entryInfo.getLong("costaccount.id");
            if (costAccountId != recordCostAccountId) continue;
            retValue = entryInfo;
            break;
        }
        return retValue;
    }
}

