/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.plugin.form.gpt;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.control.Hyperlink;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ChartDisplayPlugin
extends AbstractFormPlugin {
    private static final Log LOG = LogFactory.getLog(ChartDisplayPlugin.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.buildDigitalCard(new BigDecimal("100"), new BigDecimal("12"));
        this.buildChart();
        this.setUrl();
    }

    private void setUrl() {
        String domainUrl = System.getProperty("domain.contextUrl");
        String formId = "scmdi_wwb_list";
        String url = domainUrl + "?formId=bos_list&billFormId=" + formId + "&type=list";
        Hyperlink hyperlink = (Hyperlink)this.getView().getControl("hyperlinkap");
        hyperlink.setUrl(url);
    }

    private void buildDigitalCard(BigDecimal ito, BigDecimal itoYOYRate) {
        Label itoLabel = (Label)this.getView().getControl("ito");
        Label itoYoy = (Label)this.getView().getControl("ito_yoy");
        String itoText = ito == null ? "-" : ito.toPlainString();
        itoLabel.setText(itoText);
        this.setIconVisible(itoYOYRate, "ito_yoy_increase", "ito_yoy_decreases", "ito_yoy1");
        String itoYoyText = itoYOYRate == null ? "-" : itoYOYRate.toPlainString();
        itoYoy.setText(itoYoyText);
    }

    private void setIconVisible(BigDecimal rate, String increaseKey, String decreasesKey, String percent) {
        if (rate == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{increaseKey, decreasesKey, percent});
            return;
        }
        int rateSize = rate.compareTo(BigDecimal.ZERO);
        if (rateSize > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{increaseKey, percent});
            this.getView().setVisible(Boolean.FALSE, new String[]{decreasesKey});
        } else if (rateSize < 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{decreasesKey, percent});
            this.getView().setVisible(Boolean.FALSE, new String[]{increaseKey});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{increaseKey, decreasesKey, percent});
        }
    }

    private void getChartData(Long orgId) {
    }

    private void buildChart() {
        PointLineChart itoLineChart = (PointLineChart)this.getControl("pointlinechartap");
        itoLineChart.clearData();
        Axis xAxis = itoLineChart.createXAxis("", AxisType.category);
        List<String> periodAxis = this.getPeriodAxis();
        xAxis.setCategorys(periodAxis);
        xAxis.setPropValue("show", (Object)false);
        Axis yAxis = itoLineChart.createYAxis("", AxisType.value);
        yAxis.setPropValue("show", (Object)false);
        LineSeries itoLineSeries = itoLineChart.createLineSeries("");
        itoLineSeries.setData((Number[])this.getLineChartData());
        itoLineSeries.setLineColor("#40A9FF");
        itoLineChart.refresh();
    }

    private List<String> getPeriodAxis() {
        ArrayList<String> periodAxis = new ArrayList<String>();
        periodAxis.add("1");
        periodAxis.add("2");
        periodAxis.add("3");
        periodAxis.add("4");
        periodAxis.add("5");
        periodAxis.add("6");
        return periodAxis;
    }

    private BigDecimal[] getLineChartData() {
        ArrayList<BigDecimal> lineChartData = new ArrayList<BigDecimal>();
        lineChartData.add(new BigDecimal("50"));
        lineChartData.add(new BigDecimal("40"));
        lineChartData.add(new BigDecimal("55"));
        lineChartData.add(new BigDecimal("100"));
        lineChartData.add(new BigDecimal("35"));
        lineChartData.add(new BigDecimal("110"));
        return lineChartData.toArray(new BigDecimal[0]);
    }
}

