/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.plugin.form.itoanalysis;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.CustomChart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Label;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.scmdi.business.helper.BeforeF7SelectHelper;
import kd.scmc.scmdi.business.helper.DataChangeHelper;
import kd.scmc.scmdi.business.helper.OrgHelper;
import kd.scmc.scmdi.business.helper.PeriodHelper;
import kd.scmc.scmdi.business.helper.PermissionHelper;
import kd.scmc.scmdi.common.entity.CombinationChartInfo;
import kd.scmc.scmdi.common.entity.DigitalCardInfo;
import kd.scmc.scmdi.common.entity.FilterConditionInfo;
import kd.scmc.scmdi.service.mservices.ItoChartDataService;

public abstract class AbstractItoAnalysisPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Long INIT_MATERIALGROUPSTANDARD_ID = 730148448254487552L;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "calorg", "startperiod", "endperiod", "mulmaterialgroup", "materialgroupto", "materialgroupstandard");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModelerId();
        this.buildFilterCondition();
        this.buildChart();
        this.buildEntryEntity();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Boolean triggerChangeEventLocal = DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        switch (key) {
            case "calorg": {
                this.calOrgChanged(newValue);
                this.buildChart();
                break;
            }
            case "startperiod": {
                this.startPeriodChanged((DynamicObject)newValue, oldValue);
                break;
            }
            case "endperiod": {
                this.endPeriodChanged((DynamicObject)newValue, oldValue);
                break;
            }
            case "materialgroupstandard": {
                this.materialGroupStandardChanged();
                break;
            }
            case "mulmaterialgroup": {
                this.materialGroupFromChanged(newValue);
                break;
            }
            case "materialgroupto": 
            case "material": {
                this.buildEntryEntity();
                break;
            }
            case "ageval": {
                this.invAgeGroupChanged(rowIndex, oldValue, newValue);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "calorg": {
                BeforeF7SelectHelper.beforeF7Select4CalOrg(evt);
                break;
            }
            case "startperiod": 
            case "endperiod": {
                BeforeF7SelectHelper.beforeF7Select4Period(evt, (DynamicObject)this.getModel().getValue("costaccount"));
                break;
            }
            case "mulmaterialgroup": 
            case "materialgroupto": {
                this.materialGroupBeforeF7Select(evt, key);
                break;
            }
            case "materialgroupstandard": {
                this.materialGroupStandardBeforeF7Select(evt);
                break;
            }
            case "material": {
                this.materialBeforeF7Select(evt);
                break;
            }
        }
    }

    public abstract void buildEntryEntity();

    public abstract void buildFilterCondition();

    private void getModelerId() {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add("scmdi_metric_cal_ito");
        list.add("scmdi_metric_cal_itogroup");
        QFilter[] filters = new QFilter[]{new QFilter("biz_entity", "in", list), new QFilter("enable", "=", (Object)"1")};
        Map metricsMapping = BusinessDataServiceHelper.loadFromCache((String)"scmdi_metrics_mapping", (String)"biz_entity,metric_entity_identity", (QFilter[])filters);
        IPageCache pageCache = this.getPageCache();
        for (DynamicObject dynamicObject : metricsMapping.values()) {
            DynamicObject entity = dynamicObject.getDynamicObject("biz_entity");
            pageCache.put((String)entity.getPkValue(), dynamicObject.getString("metric_entity_identity"));
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        if ("ageentry".equals(e.getEntryProp().getName())) {
            int rowIndex = this.getModel().getEntryRowCount("ageentry") - 1;
            String prefixString = (String)this.getModel().getValue("agename", rowIndex - 1);
            if (StringUtils.isEmpty((CharSequence)prefixString)) {
                return;
            }
            String lastValue = prefixString.contains("days") ? prefixString.substring(prefixString.indexOf("to") + 1, prefixString.indexOf("days")).trim() : prefixString.substring(prefixString.indexOf(ResManager.loadKDString((String)"\u5230", (String)"MaterialGroupItoAnalysisPlugin_0", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0])) + 1, prefixString.indexOf(ResManager.loadKDString((String)"\u5929", (String)"MaterialGroupItoAnalysisPlugin_1", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0])));
            Integer prefixRowIntervalDaysValue = (Integer)this.getModel().getValue("ageval", rowIndex - 1);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"agename"});
            int totalDay = Integer.parseInt(lastValue) + prefixRowIntervalDaysValue;
            this.getModel().setValue("agename", (Object)String.format(ResManager.loadKDString((String)"%1$s\u5929\u53ca\u4ee5\u4e0a", (String)"MaterialGroupItoAnalysisPlugin_2", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]), totalDay), rowIndex);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if ("ageentry".equals(e.getEntryProp().getName())) {
            int[] rowIndex = e.getRowIndexs();
            if (rowIndex.length != 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e00\u6b21\u6027\u5220\u9664\u591a\u884c\uff0c\u8bf7\u4e00\u884c\u884c\u5220\u9664", (String)"MaterialGroupItoAnalysisPlugin_3", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
            }
            if (rowIndex[0] == 0 || rowIndex[0] == 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7b2c\u4e00\u884c\u548c\u7b2c\u4e8c\u884c\u4e3a\u4fdd\u7559\u884c\uff0c\u4e0d\u80fd\u5220\u9664", (String)"MaterialGroupItoAnalysisPlugin_4", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        if ("ageentry".equals(e.getEntryProp().getName())) {
            String sbFirst = ResManager.loadKDString((String)"0\u5230X\u5929", (String)"MaterialGroupItoAnalysisPlugin_5", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]);
            String secondString = sbFirst.substring(1, 2);
            String fourString = sbFirst.substring(sbFirst.length() - 1);
            if (sbFirst.toLowerCase().contains("to")) {
                secondString = "to";
                StringBuilder sb = new StringBuilder(sbFirst.trim());
                sb.replace(1, 4, " to X ");
                sbFirst = sb.toString();
                fourString = sbFirst.substring(sbFirst.indexOf("X ") + 2);
            }
            String sbSuffix = "";
            DynamicObjectCollection entry2Entity = this.getModel().getEntryEntity("ageentry");
            if (entry2Entity == null || entry2Entity.isEmpty()) {
                return;
            }
            int size = entry2Entity.size();
            for (int i = 0; i < size; ++i) {
                String lastValue;
                int invAgeGroup = ((DynamicObject)entry2Entity.get(i)).getInt("ageval");
                if (i == 0) {
                    sbFirst = sbFirst.replace("X", String.valueOf(invAgeGroup - 1));
                    this.getModel().setValue("agename", (Object)sbFirst, i);
                    sbSuffix = sbFirst;
                    continue;
                }
                if (i == size - 1) {
                    lastValue = sbSuffix.substring(sbSuffix.indexOf(secondString) + secondString.length(), sbSuffix.indexOf(fourString)).trim();
                    int totalDay = Integer.parseInt(lastValue) + 1;
                    DataChangeHelper.setValue(this.getModel(), "agename", String.format(ResManager.loadKDString((String)"%1$s\u5929\u53ca\u4ee5\u4e0a", (String)"MaterialGroupItoAnalysisPlugin_2", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]), totalDay), i, false);
                    DataChangeHelper.setValue(this.getModel(), "ageval", null, i, false);
                    continue;
                }
                lastValue = sbSuffix.substring(sbSuffix.indexOf(secondString) + secondString.length(), sbSuffix.indexOf(fourString)).trim();
                String tmp = "to".equals(secondString) ? Integer.parseInt(lastValue) + 1 + " " + secondString + " " + (Integer.parseInt(lastValue) + invAgeGroup) + " " + fourString : Integer.parseInt(lastValue) + 1 + secondString + (Integer.parseInt(lastValue) + invAgeGroup) + fourString;
                DataChangeHelper.setValue(this.getModel(), "agename", tmp, i, false);
                sbSuffix = tmp;
            }
        }
    }

    public void invAgeGroupChanged(int rowIndex, Object oldValue, Object newValue) {
        if ((Integer)newValue == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"MaterialGroupItoAnalysisPlugin_6", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
            DataChangeHelper.setValue(this.getModel(), "ageval", oldValue, false);
            return;
        }
        String sbFirst = ResManager.loadKDString((String)"0\u5230X\u5929", (String)"MaterialGroupItoAnalysisPlugin_5", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]);
        String secondString = sbFirst.substring(1, 2);
        String fourString = sbFirst.substring(sbFirst.length() - 1);
        if (sbFirst.toLowerCase().contains("to")) {
            StringBuilder sb = new StringBuilder(sbFirst.trim());
            sb.replace(1, 4, " to X ");
            sbFirst = sb.toString();
            secondString = "to";
            fourString = sbFirst.substring(sbFirst.indexOf("X ") + 2);
        }
        String sbSuffix = "";
        DynamicObjectCollection entry2Entity = this.getModel().getEntryEntity("ageentry");
        if (entry2Entity == null || entry2Entity.isEmpty()) {
            return;
        }
        int size = entry2Entity.size();
        if (rowIndex == size - 1) {
            if (size == 2 && ((DynamicObject)entry2Entity.get(1)).getInt("ageval") != 0) {
                this.getView().invokeOperation("newentry");
                entry2Entity = this.getModel().getEntryEntity("ageentry");
                size = entry2Entity.size();
            } else if (size != 2) {
                this.getView().invokeOperation("newentry");
                entry2Entity = this.getModel().getEntryEntity("ageentry");
                size = entry2Entity.size();
            }
        }
        for (int i = 0; i < size; ++i) {
            String lastValue;
            int invAgeGroup = ((DynamicObject)entry2Entity.get(i)).getInt("ageval");
            if (i == 0) {
                sbFirst = sbFirst.replace("X", String.valueOf(invAgeGroup - 1));
                DataChangeHelper.setValue(this.getModel(), "agename", sbFirst, i, false);
                sbSuffix = sbFirst;
                continue;
            }
            if (i != size - 1) {
                lastValue = sbSuffix.substring(sbSuffix.indexOf(secondString) + secondString.length(), sbSuffix.indexOf(fourString)).trim();
                String tmp = "to".equals(secondString) ? Integer.parseInt(lastValue) + 1 + " " + secondString + " " + (Integer.parseInt(lastValue) + invAgeGroup) + " " + fourString : Integer.parseInt(lastValue) + 1 + secondString + (Integer.parseInt(lastValue) + invAgeGroup) + fourString;
                DataChangeHelper.setValue(this.getModel(), "agename", tmp, i, false);
                sbSuffix = tmp;
                continue;
            }
            lastValue = sbSuffix.substring(sbSuffix.indexOf(secondString) + secondString.length(), sbSuffix.indexOf(fourString)).trim();
            int totalDay = Integer.parseInt(lastValue) + 1;
            String tmp = String.format(ResManager.loadKDString((String)"%1$s\u5929\u53ca\u4ee5\u4e0a", (String)"MaterialGroupItoAnalysisPlugin_1", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]), totalDay);
            DataChangeHelper.setValue(this.getModel(), "agename", tmp, i, false);
            sbSuffix = tmp;
        }
    }

    public void setFilterConditionDefaultValue() {
        Long userOrgId;
        long userId = RequestContext.get().getCurrUserId();
        Long calOrgId = PermissionHelper.getCalOrgByUserOrg(userId, userOrgId = Long.valueOf(RequestContext.get().getOrgId()), "scmdi_itoanalysis", "47150e89000000ac");
        if (calOrgId != null && calOrgId != 0L) {
            this.getModel().setValue("calorg", (Object)calOrgId);
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg(calOrgId);
            if (costAccount != null) {
                this.getModel().setValue("costaccount", (Object)costAccount.getLong("id"));
                this.costAccountChanged(costAccount);
            }
        }
    }

    private void costAccountChanged(DynamicObject costAccount) {
        if (costAccount == null) {
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        Map<String, DynamicObject> startAndCurrentPeriod = PeriodHelper.getStartAndCurrentPeriod(costAccount.getLong("id"));
        this.getStartAndEndPeriod(startAndCurrentPeriod);
    }

    private void getStartAndEndPeriod(Map<String, DynamicObject> startAndCurrentPeriod) {
        DynamicObject startPeriod = startAndCurrentPeriod.get("startPeriod");
        DynamicObject currentPeriod = startAndCurrentPeriod.get("currentPeriod");
        if (startPeriod == null || currentPeriod == null) {
            this.getModel().setValue("startperiod", (Object)startPeriod);
        } else {
            boolean beforeStartPeriod = PeriodHelper.isBeforeStartPeriod(startPeriod, currentPeriod);
            if (beforeStartPeriod) {
                this.getModel().setValue("startperiod", (Object)startPeriod);
            } else {
                DynamicObject loadPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)currentPeriod.getPkValue(), (String)"bd_period");
                DynamicObject period = PeriodHelper.getSixMonthAgoPeriod(loadPeriod);
                this.getModel().setValue("startperiod", (Object)period);
            }
        }
        this.getModel().setValue("endperiod", (Object)currentPeriod);
    }

    private void materialGroupStandardBeforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        if (calOrg == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"InventoryTurnoverAnalysisPlugin_3", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        BeforeF7SelectHelper.beforeF7Select4MaterialGroupStandard(evt, calOrg);
    }

    private void materialGroupBeforeF7Select(BeforeF7SelectEvent evt, String key) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        if (calOrg == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"InventoryTurnoverAnalysisPlugin_3", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject materialGroupStandard = (DynamicObject)this.getModel().getValue("materialgroupstandard");
        if (materialGroupStandard == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"InventoryTurnoverAnalysisPlugin_3", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if ("mulmaterialgroup".equals(key)) {
            BeforeF7SelectHelper.beforeF7Select4MaterialGroup(evt, materialGroupStandard, calOrg);
        } else if ("materialgroupto".equals(key)) {
            DynamicObjectCollection materialGroupFrom = (DynamicObjectCollection)this.getModel().getValue("mulmaterialgroup");
            BeforeF7SelectHelper.beforeF7Select4MaterialGroupTo(evt, materialGroupFrom, materialGroupStandard, calOrg);
        }
    }

    private void materialBeforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        if (calOrg == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"InventoryTurnoverAnalysisPlugin_3", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject materialGroupStandard = (DynamicObject)this.getModel().getValue("materialgroupstandard");
        if (materialGroupStandard == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"InventoryTurnoverAnalysisPlugin_3", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObjectCollection materialGroupFrom = (DynamicObjectCollection)this.getModel().getValue("mulmaterialgroup");
        DynamicObject materialGroupTo = (DynamicObject)this.getModel().getValue("materialgroupto");
        BeforeF7SelectHelper.beforeF7Select4Material(evt, materialGroupStandard, calOrg, materialGroupFrom, materialGroupTo);
    }

    public void calOrgChanged(Object newValue) {
        DataChangeHelper.setValue(this.getModel(), "materialgroupstandard", INIT_MATERIALGROUPSTANDARD_ID, false);
        DataChangeHelper.setValue(this.getModel(), "mulmaterialgroup", null, false);
        DataChangeHelper.setValue(this.getModel(), "materialgroupto", null, false);
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"materialgroupto"});
        if (newValue == null) {
            DataChangeHelper.setValue(this.getModel(), "startperiod", null, false);
            DataChangeHelper.setValue(this.getModel(), "endperiod", null, false);
            DataChangeHelper.setValue(this.getModel(), "costaccount", null, false);
        } else {
            DynamicObject calOrg = (DynamicObject)newValue;
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg(calOrg.getLong("id"));
            if (costAccount != null) {
                this.getModel().setValue("costaccount", (Object)costAccount.getLong("id"));
            } else {
                this.getModel().setValue("costaccount", null);
            }
            this.costAccountChanged(costAccount);
        }
    }

    private void startPeriodChanged(DynamicObject startPeriod, Object oldValue) {
        DynamicObject endPeriod;
        if (startPeriod != null && (endPeriod = (DynamicObject)this.getModel().getValue("endperiod")) != null) {
            boolean startBigThanEndPeriod = PeriodHelper.isStartBigThanEndPeriod(startPeriod, endPeriod);
            if (!startBigThanEndPeriod) {
                DataChangeHelper.setValue(this.getModel(), "startperiod", oldValue, false);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u671f\u95f4\u9700\u8981\u5c0f\u4e8e\u7ed3\u675f\u671f\u95f4\u3002", (String)"MaterialGroupItoAnalysisPlugin_11", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
                return;
            }
            boolean beforeYearAgo = PeriodHelper.isBeforeAYearAgo(startPeriod, endPeriod);
            if (beforeYearAgo) {
                DataChangeHelper.setValue(this.getModel(), "startperiod", oldValue, false);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u671f\u95f4\u8303\u56f4\u9700\u5c0f\u4e8e12\u4e2a\u6708\u3002", (String)"MaterialGroupItoAnalysisPlugin_12", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
                return;
            }
            this.buildChart();
        }
    }

    private void endPeriodChanged(DynamicObject endPeriod, Object oldValue) {
        DynamicObject startPeriod;
        if (endPeriod != null && (startPeriod = (DynamicObject)this.getModel().getValue("startperiod")) != null) {
            boolean startBigThanEndPeriod = PeriodHelper.isStartBigThanEndPeriod(startPeriod, endPeriod);
            if (!startBigThanEndPeriod) {
                DataChangeHelper.setValue(this.getModel(), "endperiod", oldValue, false);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u9700\u8981\u5927\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"MaterialGroupItoAnalysisPlugin_13", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
                return;
            }
            boolean beforeYearAgo = PeriodHelper.isBeforeAYearAgo(startPeriod, endPeriod);
            if (beforeYearAgo) {
                DataChangeHelper.setValue(this.getModel(), "endperiod", oldValue, false);
                this.getModel().setValue("endperiod", oldValue);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u671f\u95f4\u8303\u56f4\u9700\u5c0f\u4e8e12\u4e2a\u6708\u3002", (String)"MaterialGroupItoAnalysisPlugin_12", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
                return;
            }
            this.buildChart();
        }
    }

    public void materialGroupStandardChanged() {
        this.getModel().setValue("mulmaterialgroup", null);
        this.getModel().setValue("materialgroupto", null);
    }

    public void materialGroupFromChanged(Object newValue) {
        DynamicObjectCollection newMaterialGroup = (DynamicObjectCollection)newValue;
        if (newMaterialGroup == null || newMaterialGroup.isEmpty()) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"materialgroupto"});
            this.getModel().setValue("materialgroupto", null);
        } else if (newMaterialGroup.size() == 1) {
            this.getModel().setValue("materialgroupto", ((DynamicObject)newMaterialGroup.get(0)).getDynamicObject("fbasedataid").getPkValue());
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"materialgroupto"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"materialgroupto"});
            this.getModel().setValue("materialgroupto", null);
        }
    }

    public void buildChart() {
        this.buildDigitalCard();
        this.buildItoTrendChart();
    }

    public abstract FilterConditionInfo getFilterConditionInfo();

    private void buildDigitalCard() {
        DigitalCardInfo itoDigitalCardData = ItoChartDataService.getItoDigitalCardData(this.getFilterConditionInfo());
        Label ito = (Label)this.getView().getControl("itocurrentvalue");
        Label itoYoy = (Label)this.getView().getControl("ito_yoy");
        Label itoQoq = (Label)this.getView().getControl("ito_qoq");
        Label turnOverDay = (Label)this.getView().getControl("tdcurrentvalue");
        Label turnOverDayYoy = (Label)this.getView().getControl("td_yoy");
        Label turnOverDayQoq = (Label)this.getView().getControl("td_qoq");
        Label saleCost = (Label)this.getView().getControl("salecostcurrentvalue");
        Label saleCostYoy = (Label)this.getView().getControl("salecost_yoy");
        Label saleCostQoq = (Label)this.getView().getControl("salecost_qoq");
        Label invCost = (Label)this.getView().getControl("invcostcurrentvalue");
        Label invCostYoy = (Label)this.getView().getControl("invcost_yoy");
        Label invCostQoq = (Label)this.getView().getControl("invcost_qoq");
        String itoText = itoDigitalCardData.getStockTurnOver() == null ? "-" : itoDigitalCardData.getStockTurnOver().toPlainString();
        ito.setText(itoText);
        BigDecimal stockTurnOverYOYRate = itoDigitalCardData.getStockTurnOverYOYRate();
        this.setIconVisible(stockTurnOverYOYRate, "ito_yoy_increase", "ito_yoy_decreases", "ito_yoy1");
        String itoYoyText = stockTurnOverYOYRate == null ? "-" : stockTurnOverYOYRate.toPlainString();
        itoYoy.setText(itoYoyText);
        BigDecimal stockTurnOverQOQRate = itoDigitalCardData.getStockTurnOverQOQRate();
        this.setIconVisible(stockTurnOverQOQRate, "ito_qoq_increase", "ito_qoq_decreases", "ito_qoq1");
        String itoQoqText = stockTurnOverQOQRate == null ? "-" : stockTurnOverQOQRate.toPlainString();
        itoQoq.setText(itoQoqText);
        String turnOverDayText = itoDigitalCardData.getTurnOverDay() == null ? "-" : itoDigitalCardData.getTurnOverDay().toPlainString();
        turnOverDay.setText(turnOverDayText);
        BigDecimal turnOverDayYOYRate = itoDigitalCardData.getTurnOverDayYOYRate();
        this.setIconVisible(turnOverDayYOYRate, "td_yoy_increase", "td_yoy_decreases", "td_yoy1");
        String turnOverDayYoyText = turnOverDayYOYRate == null ? "-" : turnOverDayYOYRate.toPlainString();
        turnOverDayYoy.setText(turnOverDayYoyText);
        BigDecimal turnOverDayQOQRate = itoDigitalCardData.getTurnOverDayQOQRate();
        this.setIconVisible(turnOverDayQOQRate, "td_qoq_increase", "td_qoq_decreases", "td_qoq1");
        String turnOverDayQoqText = turnOverDayQOQRate == null ? "-" : turnOverDayQOQRate.toPlainString();
        turnOverDayQoq.setText(turnOverDayQoqText);
        String saleCostText = itoDigitalCardData.getSaleCost() == null ? "-" : itoDigitalCardData.getSaleCost().toPlainString();
        saleCost.setText(saleCostText);
        BigDecimal saleCostYOYRate = itoDigitalCardData.getSaleCostYOYRate();
        this.setIconVisible(saleCostYOYRate, "salecost_yoy_increase", "salecost_yoy_decreases", "salecost_yoy1");
        String saleCostYoyText = saleCostYOYRate == null ? "-" : saleCostYOYRate.toPlainString();
        saleCostYoy.setText(saleCostYoyText);
        BigDecimal saleCostQOQRate = itoDigitalCardData.getSaleCostQOQRate();
        this.setIconVisible(saleCostQOQRate, "salecost_qoq_increase", "salecost_qoq_decreases", "salecost_qoq1");
        String saleCostQoqText = saleCostQOQRate == null ? "-" : saleCostQOQRate.toPlainString();
        saleCostQoq.setText(saleCostQoqText);
        String invCostText = itoDigitalCardData.getInvCost() == null ? "-" : itoDigitalCardData.getInvCost().toPlainString();
        invCost.setText(invCostText);
        BigDecimal invCostYOYRate = itoDigitalCardData.getInvCostYOYRate();
        this.setIconVisible(invCostYOYRate, "invcost_yoy_increase", "invcost_yoy_decreases", "invcost_yoy1");
        String invCostYoyText = invCostYOYRate == null ? "-" : invCostYOYRate.toPlainString();
        invCostYoy.setText(invCostYoyText);
        BigDecimal invCostQOQRate = itoDigitalCardData.getInvCostQOQRate();
        this.setIconVisible(invCostQOQRate, "invcost_qoq_increase", "invcost_qoq_decreases", "invcost_qoq1");
        String invCostQoqText = invCostQOQRate == null ? "-" : invCostQOQRate.toPlainString();
        invCostQoq.setText(invCostQoqText);
    }

    private void setIconVisible(BigDecimal rate, String increaseKey, String decreasesKey, String percent) {
        if (rate == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{increaseKey, decreasesKey, percent});
            return;
        }
        int rateSize = rate.compareTo(BigDecimal.ZERO);
        if (rateSize > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{increaseKey, percent});
            this.getView().setVisible(Boolean.FALSE, new String[]{decreasesKey});
        } else if (rateSize < 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{decreasesKey, percent});
            this.getView().setVisible(Boolean.FALSE, new String[]{increaseKey});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{increaseKey, decreasesKey, percent});
        }
    }

    private void buildItoTrendChart() {
        CustomChart itoChart = (CustomChart)this.getControl("ito_trend");
        itoChart.addTooltip("trigger", (Object)"axis");
        HashMap<String, String> axisPointType = new HashMap<String, String>(1);
        axisPointType.put("type", "shadow");
        itoChart.addTooltip("axisPointer", axisPointType);
        itoChart.clearData();
        CombinationChartInfo itoTrendChartData = ItoChartDataService.getItoTrendChartData(this.getFilterConditionInfo());
        this.setItoTrendChartAxisTick(itoChart, itoTrendChartData);
        this.setItoTrendChartData(itoChart, itoTrendChartData);
        itoChart.setLegendAlign(XAlign.right, YAlign.top);
        itoChart.setShowTitle(true);
        itoChart.setShowTooltip(true);
        itoChart.setShowLegend(true);
        itoChart.setLegendVertical(false);
        itoChart.refresh();
    }

    private void setItoTrendChartAxisTick(CustomChart chart, CombinationChartInfo itoTrendChartData) {
        Axis axis = chart.createXAxis("", AxisType.category);
        List<String> periodAxis = itoTrendChartData.getPeriodAxis();
        axis.setCategorys(periodAxis);
        axis.setPosition(Position.bottom);
        axis.setPropValue("nameGap", (Object)"10");
        HashMap<String, Object> axisTick = new HashMap<String, Object>(2);
        axisTick.put("interval", "0");
        axisTick.put("show", Boolean.TRUE);
        axis.setPropValue("axisTick", axisTick);
        HashMap<String, Object> axisLabel = new HashMap<String, Object>(3);
        axisLabel.put("rotate", "30");
        axisLabel.put("show", Boolean.TRUE);
        axisLabel.put("interval", 0);
        axis.setPropValue("axisLabel", axisLabel);
        this.setLineColor(axis, "#999999");
    }

    private void setItoTrendChartData(CustomChart itoChart, CombinationChartInfo itoTrendChartData) {
        Axis barY = itoChart.createYAxis("", AxisType.value);
        barY.setPropValue("nameGap", (Object)"8");
        Map<String, BigDecimal[]> barChartData = itoTrendChartData.getBarChartData();
        int barChartIndex = 0;
        for (Map.Entry<String, BigDecimal[]> entry : barChartData.entrySet()) {
            String name = entry.getKey();
            BarSeries barSeries = itoChart.createBarSeries(name);
            barSeries.setBarWidth("20px");
            Number[] temp = entry.getValue();
            barSeries.setData(temp);
            barSeries.setColor(this.getBarChartColorList().get(barChartIndex));
            kd.bos.form.chart.Label label = new kd.bos.form.chart.Label();
            label.setShow(false);
            barSeries.setLabel(label);
            ++barChartIndex;
        }
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>(1);
        axisTick.put("show", Boolean.TRUE);
        barY.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap(1);
        HashMap<String, String> lineStyle = new HashMap<String, String>(2);
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#8A8B99");
        splitLine.put("lineStyle", lineStyle);
        barY.setPropValue("splitLine", splitLine);
        this.setLineColor(barY, "#8A8B99");
        HashMap<String, String> barAxisLabel = new HashMap<String, String>(1);
        barAxisLabel.put("formatter", "{value}");
        barY.setPropValue("axisLabel", barAxisLabel);
        Axis lineY = itoChart.createYAxis("", AxisType.value);
        lineY.setPropValue("nameGap", (Object)"8");
        lineY.setPropValue("show", (Object)Boolean.TRUE);
        lineY.setPropValue("axisTick", axisTick);
        lineY.setPropValue("splitLine", splitLine);
        this.setLineColor(lineY, "#8A8B99");
        HashMap<String, String> lineAxisLabel = new HashMap<String, String>(1);
        lineAxisLabel.put("formatter", "{value}%");
        lineY.setPropValue("axisLabel", lineAxisLabel);
        Map<String, BigDecimal[]> lineChartData = itoTrendChartData.getLineChartData();
        int lineChartIndex = 0;
        for (Map.Entry<String, BigDecimal[]> entry : lineChartData.entrySet()) {
            String name = entry.getKey();
            LineSeries lineSeries = itoChart.createLineSeries(name);
            lineSeries.setLineColor(this.getLineChartColorList().get(lineChartIndex));
            lineSeries.setItemColor(this.getLineChartColorList().get(lineChartIndex));
            Number[] temp = entry.getValue();
            lineSeries.setData(temp);
            lineSeries.setYAxisIndex(1);
            ++lineChartIndex;
        }
    }

    private List<String> getBarChartColorList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("#1890FF");
        list.add("#45DAD1");
        return list;
    }

    private void setLineColor(Axis axis, String color) {
        HashMap axisLineMap = new HashMap(1);
        HashMap<String, String> lineStyleMap = new HashMap<String, String>(1);
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axis.setPropValue("axisLine", axisLineMap);
    }

    private List<String> getLineChartColorList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("#26C9C3");
        list.add("#FFA940");
        return list;
    }

    public void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String s : f7Name) {
            BasedataEdit f7 = (BasedataEdit)this.getControl(s);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }
}

