/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.plugin.form.itoanalysis;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.CustomChart;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.scmdi.business.helper.DataChangeHelper;
import kd.scmc.scmdi.business.helper.PeriodHelper;
import kd.scmc.scmdi.common.entity.BarChartInfo;
import kd.scmc.scmdi.common.entity.CombinationChartInfo;
import kd.scmc.scmdi.common.entity.FilterConditionInfo;
import kd.scmc.scmdi.common.entity.MaterialGroupItoInfo;
import kd.scmc.scmdi.plugin.form.itoanalysis.AbstractItoAnalysisPlugin;
import kd.scmc.scmdi.service.mservices.ItoChartDataService;
import kd.scmc.scmdi.service.mservices.ItoEntryEntityDataService;

public class InventoryTurnoverAnalysisPlugin
extends AbstractItoAnalysisPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        HistogramChart chartAp = (HistogramChart)this.getView().getControl("histogramchartap");
        chartAp.addClickListener((ClickListener)this);
    }

    @Override
    public void buildFilterCondition() {
        this.setFilterConditionDefaultValue();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String opKey = source.getKey();
        if ("histogramchartap".equals(opKey)) {
            String labelName = ((ChartClickEvent)evt).getName();
            if (labelName == null) {
                return;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("scmdi_ito_materialgroup");
            this.buildChartCustomParam(formShowParameter, labelName);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(formShowParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("donothing".equals(operateKey)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("scmdi_ito_materialgroup");
            EntryGrid entryControl = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectRows = entryControl.getSelectRows();
            DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(selectRows[0]);
            DynamicObject materialGroup = entry.getDynamicObject("materialgroup");
            this.buildCustomParam(formShowParameter, materialGroup);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(formShowParameter);
        }
    }

    private void buildCustomParam(FormShowParameter formShowParameter, DynamicObject materialGroup) {
        DynamicObject materialGroupStandard;
        DynamicObject costAccount;
        DynamicObject endPeriod;
        DynamicObject startPeriod;
        HashMap<String, Object> customParam = new HashMap<String, Object>(7);
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        if (calOrg != null) {
            customParam.put("calorg", calOrg.getPkValue());
        }
        if ((startPeriod = (DynamicObject)this.getModel().getValue("startperiod")) != null) {
            customParam.put("startperiod", startPeriod.getPkValue());
        }
        if ((endPeriod = (DynamicObject)this.getModel().getValue("endperiod")) != null) {
            customParam.put("endperiod", endPeriod.getPkValue());
        }
        if ((costAccount = (DynamicObject)this.getModel().getValue("costaccount")) != null) {
            customParam.put("costaccount", costAccount.getPkValue());
        }
        if ((materialGroupStandard = (DynamicObject)this.getModel().getValue("materialgroupstandard")) != null) {
            customParam.put("materialgroupstandard", materialGroupStandard.getPkValue());
        }
        if (materialGroup != null) {
            customParam.put("mulmaterialgroup", Collections.singletonList((Long)materialGroup.getPkValue()));
            customParam.put("materialgroupto", materialGroup.getPkValue());
        }
        formShowParameter.setCustomParams(customParam);
    }

    private void buildChartCustomParam(FormShowParameter formShowParameter, String groupName) {
        DynamicObject materialGroupStandard;
        DynamicObject costAccount;
        DynamicObject endPeriod;
        DynamicObject startPeriod;
        HashMap<String, Object> customParam = new HashMap<String, Object>(7);
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        if (calOrg != null) {
            customParam.put("calorg", calOrg.getPkValue());
        }
        if ((startPeriod = (DynamicObject)this.getModel().getValue("startperiod")) != null) {
            customParam.put("startperiod", startPeriod.getPkValue());
        }
        if ((endPeriod = (DynamicObject)this.getModel().getValue("endperiod")) != null) {
            customParam.put("endperiod", endPeriod.getPkValue());
        }
        if ((costAccount = (DynamicObject)this.getModel().getValue("costaccount")) != null) {
            customParam.put("costaccount", costAccount.getPkValue());
        }
        if ((materialGroupStandard = (DynamicObject)this.getModel().getValue("materialgroupstandard")) != null) {
            customParam.put("materialgroupstandard", materialGroupStandard.getPkValue());
            QFilter qFilter = new QFilter("standard", "=", materialGroupStandard.getPkValue());
            qFilter.and(new QFilter("group.name", "=", (Object)groupName));
            DynamicObject materialGroupDetail = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialgroupdetail", (QFilter[])new QFilter[]{qFilter});
            DynamicObject group = materialGroupDetail.getDynamicObject("group");
            customParam.put("mulmaterialgroup", Collections.singletonList((Long)group.getPkValue()));
            customParam.put("materialgroupto", group.getPkValue());
        }
        formShowParameter.setCustomParams(customParam);
    }

    @Override
    public void buildEntryEntity() {
        this.getModel().deleteEntryData("entryentity");
        DynamicObject standard = (DynamicObject)this.getModel().getValue("materialgroupstandard");
        if (standard == null) {
            return;
        }
        List<MaterialGroupItoInfo> materialGroupEntryEntityData = ItoEntryEntityDataService.getMaterialGroupEntryEntityData(this.getMaterialGroupFilterConditionInfo());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObjectType entryEntityType = entryEntity.getDynamicObjectType();
        for (MaterialGroupItoInfo materialGroupItoInfo : materialGroupEntryEntityData) {
            DynamicObject entry = new DynamicObject(entryEntityType);
            entry.set("materialgroup", (Object)materialGroupItoInfo.getMaterialGroup());
            entry.set("salecost", (Object)materialGroupItoInfo.getSaleCost());
            entry.set("inventorycost", (Object)materialGroupItoInfo.getInventoryCost());
            entry.set("turnrate", (Object)materialGroupItoInfo.getTurnRate());
            entry.set("turndays", (Object)materialGroupItoInfo.getTurnDays());
            entry.set("currency", (Object)materialGroupItoInfo.getCurrency());
            entryEntity.add((Object)entry);
        }
        this.getModel().updateEntryCache(entryEntity);
        this.getView().updateView("entryentity");
    }

    @Override
    public void buildChart() {
        IDataModel model = this.getModel();
        DynamicObject calOrg = (DynamicObject)model.getValue("calorg");
        DynamicObject startPeriod = (DynamicObject)model.getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)model.getValue("endperiod");
        if (calOrg != null && startPeriod != null && endPeriod != null) {
            super.buildChart();
            this.buildTurnDayTrendChart();
            DynamicObject materialGroupStandard = (DynamicObject)model.getValue("materialgroupstandard");
            if (materialGroupStandard != null) {
                this.buildMaterialGroupBarChart();
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        Boolean triggerChangeEventLocal = DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "materialgroupstandard": 
            case "mulmaterialgroup": 
            case "materialgroupto": {
                this.buildMaterialGroupBarChart();
                this.buildEntryEntity();
                this.getView().updateView("histogramchartap");
                break;
            }
        }
    }

    @Override
    public FilterConditionInfo getFilterConditionInfo() {
        IDataModel model = this.getModel();
        DynamicObject calOrg = (DynamicObject)model.getValue("calorg");
        DynamicObject costAccount = (DynamicObject)model.getValue("costaccount");
        DynamicObject startPeriod = (DynamicObject)model.getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)model.getValue("endperiod");
        Map<Object, DynamicObject> coll = PeriodHelper.getCollByStartPeriodAndEndPeriod(startPeriod, endPeriod);
        List<Long> periodId = coll.values().stream().map(period -> period.getLong("id")).collect(Collectors.toList());
        List<String> periodName = coll.values().stream().map(period -> period.getString("name")).collect(Collectors.toList());
        Map<String, DynamicObject> qoqPeriod = PeriodHelper.getQOQPeriod(startPeriod, endPeriod);
        Map<Object, DynamicObject> qoqColl = PeriodHelper.getCollByStartPeriodAndEndPeriod(qoqPeriod.get("startPeriod"), qoqPeriod.get("endPeriod"));
        List<Long> qoqPeriodId = qoqColl.values().stream().map(period -> period.getLong("id")).collect(Collectors.toList());
        Map<String, DynamicObject> yoyPeriod = PeriodHelper.getYOYPeriod(startPeriod, endPeriod);
        Map<Object, DynamicObject> yoyColl = PeriodHelper.getCollByStartPeriodAndEndPeriod(yoyPeriod.get("startPeriod"), yoyPeriod.get("endPeriod"));
        List<Long> yoyPeriodId = yoyColl.values().stream().map(period -> period.getLong("id")).collect(Collectors.toList());
        FilterConditionInfo filterConditionInfo = new FilterConditionInfo();
        filterConditionInfo.setCalOrg(calOrg.getLong("id"));
        if (costAccount != null) {
            filterConditionInfo.setCostAccount(costAccount.getLong("id"));
        }
        filterConditionInfo.setPeriod(periodId);
        filterConditionInfo.setPeriodName(periodName);
        filterConditionInfo.setQoqPeriod(qoqPeriodId);
        filterConditionInfo.setYoyPeriod(yoyPeriodId);
        filterConditionInfo.setMetricModel(this.getPageCache().get("scmdi_metric_cal_ito"));
        filterConditionInfo.setMetricModelWithGroup(this.getPageCache().get("scmdi_metric_cal_itogroup"));
        return filterConditionInfo;
    }

    public FilterConditionInfo getMaterialGroupFilterConditionInfo() {
        List<Long> groupIds;
        IDataModel model = this.getModel();
        DynamicObject calOrg = (DynamicObject)model.getValue("calorg");
        DynamicObject costAccount = (DynamicObject)model.getValue("costaccount");
        DynamicObject startPeriod = (DynamicObject)model.getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)model.getValue("endperiod");
        DynamicObject periodType = startPeriod.getDynamicObject("periodtype");
        QFilter periodFilter = new QFilter("periodtype", "=", (Object)periodType.getLong("id"));
        periodFilter.and(new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE));
        periodFilter.and("id", ">=", (Object)startPeriod.getLong("id"));
        periodFilter.and("id", "<=", (Object)endPeriod.getLong("id"));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])new QFilter[]{periodFilter}, (String)"periodyear asc,periodnumber asc");
        List<Long> periodId = coll.stream().map(period -> period.getLong("id")).collect(Collectors.toList());
        DynamicObject materialGroupStandard = (DynamicObject)model.getValue("materialgroupstandard");
        DynamicObjectCollection materialGroupFrom = (DynamicObjectCollection)model.getValue("mulmaterialgroup");
        DynamicObject materialGroupTo = (DynamicObject)model.getValue("materialgroupto");
        if (materialGroupFrom.size() == 1 && materialGroupTo != null) {
            DynamicObject from2 = ((DynamicObject)materialGroupFrom.get(0)).getDynamicObject(1);
            QFilter groupFilter = new QFilter("number", ">=", from2.get("number"));
            groupFilter.and(new QFilter("number", "<=", materialGroupTo.get("number")));
            groupFilter.and(new QFilter("standard", "=", materialGroupStandard.getPkValue()));
            Map materialGroupDetailMap = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroup", (String)"id,number,standard", (QFilter[])groupFilter.toArray());
            groupIds = materialGroupDetailMap.values().stream().map(groupDetail -> groupDetail.getLong("id")).collect(Collectors.toList());
        } else {
            groupIds = materialGroupFrom.stream().map(from -> from.getLong("fbasedataid.id")).collect(Collectors.toList());
        }
        FilterConditionInfo filterConditionInfo = new FilterConditionInfo();
        filterConditionInfo.setCalOrg(calOrg.getLong("id"));
        if (costAccount != null) {
            filterConditionInfo.setCostAccount(costAccount.getLong("id"));
        }
        filterConditionInfo.setMaterialGroupStandard(materialGroupStandard.getLong("id"));
        filterConditionInfo.setPeriod(periodId);
        filterConditionInfo.setMaterialGroup(groupIds);
        filterConditionInfo.setMetricModel(this.getPageCache().get("scmdi_metric_cal_ito"));
        filterConditionInfo.setMetricModelWithGroup(this.getPageCache().get("scmdi_metric_cal_itogroup"));
        return filterConditionInfo;
    }

    private void buildTurnDayTrendChart() {
        CustomChart turnDayChart = (CustomChart)this.getControl("turndaytrend");
        turnDayChart.addTooltip("trigger", (Object)"axis");
        HashMap<String, String> axisPointType = new HashMap<String, String>(1);
        axisPointType.put("type", "shadow");
        turnDayChart.addTooltip("axisPointer", axisPointType);
        turnDayChart.clearData();
        CombinationChartInfo turnOverDayTrendChartData = ItoChartDataService.getTurnOverDayTrendChartData(this.getFilterConditionInfo());
        this.setItoTrendChartAxisTick(turnDayChart, turnOverDayTrendChartData);
        this.setTurnDayChartData(turnDayChart, turnOverDayTrendChartData);
        turnDayChart.setLegendAlign(XAlign.right, YAlign.top);
        turnDayChart.setShowTitle(true);
        turnDayChart.setShowTooltip(true);
        turnDayChart.setShowLegend(true);
        turnDayChart.setLegendVertical(false);
        turnDayChart.refresh();
    }

    private void buildMaterialGroupBarChart() {
        DynamicObject materialGroupStandard = (DynamicObject)this.getModel().getValue("materialgroupstandard");
        if (materialGroupStandard == null) {
            HistogramChart barChart = (HistogramChart)this.getControl("histogramchartap");
            barChart.clearData();
            return;
        }
        HistogramChart barChart = (HistogramChart)this.getControl("histogramchartap");
        barChart.addTooltip("trigger", (Object)"axis");
        HashMap<String, String> axisPointType = new HashMap<String, String>(1);
        axisPointType.put("type", "line");
        barChart.addTooltip("axisPointer", axisPointType);
        barChart.clearData();
        BarChartInfo materialGroupItoChartData = ItoChartDataService.getMaterialGroupItoChartData(this.getMaterialGroupFilterConditionInfo());
        this.setChartXAxisTick(barChart, materialGroupItoChartData);
        this.setMaterialGroupBarChartData(barChart, materialGroupItoChartData);
        barChart.setShowTitle(true);
        barChart.setShowTooltip(true);
    }

    private void setChartXAxisTick(HistogramChart barChart, BarChartInfo materialGroupItoChartData) {
        Axis axis = barChart.createXAxis("", AxisType.category);
        List<String> periodAxis = materialGroupItoChartData.getPeriodAxis();
        List periodAxisColl = periodAxis.stream().map(x -> x != null && x.length() > 8 ? x.substring(0, 7) + "..." : x).collect(Collectors.toList());
        axis.setCategorys(periodAxisColl);
        axis.setPosition(Position.bottom);
        axis.setPropValue("nameGap", (Object)"10");
        HashMap<String, Object> axisTick = new HashMap<String, Object>(2);
        axisTick.put("interval", "0");
        axisTick.put("show", Boolean.TRUE);
        axis.setPropValue("axisTick", axisTick);
        HashMap<String, Comparable<Boolean>> axisLabel = new HashMap<String, Comparable<Boolean>>(2);
        axisLabel.put("show", Boolean.TRUE);
        axisLabel.put("interval", Integer.valueOf(0));
        axis.setPropValue("axisLabel", axisLabel);
        this.setLineColor(axis, "#999999");
    }

    private void setItoTrendChartAxisTick(CustomChart chart, CombinationChartInfo itoTrendChartData) {
        Axis axis = chart.createXAxis("", AxisType.category);
        List<String> periodAxis = itoTrendChartData.getPeriodAxis();
        axis.setCategorys(periodAxis);
        axis.setPosition(Position.bottom);
        axis.setPropValue("nameGap", (Object)"10");
        HashMap<String, Object> axisTick = new HashMap<String, Object>(2);
        axisTick.put("interval", "0");
        axisTick.put("show", Boolean.TRUE);
        axis.setPropValue("axisTick", axisTick);
        HashMap<String, Object> axisLabel = new HashMap<String, Object>(3);
        axisLabel.put("rotate", "30");
        axisLabel.put("show", Boolean.TRUE);
        axisLabel.put("interval", 0);
        axis.setPropValue("axisLabel", axisLabel);
        this.setLineColor(axis, "#999999");
    }

    private void setTurnDayChartData(CustomChart chart, CombinationChartInfo turnOverDayTrendChartData) {
        Axis barY = chart.createYAxis("", AxisType.value);
        barY.setPropValue("nameGap", (Object)"8");
        Map<String, BigDecimal[]> barChartData = turnOverDayTrendChartData.getBarChartData();
        int barChartIndex = 0;
        for (Map.Entry<String, BigDecimal[]> entry : barChartData.entrySet()) {
            String name = entry.getKey();
            BarSeries barSeries = chart.createBarSeries(name);
            barSeries.setBarWidth("20px");
            Number[] temp = entry.getValue();
            barSeries.setData(temp);
            barSeries.setColor(this.getBarChartColorList().get(barChartIndex));
            Label label = new Label();
            label.setShow(false);
            barSeries.setLabel(label);
            ++barChartIndex;
        }
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>(1);
        axisTick.put("show", Boolean.TRUE);
        barY.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap(1);
        HashMap<String, String> lineStyle = new HashMap<String, String>(2);
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#8A8B99");
        splitLine.put("lineStyle", lineStyle);
        barY.setPropValue("splitLine", splitLine);
        this.setLineColor(barY, "#8A8B99");
        HashMap<String, String> barAxisLabel = new HashMap<String, String>(1);
        barAxisLabel.put("formatter", "{value}");
        barY.setPropValue("axisLabel", barAxisLabel);
        Axis lineY = chart.createYAxis("", AxisType.value);
        lineY.setPropValue("nameGap", (Object)"8");
        lineY.setPropValue("show", (Object)Boolean.TRUE);
        lineY.setPropValue("axisTick", axisTick);
        lineY.setPropValue("splitLine", splitLine);
        this.setLineColor(lineY, "#8A8B99");
        HashMap<String, String> lineAxisLabel = new HashMap<String, String>(1);
        lineAxisLabel.put("formatter", "{value}%");
        lineY.setPropValue("axisLabel", lineAxisLabel);
        Map<String, BigDecimal[]> lineChartData = turnOverDayTrendChartData.getLineChartData();
        int lineChartIndex = 0;
        for (Map.Entry<String, BigDecimal[]> entry : lineChartData.entrySet()) {
            String name = entry.getKey();
            LineSeries lineSeries = chart.createLineSeries(name);
            lineSeries.setLineColor(this.getLineChartColorList().get(lineChartIndex));
            lineSeries.setItemColor(this.getLineChartColorList().get(lineChartIndex));
            Number[] temp = entry.getValue();
            lineSeries.setData(temp);
            lineSeries.setYAxisIndex(1);
            ++lineChartIndex;
        }
    }

    private void setMaterialGroupBarChartData(HistogramChart barChart, BarChartInfo materialGroupItoChartData) {
        String barChartName = materialGroupItoChartData.getBarChartName();
        Axis barY = barChart.createYAxis("", AxisType.value);
        barY.setPropValue("nameGap", (Object)"8");
        Number[] barChartData = materialGroupItoChartData.getBarChartData();
        BarSeries series = barChart.createSeries(barChartName);
        series.setData(barChartData);
        series.setBarWidth("20px");
        series.setColor("#1890FF");
    }

    private List<String> getBarChartColorList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("#1890FF");
        list.add("#45DAD1");
        return list;
    }

    private List<String> getLineChartColorList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("#26C9C3");
        list.add("#FFA940");
        return list;
    }

    private void setLineColor(Axis axis, String color) {
        HashMap axisLineMap = new HashMap(1);
        HashMap<String, String> lineStyleMap = new HashMap<String, String>(1);
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axis.setPropValue("axisLine", axisLineMap);
    }
}

