/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.plugin.form.itoanalysis;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.scmdi.business.helper.PeriodHelper;
import kd.scmc.scmdi.common.entity.DullMaterialFilterInfo;
import kd.scmc.scmdi.common.entity.FilterConditionInfo;
import kd.scmc.scmdi.common.entity.InvAgeFilterInfo;
import kd.scmc.scmdi.common.entity.LineChartInfo;
import kd.scmc.scmdi.common.entity.MaterialItoInfo;
import kd.scmc.scmdi.common.entity.StackedBarChartInfo;
import kd.scmc.scmdi.plugin.form.itoanalysis.AbstractItoAnalysisPlugin;
import kd.scmc.scmdi.service.mservices.ItoChartDataService;
import kd.scmc.scmdi.service.mservices.ItoEntryEntityDataService;
import org.apache.commons.lang3.StringUtils;

public class MaterialGroupItoAnalysisPlugin
extends AbstractItoAnalysisPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Chart chartAp = (Chart)this.getView().getControl("customchartap");
        chartAp.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{"vectorap"});
    }

    @Override
    public void buildFilterCondition() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        this.getModel().setValue("calorg", formShowParameter.getCustomParam("calorg"));
        this.getModel().setValue("startperiod", formShowParameter.getCustomParam("startperiod"));
        this.getModel().setValue("endperiod", formShowParameter.getCustomParam("endperiod"));
        this.getModel().setValue("costaccount", formShowParameter.getCustomParam("costaccount"));
        this.getModel().setValue("materialgroupstandard", formShowParameter.getCustomParam("materialgroupstandard"));
        List materialGroupFrom = (List)formShowParameter.getCustomParam("mulmaterialgroup");
        this.getModel().setValue("mulmaterialgroup", (Object)materialGroupFrom.toArray());
        this.getModel().setValue("materialgroupto", formShowParameter.getCustomParam("materialgroupto"));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.initInvAgeGroup();
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.buildSaleAndInvCostBubbleChart();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "materialgroupstandard": 
            case "mulmaterialgroup": 
            case "materialgroupto": {
                this.buildChart();
                break;
            }
            case "checkboxfield": {
                this.buildEntryEntity();
                break;
            }
            case "dulldays": 
            case "dulltype": {
                this.buildMaterialDullBarChart();
                this.getView().updateView("histogramchartap");
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String opKey = source.getKey();
        if ("customchartap".equals(opKey)) {
            String labelName = ((ChartClickEvent)evt).getName();
            if (labelName == null) {
                return;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("scmdi_ito_material");
            this.buildChartCustomParam(formShowParameter, labelName);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(formShowParameter);
        } else if ("vectorap".equals(opKey)) {
            this.buildMaterialAgePieChart();
            this.getView().updateView("piechartap");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("donothing".equals(operateKey)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("scmdi_ito_material");
            EntryGrid entryControl = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectRows = entryControl.getSelectRows();
            DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(selectRows[0]);
            DynamicObject material = entry.getDynamicObject("material");
            this.buildCustomParam(formShowParameter, material);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(formShowParameter);
        }
    }

    private void buildCustomParam(FormShowParameter formShowParameter, DynamicObject material) {
        DynamicObject materialGroupTo;
        DynamicObjectCollection materialGroupFrom;
        DynamicObject materialGroupStandard;
        DynamicObject costAccount;
        DynamicObject endPeriod;
        DynamicObject startPeriod;
        HashMap<String, Object> customParam = new HashMap<String, Object>(7);
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        if (calOrg != null) {
            customParam.put("calorg", calOrg.getPkValue());
        }
        if ((startPeriod = (DynamicObject)this.getModel().getValue("startperiod")) != null) {
            customParam.put("startperiod", startPeriod.getPkValue());
        }
        if ((endPeriod = (DynamicObject)this.getModel().getValue("endperiod")) != null) {
            customParam.put("endperiod", endPeriod.getPkValue());
        }
        if ((costAccount = (DynamicObject)this.getModel().getValue("costaccount")) != null) {
            customParam.put("costaccount", costAccount.getPkValue());
        }
        if ((materialGroupStandard = (DynamicObject)this.getModel().getValue("materialgroupstandard")) != null) {
            customParam.put("materialgroupstandard", materialGroupStandard.getPkValue());
        }
        if ((materialGroupFrom = (DynamicObjectCollection)this.getModel().getValue("mulmaterialgroup")) != null) {
            List ids = materialGroupFrom.stream().map(from -> from.getLong("fbasedataid.id")).collect(Collectors.toList());
            customParam.put("mulmaterialgroup", ids);
        }
        if ((materialGroupTo = (DynamicObject)this.getModel().getValue("materialgroupto")) != null) {
            customParam.put("materialgroupto", materialGroupTo.getPkValue());
        }
        if (material != null) {
            customParam.put("material", Collections.singletonList((Long)material.getPkValue()));
        }
        formShowParameter.setCustomParams(customParam);
    }

    private void buildChartCustomParam(FormShowParameter formShowParameter, String materialName) {
        DynamicObject materialGroupTo;
        DynamicObjectCollection materialGroupFrom;
        DynamicObject materialGroupStandard;
        DynamicObject costAccount;
        DynamicObject endPeriod;
        DynamicObject startPeriod;
        HashMap<String, Object> customParam = new HashMap<String, Object>(7);
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        if (calOrg != null) {
            customParam.put("calorg", calOrg.getPkValue());
        }
        if ((startPeriod = (DynamicObject)this.getModel().getValue("startperiod")) != null) {
            customParam.put("startperiod", startPeriod.getPkValue());
        }
        if ((endPeriod = (DynamicObject)this.getModel().getValue("endperiod")) != null) {
            customParam.put("endperiod", endPeriod.getPkValue());
        }
        if ((costAccount = (DynamicObject)this.getModel().getValue("costaccount")) != null) {
            customParam.put("costaccount", costAccount.getPkValue());
        }
        if ((materialGroupStandard = (DynamicObject)this.getModel().getValue("materialgroupstandard")) != null) {
            customParam.put("materialgroupstandard", materialGroupStandard.getPkValue());
            QFilter qFilter = new QFilter("standard", "=", materialGroupStandard.getPkValue());
            qFilter.and(new QFilter("material.name", "=", (Object)materialName));
            DynamicObject materialGroupDetail = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialgroupdetail", (QFilter[])new QFilter[]{qFilter});
            DynamicObject material = materialGroupDetail.getDynamicObject("material");
            customParam.put("material", Collections.singletonList((Long)material.getPkValue()));
        }
        if ((materialGroupFrom = (DynamicObjectCollection)this.getModel().getValue("mulmaterialgroup")) != null && !materialGroupFrom.isEmpty()) {
            List groupIds = materialGroupFrom.stream().map(mg -> mg.getLong("fbasedataid.id")).collect(Collectors.toList());
            customParam.put("mulmaterialgroup", groupIds);
        }
        if ((materialGroupTo = (DynamicObject)this.getModel().getValue("materialgroupto")) != null) {
            customParam.put("materialgroupto", materialGroupTo.getPkValue());
        }
        formShowParameter.setCustomParams(customParam);
    }

    private void initInvAgeGroup() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("ageentry");
        DynamicObjectType entryEntityType = entryEntity.getDynamicObjectType();
        DynamicObject entry1 = new DynamicObject(entryEntityType);
        entry1.set("agename", (Object)ResManager.loadKDString((String)"0\u52306\u5929", (String)"MaterialGroupItoAnalysisPlugin_14", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
        entry1.set("ageval", (Object)7);
        entryEntity.add((Object)entry1);
        DynamicObject entry2 = new DynamicObject(entryEntityType);
        entry2.set("agename", (Object)ResManager.loadKDString((String)"7\u523013\u5929", (String)"MaterialGroupItoAnalysisPlugin_7", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
        entry2.set("ageval", (Object)7);
        entryEntity.add((Object)entry2);
        DynamicObject entry3 = new DynamicObject(entryEntityType);
        entry3.set("agename", (Object)ResManager.loadKDString((String)"14\u523020\u5929", (String)"MaterialGroupItoAnalysisPlugin_8", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
        entry3.set("ageval", (Object)7);
        entryEntity.add((Object)entry3);
        DynamicObject entry4 = new DynamicObject(entryEntityType);
        entry4.set("agename", (Object)ResManager.loadKDString((String)"21\u5929\u53ca\u4ee5\u4e0a", (String)"MaterialGroupItoAnalysisPlugin_9", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
        entry4.set("ageval", null);
        entryEntity.add((Object)entry4);
        this.getModel().updateEntryCache(entryEntity);
        this.getView().updateView("ageentry");
    }

    @Override
    public void buildChart() {
        super.buildChart();
        this.buildSaleCostAndQtyChart();
        this.buildInvCostAndQtyChart();
        this.buildMaterialAgePieChart();
        this.buildMaterialDullBarChart();
    }

    @Override
    public FilterConditionInfo getFilterConditionInfo() {
        List<Object> groupIds;
        IDataModel model = this.getModel();
        DynamicObject calOrg = (DynamicObject)model.getValue("calorg");
        DynamicObject costAccount = (DynamicObject)model.getValue("costaccount");
        DynamicObject startPeriod = (DynamicObject)model.getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)model.getValue("endperiod");
        Map<Object, DynamicObject> coll = PeriodHelper.getCollByStartPeriodAndEndPeriod(startPeriod, endPeriod);
        List<Long> periodId = coll.values().stream().map(period -> period.getLong("id")).collect(Collectors.toList());
        List<String> periodName = coll.values().stream().map(period -> period.getString("name")).collect(Collectors.toList());
        Map<String, DynamicObject> qoqPeriod = PeriodHelper.getQOQPeriod(startPeriod, endPeriod);
        Map<Object, DynamicObject> qoqColl = PeriodHelper.getCollByStartPeriodAndEndPeriod(qoqPeriod.get("startPeriod"), qoqPeriod.get("endPeriod"));
        List<Long> qoqPeriodId = qoqColl.values().stream().map(period -> period.getLong("id")).collect(Collectors.toList());
        Map<String, DynamicObject> yoyPeriod = PeriodHelper.getYOYPeriod(startPeriod, endPeriod);
        Map<Object, DynamicObject> yoyColl = PeriodHelper.getCollByStartPeriodAndEndPeriod(yoyPeriod.get("startPeriod"), yoyPeriod.get("endPeriod"));
        List<Long> yoyPeriodId = yoyColl.values().stream().map(period -> period.getLong("id")).collect(Collectors.toList());
        DynamicObject materialGroupStandard = (DynamicObject)model.getValue("materialgroupstandard");
        DynamicObjectCollection materialGroupFrom = (DynamicObjectCollection)model.getValue("mulmaterialgroup");
        if (materialGroupFrom.size() == 1) {
            DynamicObject materialGroupTo = (DynamicObject)model.getValue("materialgroupto");
            DynamicObject from2 = ((DynamicObject)materialGroupFrom.get(0)).getDynamicObject(1);
            if (materialGroupTo == null) {
                groupIds = Collections.singletonList(from2.getLong("id"));
            } else {
                QFilter groupFilter = new QFilter("number", ">=", from2.get("number"));
                groupFilter.and(new QFilter("number", "<=", materialGroupTo.get("number")));
                groupFilter.and(new QFilter("standard", "=", materialGroupStandard.getPkValue()));
                Map materialGroupDetailMap = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroup", (String)"id,standard,number", (QFilter[])groupFilter.toArray());
                groupIds = materialGroupDetailMap.values().stream().map(groupDetail -> groupDetail.getLong("id")).collect(Collectors.toList());
            }
        } else {
            groupIds = materialGroupFrom.stream().map(from -> from.getLong("fbasedataid.id")).collect(Collectors.toList());
        }
        FilterConditionInfo filterConditionInfo = new FilterConditionInfo();
        filterConditionInfo.setCalOrg(calOrg.getLong("id"));
        if (costAccount != null) {
            filterConditionInfo.setCostAccount(costAccount.getLong("id"));
        }
        filterConditionInfo.setPeriod(periodId);
        filterConditionInfo.setPeriodName(periodName);
        filterConditionInfo.setQoqPeriod(qoqPeriodId);
        filterConditionInfo.setYoyPeriod(yoyPeriodId);
        filterConditionInfo.setMaterialGroupStandard(materialGroupStandard.getLong("id"));
        filterConditionInfo.setMaterialGroup(groupIds);
        filterConditionInfo.setMetricModel(this.getPageCache().get("scmdi_metric_cal_ito"));
        filterConditionInfo.setMetricModelWithGroup(this.getPageCache().get("scmdi_metric_cal_itogroup"));
        return filterConditionInfo;
    }

    private InvAgeFilterInfo getMaterialAgeFilter() {
        IDataModel model = this.getModel();
        InvAgeFilterInfo invAgeFilterInfo = new InvAgeFilterInfo();
        invAgeFilterInfo.setCalOrg((DynamicObject)model.getValue("calorg"));
        invAgeFilterInfo.setMaterialGroupStandard((DynamicObject)model.getValue("materialgroupstandard"));
        invAgeFilterInfo.setMaterialGroupFrom((DynamicObjectCollection)model.getValue("mulmaterialgroup"));
        invAgeFilterInfo.setMaterialGroupTo((DynamicObject)model.getValue("materialgroupto"));
        DynamicObject endPeriod = (DynamicObject)model.getValue("endperiod");
        Date enddate = endPeriod.getDate("enddate");
        invAgeFilterInfo.setEndDate(enddate);
        DynamicObjectCollection entryEntity = model.getEntryEntity("ageentry");
        ArrayList<Integer> intervalDays = new ArrayList<Integer>(32);
        for (DynamicObject entry : entryEntity) {
            int day = entry.getInt("ageval");
            intervalDays.add(day);
        }
        String ageVal = StringUtils.join(intervalDays, (String)",");
        invAgeFilterInfo.setIntervalDays(ageVal);
        int size = entryEntity.size();
        ArrayList<String> groupList = new ArrayList<String>(size);
        int end = 0;
        for (DynamicObject entry : entryEntity) {
            int day = entry.getInt("ageval");
            int start = end;
            end = day + end;
            if (day <= 0) break;
            String msg = ResManager.loadKDString((String)"%s-%s\u5929", (String)"MaterialGroupItoAnalysisPlugin_19", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]);
            groupList.add(String.format(msg, start, end - 1));
        }
        String msg = ResManager.loadKDString((String)"%s\u5929\u53ca\u4ee5\u4e0a", (String)"MaterialGroupItoAnalysisPlugin_20", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]);
        groupList.add(String.format(msg, end));
        invAgeFilterInfo.setInvAgeGroup(groupList);
        return invAgeFilterInfo;
    }

    private DullMaterialFilterInfo getDullMaterialFilter() {
        IDataModel model = this.getModel();
        DullMaterialFilterInfo dullMaterialFilterInfo = new DullMaterialFilterInfo();
        dullMaterialFilterInfo.setCalOrg((DynamicObject)model.getValue("calorg"));
        dullMaterialFilterInfo.setCostAccount((DynamicObject)model.getValue("costaccount"));
        dullMaterialFilterInfo.setMaterialGroupStandard((DynamicObject)model.getValue("materialgroupstandard"));
        dullMaterialFilterInfo.setMaterialGroupFrom((DynamicObjectCollection)model.getValue("mulmaterialgroup"));
        dullMaterialFilterInfo.setMaterialGroupTo((DynamicObject)model.getValue("materialgroupto"));
        dullMaterialFilterInfo.setDullDays((Integer)model.getValue("dulldays"));
        dullMaterialFilterInfo.setDullType((String)model.getValue("dulltype"));
        DynamicObject startPeriod = (DynamicObject)model.getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)model.getValue("endperiod");
        Map<Object, DynamicObject> coll = PeriodHelper.getCollByStartPeriodAndEndPeriod(startPeriod, endPeriod);
        List<Date> enddateColl = coll.values().stream().map(period -> period.getDate("enddate")).collect(Collectors.toList());
        dullMaterialFilterInfo.setEndDateColl(enddateColl);
        dullMaterialFilterInfo.setPeriod(coll);
        dullMaterialFilterInfo.setMetricModelWithGroup(this.getPageCache().get("scmdi_metric_cal_itogroup"));
        return dullMaterialFilterInfo;
    }

    @Override
    public void buildEntryEntity() {
        this.getModel().deleteEntryData("entryentity");
        boolean zeroShow = (Boolean)this.getModel().getValue("checkboxfield");
        List<MaterialItoInfo> materialEntryEntityData = ItoEntryEntityDataService.getMaterialEntryEntityData(this.getFilterConditionInfo(), zeroShow);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObjectType entryEntityType = entryEntity.getDynamicObjectType();
        for (MaterialItoInfo materialItoInfo : materialEntryEntityData) {
            DynamicObject entry = new DynamicObject(entryEntityType);
            entry.set("materialgroup", (Object)materialItoInfo.getMaterialGroup());
            entry.set("material", (Object)materialItoInfo.getMaterial());
            entry.set("salecost", (Object)materialItoInfo.getSaleCost());
            entry.set("inventorycost", (Object)materialItoInfo.getInventoryCost());
            entry.set("turnrate", (Object)materialItoInfo.getTurnRate());
            entry.set("turndays", (Object)materialItoInfo.getTurnDays());
            entry.set("currency", (Object)materialItoInfo.getCurrency());
            entryEntity.add((Object)entry);
        }
        this.getModel().updateEntryCache(entryEntity);
        this.getView().updateView("entryentity");
    }

    private void buildSaleCostAndQtyChart() {
        PointLineChart saleLineChart = (PointLineChart)this.getControl("pointlinechartap");
        saleLineChart.addTooltip("trigger", (Object)"axis");
        HashMap<String, String> axisPointType = new HashMap<String, String>(1);
        axisPointType.put("type", "shadow");
        saleLineChart.addTooltip("axisPointer", axisPointType);
        saleLineChart.clearData();
        saleLineChart.setMargin(Position.left, "5%");
        LineChartInfo saleCostAndQtyChartData = ItoChartDataService.getSaleCostAndQtyChartData(this.getFilterConditionInfo());
        this.setCostAndQtyLineChartAxisTick(saleLineChart, saleCostAndQtyChartData);
        this.serCostAndQtyLineChartData(saleLineChart, saleCostAndQtyChartData);
        saleLineChart.setLegendAlign(XAlign.right, YAlign.top);
        saleLineChart.setShowTitle(true);
        saleLineChart.setShowTooltip(true);
        saleLineChart.setShowLegend(true);
        saleLineChart.setLegendVertical(false);
        saleLineChart.refresh();
    }

    private void buildInvCostAndQtyChart() {
        PointLineChart invLineChart = (PointLineChart)this.getControl("pointlinechartap1");
        invLineChart.addTooltip("trigger", (Object)"axis");
        HashMap<String, String> axisPointType = new HashMap<String, String>(1);
        axisPointType.put("type", "shadow");
        invLineChart.addTooltip("axisPointer", axisPointType);
        invLineChart.clearData();
        invLineChart.setMargin(Position.left, "5%");
        LineChartInfo invCostAndQtyChartData = ItoChartDataService.getInvCostAndQtyChartData(this.getFilterConditionInfo());
        this.setCostAndQtyLineChartAxisTick(invLineChart, invCostAndQtyChartData);
        this.serCostAndQtyLineChartData(invLineChart, invCostAndQtyChartData);
        invLineChart.setLegendAlign(XAlign.right, YAlign.top);
        invLineChart.setShowTitle(true);
        invLineChart.setShowTooltip(true);
        invLineChart.setShowLegend(true);
        invLineChart.setLegendVertical(false);
        invLineChart.refresh();
    }

    private void buildMaterialAgePieChart() {
        PieChart itoChart = (PieChart)this.getControl("piechartap");
        itoChart.addTooltip("trigger", (Object)"item");
        HashMap<String, String> axisPointType = new HashMap<String, String>(1);
        axisPointType.put("type", "shadow");
        itoChart.addTooltip("axisPointer", axisPointType);
        itoChart.clearData();
        PieSeries pieSeries = itoChart.createPieSeries("");
        ItemValue[] pieChartData = ItoChartDataService.getInvAgeChartData(this.getMaterialAgeFilter());
        pieSeries.setData(pieChartData);
        pieSeries.setRadius("50%", "70%");
        Label label = new Label();
        label.setShow(false);
        pieSeries.setLabel(label);
        itoChart.setLegendAlign(XAlign.right, YAlign.center);
        itoChart.setLegendVertical(true);
        itoChart.setShowTooltip(true);
        itoChart.setShowLegend(true);
        itoChart.refresh();
    }

    private void buildMaterialDullBarChart() {
        HistogramChart dullBarChart = (HistogramChart)this.getControl("histogramchartap");
        dullBarChart.addTooltip("trigger", (Object)"axis");
        HashMap<String, String> axisPointType = new HashMap<String, String>(1);
        axisPointType.put("type", "shadow");
        dullBarChart.addTooltip("axisPointer", axisPointType);
        dullBarChart.clearData();
        StackedBarChartInfo invDullChartData = ItoChartDataService.getInvDullChartData(this.getDullMaterialFilter());
        this.setDullBarChartAxis(dullBarChart, invDullChartData);
        this.setDullBarChartData(dullBarChart, invDullChartData);
        dullBarChart.setLegendAlign(XAlign.center, YAlign.top);
        dullBarChart.setShowTooltip(true);
        dullBarChart.setShowLegend(true);
        dullBarChart.setLegendVertical(false);
        dullBarChart.refresh();
    }

    private void buildSaleAndInvCostBubbleChart() {
        Control customChart = this.getControl("customchartap");
        HashMap<String, Cloneable> result = new HashMap<String, Cloneable>(3);
        ArrayList seriesList = new ArrayList();
        HashMap<String, Object> seriesMap = new HashMap<String, Object>(3);
        HashMap<String, String> titleMap = new HashMap<String, String>(1);
        titleMap.put("text", ResManager.loadKDString((String)"\u9500\u552e&\u5e93\u5b58\u6210\u672c\u5f71\u54cd\u5206\u6790", (String)"MaterialGroupItoAnalysisPlugin_15", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
        result.put("title", titleMap);
        boolean zeroShow = (Boolean)this.getModel().getValue("checkboxfield");
        List<Object[]> saleAndInvCostChartData = ItoChartDataService.getSaleAndInvCostChartData(this.getFilterConditionInfo(), zeroShow);
        seriesMap.put("data", saleAndInvCostChartData);
        seriesMap.put("symbolSize", "function (data) { return data[2]; }");
        seriesMap.put("type", "scatter");
        seriesList.add(seriesMap);
        result.put("series", seriesList);
        HashMap<String, String> xAxisMap = new HashMap<String, String>(1);
        xAxisMap.put("name", ResManager.loadKDString((String)"\u5e93\u5b58\u6210\u672c", (String)"MaterialGroupItoAnalysisPlugin_17", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
        HashMap<String, String> yAxisMap = new HashMap<String, String>(1);
        yAxisMap.put("name", ResManager.loadKDString((String)"\u9500\u552e\u6210\u672c", (String)"MaterialGroupItoAnalysisPlugin_16", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
        result.put("xAxis", xAxisMap);
        result.put("yAxis", yAxisMap);
        HashMap<String, String> gridMap = new HashMap<String, String>(1);
        gridMap.put("right", "10%");
        result.put("grid", gridMap);
        HashMap<String, String> tooltipMap = new HashMap<String, String>(1);
        tooltipMap.put("trigger", "item");
        tooltipMap.put("formatter", "function (data) {return data.value[3] + '<br>'+'" + ResManager.loadKDString((String)"\u9500\u552e\u6210\u672c", (String)"MaterialGroupItoAnalysisPlugin_16", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]) + "\uff1a'+data.value[1] + '<br>'+'" + ResManager.loadKDString((String)"\u5e93\u5b58\u6210\u672c", (String)"MaterialGroupItoAnalysisPlugin_17", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]) + "\uff1a'+data.value[0] + '<br>'+'" + ResManager.loadKDString((String)"\u5e93\u5b58\u5468\u8f6c\u7387", (String)"MaterialGroupItoAnalysisPlugin_18", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]) + "\uff1a'+data.value[2] + '<br>';}");
        result.put("tooltip", tooltipMap);
        ArrayList funcPaths = new ArrayList(10);
        ArrayList<Object> funPatch = new ArrayList<Object>();
        funPatch.add("series");
        funPatch.add(0);
        funPatch.add("symbolSize");
        ArrayList<String> funPatch1 = new ArrayList<String>();
        funPatch1.add("tooltip");
        funPatch1.add("formatter");
        funcPaths.add(funPatch);
        funcPaths.add(funPatch1);
        result.put("functions", funcPaths);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.setFieldProperty(customChart.getKey(), "data", result);
    }

    private void setCostAndQtyLineChartAxisTick(PointLineChart saleLineChart, LineChartInfo saleCostAndQtyChartData) {
        Axis axis = saleLineChart.createXAxis("", AxisType.category);
        List<String> periodAxis = saleCostAndQtyChartData.getPeriodAxis();
        axis.setCategorys(periodAxis);
        axis.setPosition(Position.bottom);
        axis.setPropValue("nameGap", (Object)"10");
        HashMap<String, Object> axisTick = new HashMap<String, Object>(2);
        axisTick.put("interval", "0");
        axisTick.put("show", Boolean.TRUE);
        axis.setPropValue("axisTick", axisTick);
        HashMap<String, Object> axisLabel = new HashMap<String, Object>(3);
        axisLabel.put("rotate", "30");
        axisLabel.put("show", Boolean.TRUE);
        axisLabel.put("interval", 0);
        axis.setPropValue("axisLabel", axisLabel);
        this.setLineColor(axis, "#999999");
    }

    private void serCostAndQtyLineChartData(PointLineChart saleLineChart, LineChartInfo saleCostAndQtyChartData) {
        Axis costY = saleLineChart.createYAxis(saleCostAndQtyChartData.getFirstLineChartName(), AxisType.value);
        costY.setPropValue("nameGap", (Object)"8");
        Number[] costLineChartData = saleCostAndQtyChartData.getFirstLineChartData();
        LineSeries costLineSeries = saleLineChart.createLineSeries(saleCostAndQtyChartData.getFirstLineChartName());
        costLineSeries.setData(costLineChartData);
        costLineSeries.setLineColor("#40A9FF");
        Label label = new Label();
        label.setShow(false);
        costLineSeries.setLabel(label);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>(1);
        axisTick.put("show", Boolean.TRUE);
        costY.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap(1);
        HashMap<String, String> lineStyle = new HashMap<String, String>(2);
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#8A8B99");
        splitLine.put("lineStyle", lineStyle);
        costY.setPropValue("splitLine", splitLine);
        this.setLineColor(costY, "#8A8B99");
        HashMap<String, String> costAxisLabel = new HashMap<String, String>(1);
        costAxisLabel.put("formatter", "{value}");
        costY.setPropValue("axisLabel", costAxisLabel);
    }

    private void setDullBarChartAxis(HistogramChart dullBarChart, StackedBarChartInfo invDullChartData) {
        Axis axis = dullBarChart.createXAxis("", AxisType.category);
        List<String> periodAxis = invDullChartData.getPeriodAxis();
        axis.setCategorys(periodAxis);
        axis.setPosition(Position.bottom);
        axis.setPropValue("nameGap", (Object)"10");
        HashMap<String, Object> axisTick = new HashMap<String, Object>(2);
        axisTick.put("interval", "0");
        axisTick.put("show", Boolean.TRUE);
        axis.setPropValue("axisTick", axisTick);
        HashMap<String, Object> axisLabel = new HashMap<String, Object>(3);
        axisLabel.put("rotate", "45");
        axisLabel.put("show", Boolean.TRUE);
        axisLabel.put("interval", 0);
        axis.setPropValue("axisLabel", axisLabel);
        this.setLineColor(axis, "#999999");
    }

    private void setDullBarChartData(HistogramChart dullBarChart, StackedBarChartInfo invDullChartData) {
        Axis barY = dullBarChart.createYAxis("", AxisType.value);
        barY.setPropValue("nameGap", (Object)"8");
        Map<String, BigDecimal[]> barChartData = invDullChartData.getBarChartData();
        int barChartIndex = 0;
        for (Map.Entry<String, BigDecimal[]> entry : barChartData.entrySet()) {
            String name = entry.getKey();
            BarSeries barSeries = dullBarChart.createBarSeries(name);
            barSeries.setBarWidth("20px");
            Number[] temp = entry.getValue();
            barSeries.setStack("Ad");
            barSeries.setData(temp);
            barSeries.setColor(this.getBarChartColorList().get(barChartIndex));
            Label label = new Label();
            label.setShow(false);
            barSeries.setLabel(label);
            ++barChartIndex;
        }
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>(1);
        axisTick.put("show", Boolean.TRUE);
        barY.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap(1);
        HashMap<String, String> lineStyle = new HashMap<String, String>(2);
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#8A8B99");
        splitLine.put("lineStyle", lineStyle);
        barY.setPropValue("splitLine", splitLine);
        this.setLineColor(barY, "#8A8B99");
        HashMap<String, String> barAxisLabel = new HashMap<String, String>(1);
        barAxisLabel.put("formatter", "{value}%");
        barY.setPropValue("axisLabel", barAxisLabel);
    }

    private List<String> getBarChartColorList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("#1890FF");
        list.add("#45DAD1");
        return list;
    }

    private void setLineColor(Axis axis, String color) {
        HashMap axisLineMap = new HashMap(1);
        HashMap<String, String> lineStyleMap = new HashMap<String, String>(1);
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axis.setPropValue("axisLine", axisLineMap);
    }
}

