/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.plugin.form.itoanalysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.scmdi.business.helper.PeriodHelper;
import kd.scmc.scmdi.common.entity.DullMaterialFilterInfo;
import kd.scmc.scmdi.common.entity.FilterConditionInfo;
import kd.scmc.scmdi.common.entity.InvAgeFilterInfo;
import kd.scmc.scmdi.common.entity.LineChartInfo;
import kd.scmc.scmdi.common.entity.MaterialItoInfo;
import kd.scmc.scmdi.plugin.form.itoanalysis.AbstractItoAnalysisPlugin;
import kd.scmc.scmdi.service.mservices.ItoChartDataService;
import kd.scmc.scmdi.service.mservices.ItoEntryEntityDataService;
import org.apache.commons.lang3.StringUtils;

public class MaterialItoAnalysisPlugin
extends AbstractItoAnalysisPlugin
implements BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "material");
        this.addClickListeners(new String[]{"vectorap"});
    }

    @Override
    public void buildFilterCondition() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        this.getModel().setValue("calorg", formShowParameter.getCustomParam("calorg"));
        this.getModel().setValue("startperiod", formShowParameter.getCustomParam("startperiod"));
        this.getModel().setValue("endperiod", formShowParameter.getCustomParam("endperiod"));
        this.getModel().setValue("costaccount", formShowParameter.getCustomParam("costaccount"));
        this.getModel().setValue("materialgroupstandard", formShowParameter.getCustomParam("materialgroupstandard"));
        List materialGroupFrom = (List)formShowParameter.getCustomParam("mulmaterialgroup");
        this.getModel().setValue("mulmaterialgroup", (Object)materialGroupFrom.toArray());
        this.getModel().setValue("materialgroupto", formShowParameter.getCustomParam("materialgroupto"));
        List material = (List)formShowParameter.getCustomParam("material");
        this.getModel().setValue("material", (Object)material.toArray());
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.initInvAgeGroup();
        super.afterCreateNewData(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String opKey = source.getKey();
        if ("vectorap".equals(opKey)) {
            this.buildMaterialAgePieChart();
            this.getView().updateView("piechartap");
        }
    }

    private void initInvAgeGroup() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("ageentry");
        DynamicObjectType entryEntityType = entryEntity.getDynamicObjectType();
        DynamicObject entry1 = new DynamicObject(entryEntityType);
        entry1.set("agename", (Object)ResManager.loadKDString((String)"0\u52306\u5929", (String)"MaterialGroupItoAnalysisPlugin_14", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
        entry1.set("ageval", (Object)7);
        entryEntity.add((Object)entry1);
        DynamicObject entry2 = new DynamicObject(entryEntityType);
        entry2.set("agename", (Object)ResManager.loadKDString((String)"7\u523013\u5929", (String)"MaterialGroupItoAnalysisPlugin_14", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
        entry2.set("ageval", (Object)7);
        entryEntity.add((Object)entry2);
        DynamicObject entry3 = new DynamicObject(entryEntityType);
        entry3.set("agename", (Object)ResManager.loadKDString((String)"14\u523020\u5929", (String)"MaterialGroupItoAnalysisPlugin_14", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
        entry3.set("ageval", (Object)7);
        entryEntity.add((Object)entry3);
        DynamicObject entry4 = new DynamicObject(entryEntityType);
        entry4.set("agename", (Object)ResManager.loadKDString((String)"21\u5929\u53ca\u4ee5\u4e0a", (String)"MaterialGroupItoAnalysisPlugin_14", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
        entry4.set("ageval", null);
        entryEntity.add((Object)entry4);
        this.getModel().updateEntryCache(entryEntity);
        this.getView().updateView("ageentry");
    }

    @Override
    public void buildChart() {
        super.buildChart();
        this.buildSaleCostAndQtyChart();
        this.buildInvCostAndQtyChart();
        this.buildMaterialAgePieChart();
    }

    @Override
    public FilterConditionInfo getFilterConditionInfo() {
        List<Object> groupIds;
        IDataModel model = this.getModel();
        DynamicObject calOrg = (DynamicObject)model.getValue("calorg");
        DynamicObject costAccount = (DynamicObject)model.getValue("costaccount");
        DynamicObject startPeriod = (DynamicObject)model.getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)model.getValue("endperiod");
        Map<Object, DynamicObject> coll = PeriodHelper.getCollByStartPeriodAndEndPeriod(startPeriod, endPeriod);
        List<Long> periodId = coll.values().stream().map(period -> period.getLong("id")).collect(Collectors.toList());
        List<String> periodName = coll.values().stream().map(period -> period.getString("name")).collect(Collectors.toList());
        Map<String, DynamicObject> qoqPeriod = PeriodHelper.getQOQPeriod(startPeriod, endPeriod);
        Map<Object, DynamicObject> qoqColl = PeriodHelper.getCollByStartPeriodAndEndPeriod(qoqPeriod.get("startPeriod"), qoqPeriod.get("endPeriod"));
        List<Long> qoqPeriodId = qoqColl.values().stream().map(period -> period.getLong("id")).collect(Collectors.toList());
        Map<String, DynamicObject> yoyPeriod = PeriodHelper.getYOYPeriod(startPeriod, endPeriod);
        Map<Object, DynamicObject> yoyColl = PeriodHelper.getCollByStartPeriodAndEndPeriod(yoyPeriod.get("startPeriod"), yoyPeriod.get("endPeriod"));
        List<Long> yoyPeriodId = yoyColl.values().stream().map(period -> period.getLong("id")).collect(Collectors.toList());
        DynamicObject materialGroupStandard = (DynamicObject)model.getValue("materialgroupstandard");
        DynamicObjectCollection materialGroupFrom = (DynamicObjectCollection)model.getValue("mulmaterialgroup");
        if (materialGroupFrom.size() == 1) {
            DynamicObject materialGroupTo = (DynamicObject)model.getValue("materialgroupto");
            DynamicObject from2 = ((DynamicObject)materialGroupFrom.get(0)).getDynamicObject(1);
            if (materialGroupTo == null) {
                groupIds = Collections.singletonList(from2.getLong("id"));
            } else {
                QFilter groupFilter = new QFilter("number", ">=", from2.get("number"));
                groupFilter.and(new QFilter("number", "<=", materialGroupTo.get("number")));
                groupFilter.and(new QFilter("standard", "=", materialGroupStandard.getPkValue()));
                Map materialGroupDetailMap = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroup", (String)"id,standard,number", (QFilter[])groupFilter.toArray());
                groupIds = materialGroupDetailMap.values().stream().map(groupDetail -> groupDetail.getLong("id")).collect(Collectors.toList());
            }
        } else {
            groupIds = materialGroupFrom.stream().map(from -> from.getLong("fbasedataid.id")).collect(Collectors.toList());
        }
        DynamicObjectCollection material = (DynamicObjectCollection)model.getValue("material");
        List<Long> materialId = material.stream().map(from -> from.getLong("fbasedataid.id")).collect(Collectors.toList());
        FilterConditionInfo filterConditionInfo = new FilterConditionInfo();
        filterConditionInfo.setCalOrg(calOrg.getLong("id"));
        if (costAccount != null) {
            filterConditionInfo.setCostAccount(costAccount.getLong("id"));
        }
        filterConditionInfo.setPeriod(periodId);
        filterConditionInfo.setPeriodName(periodName);
        filterConditionInfo.setQoqPeriod(qoqPeriodId);
        filterConditionInfo.setYoyPeriod(yoyPeriodId);
        filterConditionInfo.setMaterialGroupStandard(materialGroupStandard.getLong("id"));
        filterConditionInfo.setMaterialGroup(groupIds);
        filterConditionInfo.setMaterial(materialId);
        filterConditionInfo.setMetricModel(this.getPageCache().get("scmdi_metric_cal_ito"));
        filterConditionInfo.setMetricModelWithGroup(this.getPageCache().get("scmdi_metric_cal_itogroup"));
        return filterConditionInfo;
    }

    private InvAgeFilterInfo getMaterialAgeFilter() {
        IDataModel model = this.getModel();
        InvAgeFilterInfo invAgeFilterInfo = new InvAgeFilterInfo();
        invAgeFilterInfo.setCalOrg((DynamicObject)model.getValue("calorg"));
        invAgeFilterInfo.setMaterialGroupStandard((DynamicObject)model.getValue("materialgroupstandard"));
        invAgeFilterInfo.setMaterialGroupFrom((DynamicObjectCollection)model.getValue("mulmaterialgroup"));
        invAgeFilterInfo.setMaterialGroupTo((DynamicObject)model.getValue("materialgroupto"));
        invAgeFilterInfo.setMaterial((DynamicObjectCollection)model.getValue("material"));
        DynamicObject endPeriod = (DynamicObject)model.getValue("endperiod");
        Date enddate = endPeriod.getDate("enddate");
        invAgeFilterInfo.setEndDate(enddate);
        DynamicObjectCollection entryEntity = model.getEntryEntity("ageentry");
        ArrayList<Integer> intervalDays = new ArrayList<Integer>(32);
        for (DynamicObject entry : entryEntity) {
            int day = entry.getInt("ageval");
            intervalDays.add(day);
        }
        String ageVal = StringUtils.join(intervalDays, (String)",");
        invAgeFilterInfo.setIntervalDays(ageVal);
        int size = entryEntity.size();
        ArrayList<String> groupList = new ArrayList<String>(size);
        int end = 0;
        for (DynamicObject entry : entryEntity) {
            int day = entry.getInt("ageval");
            int start = end;
            end = day + end;
            if (day <= 0) break;
            String msg = ResManager.loadKDString((String)"%s-%s\u5929", (String)"MaterialGroupItoAnalysisPlugin_19", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]);
            groupList.add(String.format(msg, start, end - 1));
        }
        String msg = ResManager.loadKDString((String)"%s\u5929\u53ca\u4ee5\u4e0a", (String)"MaterialGroupItoAnalysisPlugin_20", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]);
        groupList.add(String.format(msg, end));
        invAgeFilterInfo.setInvAgeGroup(groupList);
        return invAgeFilterInfo;
    }

    private DullMaterialFilterInfo getDullMaterialFilter() {
        IDataModel model = this.getModel();
        DullMaterialFilterInfo dullMaterialFilterInfo = new DullMaterialFilterInfo();
        dullMaterialFilterInfo.setCalOrg((DynamicObject)model.getValue("calorg"));
        dullMaterialFilterInfo.setCostAccount((DynamicObject)model.getValue("costaccount"));
        dullMaterialFilterInfo.setMaterialGroupStandard((DynamicObject)model.getValue("materialgroupstandard"));
        dullMaterialFilterInfo.setMaterialGroupFrom((DynamicObjectCollection)model.getValue("mulmaterialgroup"));
        dullMaterialFilterInfo.setMaterialGroupTo((DynamicObject)model.getValue("materialgroupto"));
        dullMaterialFilterInfo.setDullDays((Integer)model.getValue("dulldays"));
        dullMaterialFilterInfo.setDullType((String)model.getValue("dulltype"));
        dullMaterialFilterInfo.setMaterial((DynamicObjectCollection)model.getValue("material"));
        DynamicObject startPeriod = (DynamicObject)model.getValue("startperiod");
        DynamicObject endPeriod = (DynamicObject)model.getValue("endperiod");
        Map<Object, DynamicObject> coll = PeriodHelper.getCollByStartPeriodAndEndPeriod(startPeriod, endPeriod);
        List<Date> enddateColl = coll.values().stream().map(period -> period.getDate("enddate")).collect(Collectors.toList());
        dullMaterialFilterInfo.setEndDateColl(enddateColl);
        dullMaterialFilterInfo.setPeriod(coll);
        dullMaterialFilterInfo.setMetricModelWithGroup(this.getPageCache().get("scmdi_metric_cal_itogroup"));
        return dullMaterialFilterInfo;
    }

    @Override
    public void materialGroupStandardChanged() {
        super.materialGroupStandardChanged();
        this.getModel().setValue("material", null);
    }

    @Override
    public void buildEntryEntity() {
        this.getModel().deleteEntryData("entryentity");
        List<MaterialItoInfo> materialEntryEntityData = ItoEntryEntityDataService.getMaterialDullEntryEntityData(this.getDullMaterialFilter());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObjectType entryEntityType = entryEntity.getDynamicObjectType();
        for (MaterialItoInfo materialItoInfo : materialEntryEntityData) {
            DynamicObject entry = new DynamicObject(entryEntityType);
            entry.set("materialnum", (Object)materialItoInfo.getMaterial());
            entry.set("salecost", (Object)materialItoInfo.getSaleCost());
            entry.set("inventorycost", (Object)materialItoInfo.getInventoryCost());
            entry.set("turnrate", (Object)materialItoInfo.getTurnRate());
            entry.set("turndays", (Object)materialItoInfo.getTurnDays());
            entry.set("currency", (Object)materialItoInfo.getCurrency());
            entryEntity.add((Object)entry);
        }
        this.getModel().updateEntryCache(entryEntity);
        this.getView().updateView("entryentity");
    }

    @Override
    public void calOrgChanged(Object newValue) {
        this.getModel().setValue("material", null);
        super.calOrgChanged(newValue);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "materialgroupstandard": 
            case "mulmaterialgroup": 
            case "materialgroupto": 
            case "material": {
                this.buildChart();
                break;
            }
            case "dulldays": 
            case "dulltype": {
                this.buildEntryEntity();
                break;
            }
        }
    }

    private void buildSaleCostAndQtyChart() {
        PointLineChart saleLineChart = (PointLineChart)this.getControl("pointlinechartap");
        saleLineChart.addTooltip("trigger", (Object)"axis");
        HashMap<String, String> axisPointType = new HashMap<String, String>(1);
        axisPointType.put("type", "shadow");
        saleLineChart.addTooltip("axisPointer", axisPointType);
        saleLineChart.clearData();
        saleLineChart.setMargin(Position.left, "5%");
        LineChartInfo saleCostAndQtyChartData = ItoChartDataService.getSaleCostAndQtyChartData(this.getFilterConditionInfo());
        this.setCostAndQtyLineChartAxisTick(saleLineChart, saleCostAndQtyChartData);
        this.serCostAndQtyLineChartData(saleLineChart, saleCostAndQtyChartData);
        saleLineChart.setLegendAlign(XAlign.right, YAlign.top);
        saleLineChart.setShowTitle(true);
        saleLineChart.setShowTooltip(true);
        saleLineChart.setShowLegend(true);
        saleLineChart.setLegendVertical(false);
        saleLineChart.refresh();
    }

    private void buildInvCostAndQtyChart() {
        PointLineChart invLineChart = (PointLineChart)this.getControl("pointlinechartap1");
        invLineChart.addTooltip("trigger", (Object)"axis");
        HashMap<String, String> axisPointType = new HashMap<String, String>(1);
        axisPointType.put("type", "shadow");
        invLineChart.addTooltip("axisPointer", axisPointType);
        invLineChart.clearData();
        invLineChart.setMargin(Position.left, "5%");
        LineChartInfo invCostAndQtyChartData = ItoChartDataService.getInvCostAndQtyChartData(this.getFilterConditionInfo());
        this.setCostAndQtyLineChartAxisTick(invLineChart, invCostAndQtyChartData);
        this.serCostAndQtyLineChartData(invLineChart, invCostAndQtyChartData);
        invLineChart.setLegendAlign(XAlign.right, YAlign.top);
        invLineChart.setShowTitle(true);
        invLineChart.setShowTooltip(true);
        invLineChart.setShowLegend(true);
        invLineChart.setLegendVertical(false);
        invLineChart.refresh();
    }

    private void buildMaterialAgePieChart() {
        PieChart itoChart = (PieChart)this.getControl("piechartap");
        itoChart.addTooltip("trigger", (Object)"item");
        HashMap<String, String> axisPointType = new HashMap<String, String>(1);
        axisPointType.put("type", "shadow");
        itoChart.addTooltip("axisPointer", axisPointType);
        itoChart.clearData();
        PieSeries pieSeries = itoChart.createPieSeries("");
        ItemValue[] pieChartData = ItoChartDataService.getInvAgeChartData(this.getMaterialAgeFilter());
        pieSeries.setData(pieChartData);
        pieSeries.setRadius("50%", "70%");
        Label label = new Label();
        label.setShow(false);
        pieSeries.setLabel(label);
        itoChart.setLegendAlign(XAlign.right, YAlign.center);
        itoChart.setLegendVertical(true);
        itoChart.setShowTooltip(true);
        itoChart.setShowLegend(true);
        itoChart.refresh();
    }

    private void setCostAndQtyLineChartAxisTick(PointLineChart saleLineChart, LineChartInfo saleCostAndQtyChartData) {
        Axis axis = saleLineChart.createXAxis("", AxisType.category);
        List<String> periodAxis = saleCostAndQtyChartData.getPeriodAxis();
        axis.setCategorys(periodAxis);
        axis.setPosition(Position.bottom);
        axis.setPropValue("nameGap", (Object)"10");
        HashMap<String, Object> axisTick = new HashMap<String, Object>(2);
        axisTick.put("interval", "0");
        axisTick.put("show", Boolean.TRUE);
        axis.setPropValue("axisTick", axisTick);
        HashMap<String, Object> axisLabel = new HashMap<String, Object>(3);
        axisLabel.put("rotate", "30");
        axisLabel.put("show", Boolean.TRUE);
        axisLabel.put("interval", 0);
        axis.setPropValue("axisLabel", axisLabel);
        this.setLineColor(axis, "#999999");
    }

    private void serCostAndQtyLineChartData(PointLineChart saleLineChart, LineChartInfo saleCostAndQtyChartData) {
        Axis costY = saleLineChart.createYAxis(saleCostAndQtyChartData.getFirstLineChartName(), AxisType.value);
        costY.setPropValue("nameGap", (Object)"8");
        Number[] costLineChartData = saleCostAndQtyChartData.getFirstLineChartData();
        LineSeries costLineSeries = saleLineChart.createLineSeries(saleCostAndQtyChartData.getFirstLineChartName());
        costLineSeries.setData(costLineChartData);
        costLineSeries.setLineColor("#40A9FF");
        Label label = new Label();
        label.setShow(false);
        costLineSeries.setLabel(label);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>(1);
        axisTick.put("show", Boolean.TRUE);
        costY.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap(1);
        HashMap<String, String> lineStyle = new HashMap<String, String>(2);
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#8A8B99");
        splitLine.put("lineStyle", lineStyle);
        costY.setPropValue("splitLine", splitLine);
        this.setLineColor(costY, "#8A8B99");
        HashMap<String, String> costAxisLabel = new HashMap<String, String>(1);
        costAxisLabel.put("formatter", "{value}");
        costY.setPropValue("axisLabel", costAxisLabel);
    }

    private void setLineColor(Axis axis, String color) {
        HashMap axisLineMap = new HashMap(1);
        HashMap<String, String> lineStyleMap = new HashMap<String, String>(1);
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axis.setPropValue("axisLine", axisLineMap);
    }
}

