/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.service.mservices;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.scmdi.business.helper.DullMaterialHelper;
import kd.scmc.scmdi.business.helper.DullTypeBuilder;
import kd.scmc.scmdi.common.utils.DateUtils;
import kd.scmc.scmdi.service.mservices.billparse.IInvBillAsAccParser;
import kd.scmc.scmdi.service.mservices.billparse.InvBillAsAccParserFactory;

public class DullMaterialQueryService
extends AbstractReportListDataPlugin {
    private static String[] INV_BALC_DIMENSION_FIELDS = new String[]{"org", "producedate", "expirydate", "warehouse", "location", "ownertype", "owner", "keepertype", "keeper", "invstatus", "invtype", "material", "auxpty", "lotnumber", "project", "unit", "baseunit", "unit2nd"};
    private static String[] BILL_FIELDS = new String[]{"org", "producedate", "expirydate", "warehouse", "location", "ownertype", "owner", "keepertype", "keeper", "invstatus", "invtype", "material", "auxpty", "lotnumber", "project", "unit", "baseunit", "unit2nd", "qty", "baseqty", "qty2nd", "bookdate"};
    private static final Long INIT_MATERIALGROUPSTANDARD_ID = 730148448254487552L;

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        DataSet dullMaterialDataSet = this.buildDeadlineInvAccDataSet(filterInfo);
        return this.reBuildDataSet(filterInfo, dullMaterialDataSet);
    }

    public DataSet buildDeadlineInvAccDataSet(FilterInfo filterInfo) {
        DataSet beforeDeadlineAccSet = this.getBeforeDeadlineAccSet(filterInfo);
        DataSet billDataSet = this.getBillDataSetBeforeEndTime(filterInfo);
        String[] invBalcDimensionField = INV_BALC_DIMENSION_FIELDS;
        if (billDataSet == null) {
            if (beforeDeadlineAccSet != null) {
                beforeDeadlineAccSet = beforeDeadlineAccSet.removeFields(new String[]{"endperiod"}).groupBy(invBalcDimensionField).sum("qty").sum("baseqty").sum("qty2nd").finish();
            }
            return beforeDeadlineAccSet;
        }
        if (beforeDeadlineAccSet == null) {
            return billDataSet.groupBy(invBalcDimensionField).sum("qty").sum("baseqty").sum("qty2nd").finish();
        }
        billDataSet = billDataSet.groupBy(invBalcDimensionField).sum("qty").sum("baseqty").sum("qty2nd").finish();
        DataSet balanceDataSet = beforeDeadlineAccSet.removeFields(new String[]{"endperiod"}).union(billDataSet);
        balanceDataSet = balanceDataSet.groupBy(invBalcDimensionField).sum("qty").sum("baseqty").sum("qty2nd").finish();
        return balanceDataSet;
    }

    private DataSet reBuildDataSet(FilterInfo filterInfo, DataSet accInvDataSet) {
        QFilter materialGroupNumberFilter;
        DynamicObject materialgroupstandard = filterInfo.getDynamicObject("materialgroupstandard");
        Long standardId = 0L;
        standardId = materialgroupstandard == null ? INIT_MATERIALGROUPSTANDARD_ID : (Long)materialgroupstandard.getPkValue();
        DataSet classMaterialDataSet = this.getClassifiedMaterialDataSet(filterInfo);
        accInvDataSet = accInvDataSet.leftJoin(classMaterialDataSet).on("material", "material").select(DullMaterialHelper.getDataSetFieldStrs(accInvDataSet, "standard", "group", "groupnumber", "materialnumber")).finish();
        if (!INIT_MATERIALGROUPSTANDARD_ID.equals(standardId)) {
            accInvDataSet = accInvDataSet.where("standard = " + standardId);
        }
        if ((materialGroupNumberFilter = DullMaterialHelper.getDynamicObjectFromToFilter(filterInfo, "groupnumber", "materialgroupfrom", "materialgroupto")) != null) {
            accInvDataSet = accInvDataSet.filter(materialGroupNumberFilter.toString());
        }
        accInvDataSet = accInvDataSet.select(this.getDullMaterialRptListCols()).where("qty != 0 or qty2nd != 0");
        accInvDataSet = accInvDataSet.groupBy(this.getGroupByFields(filterInfo)).sum("qty").sum("baseqty").sum("qty2nd").finish();
        accInvDataSet = accInvDataSet.where("qty != 0 or qty2nd != 0");
        DataSet billDataSet = DullTypeBuilder.buildDullTypeDataSet(filterInfo);
        String dulltype = filterInfo.getString("dulltype");
        if (billDataSet == null) {
            if ("0".equals(dulltype) || "2".equals(dulltype)) {
                return accInvDataSet;
            }
            return accInvDataSet.filter(DullMaterialHelper.getIdentNotEqQFilter().toString());
        }
        accInvDataSet = accInvDataSet.leftJoin(billDataSet).select(DullMaterialHelper.getDataSetFieldStrs(accInvDataSet, "dullTypeSum")).on("org", "org").on("material", "material").finish();
        String whereExp = null;
        switch (dulltype) {
            case "0": {
                whereExp = "dullTypeSum = 0 or dullTypeSum is null";
                break;
            }
            case "1": {
                whereExp = "dullTypeSum = 1";
                break;
            }
            case "2": {
                whereExp = "dullTypeSum = 1 or (dullTypeSum = 0 or dullTypeSum is null)";
                break;
            }
            default: {
                whereExp = DullMaterialHelper.getIdentEqQFilter().toString();
            }
        }
        accInvDataSet = accInvDataSet.where(whereExp);
        return accInvDataSet;
    }

    private DataSet getBeforeDeadlineAccSet(FilterInfo filterInfo) {
        Date endTime = filterInfo.getDate("deadline");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMM");
        Integer deadLine = Integer.parseInt(simpleDateFormat.format(endTime));
        QFilter invBalcQFilter = new QFilter("period", "<", (Object)deadLine).and("endperiod", ">=", (Object)deadLine);
        if (!DullMaterialHelper.isNewPeriodBal()) {
            invBalcQFilter.and("balancetype", "=", (Object)"1");
        }
        invBalcQFilter.and(DullMaterialHelper.addCommonDataQFilter(filterInfo));
        QFilter lotNumberFilter = DullMaterialHelper.getTextFromToFilter(filterInfo, "lotnumber", "lotnumberfrom", "lotnumberto");
        if (lotNumberFilter != null) {
            invBalcQFilter.and(lotNumberFilter);
        }
        Set<String> accRecFieldSet = this.getAliasAccRecFields();
        accRecFieldSet.add("endperiod");
        String accRecFields = DullMaterialHelper.collectionToStr(accRecFieldSet);
        String entityInvbalance = "im_invbalance";
        if (DullMaterialHelper.isNewPeriodBal()) {
            entityInvbalance = "im_inv_periodbalance";
        }
        DataSet invBalDataSet = QueryServiceHelper.queryDataSet((String)"scmc-scmdi-themeanalysis", (String)entityInvbalance, (String)accRecFields, (QFilter[])invBalcQFilter.toArray(), (String)"");
        return invBalDataSet;
    }

    private DataSet getBillDataSetBeforeEndTime(FilterInfo filterInfo) {
        HashMap<String, IInvBillAsAccParser> billToParser = new HashMap<String, IInvBillAsAccParser>();
        DataSet billDataSet = this.parseBillData(filterInfo, billToParser);
        if (billDataSet == null) {
            return null;
        }
        String[] billSelectFields = DullMaterialHelper.getDataSetFieldStrs(billDataSet);
        QFilter invSchemeQFilter = new QFilter("isnotupdate", "=", (Object)Boolean.FALSE);
        DataSet invSchemeDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey(), (String)"im_invscheme", (String)"id as invschemeId,transceivertype.transceiver as transceiver", (QFilter[])invSchemeQFilter.toArray(), (String)"");
        billDataSet = billDataSet.join(invSchemeDataSet, JoinType.LEFT).on("billinvscheme", "invschemeId").select(billSelectFields, new String[]{"transceiver"}).finish();
        DataSet unionBillDataSet = this.handleReceiveSend(billDataSet, billToParser);
        QFilter billQFilter = this.buildBillQFilter(filterInfo);
        unionBillDataSet = unionBillDataSet.filter(billQFilter.toString());
        String[] unionBillFields = DullMaterialHelper.getDataSetFieldStrs(unionBillDataSet);
        QFilter mainQFilter = DullMaterialHelper.getAuditedDataQFilter();
        DataSet materialInvInfo = QueryServiceHelper.queryDataSet((String)this.getAlgoKey(), (String)"bd_materialinventoryinfo", (String)"id as materialinvstgy,masterid as material", (QFilter[])mainQFilter.toArray(), null);
        unionBillDataSet = unionBillDataSet.join(materialInvInfo, JoinType.LEFT).select(DullMaterialHelper.addNewValsToSrcArr(unionBillFields, "material")).on("materialinvstgy", "materialinvstgy").finish().removeFields(new String[]{"materialinvstgy"});
        unionBillDataSet = DullMaterialHelper.handleOtherFilter(filterInfo, BILL_FIELDS, unionBillDataSet);
        return unionBillDataSet.select(BILL_FIELDS);
    }

    private Set<String> getAliasAccRecFields() {
        LinkedHashSet<String> accRecFields = new LinkedHashSet<String>(21);
        accRecFields.add("org");
        accRecFields.add("producedate");
        accRecFields.add("expirydate");
        accRecFields.add("warehouse");
        accRecFields.add("location");
        accRecFields.add("ownertype");
        accRecFields.add("owner");
        accRecFields.add("keepertype");
        accRecFields.add("keeper");
        accRecFields.add("invstatus");
        accRecFields.add("invtype");
        accRecFields.add("material");
        accRecFields.add("auxpty");
        accRecFields.add("lotnumber");
        accRecFields.add("project");
        accRecFields.add("unit");
        accRecFields.add("baseunit");
        accRecFields.add("unit2nd");
        if (DullMaterialHelper.isNewPeriodBal()) {
            accRecFields.add("qty_bal as qty");
            accRecFields.add("baseqty_bal as baseqty");
            accRecFields.add("qty2nd_bal as qty2nd");
        } else {
            accRecFields.add("endqty as qty");
            accRecFields.add("endbaseqty as baseqty");
            accRecFields.add("endqty2nd as qty2nd");
        }
        return accRecFields;
    }

    private DataSet parseBillData(FilterInfo filterInfo, Map<String, IInvBillAsAccParser> billToParser) {
        DataSet billDataSet = null;
        Date endTime = filterInfo.getDate("deadline");
        Date beginDate = DateUtils.getFirstDayOfMonthByDate(endTime);
        Date endDate = DateUtils.getDayEndTime(endTime);
        QFilter timeQFilter = new QFilter("bookdate", ">=", (Object)beginDate).and("bookdate", "<=", (Object)endDate);
        for (String billType : this.getAccModelBillTypes()) {
            IInvBillAsAccParser accRecBillParser = InvBillAsAccParserFactory.buildBillAsAccParser(billType, timeQFilter);
            if (accRecBillParser == null) continue;
            DataSet billDataSetTemp = accRecBillParser.buildBillDataSet();
            if (billDataSet == null) {
                billDataSet = billDataSetTemp;
            } else if (billDataSetTemp != null) {
                billDataSet = billDataSet.union(billDataSetTemp);
            }
            billToParser.put(billType, accRecBillParser);
        }
        return billDataSet;
    }

    private Set<String> getAccModelBillTypes() {
        QFilter dymAccQFilter = new QFilter("enable", "=", (Object)"1");
        DataSet dymAccdsDSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey(), (String)"plat_dymaccds", (String)"srcbill.number as billType", (QFilter[])dymAccQFilter.toArray(), (String)"");
        HashSet<String> billTypeSet = new HashSet<String>(10);
        while (dymAccdsDSet.hasNext()) {
            String billType = dymAccdsDSet.next().getString("billType");
            billTypeSet.add(billType);
        }
        return billTypeSet;
    }

    private String getAlgoKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private DataSet handleReceiveSend(DataSet billDataSet, Map<String, IInvBillAsAccParser> billToParser) {
        DataSet unionBillDataSet = null;
        for (Map.Entry<String, IInvBillAsAccParser> billToParserEntry : billToParser.entrySet()) {
            DataSet receSendSepcialBillDSet;
            String billType = billToParserEntry.getKey();
            IInvBillAsAccParser accRecBillParser = billToParserEntry.getValue();
            String[] inInvFields = DullMaterialHelper.collectionToStrArr(accRecBillParser.buildInInvAsAccFields());
            String[] outInvFields = DullMaterialHelper.collectionToStrArr(accRecBillParser.buildOutInvAsAccFields());
            DataSet receiveBillDSet = billDataSet.filter("((billinvscheme != 0 and transceiver = '0') or (billinvscheme = 0 and billtransceiver = '2_sub')) and billType = '" + billType + "'");
            DataSet sendBillDSet = billDataSet.filter("billinvscheme != 0 and transceiver = '1' and billType = '" + billType + "'");
            if (receiveBillDSet != null) {
                DataSet receiveDataDSet = receiveBillDSet.select(inInvFields);
                unionBillDataSet = unionBillDataSet == null ? receiveDataDSet : unionBillDataSet.union(receiveDataDSet);
            }
            if (sendBillDSet != null) {
                DataSet sendDataDSet = sendBillDSet.select(outInvFields);
                unionBillDataSet = unionBillDataSet == null ? sendDataDSet : unionBillDataSet.union(sendDataDSet);
            }
            if ((receSendSepcialBillDSet = billDataSet.filter("(billtransceiver = '2' or transceiver = '2') and billType = '" + billType + "'")) == null) continue;
            DataSet receSepcialBillDSet = receSendSepcialBillDSet.select(inInvFields);
            DataSet sendSepcialBillDSet = receSendSepcialBillDSet.select(outInvFields);
            unionBillDataSet = unionBillDataSet == null ? receSepcialBillDSet : unionBillDataSet.union(receSepcialBillDSet);
            unionBillDataSet = unionBillDataSet.union(sendSepcialBillDSet);
        }
        return unionBillDataSet;
    }

    protected QFilter buildBillQFilter(FilterInfo filterInfo) {
        QFilter lotNumberFilter;
        DynamicObjectCollection invstatusheads;
        DynamicObjectCollection ivntypeheads;
        QFilter billQFilter = DullMaterialHelper.getIdentEqQFilter();
        DynamicObject org = filterInfo.getDynamicObject("orghead");
        billQFilter.and(new QFilter("org", "=", org.getPkValue()));
        String ownerTypehead = filterInfo.getString("ownertypehead");
        QFilter ownerTypeFilter = null;
        if (ownerTypehead != null && !ownerTypehead.trim().equals("")) {
            ownerTypeFilter = new QFilter("ownertype", "=", (Object)ownerTypehead);
            billQFilter.and(ownerTypeFilter);
        }
        if ((ivntypeheads = filterInfo.getDynamicObjectCollection("ivntypehead")) != null && ivntypeheads.size() > 0) {
            HashSet<Object> ivntypeIds = new HashSet<Object>();
            for (Iterator ivntype : ivntypeheads) {
                ivntypeIds.add(ivntype.getPkValue());
            }
            QFilter ivntypeheadFilter = new QFilter("invtype", "in", ivntypeIds);
            billQFilter.and(ivntypeheadFilter);
        }
        if ((invstatusheads = filterInfo.getDynamicObjectCollection("invstatushead")) != null && invstatusheads.size() > 0) {
            HashSet<Object> invstatusIds = new HashSet<Object>();
            for (DynamicObject invstatus : invstatusheads) {
                invstatusIds.add(invstatus.getPkValue());
            }
            QFilter invstatusheadFilter = new QFilter("invstatus", "in", invstatusIds);
            billQFilter.and(invstatusheadFilter);
        }
        if ((lotNumberFilter = DullMaterialHelper.getTextFromToFilter(filterInfo, "lotnumber", "lotnumberfrom", "lotnumberto")) != null) {
            billQFilter.and(lotNumberFilter);
        }
        return billQFilter;
    }

    private DataSet getClassifiedMaterialDataSet(FilterInfo filterInfo) {
        Object pkValue = null;
        DynamicObject materialgroupstandard = filterInfo.getDynamicObject("materialgroupstandard");
        pkValue = materialgroupstandard == null ? INIT_MATERIALGROUPSTANDARD_ID : materialgroupstandard.getPkValue();
        DataSet classifiedMaterialDataSet = QueryServiceHelper.queryDataSet((String)"bd_materialgroupdetail", (String)"bd_materialgroupdetail", (String)"group,group.number as groupnumber,material,material.number as materialnumber,standard", (QFilter[])new QFilter("standard", "=", pkValue).toArray(), (String)"group desc");
        return classifiedMaterialDataSet;
    }

    private String[] getDullMaterialRptListCols() {
        StringBuilder tabHeadCols = new StringBuilder();
        tabHeadCols.append("invtype,");
        tabHeadCols.append("invstatus,");
        tabHeadCols.append("group,");
        tabHeadCols.append("material,");
        tabHeadCols.append("auxpty,");
        tabHeadCols.append("lotnumber,");
        tabHeadCols.append("unit,");
        tabHeadCols.append("baseunit,");
        tabHeadCols.append("unit2nd,");
        tabHeadCols.append("qty,");
        tabHeadCols.append("baseqty,");
        tabHeadCols.append("qty2nd,");
        tabHeadCols.append("warehouse,");
        tabHeadCols.append("location,");
        tabHeadCols.append("org,");
        tabHeadCols.append("owner,");
        tabHeadCols.append("ownertype,");
        tabHeadCols.append("keeper,");
        tabHeadCols.append("keepertype,");
        tabHeadCols.append("project,");
        tabHeadCols.append("0 as tracknumber");
        return tabHeadCols.toString().split(",");
    }

    private String[] getGroupByFields(FilterInfo filterInfo) {
        String defGroupFields = this.getDefaultGroupByCols();
        String summaryBasis = this.getSummaryBasis(filterInfo);
        if (summaryBasis != null) {
            if (summaryBasis.contains("tracknumber")) {
                summaryBasis = summaryBasis.replace("tracknumber,", "");
            }
            defGroupFields = defGroupFields + summaryBasis;
        }
        return defGroupFields.split(",");
    }

    private String getDefaultGroupByCols() {
        return "invtype,invstatus,group,material,unit,baseunit,unit2nd,org,ownertype,keeper,keepertype";
    }

    private String getSummaryBasis(FilterInfo filterInfo) {
        return filterInfo.getString("summarybasis");
    }
}

