/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.service.mservices;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.scmdi.business.helper.InvBillAgeHelper;
import kd.scmc.scmdi.common.utils.DateUtils;

public class InvBillAgeQueryService
extends AbstractReportListDataPlugin {
    private static final String[] ALL_SUMS = new String[]{"lotnumber", "warehouse", "location", "project", "auxpty", "owner", "configuredcode", "tracknumber"};

    public DataSet query(ReportQueryParam paramReportQueryParam, Object arg1) throws Throwable {
        FilterInfo filterInfo = paramReportQueryParam.getFilter();
        DataSet billDataSet = this.getFinallyDataSet(filterInfo, null);
        return billDataSet;
    }

    private DataSet getFinallyDataSet(FilterInfo filterInfo, QFilter timefilter) {
        DataSet billSet = null;
        if ("0".equals(filterInfo.getString("ageanalysis")) ? (billSet = this.getInvAccFinallyDataSet(filterInfo)).copy().isEmpty() : "1".equals(filterInfo.getString("ageanalysis")) && (billSet = this.handleInvBalanceFinallyDataSetByTimeFilter(filterInfo)).copy().isEmpty()) {
            return billSet;
        }
        if (billSet != null) {
            billSet = this.handleSumref(filterInfo, billSet);
            billSet = this.handledisplayclasssum(filterInfo, billSet);
            billSet = this.handleOrderBy(filterInfo, billSet);
            billSet = billSet.filter("qty > 0 and baseqty > 0 ");
        }
        return billSet;
    }

    private DataSet getInvAccFinallyDataSet(FilterInfo filterInfo) {
        QFilter billInvaccFilter = InvBillAgeHelper.getBillInvAcOrInvBalancecQFilter(filterInfo, true);
        DataSet billSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_inv_realbalance", (String)"org,ownertype,owner,warehouse,location,invtype,material,unit,baseunit,qty,baseqty,lotnum as lotnumber,auxpty,project,configuredcode,tracknumber", (QFilter[])billInvaccFilter.toArray(), null);
        DataSet classifiedMaterialDataSet = this.getClassifiedMaterialDataSet(filterInfo, true);
        billSet = classifiedMaterialDataSet.leftJoin(billSet).on("material", "material").select(new String[]{"group", "standard"}, InvBillAgeHelper.getDataSetFieldArray(billSet)).finish();
        billSet = billSet.filter("baseqty is not null");
        billSet = billSet.select(this.getBasicSelectFileds());
        billSet = this.handleInvAgeGroupBiztimeInterval(filterInfo, billSet, null);
        return billSet;
    }

    private DataSet handleInvBalanceFinallyDataSetByTimeFilter(FilterInfo filterInfo) {
        Date suffixDateFilter = filterInfo.getDate("enddate");
        Date dayStartTime = DateUtils.getDayStartTime(DateUtils.addDay(suffixDateFilter, 1));
        QFilter timefilter = new QFilter("bookdate", "<", (Object)dayStartTime);
        DataSet billSet = this.buildBaseBillInfoDataSet(filterInfo, timefilter);
        billSet = this.handleRecAndSendAndSpecialBill(filterInfo, timefilter, billSet);
        billSet = this.addMaterialFilter(billSet, filterInfo);
        billSet = InvBillAgeHelper.filterNoUpdateField(billSet, filterInfo);
        billSet = billSet.select(this.getCalculateBasicSelectFileds());
        billSet = this.handleInvAgeGroupBiztimeInterval(filterInfo, billSet, dayStartTime);
        billSet = this.filterInvBalanceInvtype(filterInfo, billSet);
        return billSet;
    }

    private DataSet filterInvBalanceInvtype(FilterInfo filterInfo, DataSet dataSet) {
        DynamicObjectCollection ivntypeheads = filterInfo.getDynamicObjectCollection("ivntypehead");
        if (ivntypeheads != null && ivntypeheads.size() > 0) {
            HashSet<Object> ivntypeIds = new HashSet<Object>();
            for (DynamicObject ivntype : ivntypeheads) {
                ivntypeIds.add(ivntype.getPkValue());
            }
            QFilter invtypeheadFilter = new QFilter("invtype", "in", ivntypeIds);
            dataSet = dataSet.filter(invtypeheadFilter.toString());
        }
        return dataSet;
    }

    private final String[] addArrayFileds(String[] source, String[] ... addFiledS) {
        for (String[] strings : addFiledS) {
            source = InvBillAgeHelper.addFileds(source, strings);
        }
        return source;
    }

    private String getCalculateBasicSelectFileds() {
        String fileds = "org,ownertype,owner,warehouse,location ,invtype,material,standard,group,baseunit,inbaseqty-outbaseqty as baseqty,inqty-outqty as qty,unit,lotnumber,auxpty,project,configuredcode,tracknumber";
        return fileds;
    }

    private String getBasicSelectFileds() {
        String fileds = "org,ownertype,owner,warehouse,location,invtype,material,standard,group,baseunit,baseqty,qty,unit,lotnumber,auxpty,project,configuredcode,tracknumber";
        return fileds;
    }

    private String[] getBasicSelectDimensionFileds() {
        return new String[]{"material", "standard", "group", "org", "ownertype", "owner", "warehouse", "location", "invtype", "baseunit", "unit", "lotnumber", "auxpty", "project", "configuredcode", "tracknumber"};
    }

    private JoinDataSet addJoinColumn(JoinDataSet dataSet, String ... joinFields) {
        for (String joinField : joinFields) {
            dataSet.on(joinField, joinField);
        }
        return dataSet;
    }

    private DataSet handleSumref(FilterInfo filterInfo, DataSet billSet) {
        String[] sumref = this.getSumFields(filterInfo);
        String intervaldays = filterInfo.getString("intervaldays");
        StringBuilder sb = new StringBuilder();
        sb.append("baseqty,qty");
        String[] intervalDaysArray = intervaldays.split(",");
        for (int i = 0; i < intervalDaysArray.length; ++i) {
            String str = ",baseqtyrang" + i + ",qtyrang" + i;
            sb.append(str);
        }
        billSet = this.addSumColumn(billSet.groupBy(InvBillAgeHelper.addFileds(InvBillAgeHelper.removeFiled(this.getBasicSelectDimensionFileds(), ALL_SUMS), sumref)), sb.toString().split(",")).finish();
        return billSet;
    }

    private String[] getSumFields(FilterInfo filterInfo) {
        String sumref = filterInfo.getString("sumref");
        String[] removeFileds = null;
        if (sumref == null) {
            removeFileds = null;
        } else {
            sumref = sumref.substring(sumref.indexOf(44) + 1, sumref.lastIndexOf(44));
            removeFileds = sumref.split(",");
            if (sumref.isEmpty()) {
                removeFileds = null;
            }
        }
        return removeFileds;
    }

    private DataSet handleInvAgeGroupBiztimeInterval(FilterInfo filterInfo, DataSet billSet, Date suffixDateFilter) {
        DataSet finallyReturnDataSet = billSet;
        ArrayList<DataSet> exitList = new ArrayList<DataSet>();
        String intervaldays = filterInfo.getString("intervaldays");
        DataSet billSetContainsOnlyAllRec = this.getInvAgeGroupAllBiztimeIntervalBillRec(filterInfo);
        if (billSetContainsOnlyAllRec.copy().isEmpty()) {
            return billSetContainsOnlyAllRec;
        }
        String[] sumref = this.getSumFields(filterInfo);
        String[] intervalDaysArray = intervaldays.split(",");
        Date prefix = null;
        Date suffix = suffixDateFilter == null ? new Date() : suffixDateFilter;
        StringBuilder bizTimesFilterExpr = new StringBuilder();
        SimpleDateFormat jdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < intervalDaysArray.length; ++i) {
            String prefixString;
            String biztime = intervalDaysArray[i];
            if ("0".equals(biztime)) {
                bizTimesFilterExpr.setLength(0);
                jdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                prefixString = jdf.format(DateUtils.addDay(suffix, -Integer.parseInt(biztime)));
                String timef = " bookdate <  to_date('" + prefixString + "','yyyy-MM-dd HH:mm:ss')";
                bizTimesFilterExpr.append(timef);
            } else {
                bizTimesFilterExpr.setLength(0);
                prefix = DateUtils.addDay(suffix, -Integer.parseInt(biztime));
                prefixString = jdf.format(DateUtils.addDay(suffix, -Integer.parseInt(biztime)));
                String suffixString = jdf.format(suffix);
                String largePreTime = " bookdate >=  to_date('" + prefixString + "','yyyy-MM-dd HH:mm:ss')";
                bizTimesFilterExpr.append(largePreTime);
                String lessEqualsTime = " and bookdate <  to_date('" + suffixString + "','yyyy-MM-dd HH:mm:ss')";
                bizTimesFilterExpr.append(lessEqualsTime);
            }
            DataSet billSetContainsOnlyRecByTimeFilter = this.getInvAgeGroupBiztimeIntervalBillRec(sumref, billSetContainsOnlyAllRec.copy(), bizTimesFilterExpr.toString());
            if (billSetContainsOnlyRecByTimeFilter.copy().isEmpty()) {
                for (int n = 0; n < exitList.size(); ++n) {
                    DataSet dataSetExit = (DataSet)exitList.get(n);
                    String[] fieldNames = dataSetExit.getRowMeta().getFieldNames();
                    for (int m = 0; m < intervalDaysArray.length; ++m) {
                        String qtyrangX = "qtyrang" + m;
                        String baseqtyrangX = "baseqtyrang" + m;
                        if (!Arrays.asList(fieldNames).contains(qtyrangX)) {
                            dataSetExit = dataSetExit.addField("0", qtyrangX);
                        }
                        if (Arrays.asList(fieldNames).contains(baseqtyrangX)) continue;
                        dataSetExit = dataSetExit.addField("0", baseqtyrangX);
                    }
                }
                suffix = prefix;
                continue;
            }
            DataSet exit = this.getInvAgeGroupBiztimeIntervalExit(sumref, billSet = this.getInvAgeGroupBiztimeIntervalBillSet(sumref, billSet, i), billSetContainsOnlyRecByTimeFilter, i);
            if (exit != null) {
                String[] fieldNames = exit.getRowMeta().getFieldNames();
                for (int m = 0; m < intervalDaysArray.length; ++m) {
                    String qtyrangX = "qtyrang" + m;
                    String baseqtyrangX = "baseqtyrang" + m;
                    if (!Arrays.asList(fieldNames).contains(qtyrangX)) {
                        exit = exit.addField("0", qtyrangX);
                    }
                    if (Arrays.asList(fieldNames).contains(baseqtyrangX)) continue;
                    exit = exit.addField("0", baseqtyrangX);
                }
                exitList.add(exit);
            }
            DataSet noExit = this.getInvAgeGroupBiztimeIntervalNoExit(sumref, billSet, billSetContainsOnlyRecByTimeFilter, i);
            if (exit != null && noExit == null) {
                int size = exitList.size();
                if (size == 1) {
                    finallyReturnDataSet = (DataSet)exitList.get(0);
                } else {
                    finallyReturnDataSet = (DataSet)exitList.get(0);
                    for (int z = 1; z < size; ++z) {
                        finallyReturnDataSet = finallyReturnDataSet.union((DataSet)exitList.get(z));
                    }
                }
                return finallyReturnDataSet;
            }
            billSet = noExit;
            suffix = prefix;
        }
        billSetContainsOnlyAllRec.close();
        return this.handleSpecialSituationData(exitList, billSet, filterInfo, intervalDaysArray.length);
    }

    private DataSet handleSpecialSituationData(List<DataSet> exitList, DataSet billSet, FilterInfo filterInfo, int rangSize) {
        String baseqtyrangX;
        String qtyrangX;
        int n;
        for (int m = 0; m < exitList.size(); ++m) {
            DataSet dataSet = exitList.get(m);
            String[] fieldNames = dataSet.getRowMeta().getFieldNames();
            for (n = 0; n < rangSize; ++n) {
                qtyrangX = "qtyrang" + n;
                baseqtyrangX = "baseqtyrang" + n;
                if (!Arrays.asList(fieldNames).contains(qtyrangX)) {
                    dataSet = dataSet.addField("0", qtyrangX);
                }
                if (Arrays.asList(fieldNames).contains(baseqtyrangX)) continue;
                dataSet = dataSet.addField("0", baseqtyrangX);
            }
        }
        DataSet finallyReturnDataSet = null;
        int size = exitList.size();
        if (size == 1) {
            finallyReturnDataSet = exitList.get(0);
        } else if (size != 0) {
            finallyReturnDataSet = exitList.get(0);
            for (int z = 1; z < size; ++z) {
                finallyReturnDataSet = finallyReturnDataSet.union(exitList.get(z));
            }
        }
        String[] fieldNames = billSet.getRowMeta().getFieldNames();
        for (n = 0; n < rangSize; ++n) {
            qtyrangX = "qtyrang" + n;
            baseqtyrangX = "baseqtyrang" + n;
            if (!Arrays.asList(fieldNames).contains(qtyrangX)) {
                billSet = billSet.addField("0", qtyrangX);
            }
            if (Arrays.asList(fieldNames).contains(baseqtyrangX)) continue;
            billSet = billSet.addField("0", baseqtyrangX);
        }
        if (finallyReturnDataSet == null) {
            return billSet;
        }
        return finallyReturnDataSet.union(billSet);
    }

    private DataSet getInvAgeGroupBiztimeIntervalNoExit(String[] sumref, DataSet billSet, DataSet billSetContainsOnlyRec, int i) {
        DataSet noExit = null;
        StringBuilder sbQtyExpr1 = new StringBuilder("qty");
        StringBuilder sbBaseQtyExpr1 = new StringBuilder("baseqty");
        ArrayList<String> sb1 = new ArrayList<String>(i + 2);
        sb1.add("qty");
        sb1.add("baseqty");
        for (int m = 0; m < i; ++m) {
            sbQtyExpr1.append("-qtyrang");
            sbQtyExpr1.append(m);
            sbBaseQtyExpr1.append("-baseqtyrang");
            sbBaseQtyExpr1.append(m);
            sb1.add("qtyrang" + m);
            sb1.add("baseqtyrang" + m);
        }
        String sbQtyExpStr = sbQtyExpr1.toString();
        String sbBaseQtyExpStr = sbBaseQtyExpr1.toString();
        String[] selectField = InvBillAgeHelper.addFileds(InvBillAgeHelper.removeFiled(this.getBasicSelectDimensionFileds(), ALL_SUMS), sumref);
        DataSet dataSetNotExit = this.addJoinColumn(billSet.leftJoin(billSetContainsOnlyRec), selectField).select(InvBillAgeHelper.addFileds(selectField, sb1.toArray(new String[sb1.size()])), new String[]{"qtytmp", "baseqtytmp"}).finish().filter("qtytmp < " + sbQtyExpStr + " and baseqtytmp < " + sbBaseQtyExpStr).select(InvBillAgeHelper.arraysToString(this.addArrayFileds(selectField, sb1.toArray(new String[sb1.size()]), {"qtytmp", "baseqtytmp"})));
        dataSetNotExit = InvBillAgeQueryService.handleNullFiledAsZero(dataSetNotExit, "qtytmp", "baseqtytmp");
        noExit = dataSetNotExit.select(InvBillAgeHelper.arraysToString(this.addArrayFileds(selectField, new String[][]{sb1.toArray(new String[sb1.size()])})) + ",qtytmp as qtyrang" + i + " ,baseqtytmp as baseqtyrang" + i);
        return noExit;
    }

    private DataSet getInvAgeGroupBiztimeIntervalExit(String[] sumref, DataSet billSet, DataSet billSetContainsOnlyRec, int i) {
        DataSet exit = null;
        StringBuilder sbQtyExpr = new StringBuilder("qty");
        StringBuilder sbBaseQtyExpr = new StringBuilder("baseqty");
        ArrayList<String> sb = new ArrayList<String>(2 + i * 2);
        sb.add("qty");
        sb.add("baseqty");
        for (int m = 0; m < i; ++m) {
            sbQtyExpr.append("-qtyrang");
            sbQtyExpr.append(m);
            sbBaseQtyExpr.append("-baseqtyrang");
            sbBaseQtyExpr.append(m);
            sb.add("qtyrang" + m);
            sb.add("baseqtyrang" + m);
        }
        String sbQtyExpStr = sbQtyExpr.toString();
        String sbBaseQtyExpStr = sbBaseQtyExpr.toString();
        String[] selectField = InvBillAgeHelper.addFileds(InvBillAgeHelper.removeFiled(this.getBasicSelectDimensionFileds(), ALL_SUMS), sumref);
        DataSet dataSetPrepareExit = this.addJoinColumn(billSet.leftJoin(billSetContainsOnlyRec), selectField).select(InvBillAgeHelper.addFileds(selectField, sb.toArray(new String[sb.size()])), new String[]{"qtytmp", "baseqtytmp"}).finish().filter("qtytmp >=" + sbQtyExpStr + " and baseqtytmp >=" + sbBaseQtyExpStr).select(InvBillAgeHelper.arraysToString(this.addArrayFileds(selectField, sb.toArray(new String[sb.size()]), {"qtytmp", "baseqtytmp"})));
        dataSetPrepareExit = InvBillAgeQueryService.handleNullFiledAsZero(dataSetPrepareExit, "qtytmp", "baseqtytmp");
        exit = dataSetPrepareExit.select(InvBillAgeHelper.arraysToString(this.addArrayFileds(selectField, new String[][]{sb.toArray(new String[sb.size()])})) + "," + sbQtyExpStr + " as qtyrang" + i + " ," + sbBaseQtyExpStr + " as baseqtyrang" + i);
        return exit;
    }

    private DataSet getInvAgeGroupBiztimeIntervalBillSet(String[] sumref, DataSet billSetCopy, int i) {
        String[] fieldNames = billSetCopy.getRowMeta().getFieldNames();
        for (int n = 0; n < i; ++n) {
            String qtyrangX = "qtyrang" + n;
            String baseqtyrangX = "baseqtyrang" + n;
            if (!Arrays.asList(fieldNames).contains(qtyrangX)) {
                billSetCopy = billSetCopy.addField("0", qtyrangX);
            }
            if (Arrays.asList(fieldNames).contains(baseqtyrangX)) continue;
            billSetCopy = billSetCopy.addField("0", baseqtyrangX);
        }
        ArrayList<String> sb2 = new ArrayList<String>(i + 2);
        sb2.add("qty");
        sb2.add("baseqty");
        for (int n = 0; n < i; ++n) {
            sb2.add("qtyrang" + n);
            sb2.add("baseqtyrang" + n);
        }
        billSetCopy = this.addSumColumn(billSetCopy.groupBy(InvBillAgeHelper.addFileds(InvBillAgeHelper.removeFiled(this.getBasicSelectDimensionFileds(), ALL_SUMS), sumref)), sb2.toArray(new String[sb2.size()])).finish();
        billSetCopy = billSetCopy.select(InvBillAgeHelper.getDataSetFieldArray(billSetCopy));
        return billSetCopy;
    }

    private DataSet getInvAgeGroupAllBiztimeIntervalBillRec(FilterInfo filterInfo) {
        DataSet billSetContainsOnlyRec = this.buildBaseBillInfoDataSet(filterInfo, null);
        billSetContainsOnlyRec = InvBillAgeHelper.filterNoUpdateField(billSetContainsOnlyRec, filterInfo);
        billSetContainsOnlyRec = this.filterInvtype(filterInfo, billSetContainsOnlyRec);
        billSetContainsOnlyRec = this.handleRec(filterInfo, billSetContainsOnlyRec);
        if ((billSetContainsOnlyRec = this.addMaterialFilter(billSetContainsOnlyRec, filterInfo)).copy().isEmpty()) {
            return billSetContainsOnlyRec;
        }
        return billSetContainsOnlyRec;
    }

    private DataSet getInvAgeGroupBiztimeIntervalBillRec(String[] sumref, DataSet billSetContainsOnlyRecCopy, String bizTimesFilterExpr) {
        DataSet billSetContainsOnlyRecByTimeFilter = billSetContainsOnlyRecCopy.filter(bizTimesFilterExpr);
        billSetContainsOnlyRecByTimeFilter = this.addSumColumn(billSetContainsOnlyRecByTimeFilter.groupBy(InvBillAgeHelper.addFileds(InvBillAgeHelper.removeFiled(this.getBasicSelectDimensionFileds(), ALL_SUMS), sumref)), new String[]{"baseqty", "qty"}).finish();
        billSetContainsOnlyRecByTimeFilter = billSetContainsOnlyRecByTimeFilter.select(InvBillAgeHelper.addFileds(InvBillAgeHelper.getDataSetFieldArray(billSetContainsOnlyRecByTimeFilter), "qty as qtytmp", "baseqty as baseqtytmp"));
        return billSetContainsOnlyRecByTimeFilter;
    }

    private DataSet handledisplayclasssum(FilterInfo filterInfo, DataSet billSet) {
        if (filterInfo.getBoolean("displayclasssum")) {
            billSet = billSet.orderBy(new String[]{"group"});
            if (filterInfo.getBoolean("displaysum")) {
                GroupbyDataSet groupbyDataSet = billSet.groupBy(new String[]{"org", "group"});
                StringBuilder sb = new StringBuilder();
                sb.append("baseqty,qty");
                String intervaldays = filterInfo.getString("intervaldays");
                String[] intervalDaysArray = intervaldays.split(",");
                for (int i = 0; i < intervalDaysArray.length; ++i) {
                    String str = ",baseqtyrang" + i + ",qtyrang" + i;
                    sb.append(str);
                }
                billSet = this.addSumColumn(groupbyDataSet, sb.toString().split(",")).finish();
            }
        }
        return billSet;
    }

    private DataSet handleOrderBy(FilterInfo filterInfo, DataSet billSet) {
        String sumref = filterInfo.getString("sumref");
        if (sumref != null) {
            return billSet;
        }
        if (filterInfo.getBoolean("displayclasssum")) {
            return billSet;
        }
        billSet = billSet.orderBy(new String[]{"invtype", "material"});
        return billSet;
    }

    private DataSet addMaterialFilter(DataSet billSet, FilterInfo filterInfo) {
        DataSet classifiedMaterialDataSet = this.getClassifiedMaterialDataSet(filterInfo, true);
        billSet = classifiedMaterialDataSet.leftJoin(billSet).on("material", "material").select(new String[]{"group", "standard"}, InvBillAgeHelper.getDataSetFieldArray(billSet)).finish();
        billSet = billSet.filter("invtype is not null");
        return billSet;
    }

    private DataSet handleRecAndSendAndSpecialBill(FilterInfo filterInfo, QFilter timefilter, DataSet billSet) {
        String[] stringsBillSet = InvBillAgeHelper.getDataSetFieldArray(billSet);
        String[] reportFiled = InvBillAgeHelper.addFileds(InvBillAgeHelper.addFileds(stringsBillSet, this.getRecAndSendField()), "transceiver", "transnumber");
        DataSet biztypeDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_biztype", (String)"id as biztypeId", null, null);
        billSet = billSet.leftJoin(biztypeDataSet).on("biztype", "biztypeId").select(stringsBillSet).finish();
        DataSet invSchemeDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_invscheme", (String)"id as invschemeId,transceivertype.transceiver as transceiver,transceivertype.number as transnumber,isnotupdate", null, null);
        billSet = billSet.leftJoin(invSchemeDataSet).on("invscheme", "invschemeId").select(stringsBillSet, new String[]{"transceiver", "transnumber", "isnotupdate"}).finish();
        HashMap<String, String> sendMapper = new HashMap<String, String>();
        sendMapper.put("invtype", "outinvtype");
        sendMapper.put("outbaseqty", "baseqty");
        sendMapper.put("outqty", "qty");
        sendMapper.put("inbaseqty", "0");
        sendMapper.put("inqty", "0");
        sendMapper.put("ownertype", "outownertype");
        sendMapper.put("owner", "outowner");
        String sendselectedFiled = InvBillAgeHelper.arraysToString(InvBillAgeHelper.mapperFileds(reportFiled, sendMapper, "outinvtype", "outownertype", "outowner", "qty", "baseqty"));
        DataSet sendBillSet = billSet.filter(new QFilter("transceiver", "in", (Object)new String[]{"1", "2"}).and("isnotupdate", "=", (Object)false).toString()).select(sendselectedFiled);
        HashMap<String, String> recMapper = new HashMap<String, String>(4);
        recMapper.put("outbaseqty", "0");
        recMapper.put("outqty", "0");
        recMapper.put("inbaseqty", "baseqty");
        recMapper.put("inqty", "qty");
        String recselectedFiled = InvBillAgeHelper.arraysToString(InvBillAgeHelper.mapperFileds(reportFiled, recMapper, "outinvtype", "outownertype", "outowner", "qty", "baseqty"));
        DataSet recBillSet = billSet.filter(new QFilter("transceiver", "in", (Object)new String[]{"0", "2"}).and("isnotupdate", "=", (Object)false).toString()).select(recselectedFiled);
        billSet = sendBillSet.union(recBillSet);
        DataSet specialRecAndSendDataSet = InvBillAgeHelper.addInitBillRecAndSend(filterInfo, timefilter).union(new DataSet[]{InvBillAgeHelper.addAdjustBillRecAndSend(filterInfo, timefilter), InvBillAgeHelper.addAssembBillRecAndSend(filterInfo, timefilter), InvBillAgeHelper.addDisassBillRecAndSend(filterInfo, timefilter), InvBillAgeHelper.addLocationtransferRecAndSend(filterInfo, timefilter), InvBillAgeHelper.addTransdirBillRecAndSend(filterInfo, timefilter)});
        specialRecAndSendDataSet = InvBillAgeHelper.filterNoUpdateField(specialRecAndSendDataSet, filterInfo).select(billSet.getRowMeta().getFieldNames());
        billSet = billSet.union(specialRecAndSendDataSet);
        billSet = billSet.filter(this.addNostatisticalFilter(filterInfo).toString());
        return billSet;
    }

    private DataSet handleRec(FilterInfo filterInfo, DataSet billSetInvAgeGroup) {
        String[] stringsBillSet = InvBillAgeHelper.getDataSetFieldArray(billSetInvAgeGroup);
        DataSet biztypeDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_biztype", (String)"id as biztypeId", null, null);
        billSetInvAgeGroup = billSetInvAgeGroup.leftJoin(biztypeDataSet).on("biztype", "biztypeId").select(stringsBillSet).finish();
        DataSet invSchemeDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_invscheme", (String)"id as invschemeId,transceivertype.transceiver as transceiver,transceivertype.number as transnumber,isnotupdate", null, null);
        billSetInvAgeGroup = billSetInvAgeGroup.leftJoin(invSchemeDataSet).on("invscheme", "invschemeId").select(stringsBillSet, new String[]{"transceiver", "transnumber", "isnotupdate"}).finish();
        DataSet recBillSet = billSetInvAgeGroup.filter(new QFilter("transceiver", "in", (Object)new String[]{"0", "2"}).and("isnotupdate", "=", (Object)false).toString()).filter("baseqty > 0 and qty > 0").select(stringsBillSet);
        DataSet recBillSet2 = billSetInvAgeGroup.filter(new QFilter("transceiver", "in", (Object)new String[]{"1"}).and("isnotupdate", "=", (Object)false).toString()).filter("baseqty < 0 and qty < 0").select(InvBillAgeHelper.addFileds(InvBillAgeHelper.removeFiled(stringsBillSet, "baseqty", "qty", "outinvtype", "outownertype", "outowner", "invtype", "ownertype", "owner"), "baseqty*-1 as baseqty", "qty*-1 as qty", "outinvtype as invtype", "outownertype as ownertype", "outowner as owner", "0 as outinvtype", " ' ' as outownertype", "0 as outowner")).select(stringsBillSet);
        recBillSet = recBillSet.union(recBillSet2);
        recBillSet = recBillSet.removeFields(new String[]{"outinvtype", "outownertype", "outowner"});
        DataSet specialRecDataSet = InvBillAgeHelper.addInitBillRec(filterInfo).union(new DataSet[]{InvBillAgeHelper.addLocationtransferRec(filterInfo), InvBillAgeHelper.addAdjustBillRec(filterInfo), InvBillAgeHelper.addAssembBillRec(filterInfo), InvBillAgeHelper.addDisassBillRec(filterInfo), InvBillAgeHelper.addTransdirBillRec(filterInfo)});
        specialRecDataSet = InvBillAgeHelper.filterNoUpdateField(specialRecDataSet, filterInfo).select(recBillSet.getRowMeta().getFieldNames());
        recBillSet = recBillSet.union(specialRecDataSet);
        recBillSet = recBillSet.filter(this.addNostatisticalFilter(filterInfo).toString());
        return recBillSet;
    }

    private QFilter addNostatisticalFilter(FilterInfo filterInfo) {
        String nostatistical = filterInfo.getString("nostatistical");
        QFilter qFilter = new QFilter("'1'", "=", (Object)"1");
        if (nostatistical != null && !nostatistical.isEmpty()) {
            String[] nostatisticalArray = nostatistical.split(",");
            for (int i = 0; i < nostatisticalArray.length; ++i) {
                String tmp = nostatisticalArray[i];
                String[] tmps = tmp.split(":");
                if (tmps.length <= 0) continue;
                String billType = tmps[0];
                QFilter qFilter2 = new QFilter("billtype", "!=", (Object)billType);
                if (tmps.length > 1) {
                    long biztypeId = Long.parseLong(tmps[1]);
                    qFilter2.or("biztype", "!=", (Object)biztypeId);
                    if (tmps.length > 2) {
                        long invschemeId = Long.parseLong(tmps[2]);
                        qFilter2.or("invscheme", "!=", (Object)invschemeId);
                    }
                }
                qFilter.and(qFilter2);
            }
            return qFilter;
        }
        return qFilter;
    }

    private DataSet buildBaseBillInfoDataSet(FilterInfo filterInfo, QFilter timefilter) {
        DataSet billSet = null;
        Map<String, String> billAndSelectedFields = this.getBillAndSelectedFields();
        for (Map.Entry<String, String> entry : billAndSelectedFields.entrySet()) {
            String billType = entry.getKey();
            String selectedFields = entry.getValue();
            QFilter billFilter = InvBillAgeHelper.getBillPartQFilter(filterInfo).and(timefilter);
            QFilter billTypeFilter = this.getBillFilter(billType);
            if (billTypeFilter != null) {
                billFilter.and(billTypeFilter);
            }
            DataSet dataSet = null;
            switch (billType) {
                case "im_mdc_mftproorder": 
                case "im_mdc_mftfeedorder": 
                case "im_mdc_mftreturnorder": 
                case "im_mdc_mftmanuinbill": 
                case "im_mdc_mftreturnbill": 
                case "im_mdc_ominbill": 
                case "im_mdc_omfeedorder": 
                case "im_mdc_omproorder": 
                case "im_mdc_omreturnorder": 
                case "im_mdc_omcmplinbill": {
                    QFilter qFilter = new QFilter("billformid", "=", (Object)billType);
                    Map billTypes = BusinessDataServiceHelper.loadFromCache((String)"bos_billtype", (String)"billformid,number,name", (QFilter[])qFilter.toArray(), null);
                    Set billTypeIds = billTypes.keySet();
                    QFilter billTypeIdFilter = new QFilter("billtype", "in", billTypeIds);
                    dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)billType, (String)selectedFields, (QFilter[])new QFilter[]{billFilter, billTypeIdFilter}, null);
                    break;
                }
                default: {
                    dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)billType, (String)selectedFields, (QFilter[])billFilter.toArray(), null);
                }
            }
            if (billSet == null) {
                billSet = dataSet;
                continue;
            }
            billSet = billSet.union(dataSet);
        }
        return billSet;
    }

    private QFilter getBillFilter(String billtype) {
        QFilter qFilter = null;
        DynamicProperty isVirtualBill = EntityMetadataCache.getDataEntityType((String)billtype).getProperty("isvirtualbill");
        if (isVirtualBill != null && StringUtils.isNotEmpty((CharSequence)isVirtualBill.getAlias())) {
            qFilter = new QFilter("isvirtualbill", "=", (Object)Boolean.FALSE);
        }
        switch (billtype) {
            case "im_saloutbill": 
            case "im_purinbill": {
                qFilter = qFilter == null ? new QFilter("isinitbill", "=", (Object)Boolean.FALSE) : qFilter.and("isinitbill", "=", (Object)Boolean.FALSE);
                break;
            }
        }
        return qFilter;
    }

    private Map<String, String> getBillAndSelectedFields() {
        HashMap<String, String> billAndSelectedFields = new HashMap<String, String>(20);
        Map<String, String> mapper = this.getBillEntryMapper();
        String billCommonSelectedFields = InvBillAgeHelper.arraysToString(InvBillAgeHelper.mapperFileds(this.getBillInfoColumnFileds(), mapper, new String[0]));
        billAndSelectedFields.put("im_productinbill", billCommonSelectedFields + ",'im_productinbill' as billType");
        billAndSelectedFields.put("im_materialreqoutbill", billCommonSelectedFields + ",'im_materialreqoutbill' as billType");
        billAndSelectedFields.put("im_saloutbill", billCommonSelectedFields + ",'im_saloutbill' as billType");
        billAndSelectedFields.put("im_purinbill", billCommonSelectedFields + ",'im_purinbill' as billType");
        billAndSelectedFields.put("im_purreceivebill", billCommonSelectedFields + ",'im_purreceivebill' as billType");
        billAndSelectedFields.put("im_transinbill", billCommonSelectedFields + ",'im_transinbill' as billType");
        billAndSelectedFields.put("im_transoutbill", billCommonSelectedFields + ",'im_transoutbill' as billType");
        billAndSelectedFields.put("im_otherinbill", billCommonSelectedFields + ",'im_otherinbill' as billType");
        billAndSelectedFields.put("im_otheroutbill", billCommonSelectedFields + ",'im_otheroutbill' as billType");
        billAndSelectedFields.put("im_mdc_mftproorder", billCommonSelectedFields + ",'im_mdc_mftproorder' as billType");
        billAndSelectedFields.put("im_mdc_mftfeedorder", billCommonSelectedFields + ",'im_mdc_mftfeedorder' as billType");
        billAndSelectedFields.put("im_mdc_mftreturnorder", billCommonSelectedFields + ",'im_mdc_mftreturnorder' as billType");
        billAndSelectedFields.put("im_mdc_mftmanuinbill", billCommonSelectedFields + ",'im_mdc_mftmanuinbill' as billType");
        billAndSelectedFields.put("im_mdc_mftreturnbill", billCommonSelectedFields + ",'im_mdc_mftreturnbill' as billType");
        billAndSelectedFields.put("im_mdc_ominbill", billCommonSelectedFields + ",'im_mdc_ominbill' as billType");
        billAndSelectedFields.put("im_mdc_omfeedorder", billCommonSelectedFields + ",'im_mdc_omfeedorder' as billType");
        billAndSelectedFields.put("im_mdc_omproorder", billCommonSelectedFields + ",'im_mdc_omproorder' as billType");
        billAndSelectedFields.put("im_mdc_omreturnorder", billCommonSelectedFields + ",'im_mdc_omreturnorder' as billType");
        billAndSelectedFields.put("im_mdc_omcmplinbill", billCommonSelectedFields + ",'im_mdc_omcmplinbill' as billType");
        return billAndSelectedFields;
    }

    private String[] getBillInfoColumnFileds() {
        return new String[]{"org", "invtype", "outinvtype", "ownertype", "owner", "outownertype", "outowner", "material", "baseunit", "baseqty", "unit", "qty", "warehouse", "location", "invscheme", "biztype", "lotnumber", "auxpty", "project", "project.number", "configuredcode", "tracknumber", "tracknumber.number", "bookdate", "noupdateinvfields"};
    }

    private Map<String, String> getBillEntryMapper() {
        HashMap<String, String> mapper = new HashMap<String, String>(32);
        mapper.put("material", "billentry.material.masterid");
        mapper.put("baseunit", "billentry.baseunit");
        mapper.put("baseqty", "billentry.baseqty");
        mapper.put("unit", "billentry.unit");
        mapper.put("qty", "billentry.qty");
        mapper.put("warehouse", "billentry.warehouse");
        mapper.put("location", "billentry.location");
        mapper.put("invtype", "billentry.invtype");
        mapper.put("outinvtype", "billentry.outinvtype");
        mapper.put("ownertype", "billentry.ownertype");
        mapper.put("owner", "billentry.owner");
        mapper.put("outownertype", "billentry.outownertype");
        mapper.put("outowner", "billentry.outowner");
        mapper.put("lotnumber", "billentry.lotnumber");
        mapper.put("auxpty", "billentry.auxpty");
        mapper.put("project", "billentry.project");
        mapper.put("project.number", "billentry.project.number");
        mapper.put("configuredcode", "billentry.configuredcode");
        mapper.put("tracknumber", "billentry.tracknumber");
        mapper.put("tracknumber.number", "billentry.tracknumber.number");
        mapper.put("noupdateinvfields", "billentry.noupdateinvfields");
        return mapper;
    }

    private String[] getRecAndSendField() {
        return new String[]{"outbaseqty", "inbaseqty", "outqty", "inqty"};
    }

    private DataSet getClassifiedMaterialDataSet(FilterInfo filterInfo, boolean isMaterialNumber) {
        QFilter materialNumberFilter;
        Object pkValue = null;
        DynamicObject materialgroupstandard = filterInfo.getDynamicObject("materialgroupstandard");
        pkValue = materialgroupstandard == null ? Long.valueOf(730148448254487552L) : materialgroupstandard.getPkValue();
        DataSet classifiedMaterialDataSet = QueryServiceHelper.queryDataSet((String)"bd_materialgroupdetail", (String)"bd_materialgroupdetail", (String)"standard,group,group.number as groupnumber,material,material.number as materialnumber", (QFilter[])new QFilter("standard", "=", pkValue).toArray(), (String)"group desc");
        QFilter materialGroupNumberFilter = InvBillAgeHelper.getDynamicObjectFromToFilter(filterInfo, "groupNumber", "materialgroupfrom", "materialgroupto");
        if (materialGroupNumberFilter != null) {
            classifiedMaterialDataSet = classifiedMaterialDataSet.filter(materialGroupNumberFilter.toString());
        }
        if ((materialNumberFilter = InvBillAgeHelper.getMaterialFromToFilter(filterInfo, "material", isMaterialNumber)) != null) {
            classifiedMaterialDataSet = classifiedMaterialDataSet.filter(materialNumberFilter.toString());
        }
        return classifiedMaterialDataSet;
    }

    private DataSet filterInvtype(FilterInfo filterInfo, DataSet dataSet) {
        DynamicObjectCollection ivntypeheads = filterInfo.getDynamicObjectCollection("ivntypehead");
        if (ivntypeheads != null && ivntypeheads.size() > 0) {
            HashSet<Object> ivntypeIds = new HashSet<Object>();
            for (DynamicObject ivntype : ivntypeheads) {
                ivntypeIds.add(ivntype.getPkValue());
            }
            QFilter invtypeheadFilter = new QFilter("invtype", "in", ivntypeIds);
            invtypeheadFilter.or("outinvtype", "in", ivntypeIds);
            dataSet = dataSet.filter(invtypeheadFilter.toString());
        }
        return dataSet;
    }

    private GroupbyDataSet addSumColumn(GroupbyDataSet dataSet, String[] sumFields) {
        for (String sumField : sumFields) {
            dataSet.sum(sumField);
        }
        return dataSet;
    }

    public static DataSet handleNullFiledAsZero(DataSet dataSet, String ... handleFields) {
        if (handleFields == null || handleFields.length == 0) {
            return dataSet;
        }
        HashMap<String, String> mapper = new HashMap<String, String>(handleFields.length);
        for (String handleField : handleFields) {
            mapper.put(handleField, "case " + handleField + " when null then 0 else " + handleField + " end");
        }
        String[] fileds = InvBillAgeHelper.mapperFileds(InvBillAgeHelper.getDataSetFieldArray(dataSet), mapper, new String[0]);
        return dataSet.select(fileds);
    }
}

