/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.service.mservices;

import com.kingdee.bos.qing.modeler.api.exception.ModelException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.chart.ItemValue;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.scmdi.common.entity.BarChartInfo;
import kd.scmc.scmdi.common.entity.CombinationChartInfo;
import kd.scmc.scmdi.common.entity.DigitalCardInfo;
import kd.scmc.scmdi.common.entity.DimensionInfo;
import kd.scmc.scmdi.common.entity.DullMaterialFilterInfo;
import kd.scmc.scmdi.common.entity.FilterConditionInfo;
import kd.scmc.scmdi.common.entity.InvAgeFilterInfo;
import kd.scmc.scmdi.common.entity.LineChartInfo;
import kd.scmc.scmdi.common.entity.MaterialItoInfo;
import kd.scmc.scmdi.common.entity.StackedBarChartInfo;
import kd.scmc.scmdi.service.mservices.DullMaterialQueryService;
import kd.scmc.scmdi.service.mservices.InvBillAgeQueryService;
import kd.scmc.scmdi.service.mservices.QingModelerHelper;

public class ItoChartDataService {
    public static DigitalCardInfo getItoDigitalCardData(FilterConditionInfo filterConditionInfo) {
        DigitalCardInfo digitalCardInfo = new DigitalCardInfo();
        List<Long> period = filterConditionInfo.getPeriod();
        List<Long> qoqPeriod = filterConditionInfo.getQoqPeriod();
        List<Long> yoyPeriod = filterConditionInfo.getYoyPeriod();
        ItoChartDataService.buildDigitalCardData(filterConditionInfo, period, digitalCardInfo, "period");
        ItoChartDataService.buildDigitalCardData(filterConditionInfo, qoqPeriod, digitalCardInfo, "qoqPeriod");
        ItoChartDataService.buildDigitalCardData(filterConditionInfo, yoyPeriod, digitalCardInfo, "yoyPeriod");
        digitalCardInfo.setSaleCostQOQRate(ItoChartDataService.getRate(digitalCardInfo.getSaleCost(), digitalCardInfo.getSaleCostQOQ()));
        digitalCardInfo.setSaleCostYOYRate(ItoChartDataService.getRate(digitalCardInfo.getSaleCost(), digitalCardInfo.getSaleCostYOY()));
        digitalCardInfo.setInvCostQOQRate(ItoChartDataService.getRate(digitalCardInfo.getInvCost(), digitalCardInfo.getInvCostQOQ()));
        digitalCardInfo.setInvCostYOYRate(ItoChartDataService.getRate(digitalCardInfo.getInvCost(), digitalCardInfo.getInvCostYOY()));
        digitalCardInfo.setStockTurnOverQOQRate(ItoChartDataService.getRate(digitalCardInfo.getStockTurnOver(), digitalCardInfo.getStockTurnOverQOQ()));
        digitalCardInfo.setStockTurnOverYOYRate(ItoChartDataService.getRate(digitalCardInfo.getStockTurnOver(), digitalCardInfo.getStockTurnOverYOY()));
        digitalCardInfo.setTurnOverDayQOQRate(ItoChartDataService.getRate(digitalCardInfo.getTurnOverDay(), digitalCardInfo.getTurnOverDayQOQ()));
        digitalCardInfo.setTurnOverDayYOYRate(ItoChartDataService.getRate(digitalCardInfo.getTurnOverDay(), digitalCardInfo.getTurnOverDayYOY()));
        return digitalCardInfo;
    }

    private static BigDecimal getRate(BigDecimal currentPeriodData, BigDecimal lastPeriodData) {
        if (lastPeriodData == null || lastPeriodData.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        BigDecimal rate = currentPeriodData.subtract(lastPeriodData).divide(lastPeriodData, 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
        return rate;
    }

    private static void buildDigitalCardData(FilterConditionInfo filterConditionInfo, List<Long> period, DigitalCardInfo digitalCardInfo, String periodType) {
        Long materialGroupStandard = filterConditionInfo.getMaterialGroupStandard();
        DimensionInfo saleCostDimensionInfo = ItoChartDataService.buildDimensionInfo(filterConditionInfo, period);
        BigDecimal saleCost = null;
        BigDecimal invCost = null;
        BigDecimal invTurnOver = null;
        BigDecimal turnOverDay = null;
        if (materialGroupStandard != null) {
            List<com.kingdee.bos.qing.modeler.api.response.Row> groupMetricData = QingModelerHelper.getGroupMetricData(saleCostDimensionInfo, filterConditionInfo.getMetricModelWithGroup());
            try {
                for (com.kingdee.bos.qing.modeler.api.response.Row row : groupMetricData) {
                    String fieldValue = row.getString(0);
                    if (!"itometric".equals(fieldValue)) continue;
                    saleCost = row.getBigDecimal("salecostmetric") == null ? null : row.getBigDecimal("salecostmetric").setScale(2, RoundingMode.HALF_UP);
                    invCost = row.getBigDecimal("avginvcost") == null ? null : row.getBigDecimal("avginvcost").setScale(2, RoundingMode.HALF_UP);
                    invTurnOver = row.getBigDecimal("invturnover") == null ? null : row.getBigDecimal("invturnover").setScale(4, RoundingMode.HALF_UP);
                    turnOverDay = row.getBigDecimal("turnoverdays") == null ? null : row.getBigDecimal("turnoverdays").setScale(2, RoundingMode.HALF_UP);
                }
            }
            catch (ModelException e) {
                throw new KDBizException(e.getMessage());
            }
        }
        List<com.kingdee.bos.qing.modeler.api.response.Row> groupMetricData = QingModelerHelper.getGroupMetricData(saleCostDimensionInfo, filterConditionInfo.getMetricModel());
        try {
            for (com.kingdee.bos.qing.modeler.api.response.Row row : groupMetricData) {
                String fieldValue = row.getString(0);
                if (!"itometric".equals(fieldValue)) continue;
                saleCost = row.getBigDecimal("salecostmetric_1") == null ? null : row.getBigDecimal("salecostmetric_1").setScale(2, RoundingMode.HALF_UP);
                invCost = row.getBigDecimal("avginvcost_1") == null ? null : row.getBigDecimal("avginvcost_1").setScale(2, RoundingMode.HALF_UP);
                invTurnOver = row.getBigDecimal("invturnover_1") == null ? null : row.getBigDecimal("invturnover_1").setScale(4, RoundingMode.HALF_UP);
                turnOverDay = row.getBigDecimal("turnoverdays_1") == null ? null : row.getBigDecimal("turnoverdays_1").setScale(2, RoundingMode.HALF_UP);
            }
        }
        catch (ModelException e) {
            throw new KDBizException(e.getMessage());
        }
        if ("period".equals(periodType)) {
            digitalCardInfo.setSaleCost(saleCost);
            digitalCardInfo.setInvCost(invCost);
            digitalCardInfo.setStockTurnOver(invTurnOver);
            digitalCardInfo.setTurnOverDay(turnOverDay);
        } else if ("qoqPeriod".equals(periodType)) {
            digitalCardInfo.setSaleCostQOQ(saleCost);
            digitalCardInfo.setInvCostQOQ(invCost);
            digitalCardInfo.setStockTurnOverQOQ(invTurnOver);
            digitalCardInfo.setTurnOverDayQOQ(turnOverDay);
        } else if ("yoyPeriod".equals(periodType)) {
            digitalCardInfo.setSaleCostYOY(saleCost);
            digitalCardInfo.setInvCostYOY(invCost);
            digitalCardInfo.setStockTurnOverYOY(invTurnOver);
            digitalCardInfo.setTurnOverDayYOY(turnOverDay);
        }
    }

    private static DimensionInfo buildDimensionInfo(FilterConditionInfo filterConditionInfo, List<Long> period) {
        DimensionInfo dimensionInfo = new DimensionInfo();
        dimensionInfo.setCalOrg(filterConditionInfo.getCalOrg());
        dimensionInfo.setCostAccount(filterConditionInfo.getCostAccount());
        dimensionInfo.setMaterialGroupStandard(filterConditionInfo.getMaterialGroupStandard());
        dimensionInfo.setMaterialGroup(filterConditionInfo.getMaterialGroup());
        dimensionInfo.setMaterial(filterConditionInfo.getMaterial());
        dimensionInfo.setPeriod(period);
        return dimensionInfo;
    }

    public static CombinationChartInfo getItoTrendChartData(FilterConditionInfo filterConditionInfo) {
        CombinationChartInfo combinationChartInfo = new CombinationChartInfo();
        List<Long> period = filterConditionInfo.getPeriod();
        List<Long> yoyPeriod = filterConditionInfo.getYoyPeriod();
        List<String> periodName = filterConditionInfo.getPeriodName();
        combinationChartInfo.setPeriodAxis(periodName);
        BigDecimal[] barData = ItoChartDataService.buildItoBarData(filterConditionInfo, period);
        BigDecimal[] yoyBarData = ItoChartDataService.buildItoBarData(filterConditionInfo, yoyPeriod);
        LinkedHashMap<String, BigDecimal[]> barMap = new LinkedHashMap<String, BigDecimal[]>(2);
        barMap.put(ResManager.loadKDString((String)"\u5e93\u5b58\u5468\u8f6c\u7387", (String)"ItoChartDataService_16", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]), barData);
        barMap.put(ResManager.loadKDString((String)"\u540c\u671f\u5e93\u5b58\u5468\u8f6c\u7387", (String)"ItoChartDataService_27", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]), yoyBarData);
        combinationChartInfo.setBarChartData(barMap);
        BigDecimal[] lineData = ItoChartDataService.buildItoLineData(barData);
        BigDecimal[] yoyLineData = ItoChartDataService.buildItoLineData(yoyBarData);
        LinkedHashMap<String, BigDecimal[]> lineMap = new LinkedHashMap<String, BigDecimal[]>(2);
        lineMap.put(ResManager.loadKDString((String)"\u5f53\u524d\u8d8b\u52bf", (String)"ItoChartDataService_30", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]), lineData);
        lineMap.put(ResManager.loadKDString((String)"\u540c\u671f\u8d8b\u52bf", (String)"ItoChartDataService_31", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]), yoyLineData);
        combinationChartInfo.setLineChartData(lineMap);
        return combinationChartInfo;
    }

    private static BigDecimal[] buildItoLineData(BigDecimal[] barData) {
        BigDecimal[] data = new BigDecimal[barData.length];
        data[0] = null;
        for (int i = 1; i < data.length; ++i) {
            int sign = i - 1;
            if (barData[i] == null || barData[sign] == null || barData[sign].compareTo(BigDecimal.ZERO) == 0) {
                data[i] = null;
                continue;
            }
            int flag = i - 1;
            data[i] = barData[i].subtract(barData[flag]).divide(barData[flag], 2, RoundingMode.HALF_UP);
        }
        return data;
    }

    private static BigDecimal[] buildItoBarData(FilterConditionInfo filterConditionInfo, List<Long> period) {
        BigDecimal ito;
        Long periodId;
        List<com.kingdee.bos.qing.modeler.api.response.Row> metricDataGroupByPeriod;
        Long materialGroupStandard = filterConditionInfo.getMaterialGroupStandard();
        DimensionInfo dimensionInfo = ItoChartDataService.buildDimensionInfo(filterConditionInfo, period);
        HashMap<Long, BigDecimal> itoGroupByPeriodMap = new HashMap<Long, BigDecimal>(12);
        if (materialGroupStandard != null) {
            metricDataGroupByPeriod = QingModelerHelper.getMetricDataGroupByPeriod(dimensionInfo, filterConditionInfo.getMetricModelWithGroup());
            for (com.kingdee.bos.qing.modeler.api.response.Row row : metricDataGroupByPeriod) {
                try {
                    periodId = row.getLong("periodid");
                    ito = row.getBigDecimal("invturnover") == null ? null : row.getBigDecimal("invturnover").setScale(4, RoundingMode.HALF_UP);
                }
                catch (ModelException e) {
                    throw new KDBizException(e.getMessage());
                }
                itoGroupByPeriodMap.put(periodId, ito);
            }
        } else {
            metricDataGroupByPeriod = QingModelerHelper.getMetricDataGroupByPeriod(dimensionInfo, filterConditionInfo.getMetricModel());
            for (com.kingdee.bos.qing.modeler.api.response.Row row : metricDataGroupByPeriod) {
                try {
                    periodId = row.getLong("periodid");
                    ito = row.getBigDecimal("invturnover_1") == null ? null : row.getBigDecimal("invturnover_1").setScale(4, RoundingMode.HALF_UP);
                }
                catch (ModelException e) {
                    throw new KDBizException(e.getMessage());
                }
                itoGroupByPeriodMap.put(periodId, ito);
            }
        }
        BigDecimal[] data = new BigDecimal[period.size()];
        for (int i = 0; i < period.size(); ++i) {
            data[i] = (BigDecimal)itoGroupByPeriodMap.get(period.get(i));
        }
        return data;
    }

    public static CombinationChartInfo getTurnOverDayTrendChartData(FilterConditionInfo filterConditionInfo) {
        CombinationChartInfo combinationChartInfo = new CombinationChartInfo();
        List<Long> period = filterConditionInfo.getPeriod();
        List<Long> yoyPeriod = filterConditionInfo.getYoyPeriod();
        List<String> periodName = filterConditionInfo.getPeriodName();
        combinationChartInfo.setPeriodAxis(periodName);
        BigDecimal[] barData = ItoChartDataService.buildTurnOverDayBarData(filterConditionInfo, period);
        BigDecimal[] yoyBarData = ItoChartDataService.buildTurnOverDayBarData(filterConditionInfo, yoyPeriod);
        LinkedHashMap<String, BigDecimal[]> barMap = new LinkedHashMap<String, BigDecimal[]>(2);
        barMap.put(ResManager.loadKDString((String)"\u5468\u8f6c\u5929\u6570", (String)"ItoChartDataService_28", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]), barData);
        barMap.put(ResManager.loadKDString((String)"\u540c\u671f\u5468\u8f6c\u5929\u6570", (String)"ItoChartDataService_29", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]), yoyBarData);
        combinationChartInfo.setBarChartData(barMap);
        BigDecimal[] lineData = ItoChartDataService.buildItoLineData(barData);
        BigDecimal[] yoyLineData = ItoChartDataService.buildItoLineData(yoyBarData);
        LinkedHashMap<String, BigDecimal[]> lineMap = new LinkedHashMap<String, BigDecimal[]>(2);
        lineMap.put(ResManager.loadKDString((String)"\u5f53\u524d\u8d8b\u52bf", (String)"ItoChartDataService_30", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]), lineData);
        lineMap.put(ResManager.loadKDString((String)"\u540c\u671f\u8d8b\u52bf", (String)"ItoChartDataService_31", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]), yoyLineData);
        combinationChartInfo.setLineChartData(lineMap);
        return combinationChartInfo;
    }

    private static BigDecimal[] buildTurnOverDayBarData(FilterConditionInfo filterConditionInfo, List<Long> period) {
        BigDecimal ito;
        Long periodId;
        List<com.kingdee.bos.qing.modeler.api.response.Row> metricDataGroupByPeriod;
        Long materialGroupStandard = filterConditionInfo.getMaterialGroupStandard();
        DimensionInfo dimensionInfo = ItoChartDataService.buildDimensionInfo(filterConditionInfo, period);
        HashMap<Long, BigDecimal> turnOverDayGroupByPeriodMap = new HashMap<Long, BigDecimal>(12);
        if (materialGroupStandard != null) {
            metricDataGroupByPeriod = QingModelerHelper.getMetricDataGroupByPeriod(dimensionInfo, filterConditionInfo.getMetricModelWithGroup());
            for (com.kingdee.bos.qing.modeler.api.response.Row row : metricDataGroupByPeriod) {
                try {
                    periodId = row.getLong("periodid");
                    ito = row.getBigDecimal("turnoverdays") == null ? null : row.getBigDecimal("turnoverdays").setScale(2, RoundingMode.HALF_UP);
                }
                catch (ModelException e) {
                    throw new KDBizException(e.getMessage());
                }
                turnOverDayGroupByPeriodMap.put(periodId, ito);
            }
        } else {
            metricDataGroupByPeriod = QingModelerHelper.getMetricDataGroupByPeriod(dimensionInfo, filterConditionInfo.getMetricModel());
            for (com.kingdee.bos.qing.modeler.api.response.Row row : metricDataGroupByPeriod) {
                try {
                    periodId = row.getLong("periodid");
                    ito = row.getBigDecimal("turnoverdays_1") == null ? null : row.getBigDecimal("turnoverdays_1").setScale(2, RoundingMode.HALF_UP);
                }
                catch (ModelException e) {
                    throw new KDBizException(e.getMessage());
                }
                turnOverDayGroupByPeriodMap.put(periodId, ito);
            }
        }
        BigDecimal[] data = new BigDecimal[period.size()];
        for (int i = 0; i < period.size(); ++i) {
            data[i] = (BigDecimal)turnOverDayGroupByPeriodMap.get(period.get(i));
        }
        return data;
    }

    public static BarChartInfo getMaterialGroupItoChartData(FilterConditionInfo filterConditionInfo) {
        BarChartInfo barChartInfo = new BarChartInfo();
        List<Long> period = filterConditionInfo.getPeriod();
        DimensionInfo dimensionInfo = ItoChartDataService.buildDimensionInfo(filterConditionInfo, period);
        List<com.kingdee.bos.qing.modeler.api.response.Row> metricDataGroupByMaterialGroup = QingModelerHelper.getMetricDataGroupByMaterialGroup(dimensionInfo, filterConditionInfo.getMetricModelWithGroup(), true);
        HashMap<Object, BigDecimal> itoMap = new HashMap<Object, BigDecimal>(metricDataGroupByMaterialGroup.size());
        for (com.kingdee.bos.qing.modeler.api.response.Row row : metricDataGroupByMaterialGroup) {
            BigDecimal bigDecimal;
            Long groupId;
            try {
                groupId = row.getLong("groupid");
                bigDecimal = row.getBigDecimal("invturnover") == null ? BigDecimal.ZERO : row.getBigDecimal("invturnover").setScale(4, RoundingMode.HALF_UP);
            }
            catch (ModelException e) {
                throw new KDBizException(e.getMessage());
            }
            if (groupId == null) continue;
            itoMap.put(groupId, bigDecimal);
        }
        LinkedList list = new LinkedList(itoMap.entrySet());
        list.sort(Map.Entry.comparingByValue());
        LinkedHashMap sortMap = new LinkedHashMap(list.size());
        for (Map.Entry entry : list) {
            sortMap.put(entry.getKey(), entry.getValue());
        }
        ArrayList groupIdList = new ArrayList(sortMap.size());
        ArrayList arrayList = new ArrayList(sortMap.size());
        sortMap.forEach((key, value) -> {
            groupIdList.add(key);
            itoList.add(value);
        });
        QFilter qFilter = new QFilter("id", "in", groupIdList);
        Map materialGroupColl = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroup", (String)"number,name", (QFilter[])new QFilter[]{qFilter});
        ArrayList<String> axis = new ArrayList<String>(materialGroupColl.size());
        for (Long groupId : groupIdList) {
            DynamicObject materialGroup = (DynamicObject)materialGroupColl.get(groupId);
            if (materialGroup == null) continue;
            String name = materialGroup.getString("name");
            axis.add(name);
        }
        barChartInfo.setPeriodAxis(axis);
        barChartInfo.setBarChartName(ResManager.loadKDString((String)"\u5e93\u5b58\u5468\u8f6c\u7387", (String)"ItoChartDataService_16", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
        barChartInfo.setBarChartData(arrayList.toArray(new BigDecimal[0]));
        return barChartInfo;
    }

    public static LineChartInfo getSaleCostAndQtyChartData(FilterConditionInfo filterConditionInfo) {
        LineChartInfo lineChartInfo = new LineChartInfo();
        List<Long> period = filterConditionInfo.getPeriod();
        List<String> periodName = filterConditionInfo.getPeriodName();
        lineChartInfo.setPeriodAxis(periodName);
        BigDecimal[] data = ItoChartDataService.buildSaleCostData(filterConditionInfo, period);
        lineChartInfo.setFirstLineChartData(data);
        lineChartInfo.setFirstLineChartName(ResManager.loadKDString((String)"\u9500\u552e\u6210\u672c", (String)"ItoChartDataService_17", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
        return lineChartInfo;
    }

    private static BigDecimal[] buildSaleCostData(FilterConditionInfo filterConditionInfo, List<Long> period) {
        BigDecimal ito;
        Long periodId;
        List<com.kingdee.bos.qing.modeler.api.response.Row> metricDataGroupByPeriod;
        Long materialGroupStandard = filterConditionInfo.getMaterialGroupStandard();
        DimensionInfo dimensionInfo = ItoChartDataService.buildDimensionInfo(filterConditionInfo, period);
        HashMap<Long, BigDecimal> saleCostGroupByPeriodMap = new HashMap<Long, BigDecimal>(12);
        if (materialGroupStandard != null) {
            metricDataGroupByPeriod = QingModelerHelper.getMetricDataGroupByPeriod(dimensionInfo, filterConditionInfo.getMetricModelWithGroup());
            for (com.kingdee.bos.qing.modeler.api.response.Row row : metricDataGroupByPeriod) {
                try {
                    periodId = row.getLong("periodid");
                    ito = row.getBigDecimal("salecostmetric") == null ? BigDecimal.ZERO : row.getBigDecimal("salecostmetric").stripTrailingZeros();
                }
                catch (ModelException e) {
                    throw new KDBizException(e.getMessage());
                }
                saleCostGroupByPeriodMap.put(periodId, ito);
            }
        } else {
            metricDataGroupByPeriod = QingModelerHelper.getMetricDataGroupByPeriod(dimensionInfo, filterConditionInfo.getMetricModel());
            for (com.kingdee.bos.qing.modeler.api.response.Row row : metricDataGroupByPeriod) {
                try {
                    periodId = row.getLong("periodid");
                    ito = row.getBigDecimal("salecostmetric_1") == null ? BigDecimal.ZERO : row.getBigDecimal("salecostmetric_1").stripTrailingZeros();
                }
                catch (ModelException e) {
                    throw new KDBizException(e.getMessage());
                }
                saleCostGroupByPeriodMap.put(periodId, ito);
            }
        }
        BigDecimal[] data = new BigDecimal[period.size()];
        for (int i = 0; i < period.size(); ++i) {
            data[i] = (BigDecimal)saleCostGroupByPeriodMap.get(period.get(i));
        }
        return data;
    }

    public static LineChartInfo getInvCostAndQtyChartData(FilterConditionInfo filterConditionInfo) {
        LineChartInfo lineChartInfo = new LineChartInfo();
        List<Long> period = filterConditionInfo.getPeriod();
        List<String> periodName = filterConditionInfo.getPeriodName();
        lineChartInfo.setPeriodAxis(periodName);
        BigDecimal[] data = ItoChartDataService.buildInvCostData(filterConditionInfo, period);
        lineChartInfo.setFirstLineChartData(data);
        lineChartInfo.setFirstLineChartName(ResManager.loadKDString((String)"\u5e93\u5b58\u6210\u672c", (String)"ItoChartDataService_19", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]));
        return lineChartInfo;
    }

    private static BigDecimal[] buildInvCostData(FilterConditionInfo filterConditionInfo, List<Long> period) {
        BigDecimal ito;
        Long periodId;
        List<com.kingdee.bos.qing.modeler.api.response.Row> metricDataGroupByPeriod;
        Long materialGroupStandard = filterConditionInfo.getMaterialGroupStandard();
        DimensionInfo dimensionInfo = ItoChartDataService.buildDimensionInfo(filterConditionInfo, period);
        HashMap<Long, BigDecimal> invCostGroupByPeriodMap = new HashMap<Long, BigDecimal>(12);
        if (materialGroupStandard != null) {
            metricDataGroupByPeriod = QingModelerHelper.getMetricDataGroupByPeriod(dimensionInfo, filterConditionInfo.getMetricModelWithGroup());
            for (com.kingdee.bos.qing.modeler.api.response.Row row : metricDataGroupByPeriod) {
                try {
                    periodId = row.getLong("periodid");
                    ito = row.getBigDecimal("avginvcost") == null ? BigDecimal.ZERO : row.getBigDecimal("avginvcost").stripTrailingZeros();
                }
                catch (ModelException e) {
                    throw new KDBizException(e.getMessage());
                }
                invCostGroupByPeriodMap.put(periodId, ito);
            }
        } else {
            metricDataGroupByPeriod = QingModelerHelper.getMetricDataGroupByPeriod(dimensionInfo, filterConditionInfo.getMetricModel());
            for (com.kingdee.bos.qing.modeler.api.response.Row row : metricDataGroupByPeriod) {
                try {
                    periodId = row.getLong("periodid");
                    ito = row.getBigDecimal("avginvcost_1") == null ? BigDecimal.ZERO : row.getBigDecimal("avginvcost_1").stripTrailingZeros();
                }
                catch (ModelException e) {
                    throw new KDBizException(e.getMessage());
                }
                invCostGroupByPeriodMap.put(periodId, ito);
            }
        }
        BigDecimal[] data = new BigDecimal[period.size()];
        for (int i = 0; i < period.size(); ++i) {
            data[i] = (BigDecimal)invCostGroupByPeriodMap.get(period.get(i));
        }
        return data;
    }

    public static List<Object[]> getSaleAndInvCostChartData(FilterConditionInfo filterConditionInfo, boolean zeroShow) {
        List<Long> period = filterConditionInfo.getPeriod();
        DimensionInfo dimensionInfo = ItoChartDataService.buildDimensionInfo(filterConditionInfo, period);
        List<com.kingdee.bos.qing.modeler.api.response.Row> metricDataGroupByMaterial = QingModelerHelper.getMetricDataGroupByMaterial(dimensionInfo, filterConditionInfo.getMetricModelWithGroup());
        ArrayList<Long> materialIdList = new ArrayList<Long>(16);
        for (com.kingdee.bos.qing.modeler.api.response.Row row : metricDataGroupByMaterial) {
            Long materialId;
            try {
                materialId = row.getLong("materialid");
            }
            catch (ModelException e) {
                throw new KDBizException(e.getMessage());
            }
            if (materialId == null) continue;
            materialIdList.add(materialId);
        }
        QFilter materialFilter = new QFilter("id", "in", materialIdList);
        Map materialColl = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"number,name", (QFilter[])new QFilter[]{materialFilter});
        List<Object> list = new ArrayList(16);
        for (com.kingdee.bos.qing.modeler.api.response.Row row : metricDataGroupByMaterial) {
            BigDecimal ito;
            BigDecimal invCost;
            BigDecimal saleCost;
            Long l;
            try {
                l = row.getLong("materialid");
                saleCost = row.getBigDecimal("salecostmetric") == null ? BigDecimal.ZERO : row.getBigDecimal("salecostmetric").stripTrailingZeros();
                invCost = row.getBigDecimal("avginvcost") == null ? BigDecimal.ZERO : row.getBigDecimal("avginvcost").stripTrailingZeros();
                ito = row.getBigDecimal("invturnover") == null ? BigDecimal.ZERO : row.getBigDecimal("invturnover").stripTrailingZeros();
            }
            catch (ModelException e) {
                throw new KDBizException(e.getMessage());
            }
            if (l == null) continue;
            MaterialItoInfo materialItoInfo2 = new MaterialItoInfo();
            materialItoInfo2.setMaterial((DynamicObject)materialColl.get(l));
            materialItoInfo2.setSaleCost(saleCost);
            materialItoInfo2.setInventoryCost(invCost);
            materialItoInfo2.setTurnRate(ito);
            list.add(materialItoInfo2);
        }
        if (!zeroShow) {
            list = list.stream().filter(materialItoInfo -> materialItoInfo.getTurnRate().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        }
        ArrayList<Object[]> chartData = new ArrayList<Object[]>(list.size());
        for (MaterialItoInfo materialItoInfo2 : list) {
            Object[] data = new Object[4];
            data[0] = materialItoInfo2.getInventoryCost();
            data[1] = materialItoInfo2.getSaleCost();
            data[2] = materialItoInfo2.getTurnRate();
            DynamicObject material = materialItoInfo2.getMaterial();
            data[3] = material.getString("name");
            chartData.add(data);
        }
        return chartData;
    }

    public static ItemValue[] getInvAgeChartData(InvAgeFilterInfo invAgeFilterInfo) {
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filter = new FilterInfo();
        filter.addFilterItem("ageanalysis", (Object)"1", CompareTypeEnum.CHECKBOXEQUAL.getId());
        filter.addFilterItem("enddate", (Object)invAgeFilterInfo.getEndDate(), CompareTypeEnum.EQUAL.getId());
        filter.addFilterItem("orghead", (Object)invAgeFilterInfo.getCalOrg(), CompareTypeEnum.ORGEQUAL.getId());
        filter.addFilterItem("materialgroupstandard", (Object)invAgeFilterInfo.getMaterialGroupStandard(), CompareTypeEnum.EQUAL.getId());
        filter.addFilterItem("materialgroupfrom", (Object)invAgeFilterInfo.getMaterialGroupFrom(), CompareTypeEnum.EQUAL.getId());
        filter.addFilterItem("materialgroupto", (Object)invAgeFilterInfo.getMaterialGroupTo(), CompareTypeEnum.EQUAL.getId());
        DynamicObjectCollection materialColl = invAgeFilterInfo.getMaterial();
        if (materialColl != null && materialColl.size() == 1) {
            filter.addFilterItem("materialnumberfrom", (Object)materialColl, CompareTypeEnum.EQUAL.getId());
            DynamicObject to = ((DynamicObject)materialColl.get(0)).getDynamicObject(1);
            filter.addFilterItem("materialnumberto", (Object)to, CompareTypeEnum.EQUAL.getId());
        } else {
            filter.addFilterItem("materialnumberfrom", (Object)materialColl, CompareTypeEnum.EQUAL.getId());
            filter.addFilterItem("materialnumberto", null, CompareTypeEnum.EQUAL.getId());
        }
        filter.addFilterItem("intervaldays", (Object)invAgeFilterInfo.getIntervalDays(), "=");
        queryParam.setFilter(filter);
        DataSet dataSet = ItoChartDataService.queryInvBillAge(queryParam);
        List<String> invAgeGroup = invAgeFilterInfo.getInvAgeGroup();
        int size = invAgeGroup.size();
        ArrayList<Integer> data = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            int count = 0;
            if (dataSet != null && !dataSet.isEmpty()) {
                count = dataSet.copy().filter("baseqtyrang" + i + " > 0").count("material", true);
            }
            data.add(count);
        }
        List<String> colorList = ItoChartDataService.getColorList();
        ItemValue[] items = new ItemValue[size];
        for (int i = 0; i < size; ++i) {
            String groupName = invAgeGroup.get(i);
            Integer num = (Integer)data.get(i);
            String color = i >= 6 ? colorList.get(6) : colorList.get(i);
            items[i] = new ItemValue(groupName, (Number)num, color);
        }
        return items;
    }

    private static List<String> getColorList() {
        ArrayList<String> labelColorList = new ArrayList<String>(12);
        labelColorList.add("#95DE65");
        labelColorList.add("#FFA940");
        labelColorList.add("#FFD666");
        labelColorList.add("#F57582");
        labelColorList.add("#1890FF");
        labelColorList.add("#45DAD1");
        labelColorList.add("#9F69E2");
        return labelColorList;
    }

    private static DataSet queryInvBillAge(ReportQueryParam queryParam) {
        InvBillAgeQueryService invBillAgeQueryService = new InvBillAgeQueryService();
        try {
            return invBillAgeQueryService.query(queryParam, null);
        }
        catch (Throwable e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static StackedBarChartInfo getInvDullChartData(DullMaterialFilterInfo dullMaterialFilterInfo) {
        Map<Object, DynamicObject> periodColl = dullMaterialFilterInfo.getPeriod();
        List<String> periodName = periodColl.values().stream().map(period -> period.getString("name")).collect(Collectors.toList());
        List<Long> materialGroupColl = ItoChartDataService.getMaterialGroupColl(dullMaterialFilterInfo);
        Map<String, Set<Long>> billTypeToInvSchemes = ItoChartDataService.getBillTypeToInvSchemes();
        Map<String, Set<Long>> inBillToInvSchemes = ItoChartDataService.buildBillTypeToInvSchemes(billTypeToInvSchemes, "in");
        Map<String, Set<Long>> outBillToInvSchemes = ItoChartDataService.buildBillTypeToInvSchemes(billTypeToInvSchemes, "out");
        ArrayList<BigDecimal> avgInvCostList = new ArrayList<BigDecimal>(periodColl.size());
        ArrayList<BigDecimal> dullInvCostList = new ArrayList<BigDecimal>(periodColl.size());
        for (DynamicObject period2 : periodColl.values()) {
            Date endDate = period2.getDate("enddate");
            ReportQueryParam dullMaterialQueryParam = ItoChartDataService.getDullMaterialQueryParam(dullMaterialFilterInfo, endDate, inBillToInvSchemes, outBillToInvSchemes);
            DataSet dataSet = ItoChartDataService.queryDullMaterial(dullMaterialQueryParam);
            ArrayList<Long> materialIdList = new ArrayList<Long>(16);
            for (Row row : dataSet) {
                Long material = row.getLong("material");
                materialIdList.add(material);
            }
            Long periodId = (Long)period2.getPkValue();
            DimensionInfo dimensionInfo = new DimensionInfo();
            dimensionInfo.setCalOrg(dullMaterialFilterInfo.getCalOrg().getLong("id"));
            DynamicObject costAccount = dullMaterialFilterInfo.getCostAccount();
            if (costAccount != null) {
                dimensionInfo.setCostAccount(costAccount.getLong("id"));
            }
            dimensionInfo.setMaterialGroupStandard(dullMaterialFilterInfo.getMaterialGroupStandard().getLong("id"));
            dimensionInfo.setMaterialGroup(materialGroupColl);
            dimensionInfo.setPeriod(Collections.singletonList(periodId));
            List<com.kingdee.bos.qing.modeler.api.response.Row> groupMetricData = QingModelerHelper.getGroupMetricData(dimensionInfo, dullMaterialFilterInfo.getMetricModelWithGroup());
            BigDecimal avgInvCost = null;
            try {
                for (com.kingdee.bos.qing.modeler.api.response.Row row : groupMetricData) {
                    String fieldValue = row.getString(0);
                    if (!"itometric".equals(fieldValue)) continue;
                    avgInvCost = row.getBigDecimal("avginvcost") == null ? null : row.getBigDecimal("avginvcost");
                }
            }
            catch (ModelException e) {
                throw new KDBizException(e.getMessage());
            }
            avgInvCostList.add(avgInvCost);
            if (materialIdList.isEmpty()) {
                dullInvCostList.add(null);
                continue;
            }
            DimensionInfo dullDimensionInfo = new DimensionInfo();
            dullDimensionInfo.setCalOrg(dullMaterialFilterInfo.getCalOrg().getLong("id"));
            if (costAccount != null) {
                dimensionInfo.setCostAccount(costAccount.getLong("id"));
            }
            dullDimensionInfo.setMaterialGroupStandard(dullMaterialFilterInfo.getMaterialGroupStandard().getLong("id"));
            dullDimensionInfo.setMaterialGroup(materialGroupColl);
            dullDimensionInfo.setPeriod(Collections.singletonList(periodId));
            dullDimensionInfo.setMaterial(materialIdList);
            List<com.kingdee.bos.qing.modeler.api.response.Row> dullMetricData = QingModelerHelper.getGroupMetricData(dullDimensionInfo, dullMaterialFilterInfo.getMetricModelWithGroup());
            BigDecimal dullInvCost = null;
            try {
                for (com.kingdee.bos.qing.modeler.api.response.Row row : dullMetricData) {
                    String fieldValue = row.getString(0);
                    if (!"itometric".equals(fieldValue)) continue;
                    dullInvCost = row.getBigDecimal("avginvcost") == null ? null : row.getBigDecimal("avginvcost");
                }
            }
            catch (ModelException e) {
                throw new KDBizException(e.getMessage());
            }
            dullInvCostList.add(dullInvCost);
        }
        BigDecimal[] benignInvCostRate = new BigDecimal[avgInvCostList.size()];
        BigDecimal[] dullInvCostRate = new BigDecimal[dullInvCostList.size()];
        for (int i = 0; i < avgInvCostList.size(); ++i) {
            BigDecimal benignRate;
            BigDecimal avgInvCost = (BigDecimal)avgInvCostList.get(i);
            if (avgInvCost == null || avgInvCost.compareTo(BigDecimal.ZERO) == 0) {
                benignInvCostRate[i] = null;
                dullInvCostRate[i] = null;
                continue;
            }
            BigDecimal dullInvCost = (BigDecimal)dullInvCostList.get(i);
            if (dullInvCost == null) {
                benignInvCostRate[i] = new BigDecimal("100");
                dullInvCostRate[i] = null;
                continue;
            }
            BigDecimal dullRate = dullInvCost.divide(avgInvCost, 3, RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
            benignInvCostRate[i] = benignRate = new BigDecimal("100").subtract(dullRate);
            dullInvCostRate[i] = dullRate;
        }
        StackedBarChartInfo stackedBarChartInfo = new StackedBarChartInfo();
        stackedBarChartInfo.setPeriodAxis(periodName);
        HashMap<String, BigDecimal[]> map = new HashMap<String, BigDecimal[]>(2);
        map.put(ResManager.loadKDString((String)"\u826f\u6027\u5e93\u5b58", (String)"ItoChartDataService_42", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]), benignInvCostRate);
        map.put(ResManager.loadKDString((String)"\u5446\u6ede\u5e93\u5b58", (String)"ItoChartDataService_43", (String)"scmc-scmdi-themeanalysis", (Object[])new Object[0]), dullInvCostRate);
        stackedBarChartInfo.setBarChartData(map);
        return stackedBarChartInfo;
    }

    private static List<Long> getMaterialGroupColl(DullMaterialFilterInfo dullMaterialFilterInfo) {
        DynamicObject materialGroupStandard = dullMaterialFilterInfo.getMaterialGroupStandard();
        DynamicObjectCollection materialGroupFrom = dullMaterialFilterInfo.getMaterialGroupFrom();
        DynamicObject materialGroupTo = dullMaterialFilterInfo.getMaterialGroupTo();
        List<Long> idList = new ArrayList<Long>(16);
        if (materialGroupFrom != null && !materialGroupFrom.isEmpty()) {
            if (materialGroupFrom.size() > 1) {
                idList = materialGroupFrom.stream().map(from -> from.getLong("fbasedataid.id")).collect(Collectors.toList());
            } else if (materialGroupTo != null) {
                DynamicObject from2 = ((DynamicObject)materialGroupFrom.get(0)).getDynamicObject(1);
                QFilter filter = new QFilter("number", ">=", from2.get("number"));
                filter.and(new QFilter("standard", "=", materialGroupStandard.getPkValue()));
                filter.and(new QFilter("number", "<=", materialGroupTo.get("number")));
                DynamicObjectCollection materialGroupDetail = QueryServiceHelper.query((String)"bd_materialgroup", (String)"id,number", (QFilter[])new QFilter[]{filter});
                for (DynamicObject groupDetail : materialGroupDetail) {
                    Long group = groupDetail.getLong("id");
                    idList.add(group);
                }
            } else {
                Long id = ((DynamicObject)materialGroupFrom.get(0)).getDynamicObject(1).getLong("id");
                idList.add(id);
            }
        }
        return idList;
    }

    private static DataSet queryDullMaterial(ReportQueryParam dullMaterialQueryParam) {
        DullMaterialQueryService dullMaterialQueryService = new DullMaterialQueryService();
        try {
            return dullMaterialQueryService.query(dullMaterialQueryParam, null);
        }
        catch (Throwable e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private static ReportQueryParam getDullMaterialQueryParam(DullMaterialFilterInfo dullMaterialFilterInfo, Date endDate, Map<String, Set<Long>> inBillToInvSchemes, Map<String, Set<Long>> outBillToInvSchemes) {
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filter = new FilterInfo();
        filter.addFilterItem("dullanalyseobj", (Object)"1", CompareTypeEnum.CHECKBOXEQUAL.getId());
        filter.addFilterItem("orghead", (Object)dullMaterialFilterInfo.getCalOrg(), CompareTypeEnum.EQUAL.getId());
        filter.addFilterItem("materialgroupstandard", (Object)dullMaterialFilterInfo.getMaterialGroupStandard(), CompareTypeEnum.EQUAL.getId());
        filter.addFilterItem("materialgroupfrom", (Object)dullMaterialFilterInfo.getMaterialGroupFrom(), CompareTypeEnum.EQUAL.getId());
        filter.addFilterItem("materialgroupto", (Object)dullMaterialFilterInfo.getMaterialGroupTo(), CompareTypeEnum.EQUAL.getId());
        filter.addFilterItem("materialnumberfrom", (Object)dullMaterialFilterInfo.getMaterial(), CompareTypeEnum.EQUAL.getId());
        filter.addFilterItem("deadline", (Object)endDate, CompareTypeEnum.EQUAL.getId());
        filter.addFilterItem("dulldays", (Object)dullMaterialFilterInfo.getDullDays(), CompareTypeEnum.EQUAL.getId());
        filter.addFilterItem("dulltype", (Object)dullMaterialFilterInfo.getDullType(), CompareTypeEnum.CHECKBOXEQUAL.getId());
        filter.addFilterItem("inBillToInvschemes", inBillToInvSchemes);
        filter.addFilterItem("outBillToInvschemes", outBillToInvSchemes);
        queryParam.setFilter(filter);
        return queryParam;
    }

    private static Map<String, Set<Long>> getBillTypeToInvSchemes() {
        HashMap<String, Set<Long>> billTypeToInvSchemes = new HashMap<String, Set<Long>>(16);
        ArrayList<String> billTypes = new ArrayList<String>();
        billTypes.add("im_productinbill");
        billTypes.add("im_purinbill");
        billTypes.add("im_otherinbill");
        billTypes.add("im_transinbill");
        billTypes.add("im_transdirbill");
        billTypes.add("im_ospurinbill");
        billTypes.add("im_saloutbill");
        billTypes.add("im_materialreqoutbill");
        billTypes.add("im_otheroutbill");
        billTypes.add("im_transoutbill");
        billTypes.add("im_transdirbill");
        billTypes.add("im_osmaterialreqoutbill");
        QFilter invSchemeFilter = new QFilter("billform", "in", billTypes);
        invSchemeFilter.and("enable", "=", (Object)Boolean.TRUE);
        invSchemeFilter.and("isnotupdate", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection invSchemes = QueryServiceHelper.query((String)"im_invscheme", (String)"id as invschemeId,billform.number as billtype", (QFilter[])invSchemeFilter.toArray());
        if (invSchemes != null && !invSchemes.isEmpty()) {
            for (DynamicObject invScheme : invSchemes) {
                String billtype = invScheme.getString("billtype");
                Long invschemeId = invScheme.getLong("invschemeId");
                if (!billTypeToInvSchemes.containsKey(billtype)) {
                    billTypeToInvSchemes.put(billtype, new HashSet());
                }
                ((Set)billTypeToInvSchemes.get(billtype)).add(invschemeId);
            }
        }
        return billTypeToInvSchemes;
    }

    private static Map<String, Set<Long>> buildBillTypeToInvSchemes(Map<String, Set<Long>> billTypeToInvSchemes, String key) {
        HashMap<String, Set<Long>> billToInvSchemeData = new HashMap<String, Set<Long>>(16);
        if ("in".equals(key)) {
            billToInvSchemeData.put("im_productinbill", billTypeToInvSchemes.get("im_productinbill"));
            billToInvSchemeData.put("im_purinbill", billTypeToInvSchemes.get("im_purinbill"));
            billToInvSchemeData.put("im_otherinbill", billTypeToInvSchemes.get("im_otherinbill"));
            billToInvSchemeData.put("im_transinbill", billTypeToInvSchemes.get("im_transinbill"));
            billToInvSchemeData.put("im_transdirbill", billTypeToInvSchemes.get("im_transdirbill"));
            billToInvSchemeData.put("im_ospurinbill", billTypeToInvSchemes.get("im_ospurinbill"));
        } else {
            billToInvSchemeData.put("im_saloutbill", billTypeToInvSchemes.get("im_saloutbill"));
            billToInvSchemeData.put("im_materialreqoutbill", billTypeToInvSchemes.get("im_materialreqoutbill"));
            billToInvSchemeData.put("im_otheroutbill", billTypeToInvSchemes.get("im_otheroutbill"));
            billToInvSchemeData.put("im_transoutbill", billTypeToInvSchemes.get("im_transoutbill"));
            billToInvSchemeData.put("im_transdirbill", billTypeToInvSchemes.get("im_transdirbill"));
            billToInvSchemeData.put("im_osmaterialreqoutbill", billTypeToInvSchemes.get("im_osmaterialreqoutbill"));
        }
        return billToInvSchemeData;
    }
}

