/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.service.mservices;

import com.kingdee.bos.qing.modeler.api.exception.ModelException;
import com.kingdee.bos.qing.modeler.api.response.Row;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.scmdi.business.helper.OrgHelper;
import kd.scmc.scmdi.common.entity.DimensionInfo;
import kd.scmc.scmdi.common.entity.DullMaterialFilterInfo;
import kd.scmc.scmdi.common.entity.FilterConditionInfo;
import kd.scmc.scmdi.common.entity.MaterialGroupItoInfo;
import kd.scmc.scmdi.common.entity.MaterialItoInfo;
import kd.scmc.scmdi.service.mservices.DullMaterialQueryService;
import kd.scmc.scmdi.service.mservices.QingModelerHelper;

public class ItoEntryEntityDataService {
    public static List<MaterialGroupItoInfo> getMaterialGroupEntryEntityData(FilterConditionInfo filterConditionInfo) {
        Long calOrg = filterConditionInfo.getCalOrg();
        DynamicObject currency = OrgHelper.getCurrency(calOrg);
        List<Long> period = filterConditionInfo.getPeriod();
        DimensionInfo dimensionInfo = ItoEntryEntityDataService.buildDimensionInfo(filterConditionInfo, period);
        List<Row> metricDataGroupByMaterialGroup = QingModelerHelper.getMetricDataGroupByMaterialGroup(dimensionInfo, filterConditionInfo.getMetricModelWithGroup(), false);
        ArrayList<Long> groupIdList = new ArrayList<Long>(10);
        for (Row row : metricDataGroupByMaterialGroup) {
            Long groupId;
            try {
                groupId = row.getLong("groupid");
            }
            catch (ModelException e) {
                throw new KDBizException(e.getMessage());
            }
            if (groupId == null) continue;
            groupIdList.add(groupId);
        }
        QFilter qFilter = new QFilter("id", "in", groupIdList);
        Map materialGroup = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroup", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter});
        ArrayList<MaterialGroupItoInfo> list = new ArrayList<MaterialGroupItoInfo>(16);
        for (Row row : metricDataGroupByMaterialGroup) {
            try {
                MaterialGroupItoInfo materialGroupItoInfo = new MaterialGroupItoInfo();
                Long groupId = row.getLong("groupid");
                if (groupId == null) continue;
                DynamicObject group = (DynamicObject)materialGroup.get(groupId);
                materialGroupItoInfo.setMaterialGroup(group);
                BigDecimal saleCost = row.getBigDecimal("salecostmetric") == null ? BigDecimal.ZERO : row.getBigDecimal("salecostmetric").stripTrailingZeros();
                BigDecimal invCost = row.getBigDecimal("avginvcost") == null ? BigDecimal.ZERO : row.getBigDecimal("avginvcost").stripTrailingZeros();
                BigDecimal invTurnOver = row.getBigDecimal("invturnover") == null ? BigDecimal.ZERO : row.getBigDecimal("invturnover").stripTrailingZeros();
                BigDecimal turnOverDay = row.getBigDecimal("turnoverdays") == null ? BigDecimal.ZERO : row.getBigDecimal("turnoverdays").stripTrailingZeros();
                materialGroupItoInfo.setSaleCost(saleCost);
                materialGroupItoInfo.setInventoryCost(invCost);
                materialGroupItoInfo.setTurnRate(invTurnOver);
                materialGroupItoInfo.setTurnDays(turnOverDay);
                materialGroupItoInfo.setCurrency(currency);
                list.add(materialGroupItoInfo);
            }
            catch (ModelException e) {
                throw new KDBizException(e.getMessage());
            }
        }
        List<MaterialGroupItoInfo> collect = list.stream().sorted(Comparator.comparing(MaterialGroupItoInfo::getTurnRate).reversed()).collect(Collectors.toList());
        return collect;
    }

    private static DimensionInfo buildDimensionInfo(FilterConditionInfo filterConditionInfo, List<Long> period) {
        DimensionInfo dimensionInfo = new DimensionInfo();
        dimensionInfo.setCalOrg(filterConditionInfo.getCalOrg());
        dimensionInfo.setCostAccount(filterConditionInfo.getCostAccount());
        dimensionInfo.setMaterialGroupStandard(filterConditionInfo.getMaterialGroupStandard());
        dimensionInfo.setMaterialGroup(filterConditionInfo.getMaterialGroup());
        dimensionInfo.setMaterial(filterConditionInfo.getMaterial());
        dimensionInfo.setPeriod(period);
        return dimensionInfo;
    }

    public static List<MaterialItoInfo> getMaterialEntryEntityData(FilterConditionInfo filterConditionInfo, boolean zeroShow) {
        List<Long> period = filterConditionInfo.getPeriod();
        Long calOrg = filterConditionInfo.getCalOrg();
        DynamicObject currency = OrgHelper.getCurrency(calOrg);
        DimensionInfo dimensionInfo = ItoEntryEntityDataService.buildDimensionInfo(filterConditionInfo, period);
        List<Row> metricDataGroupByMaterial = QingModelerHelper.getMetricDataGroupByMaterial(dimensionInfo, filterConditionInfo.getMetricModelWithGroup());
        ArrayList<Long> materialIdList = new ArrayList<Long>(metricDataGroupByMaterial.size());
        ArrayList<Long> groupIdList = new ArrayList<Long>(metricDataGroupByMaterial.size());
        for (Row row : metricDataGroupByMaterial) {
            Long materialId;
            Long groupId;
            try {
                groupId = row.getLong("groupid");
                materialId = row.getLong("materialid");
            }
            catch (ModelException e) {
                throw new KDBizException(e.getMessage());
            }
            if (materialId != null) {
                materialIdList.add(materialId);
            }
            if (groupId == null) continue;
            groupIdList.add(groupId);
        }
        QFilter materialFilter = new QFilter("id", "in", materialIdList);
        Map materialColl = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"number,name", (QFilter[])new QFilter[]{materialFilter});
        QFilter groupFilter = new QFilter("id", "in", groupIdList);
        Map groupColl = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroup", (String)"number,name", (QFilter[])new QFilter[]{groupFilter});
        List<MaterialItoInfo> list = new ArrayList<MaterialItoInfo>(16);
        for (Row row : metricDataGroupByMaterial) {
            BigDecimal turnOverDay;
            BigDecimal ito;
            BigDecimal invCost;
            BigDecimal saleCost;
            Long groupId;
            Long materialId;
            try {
                materialId = row.getLong("materialid");
                groupId = row.getLong("groupid");
                saleCost = row.getBigDecimal("salecostmetric") == null ? null : row.getBigDecimal("salecostmetric");
                invCost = row.getBigDecimal("avginvcost") == null ? null : row.getBigDecimal("avginvcost");
                ito = row.getBigDecimal("invturnover") == null ? null : row.getBigDecimal("invturnover").stripTrailingZeros();
                turnOverDay = row.getBigDecimal("turnoverdays") == null ? null : row.getBigDecimal("turnoverdays").stripTrailingZeros();
            }
            catch (ModelException e) {
                throw new KDBizException(e.getMessage());
            }
            if (saleCost == null || invCost == null || materialId == null) continue;
            MaterialItoInfo materialItoInfo2 = new MaterialItoInfo();
            materialItoInfo2.setMaterial((DynamicObject)materialColl.get(materialId));
            if (groupId != null) {
                materialItoInfo2.setMaterialGroup((DynamicObject)groupColl.get(groupId));
            }
            materialItoInfo2.setSaleCost(saleCost);
            materialItoInfo2.setInventoryCost(invCost);
            materialItoInfo2.setTurnRate(ito);
            materialItoInfo2.setTurnDays(turnOverDay);
            materialItoInfo2.setCurrency(currency);
            list.add(materialItoInfo2);
        }
        if (!zeroShow) {
            list = list.stream().filter(materialItoInfo -> materialItoInfo.getTurnRate().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        }
        return list;
    }

    public static List<MaterialItoInfo> getMaterialDullEntryEntityData(DullMaterialFilterInfo dullMaterialFilterInfo) {
        DynamicObject calOrg = dullMaterialFilterInfo.getCalOrg();
        DynamicObject currency = OrgHelper.getCurrency(calOrg.getLong("id"));
        Map<Object, DynamicObject> periodColl = dullMaterialFilterInfo.getPeriod();
        Map.Entry lastPeriodEntry = (Map.Entry)periodColl.entrySet().stream().reduce((first, second) -> second).get();
        DynamicObject lastPeriod = (DynamicObject)lastPeriodEntry.getValue();
        Date lastPeriodDate = lastPeriod.getDate("enddate");
        List<Long> materialGroupColl = ItoEntryEntityDataService.getMaterialGroupColl(dullMaterialFilterInfo);
        Map<String, Set<Long>> billTypeToInvSchemes = ItoEntryEntityDataService.getBillTypeToInvSchemes();
        Map<String, Set<Long>> inBillToInvSchemes = ItoEntryEntityDataService.buildBillTypeToInvSchemes(billTypeToInvSchemes, "in");
        Map<String, Set<Long>> outBillToInvSchemes = ItoEntryEntityDataService.buildBillTypeToInvSchemes(billTypeToInvSchemes, "out");
        ReportQueryParam dullMaterialQueryParam = ItoEntryEntityDataService.getDullMaterialQueryParam(dullMaterialFilterInfo, lastPeriodDate, inBillToInvSchemes, outBillToInvSchemes);
        DataSet dataSet = ItoEntryEntityDataService.queryDullMaterial(dullMaterialQueryParam);
        ArrayList<Long> materialIdList = new ArrayList<Long>(16);
        for (kd.bos.algo.Row row : dataSet) {
            Long material = row.getLong("material");
            materialIdList.add(material);
        }
        if (materialIdList.isEmpty()) {
            ArrayList<MaterialItoInfo> list = new ArrayList<MaterialItoInfo>();
            return list;
        }
        List<Long> periodId = periodColl.values().stream().map(period -> period.getLong("id")).collect(Collectors.toList());
        DimensionInfo dullDimensionInfo = ItoEntryEntityDataService.buildDullDimensionInfo(dullMaterialFilterInfo, materialIdList, materialGroupColl, periodId);
        List<Row> metricDataGroupByMaterial = QingModelerHelper.getMetricDataGroupByMaterial(dullDimensionInfo, dullMaterialFilterInfo.getMetricModelWithGroup());
        ArrayList<Long> materialList = new ArrayList<Long>(16);
        for (Row row : metricDataGroupByMaterial) {
            Long materialId;
            try {
                materialId = row.getLong("materialid");
            }
            catch (ModelException e) {
                throw new KDBizException(e.getMessage());
            }
            if (materialId == null) continue;
            materialList.add(materialId);
        }
        QFilter materialFilter = new QFilter("id", "in", materialList);
        Map materialColl = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"number,name", (QFilter[])new QFilter[]{materialFilter});
        ArrayList<MaterialItoInfo> list = new ArrayList<MaterialItoInfo>(16);
        for (Row row : metricDataGroupByMaterial) {
            BigDecimal turnOverDay;
            BigDecimal ito;
            BigDecimal invCost;
            BigDecimal saleCost;
            Long materialId;
            try {
                materialId = row.getLong("materialid");
                saleCost = row.getBigDecimal("salecostmetric") == null ? BigDecimal.ZERO : row.getBigDecimal("salecostmetric");
                invCost = row.getBigDecimal("avginvcost") == null ? BigDecimal.ZERO : row.getBigDecimal("avginvcost");
                ito = row.getBigDecimal("invturnover") == null ? BigDecimal.ZERO : row.getBigDecimal("invturnover").stripTrailingZeros();
                turnOverDay = row.getBigDecimal("turnoverdays") == null ? BigDecimal.ZERO : row.getBigDecimal("turnoverdays").stripTrailingZeros();
            }
            catch (ModelException e) {
                throw new KDBizException(e.getMessage());
            }
            if (materialId == null) continue;
            MaterialItoInfo materialItoInfo = new MaterialItoInfo();
            materialItoInfo.setMaterial((DynamicObject)materialColl.get(materialId));
            materialItoInfo.setSaleCost(saleCost);
            materialItoInfo.setInventoryCost(invCost);
            materialItoInfo.setTurnRate(ito);
            materialItoInfo.setTurnDays(turnOverDay);
            materialItoInfo.setCurrency(currency);
            list.add(materialItoInfo);
        }
        return list;
    }

    private static DimensionInfo buildDullDimensionInfo(DullMaterialFilterInfo dullMaterialFilterInfo, List<Long> materialIdList, List<Long> materialGroupColl, List<Long> period) {
        DimensionInfo dimensionInfo = new DimensionInfo();
        dimensionInfo.setCalOrg(dullMaterialFilterInfo.getCalOrg().getLong("id"));
        DynamicObject costAccount = dullMaterialFilterInfo.getCostAccount();
        if (costAccount != null) {
            dimensionInfo.setCostAccount(costAccount.getLong("id"));
        }
        dimensionInfo.setMaterialGroupStandard(dullMaterialFilterInfo.getMaterialGroupStandard().getLong("id"));
        dimensionInfo.setMaterialGroup(materialGroupColl);
        dimensionInfo.setMaterial(materialIdList);
        dimensionInfo.setPeriod(period);
        return dimensionInfo;
    }

    private static List<Long> getMaterialGroupColl(DullMaterialFilterInfo dullMaterialFilterInfo) {
        DynamicObject materialGroupStandard = dullMaterialFilterInfo.getMaterialGroupStandard();
        DynamicObjectCollection materialGroupFrom = dullMaterialFilterInfo.getMaterialGroupFrom();
        DynamicObject materialGroupTo = dullMaterialFilterInfo.getMaterialGroupTo();
        ArrayList<Long> idList = new ArrayList<Long>(16);
        if (materialGroupFrom != null && !materialGroupFrom.isEmpty()) {
            if (materialGroupFrom.size() > 1) {
                for (DynamicObject from : materialGroupFrom) {
                    idList.add(from.getLong("id"));
                }
            } else if (materialGroupTo != null) {
                DynamicObject from = ((DynamicObject)materialGroupFrom.get(0)).getDynamicObject(1);
                QFilter filter = new QFilter("number", ">=", from.get("number"));
                filter.and(new QFilter("standard", "=", materialGroupStandard.getPkValue()));
                filter.and(new QFilter("number", "<=", materialGroupTo.get("number")));
                DynamicObjectCollection materialGroupDetail = QueryServiceHelper.query((String)"bd_materialgroup", (String)"id,number", (QFilter[])new QFilter[]{filter});
                for (DynamicObject groupDetail : materialGroupDetail) {
                    Long group = groupDetail.getLong("id");
                    idList.add(group);
                }
            } else {
                Long id = ((DynamicObject)materialGroupFrom.get(0)).getDynamicObject(1).getLong("id");
                idList.add(id);
            }
        }
        return idList;
    }

    private static Map<String, Set<Long>> getBillTypeToInvSchemes() {
        HashMap<String, Set<Long>> billTypeToInvSchemes = new HashMap<String, Set<Long>>(16);
        ArrayList<String> billTypes = new ArrayList<String>();
        billTypes.add("im_productinbill");
        billTypes.add("im_purinbill");
        billTypes.add("im_otherinbill");
        billTypes.add("im_transinbill");
        billTypes.add("im_transdirbill");
        billTypes.add("im_ospurinbill");
        billTypes.add("im_saloutbill");
        billTypes.add("im_materialreqoutbill");
        billTypes.add("im_otheroutbill");
        billTypes.add("im_transoutbill");
        billTypes.add("im_transdirbill");
        billTypes.add("im_osmaterialreqoutbill");
        QFilter invSchemeFilter = new QFilter("billform", "in", billTypes);
        invSchemeFilter.and("enable", "=", (Object)Boolean.TRUE);
        invSchemeFilter.and("isnotupdate", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection invSchemes = QueryServiceHelper.query((String)"im_invscheme", (String)"id as invschemeId,billform.number as billtype", (QFilter[])invSchemeFilter.toArray());
        if (invSchemes != null && !invSchemes.isEmpty()) {
            for (DynamicObject invScheme : invSchemes) {
                String billtype = invScheme.getString("billtype");
                Long invschemeId = invScheme.getLong("invschemeId");
                if (!billTypeToInvSchemes.containsKey(billtype)) {
                    billTypeToInvSchemes.put(billtype, new HashSet());
                }
                ((Set)billTypeToInvSchemes.get(billtype)).add(invschemeId);
            }
        }
        return billTypeToInvSchemes;
    }

    private static Map<String, Set<Long>> buildBillTypeToInvSchemes(Map<String, Set<Long>> billTypeToInvSchemes, String key) {
        HashMap<String, Set<Long>> billToInvSchemeData = new HashMap<String, Set<Long>>(16);
        if ("in".equals(key)) {
            billToInvSchemeData.put("im_productinbill", billTypeToInvSchemes.get("im_productinbill"));
            billToInvSchemeData.put("im_purinbill", billTypeToInvSchemes.get("im_purinbill"));
            billToInvSchemeData.put("im_otherinbill", billTypeToInvSchemes.get("im_otherinbill"));
            billToInvSchemeData.put("im_transinbill", billTypeToInvSchemes.get("im_transinbill"));
            billToInvSchemeData.put("im_transdirbill", billTypeToInvSchemes.get("im_transdirbill"));
            billToInvSchemeData.put("im_ospurinbill", billTypeToInvSchemes.get("im_ospurinbill"));
        } else {
            billToInvSchemeData.put("im_saloutbill", billTypeToInvSchemes.get("im_saloutbill"));
            billToInvSchemeData.put("im_materialreqoutbill", billTypeToInvSchemes.get("im_materialreqoutbill"));
            billToInvSchemeData.put("im_otheroutbill", billTypeToInvSchemes.get("im_otheroutbill"));
            billToInvSchemeData.put("im_transoutbill", billTypeToInvSchemes.get("im_transoutbill"));
            billToInvSchemeData.put("im_transdirbill", billTypeToInvSchemes.get("im_transdirbill"));
            billToInvSchemeData.put("im_osmaterialreqoutbill", billTypeToInvSchemes.get("im_osmaterialreqoutbill"));
        }
        return billToInvSchemeData;
    }

    private static DataSet queryDullMaterial(ReportQueryParam dullMaterialQueryParam) {
        DullMaterialQueryService dullMaterialQueryService = new DullMaterialQueryService();
        try {
            return dullMaterialQueryService.query(dullMaterialQueryParam, null);
        }
        catch (Throwable e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private static ReportQueryParam getDullMaterialQueryParam(DullMaterialFilterInfo dullMaterialFilterInfo, Date endDate, Map<String, Set<Long>> inBillToInvSchemes, Map<String, Set<Long>> outBillToInvSchemes) {
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filter = new FilterInfo();
        filter.addFilterItem("dullanalyseobj", (Object)"1", CompareTypeEnum.CHECKBOXEQUAL.getId());
        filter.addFilterItem("orghead", (Object)dullMaterialFilterInfo.getCalOrg(), CompareTypeEnum.EQUAL.getId());
        filter.addFilterItem("materialgroupstandard", (Object)dullMaterialFilterInfo.getMaterialGroupStandard(), CompareTypeEnum.EQUAL.getId());
        filter.addFilterItem("materialgroupfrom", (Object)dullMaterialFilterInfo.getMaterialGroupFrom(), CompareTypeEnum.EQUAL.getId());
        filter.addFilterItem("materialgroupto", (Object)dullMaterialFilterInfo.getMaterialGroupTo(), CompareTypeEnum.EQUAL.getId());
        DynamicObjectCollection materialColl = dullMaterialFilterInfo.getMaterial();
        if (materialColl.size() == 1) {
            filter.addFilterItem("materialnumberfrom", (Object)dullMaterialFilterInfo.getMaterial(), CompareTypeEnum.EQUAL.getId());
            filter.addFilterItem("materialnumberto", (Object)((DynamicObject)dullMaterialFilterInfo.getMaterial().get(0)).getDynamicObject(1), CompareTypeEnum.EQUAL.getId());
        } else {
            filter.addFilterItem("materialnumberfrom", (Object)dullMaterialFilterInfo.getMaterial(), CompareTypeEnum.EQUAL.getId());
            filter.addFilterItem("materialnumberto", null, CompareTypeEnum.EQUAL.getId());
        }
        filter.addFilterItem("deadline", (Object)endDate, CompareTypeEnum.EQUAL.getId());
        filter.addFilterItem("dulldays", (Object)dullMaterialFilterInfo.getDullDays(), CompareTypeEnum.EQUAL.getId());
        filter.addFilterItem("dulltype", (Object)dullMaterialFilterInfo.getDullType(), CompareTypeEnum.CHECKBOXEQUAL.getId());
        filter.addFilterItem("inBillToInvschemes", inBillToInvSchemes);
        filter.addFilterItem("outBillToInvschemes", outBillToInvSchemes);
        queryParam.setFilter(filter);
        return queryParam;
    }
}

