/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.service.mservices;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.qing.modeler.api.ApiResponse;
import com.kingdee.bos.qing.modeler.api.request.DimMemberCondition;
import com.kingdee.bos.qing.modeler.api.request.DimMemberGroup;
import com.kingdee.bos.qing.modeler.api.request.Dimension;
import com.kingdee.bos.qing.modeler.api.request.ModelFilterItem;
import com.kingdee.bos.qing.modeler.api.request.OrderItem;
import com.kingdee.bos.qing.modeler.api.request.QueryMetricParams;
import com.kingdee.bos.qing.modeler.api.response.ModelDataSet;
import com.kingdee.bos.qing.modeler.api.response.ModelMeta;
import com.kingdee.bos.qing.modeler.api.response.Row;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scmc.scmdi.common.entity.DimensionInfo;

public class QingModelerHelper {
    public static List<Row> getGroupMetricData(DimensionInfo dimensionInfo, String modelId) {
        QueryMetricParams params = new QueryMetricParams();
        params.setModelId(modelId);
        QingModelerHelper.buildDimensions(params, dimensionInfo);
        ArrayList<DimMemberGroup> dimMemberGroups = new ArrayList<DimMemberGroup>(1);
        DimMemberGroup dimMemberGroup = new DimMemberGroup();
        dimMemberGroup.setAlias("itometric");
        dimMemberGroup.setFieldName("itometric");
        ArrayList<DimMemberCondition> conditions = new ArrayList<DimMemberCondition>(1);
        DimMemberCondition dimMemberCondition = new DimMemberCondition();
        dimMemberCondition.setDisplayFieldValue("itometric");
        List<ModelFilterItem> filters = QingModelerHelper.buildDimMemberFilters(dimensionInfo);
        dimMemberCondition.setFilters(filters);
        conditions.add(dimMemberCondition);
        dimMemberGroups.add(dimMemberGroup);
        dimMemberGroup.setConditions(conditions);
        params.setDimGroupMembers(dimMemberGroups);
        ModelDataSet metricDataSet = QingModelerHelper.getMetricDataSetByParam(params);
        return metricDataSet.getDatas();
    }

    public static List<Row> getMetricDataGroupByPeriod(DimensionInfo dimensionInfo, String modelId) {
        QueryMetricParams params = new QueryMetricParams();
        params.setModelId(modelId);
        QingModelerHelper.buildPeriodDimensions(params, dimensionInfo);
        List<ModelFilterItem> filters = QingModelerHelper.buildPeriodFilters(dimensionInfo);
        params.setFilters(filters);
        ArrayList<OrderItem> orderItems = new ArrayList<OrderItem>();
        OrderItem orderItem = new OrderItem();
        orderItem.setFieldName("periodid");
        orderItem.setSort(OrderItem.Order.ASC);
        orderItems.add(orderItem);
        params.setOrderItems(orderItems);
        ModelDataSet metricDataSet = QingModelerHelper.getMetricDataSetByParam(params);
        return metricDataSet.getDatas();
    }

    public static List<Row> getMetricDataGroupByMaterialGroup(DimensionInfo dimensionInfo, String modelId, boolean isChart) {
        OrderItem orderItem;
        ArrayList orderItems;
        QueryMetricParams params = new QueryMetricParams();
        params.setModelId(modelId);
        QingModelerHelper.buildMaterialGroupDimensions(params, dimensionInfo);
        ArrayList<ModelFilterItem> filters = new ArrayList<ModelFilterItem>(5);
        List<Long> materialGroup = dimensionInfo.getMaterialGroup();
        if (materialGroup != null && !materialGroup.isEmpty()) {
            List collect = materialGroup.stream().map(Objects::toString).collect(Collectors.toList());
            ModelFilterItem groupInFilterItem = new ModelFilterItem();
            groupInFilterItem.setFieldName("groupid");
            groupInFilterItem.setLeftBrackets(0);
            groupInFilterItem.setCompareOp(ModelFilterItem.CompareOp.IN);
            groupInFilterItem.setValue(JSON.toJSONString(collect));
            groupInFilterItem.setRightBrackets(0);
            filters.add(groupInFilterItem);
        }
        params.setFilters(filters);
        if (isChart) {
            orderItems = new ArrayList();
            orderItem = new OrderItem();
            orderItem.setFieldName("invturnover");
            orderItem.setSort(OrderItem.Order.ASC);
            params.setOrderItems(orderItems);
            params.setLimit(10);
        } else {
            orderItems = new ArrayList();
            orderItem = new OrderItem();
            orderItem.setFieldName("invturnover");
            orderItem.setSort(OrderItem.Order.DESC);
            params.setOrderItems(orderItems);
        }
        ModelDataSet metricDataSet = QingModelerHelper.getMetricDataSetByParam(params);
        return metricDataSet.getDatas();
    }

    public static List<Row> getMetricDataGroupByMaterial(DimensionInfo dimensionInfo, String modelId) {
        QueryMetricParams params = new QueryMetricParams();
        params.setModelId(modelId);
        QingModelerHelper.buildMaterialDimensions(params, dimensionInfo);
        List<ModelFilterItem> filters = QingModelerHelper.buildMaterialFilters(dimensionInfo);
        params.setFilters(filters);
        ModelDataSet metricDataSet = QingModelerHelper.getMetricDataSetByParam(params);
        return metricDataSet.getDatas();
    }

    public static ModelDataSet getMetricDataSetByParam(QueryMetricParams params) {
        ApiResponse response;
        try {
            response = (ApiResponse)DispatchServiceHelper.invokeBOSService((String)"qing_modeler", (String)"QingModelerExternalService", (String)"getMetricDataSet", (Object[])new Object[]{params});
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        if (ApiResponse.ApiCode.SUCCESS.getCode() != response.getCode()) {
            throw new KDBizException(response.getMessage());
        }
        ModelDataSet previewData = (ModelDataSet)response.getData();
        return previewData;
    }

    private static void buildDimensions(QueryMetricParams params, DimensionInfo dimensionInfo) {
        List<Long> material;
        List<Long> materialGroup;
        Long materialGroupStandard;
        List<Long> period;
        Long costAccount;
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>(5);
        Long calOrg = dimensionInfo.getCalOrg();
        if (calOrg != null) {
            Dimension orgDimension = new Dimension();
            orgDimension.setDimensionName("calorgid");
            dimensions.add(orgDimension);
        }
        if ((costAccount = dimensionInfo.getCostAccount()) != null) {
            Dimension costAccountDimension = new Dimension();
            costAccountDimension.setDimensionName("costaccountid");
            dimensions.add(costAccountDimension);
        }
        if ((period = dimensionInfo.getPeriod()) != null && !period.isEmpty()) {
            Dimension periodDimension = new Dimension();
            periodDimension.setDimensionName("periodid");
            dimensions.add(periodDimension);
        }
        if ((materialGroupStandard = dimensionInfo.getMaterialGroupStandard()) != null) {
            Dimension standardDimension = new Dimension();
            standardDimension.setDimensionName("standardid");
            dimensions.add(standardDimension);
        }
        if ((materialGroup = dimensionInfo.getMaterialGroup()) != null && !materialGroup.isEmpty()) {
            Dimension groupDimension = new Dimension();
            groupDimension.setDimensionName("groupid");
            dimensions.add(groupDimension);
        }
        if ((material = dimensionInfo.getMaterial()) != null && !material.isEmpty()) {
            Dimension materialDimension = new Dimension();
            materialDimension.setDimensionName("materialid");
            dimensions.add(materialDimension);
        }
        params.setDimensions(dimensions);
    }

    private static List<ModelFilterItem> buildDimMemberFilters(DimensionInfo dimensionInfo) {
        List<Long> period;
        List<Long> material;
        List<Long> materialGroup;
        Long materialStandard;
        Long costAccount;
        ArrayList<ModelFilterItem> filters = new ArrayList<ModelFilterItem>(5);
        Long calOrg = dimensionInfo.getCalOrg();
        if (calOrg != null) {
            ModelFilterItem orgInFilterItem = new ModelFilterItem();
            orgInFilterItem.setFieldName("calorgid");
            orgInFilterItem.setLeftBrackets(0);
            orgInFilterItem.setCompareOp(ModelFilterItem.CompareOp.EQUAL);
            orgInFilterItem.setValue(String.valueOf(calOrg));
            orgInFilterItem.setRightBrackets(0);
            filters.add(orgInFilterItem);
        }
        if ((costAccount = dimensionInfo.getCostAccount()) != null) {
            ModelFilterItem costAccountInFilterItem = new ModelFilterItem();
            costAccountInFilterItem.setFieldName("costaccountid");
            costAccountInFilterItem.setLeftBrackets(0);
            costAccountInFilterItem.setCompareOp(ModelFilterItem.CompareOp.EQUAL);
            costAccountInFilterItem.setValue(String.valueOf(costAccount));
            costAccountInFilterItem.setRightBrackets(0);
            filters.add(costAccountInFilterItem);
        }
        if ((materialStandard = dimensionInfo.getMaterialGroupStandard()) != null) {
            ModelFilterItem standardInFilterItem = new ModelFilterItem();
            standardInFilterItem.setFieldName("standardid");
            standardInFilterItem.setLeftBrackets(0);
            standardInFilterItem.setCompareOp(ModelFilterItem.CompareOp.EQUAL);
            standardInFilterItem.setValue(String.valueOf(materialStandard));
            standardInFilterItem.setRightBrackets(0);
            filters.add(standardInFilterItem);
        }
        if ((materialGroup = dimensionInfo.getMaterialGroup()) != null && !materialGroup.isEmpty()) {
            List collect = materialGroup.stream().map(Objects::toString).collect(Collectors.toList());
            ModelFilterItem groupInFilterItem = new ModelFilterItem();
            groupInFilterItem.setFieldName("groupid");
            groupInFilterItem.setLeftBrackets(0);
            groupInFilterItem.setCompareOp(ModelFilterItem.CompareOp.IN);
            groupInFilterItem.setValue(JSON.toJSONString(collect));
            groupInFilterItem.setRightBrackets(0);
            filters.add(groupInFilterItem);
        }
        if ((material = dimensionInfo.getMaterial()) != null && !material.isEmpty()) {
            List collect = material.stream().map(Objects::toString).collect(Collectors.toList());
            ModelFilterItem materialInFilterItem = new ModelFilterItem();
            materialInFilterItem.setFieldName("materialid");
            materialInFilterItem.setLeftBrackets(0);
            materialInFilterItem.setCompareOp(ModelFilterItem.CompareOp.IN);
            materialInFilterItem.setValue(JSON.toJSONString(collect));
            materialInFilterItem.setRightBrackets(0);
            filters.add(materialInFilterItem);
        }
        if ((period = dimensionInfo.getPeriod()) != null && !period.isEmpty()) {
            List collect = period.stream().map(Objects::toString).collect(Collectors.toList());
            ModelFilterItem periodInFilterItem = new ModelFilterItem();
            periodInFilterItem.setFieldName("periodid");
            periodInFilterItem.setLeftBrackets(0);
            periodInFilterItem.setCompareOp(ModelFilterItem.CompareOp.IN);
            periodInFilterItem.setValue(JSON.toJSONString(collect));
            periodInFilterItem.setRightBrackets(0);
            filters.add(periodInFilterItem);
        }
        return filters;
    }

    private static void buildPeriodDimensions(QueryMetricParams params, DimensionInfo dimensionInfo) {
        List<Long> period;
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>(5);
        Long calOrg = dimensionInfo.getCalOrg();
        if (calOrg != null) {
            Dimension orgDimension = new Dimension();
            orgDimension.setDimensionName("calorgid");
            dimensions.add(orgDimension);
        }
        if ((period = dimensionInfo.getPeriod()) != null && !period.isEmpty()) {
            Dimension periodDimension = new Dimension();
            periodDimension.setDimensionName("periodid");
            dimensions.add(periodDimension);
        }
        params.setDimensions(dimensions);
    }

    private static List<ModelFilterItem> buildPeriodFilters(DimensionInfo dimensionInfo) {
        List<Long> period;
        ArrayList<ModelFilterItem> filters = new ArrayList<ModelFilterItem>(5);
        Long calOrg = dimensionInfo.getCalOrg();
        if (calOrg != null) {
            ModelFilterItem orgInFilterItem = new ModelFilterItem();
            orgInFilterItem.setFieldName("calorgid");
            orgInFilterItem.setLeftBrackets(0);
            orgInFilterItem.setCompareOp(ModelFilterItem.CompareOp.EQUAL);
            orgInFilterItem.setValue(String.valueOf(calOrg));
            orgInFilterItem.setRightBrackets(0);
            filters.add(orgInFilterItem);
        }
        if ((period = dimensionInfo.getPeriod()) != null && !period.isEmpty()) {
            List collect = period.stream().map(Objects::toString).collect(Collectors.toList());
            ModelFilterItem periodInFilterItem = new ModelFilterItem();
            periodInFilterItem.setFieldName("periodid");
            periodInFilterItem.setLeftBrackets(0);
            periodInFilterItem.setCompareOp(ModelFilterItem.CompareOp.IN);
            periodInFilterItem.setValue(JSON.toJSONString(collect));
            periodInFilterItem.setRightBrackets(0);
            filters.add(periodInFilterItem);
        }
        return filters;
    }

    private static List<ModelFilterItem> buildMaterialFilters(DimensionInfo dimensionInfo) {
        List<Long> material;
        List<Long> materialGroup;
        Long materialStandard;
        ArrayList<ModelFilterItem> filters = new ArrayList<ModelFilterItem>(5);
        Long calOrg = dimensionInfo.getCalOrg();
        if (calOrg != null) {
            ModelFilterItem orgInFilterItem = new ModelFilterItem();
            orgInFilterItem.setFieldName("calorgid");
            orgInFilterItem.setLeftBrackets(0);
            orgInFilterItem.setCompareOp(ModelFilterItem.CompareOp.EQUAL);
            orgInFilterItem.setValue(String.valueOf(calOrg));
            orgInFilterItem.setRightBrackets(0);
            filters.add(orgInFilterItem);
        }
        if ((materialStandard = dimensionInfo.getMaterialGroupStandard()) != null) {
            ModelFilterItem standardInFilterItem = new ModelFilterItem();
            standardInFilterItem.setFieldName("standardid");
            standardInFilterItem.setLeftBrackets(0);
            standardInFilterItem.setCompareOp(ModelFilterItem.CompareOp.EQUAL);
            standardInFilterItem.setValue(String.valueOf(materialStandard));
            standardInFilterItem.setRightBrackets(0);
            filters.add(standardInFilterItem);
        }
        if ((materialGroup = dimensionInfo.getMaterialGroup()) != null && !materialGroup.isEmpty()) {
            List collect = materialGroup.stream().map(Objects::toString).collect(Collectors.toList());
            ModelFilterItem groupInFilterItem = new ModelFilterItem();
            groupInFilterItem.setFieldName("groupid");
            groupInFilterItem.setLeftBrackets(0);
            groupInFilterItem.setCompareOp(ModelFilterItem.CompareOp.IN);
            groupInFilterItem.setValue(JSON.toJSONString(collect));
            groupInFilterItem.setRightBrackets(0);
            filters.add(groupInFilterItem);
        }
        if ((material = dimensionInfo.getMaterial()) != null && !material.isEmpty()) {
            List collect = material.stream().map(Objects::toString).collect(Collectors.toList());
            ModelFilterItem materialInFilterItem = new ModelFilterItem();
            materialInFilterItem.setFieldName("materialid");
            materialInFilterItem.setLeftBrackets(0);
            materialInFilterItem.setCompareOp(ModelFilterItem.CompareOp.IN);
            materialInFilterItem.setValue(JSON.toJSONString(collect));
            materialInFilterItem.setRightBrackets(0);
            filters.add(materialInFilterItem);
        }
        return filters;
    }

    private static void buildMaterialGroupDimensions(QueryMetricParams params, DimensionInfo dimensionInfo) {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>(5);
        Dimension groupDimension = new Dimension();
        groupDimension.setDimensionName("groupid");
        dimensions.add(groupDimension);
        params.setDimensions(dimensions);
    }

    private static void buildMaterialDimensions(QueryMetricParams params, DimensionInfo dimensionInfo) {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>(5);
        Dimension orgDimension = new Dimension();
        orgDimension.setDimensionName("calorgid");
        dimensions.add(orgDimension);
        Dimension standardDimension = new Dimension();
        standardDimension.setDimensionName("standardid");
        dimensions.add(standardDimension);
        Dimension groupDimension = new Dimension();
        groupDimension.setDimensionName("groupid");
        dimensions.add(groupDimension);
        Dimension materialDimension = new Dimension();
        materialDimension.setDimensionName("materialid");
        dimensions.add(materialDimension);
        params.setDimensions(dimensions);
    }

    private static ModelMeta getModelMeta(String modelId) {
        ApiResponse response;
        try {
            response = (ApiResponse)DispatchServiceHelper.invokeBOSService((String)"qing_modeler", (String)"QingModelerExternalService", (String)"getModelMeta", (Object[])new Object[]{modelId});
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        if (ApiResponse.ApiCode.SUCCESS.getCode() != response.getCode()) {
            throw new KDBizException(response.getMessage());
        }
        return (ModelMeta)response.getData();
    }
}

