/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.service.mservices;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.scmdi.common.utils.DataSetExecutor;

public class SyncInvCostTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(SyncInvCostTask.class);
    private static final Long PERIOD_TYPE = 1L;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DBRoute scmRoute = new DBRoute("scm");
        String deleteDataSql = "delete from t_scmdi_invcost";
        boolean execute = DB.execute((DBRoute)scmRoute, (String)deleteDataSql);
        if (execute) {
            LOG.info("\u5220\u9664\u6210\u529f");
        }
        QFilter balFilter = new QFilter("calorg", "is not null", null);
        String balSelectFields = "keycol,costaccount,storageorgunit,ownertype,owner,material,mversion,assist,lot,warehouse,location,invtype,invstatus,project,configuredcode,tracknumber,costelement,costsubelement,period,endperiod,actualcost,actualcost_in,actualcost_out,actualcost_bal,currency,baseunit,accsys,calorg,calpolicy,accounttype,calrange,caldimension,isstandardcost,seqnum";
        DataSet bal = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bal", (String)balSelectFields, (QFilter[])new QFilter[]{balFilter}, null);
        String periodSelectFields = "id as periodid,number,periodyear,periodnumber";
        QFilter periodFilter = new QFilter("periodtype", "=", (Object)PERIOD_TYPE);
        QFilter qFilter = new QFilter("period", "!=", (Object)0);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_bal", (String)"period", (QFilter[])new QFilter[]{qFilter}, null);
        DataSet minPeriodDataSet = dataSet.groupBy(new String[]{"period"}).min("period").finish().top(1);
        Integer minPeriod = 0;
        if (minPeriodDataSet.hasNext()) {
            Row row = minPeriodDataSet.next();
            minPeriod = row.getInteger("period");
        }
        minPeriodDataSet.close();
        LocalDate now = LocalDate.now();
        LocalDate localDate = now.minusYears(2L);
        int year = localDate.getYear();
        int threeYearsAgo = year * 100 + 1;
        int current = threeYearsAgo >= minPeriod ? threeYearsAgo : minPeriod;
        periodFilter.and(new QFilter("number", ">=", (Object)String.valueOf(current)));
        periodFilter.and(new QFilter("isadjustperiod", "=", (Object)"0"));
        DataSet period = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_period", (String)periodSelectFields, (QFilter[])new QFilter[]{periodFilter}, (String)"number");
        DataSet periodSelect = period.select("periodid,periodyear * 100 + periodnumber as periodnum");
        String balGroupFields = "keycol,costaccount,storageorgunit,ownertype,owner,material,mversion,assist,lot,warehouse,location,invtype,invstatus,project,configuredcode,tracknumber,costelement,costsubelement,currency,baseunit,accsys,calorg,calpolicy,accounttype,calrange,caldimension,isstandardcost,seqnum";
        DataSet dimension = bal.groupBy(balGroupFields.split(",")).finish();
        DataSet crossJoinBal = dimension.join(periodSelect, JoinType.CROSS).select(balGroupFields.split(","), new String[]{"periodid", "periodnum"}).finish();
        String crossJoinSelectFields = "keycol,costaccount,storageorgunit,ownertype,owner,material,mversion,assist,lot,warehouse,location,invtype,invstatus,project,configuredcode,tracknumber,costelement,costsubelement,currency,baseunit,accsys,calorg,calpolicy,accounttype,calrange,caldimension,isstandardcost,periodid,periodnum";
        String balJoinSelectFields = "period,endperiod,actualcost,actualcost_in,actualcost_out,actualcost_bal";
        DataSet joinFirst = crossJoinBal.join(bal, JoinType.LEFT).on("keycol", "keycol").on("costaccount", "costaccount").on("storageorgunit", "storageorgunit").on("ownertype", "ownertype").on("owner", "owner").on("material", "material").on("mversion", "mversion").on("assist", "assist").on("lot", "lot").on("warehouse", "warehouse").on("location", "location").on("invtype", "invtype").on("invstatus", "invstatus").on("project", "project").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").on("costelement", "costelement").on("costsubelement", "costsubelement").on("currency", "currency").on("baseunit", "baseunit").on("accsys", "accsys").on("calorg", "calorg").on("calpolicy", "calpolicy").on("accounttype", "accounttype").on("calrange", "calrange").on("caldimension", "caldimension").on("isstandardcost", "isstandardcost").select(crossJoinSelectFields.split(","), balJoinSelectFields.split(",")).finish();
        DataSet orderByFirst = joinFirst.orderBy(crossJoinSelectFields.split(","));
        String joinSecondSelectFields = "keycol,costaccount,storageorgunit,ownertype,owner,material,mversion,assist,lot,warehouse,location,invtype,invstatus,project,configuredcode,tracknumber,costelement,costsubelement,currency,baseunit,accsys,calorg,calpolicy,accounttype,calrange,caldimension,isstandardcost,periodid,periodnum,period,endperiod,actualcost,actualcost_bal";
        String balJoinSecondSelectFields = "actualcost_in,actualcost_out";
        DataSet joinSecond = orderByFirst.join(bal, JoinType.LEFT).on("keycol", "keycol").on("costaccount", "costaccount").on("storageorgunit", "storageorgunit").on("ownertype", "ownertype").on("owner", "owner").on("material", "material").on("mversion", "mversion").on("assist", "assist").on("lot", "lot").on("warehouse", "warehouse").on("location", "location").on("invtype", "invtype").on("invstatus", "invstatus").on("project", "project").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").on("costelement", "costelement").on("costsubelement", "costsubelement").on("currency", "currency").on("baseunit", "baseunit").on("accsys", "accsys").on("calorg", "calorg").on("calpolicy", "calpolicy").on("accounttype", "accounttype").on("calrange", "calrange").on("caldimension", "caldimension").on("isstandardcost", "isstandardcost").on("periodnum", "period").select(joinSecondSelectFields.split(","), balJoinSecondSelectFields.split(",")).finish();
        DataSet finalDataset = joinSecond.select("costaccount,storageorgunit,ownertype,owner,material,mversion,assist,lot,warehouse,location,invtype,invstatus,project,configuredcode,tracknumber,costelement,costsubelement,currency,baseunit,accsys,calorg,calpolicy,accounttype,calrange,caldimension,isstandardcost,periodnum,periodid,period,endperiod,actualcost_bal as endcost,case when period = periodnum then actualcost else actualcost_bal end as begincost,case when actualcost_in = null then 0 else actualcost_in end as incost,case when actualcost_out = null then 0 else actualcost_out end as outcost");
        if (finalDataset.isEmpty()) {
            LOG.info("\u672a\u67e5\u8be2\u5230\u6709\u6548\u6570\u636e");
            return;
        }
        DataSet[] dataSets = finalDataset.splitByGroup(new String[]{"periodid"});
        String insertSql = "insert into t_scmdi_invcost (fid,fcostaccountid,faccsysid,fcalorgid,fcalpolicyid,fcurrencyid,fperiodid,fperiodnum,fperiod,fendperiod,fstorageorgunitid,fownertype,fownerid,fmaterialid,fmversionid,fassistid,flot,fwarehouseid,flocationid,finvtypeid,finvstatusid,fconfiguredcodeid,fprojectid,ftracknumber,fcalrangeid,fcaldimensionid,faccounttype,fisstandardcost,fbaseunitid,fcostelementid,fcostsubelementid,fperiodbeginactualcost,fperiodinactualcost,fperiodissueactualcost,fperiodendactualcost) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        for (DataSet splitDataSet : dataSets) {
            this.insertDataToInvCost(splitDataSet, scmRoute, insertSql);
        }
        String deleteSql = "delete from t_scmdi_invcost where fperiod > fperiodnum or fendperiod<= fperiodnum";
        boolean delete = DB.execute((DBRoute)scmRoute, (String)deleteSql);
        if (delete) {
            LOG.info("\u5220\u9664\u6210\u529f");
        }
    }

    private void insertDataToInvCost(DataSet splitDataSet, DBRoute scmRoute, String insertSql) {
        DataSetExecutor.execute((int)10000, (DataSet)splitDataSet, row -> {
            Object[] param = new Object[]{0, row.get("costaccount"), row.get("accsys"), row.get("calorg"), row.get("calpolicy"), row.get("currency"), row.get("periodid"), row.get("periodnum"), row.get("period"), row.get("endperiod"), row.get("storageorgunit"), row.get("ownertype"), row.get("owner"), row.get("material"), row.get("mversion"), row.get("assist"), row.get("lot"), row.get("warehouse"), row.get("location"), row.get("invtype"), row.get("invstatus"), row.get("configuredcode"), row.get("project"), row.get("tracknumber"), row.get("calrange"), row.get("caldimension"), row.get("accounttype"), row.get("isstandardcost"), row.get("baseunit"), row.get("costelement"), row.get("costsubelement"), row.getBigDecimal("begincost"), row.getBigDecimal("incost"), row.getBigDecimal("outcost"), row.getBigDecimal("endcost")};
            return param;
        }, list -> {
            long[] ids = DB.genLongIds((String)"t_scmdi_invcost", (int)list.size());
            for (int i = 0; i < ids.length; ++i) {
                Object[] object = (Object[])list.get(i);
                object[0] = ids[i];
            }
            DB.executeBatch((DBRoute)scmRoute, (String)insertSql, (List)list);
        });
    }
}

