/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.scmdi.service.mservices.billparse;

import kd.bos.orm.query.QFilter;
import kd.scmc.scmdi.service.mservices.billparse.IInvBillAsAccParser;
import kd.scmc.scmdi.service.mservices.billparse.impl.AdjustBillAsAccParser;
import kd.scmc.scmdi.service.mservices.billparse.impl.AssembBillAsAccParser;
import kd.scmc.scmdi.service.mservices.billparse.impl.DisassBillAsAccParser;
import kd.scmc.scmdi.service.mservices.billparse.impl.InitBillAsAccParser;
import kd.scmc.scmdi.service.mservices.billparse.impl.InvTplBillAsAccParser;
import kd.scmc.scmdi.service.mservices.billparse.impl.LocatTransferBillAsAccParser;
import kd.scmc.scmdi.service.mservices.billparse.impl.TransDirBillAsAccParser;

public class InvBillAsAccParserFactory {
    public static IInvBillAsAccParser buildBillAsAccParser(String billType, QFilter timeQFilter) {
        switch (billType) {
            case "im_adjustbill": {
                return new AdjustBillAsAccParser(billType, timeQFilter);
            }
            case "im_assembbill": {
                return new AssembBillAsAccParser(billType, timeQFilter);
            }
            case "im_disassemblebill": {
                return new DisassBillAsAccParser(billType, timeQFilter);
            }
            case "im_locationtransfer": {
                return new LocatTransferBillAsAccParser(billType, timeQFilter);
            }
            case "im_transdirbill": {
                return new TransDirBillAsAccParser(billType, timeQFilter);
            }
            case "mdc_mftmanuinbill": 
            case "mdc_mftreqoutbill": {
                return null;
            }
            case "im_initbill": {
                return new InitBillAsAccParser(billType, timeQFilter);
            }
        }
        return new InvTplBillAsAccParser(billType, timeQFilter);
    }
}

