/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sctm.mservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.business.helper.BillQuantityHelper;
import kd.mpscmm.msbd.business.service.TrackLogService;
import kd.scmc.sctm.mservice.api.SctmFiService;
import kd.scmc.sctm.mservice.helper.DealServiceParamHelper;
import kd.scmc.sctm.mservice.helper.LockHelper;

public class SctmFiServiceImpl
implements SctmFiService {
    private static final Log log = LogFactory.getLog(SctmFiServiceImpl.class);
    private static final TrackLogService trackLog = new TrackLogService(SctmFiServiceImpl.class, "sctm");
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final BigDecimal MULTIPLE = BigDecimal.valueOf(1.2);
    private static final char COMMA = ',';
    private static final char POINT = '.';
    private static final int MAX_BILL_COUNT = 100;
    private static final String KEY_MAINBILLENTITY = "mainbillentity";
    private static final String KEY_MAINBILLID = "mainbillid";
    private static final String KEY_MAINBILLENTRYID = "mainbillentryid";
    private static final String KEY_SETTLEORGID = "settleorgid";
    private static final String KEY_AMOUNT = "amount";
    private static final String KEY_BASEQTY = "baseqty";
    private static final String SUCCESS = "success";
    private static final String MESSAGE = "message";
    private final String ERROR_PARAM_ISNULL = ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"SctmFiServiceImpl_0", (String)"scmc-sctm-mservice", (Object[])new Object[0]);
    private final String ERROR_PARAM_MAINBILLID_ISNULL = ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u5f02\u5e38\uff0c\u6838\u5fc3\u5355\u636eID\uff08\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\uff09\u4e3a\u7a7a\u3002", (String)"SctmFiServiceImpl_1", (String)"scmc-sctm-mservice", (Object[])new Object[0]);
    private final String ERROR_LOCK_TIMEOUT = ResManager.loadKDString((String)"\u7b49\u5f85\u53cd\u5199\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u9501\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"SctmFiServiceImpl_29", (String)"scmc-sctm-mservice", (Object[])new Object[0]);
    private final String ERROR_MAINBILLID_DATABASE_NOT_EXIST = ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u4e2d\u6838\u5fc3\u5355\u636eID(\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355)\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"SctmFiServiceImpl_2", (String)"scmc-sctm-mservice", (Object[])new Object[0]);

    @Override
    public Map<String, Object> WbApQtyAndAmount(List<Map<String, Object>> list) {
        log.info("scmc-sctm-SctmFiServiceImpl.WbApQtyAndAmount begin-> param: " + list);
        if (DealServiceParamHelper.isNullValue(list)) {
            log.info("param exception is null");
            Map<String, Object> buildResult = DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_ISNULL);
            return buildResult;
        }
        Map<Long, List<Map<String, Object>>> billIDMap = this.buildParamBillMap(list);
        Map<String, Object> result = this.batchUpdateApQtyAndAmount(billIDMap);
        log.info("scmc-sctm-SctmFiServiceImpl.WbApQtyAndAmount end.");
        return result;
    }

    @Override
    public Map<String, Object> WbPayAmountOnly(List<Map<String, Object>> list) {
        log.info("scmc-sctm-SctmFiServiceImpl.WbPayAmountOnly begin-> param: " + list);
        if (DealServiceParamHelper.isNullValue(list)) {
            log.info("param exception is null");
            Map<String, Object> buildResult = DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_ISNULL);
            return buildResult;
        }
        Map<Long, List<Map<String, Object>>> billIDMap = this.buildParamBillMap(list);
        Map<String, Object> result = this.batchUpdatePayAmountOnly(billIDMap);
        log.info("scmc-sctm-SctmFiServiceImpl.WbPayAmountOnly end.");
        return result;
    }

    @Override
    public Map<String, Object> WbPayPlanJoinAmountOnly(List<Map<String, Object>> list) {
        log.info("scmc-sctm-SctmFiServiceImpl.WbPayPlanJoinAmountOnly begin-> param: " + list);
        if (DealServiceParamHelper.isNullValue(list)) {
            log.info("param exception is null");
            Map<String, Object> buildResult = DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_ISNULL);
            return buildResult;
        }
        Map<Long, List<Map<String, Object>>> billIDMap = this.buildParamBillMap(list);
        Map<String, Object> result = this.batchUpdatePayPlanJoinAmountOnly(billIDMap);
        log.info("scmc-sctm-SctmFiServiceImpl.WbPayPlanJoinAmountOnly end.");
        return result;
    }

    @Override
    public Map<String, Object> WbPreAmount(List<Map<String, Object>> list) {
        log.info("scmc-sctm-SctmFiServiceImpl.WbPreAmount begin-> param: " + list);
        if (DealServiceParamHelper.isNullValue(list)) {
            log.info("param exception is null");
            Map<String, Object> buildResult = DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_ISNULL);
            return buildResult;
        }
        Map<Long, List<Map<String, Object>>> billIDMap = this.buildParamBillMap(list);
        Map<String, Object> result = this.batchUpdatePreAmount(billIDMap);
        log.info("scmc-sctm-SctmFiServiceImpl.WbPreAmount end.");
        return result;
    }

    @Override
    public Map<String, Object> WbPayPlanPayAmount(List<Map<String, Object>> list) {
        log.info("scmc-sctm-SctmFiServiceImpl.WbPayPlanPayAmount begin-> param: " + list);
        if (DealServiceParamHelper.isNullValue(list)) {
            log.info("param exception is null");
            Map<String, Object> buildResult = DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_ISNULL);
            return buildResult;
        }
        Map<Long, List<Map<String, Object>>> billIDMap = this.buildParamBillMap(list);
        Map<String, Object> result = this.batchUpdatePayPlanPayAmount(billIDMap);
        log.info("scmc-sctm-SctmFiServiceImpl.WbPayPlanPayAmount end.");
        return result;
    }

    @Override
    public Map<String, Object> WbPayPlanJoinAmount(List<Map<String, Object>> list) {
        log.info("scmc-sctm-SctmFiServiceImpl.WbPayPlanJoinAmount begin-> param: " + list);
        if (DealServiceParamHelper.isNullValue(list)) {
            log.info("param exception is null");
            Map<String, Object> buildResult = DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_ISNULL);
            return buildResult;
        }
        Map<Long, List<Map<String, Object>>> billIDMap = this.buildParamBillMap(list);
        Map<String, Object> result = this.batchUpdatePayPlanJoinAmount(billIDMap);
        log.info("scmc-sctm-SctmFiServiceImpl.WbPayPlanJoinAmount end.");
        return result;
    }

    private Map<Long, List<Map<String, Object>>> buildParamBillMap(List<Map<String, Object>> list) {
        return list.stream().filter(map -> map.get(KEY_MAINBILLID) != null && "sctm_scpo".equals(map.get(KEY_MAINBILLENTITY))).collect(Collectors.groupingBy(map -> (Long)map.get(KEY_MAINBILLID)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> batchUpdateApQtyAndAmount(Map<Long, List<Map<String, Object>>> billIDMap) {
        if (DealServiceParamHelper.isNullValue(billIDMap)) {
            log.info("param exception mainbillid(sctm_scpo) is null");
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_MAINBILLID_ISNULL);
        }
        StringBuilder selectField = new StringBuilder();
        selectField.append("id").append(',').append("billno").append(',').append("supplier").append(',').append("billentry").append('.').append("seq").append(',').append("billentry").append('.').append("material").append(',').append("billentry").append('.').append("materialmasterid").append(',').append("billentry").append('.').append("unit").append(',').append("billentry").append('.').append("baseunit").append(',').append("billentry").append('.').append("qty").append(',').append("billentry").append('.').append(KEY_BASEQTY).append(',').append("billentry").append('.').append("amountandtax").append(',').append("billentry").append('.').append("payablepriceqty").append(',').append("billentry").append('.').append("payablebaseqty").append(',').append("billentry").append('.').append("payableamount").append(',').append("billentry").append('.').append("entrysettleorg");
        Set<Long> ids = billIDMap.keySet();
        int size = ids.size();
        ArrayList<String> keys = new ArrayList<String>(size);
        for (Long l : ids) {
            keys.add("wbscpo#" + String.valueOf(l));
        }
        List<DLock> dLocks = LockHelper.createDLocks(keys);
        if (LockHelper.tryDLocks(dLocks, null)) {
            try {
                if (size <= 100) {
                    Map<String, Object> map = this.updateApQtyAndAmount(billIDMap, selectField, ids);
                    return map;
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
                hashMap.put(SUCCESS, Boolean.TRUE);
                StringBuilder msg = new StringBuilder();
                ArrayList<Long> idList = new ArrayList<Long>(ids);
                while (!idList.isEmpty()) {
                    HashSet<Long> subIds = new HashSet<Long>(100);
                    while (!idList.isEmpty() && subIds.size() < 100) {
                        Long next = (Long)idList.get(0);
                        subIds.add(next);
                        idList.remove(next);
                    }
                    Map<String, Object> subResult = this.updateApQtyAndAmount(billIDMap, selectField, subIds);
                    if (subResult == null) continue;
                    if (!((Boolean)subResult.get(SUCCESS)).booleanValue()) {
                        msg.append(subResult.get(MESSAGE));
                        continue;
                    }
                    hashMap.putAll(subResult);
                }
                HashMap<String, Object> hashMap2 = hashMap;
                return hashMap2;
            }
            finally {
                LockHelper.unDLocks(dLocks);
            }
        }
        trackLog.error(this.ERROR_LOCK_TIMEOUT);
        throw new KDException(this.ERROR_LOCK_TIMEOUT);
    }

    private Map<String, Object> updateApQtyAndAmount(Map<Long, List<Map<String, Object>>> billIDMap, StringBuilder selectField, Set<Long> ids) {
        QFilter q = new QFilter("id", "in", ids);
        QFilter[] qFilters = new QFilter[]{q};
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sctm_scpo", (String)selectField.toString(), (QFilter[])qFilters);
        if (bills == null || bills.length == 0) {
            log.info("mainbillid(sctm_scpo) no exist in database :" + ids);
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_MAINBILLID_DATABASE_NOT_EXIST);
        }
        int length = bills.length;
        ArrayList loadBillDatas = new ArrayList(length);
        ArrayList updateBillDatas = new ArrayList(length);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(length);
        for (DynamicObject bill : bills) {
            Long id = (Long)bill.getPkValue();
            String billNo = bill.getString("billno");
            HashMap<String, Object> loadBillData = new HashMap<String, Object>(4);
            loadBillData.put("id", id);
            loadBillData.put("billno", billNo);
            loadBillDatas.add(loadBillData);
            List<Map<String, Object>> paramList = billIDMap.get(id);
            if (DealServiceParamHelper.isNullValue(paramList)) continue;
            boolean isUpdate = false;
            block1: for (Map<String, Object> paramMap : paramList) {
                if (DealServiceParamHelper.isNullValue(paramMap)) continue;
                if (DealServiceParamHelper.isNullValue(paramMap.get(KEY_MAINBILLENTRYID))) {
                    log.info("param validation failer, not update: mainbillentryid is null");
                    continue;
                }
                Long mainBillEntryID = (Long)paramMap.get(KEY_MAINBILLENTRYID);
                BigDecimal baseQty = DealServiceParamHelper.getNotNullBigDecimal(paramMap.get(KEY_BASEQTY));
                BigDecimal amount = DealServiceParamHelper.getNotNullBigDecimal(paramMap.get(KEY_AMOUNT));
                if (ZERO.compareTo(baseQty) == 0 && ZERO.compareTo(amount) == 0) {
                    log.info("param validation failer, not update: baseqty and amount is 0");
                    continue;
                }
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entrys) {
                    Long entryID = (Long)entry.getPkValue();
                    if (entryID == null || !entryID.equals(mainBillEntryID)) continue;
                    if (this.isWriteBack(paramMap, bill, mainBillEntryID)) {
                        if (ZERO.compareTo(amount) != 0) {
                            BigDecimal oldPayableAmount = DealServiceParamHelper.getNotNullBigDecimal(entry.get("payableamount"));
                            entry.set("payableamount", (Object)oldPayableAmount.add(amount));
                            this.trackLogWarnByBigDecimal(bill, entry, "payableamount", ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u5e94\u4ed8\u91d1\u989d", (String)"SctmFiServiceImpl_3", (String)"scmc-sctm-mservice", (Object[])new Object[0]), "amountandtax", ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u4ef7\u7a0e\u5408\u8ba1", (String)"SctmFiServiceImpl_4", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
                            isUpdate = true;
                        }
                        if (ZERO.compareTo(baseQty) == 0) continue block1;
                        BigDecimal oldPayableBaseQty = DealServiceParamHelper.getNotNullBigDecimal(entry.get("payablebaseqty"));
                        Long materialID = null;
                        if (entry.get("materialmasterid") instanceof DynamicObject) {
                            materialID = (Long)entry.getDynamicObject("materialmasterid").getPkValue();
                        } else if (entry.get("material") instanceof DynamicObject && entry.getDynamicObject("material").get("masterid") instanceof DynamicObject) {
                            materialID = (Long)entry.getDynamicObject("material").getDynamicObject("masterid").getPkValue();
                        }
                        DynamicObject unit = entry.getDynamicObject("unit");
                        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
                        if (materialID == null || unit == null || baseUnit == null) continue block1;
                        BigDecimal newPayableBaseQty = oldPayableBaseQty.add(baseQty);
                        BigDecimal newPayableQty = BillQuantityHelper.getDesQtyConv((Long)materialID, (DynamicObject)baseUnit, (BigDecimal)newPayableBaseQty, (DynamicObject)unit);
                        entry.set("payablebaseqty", (Object)newPayableBaseQty);
                        entry.set("payablepriceqty", (Object)newPayableQty);
                        this.trackLogWarnByBigDecimal(bill, entry, "payablepriceqty", ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u5e94\u4ed8\u6570\u91cf", (String)"SctmFiServiceImpl_5", (String)"scmc-sctm-mservice", (Object[])new Object[0]), "qty", ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u6570\u91cf", (String)"SctmFiServiceImpl_6", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
                        this.trackLogWarnByBigDecimal(bill, entry, "payablebaseqty", ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u5e94\u4ed8\u57fa\u672c\u6570\u91cf", (String)"SctmFiServiceImpl_7", (String)"scmc-sctm-mservice", (Object[])new Object[0]), KEY_BASEQTY, ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u57fa\u672c\u6570\u91cf", (String)"SctmFiServiceImpl_8", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
                        isUpdate = true;
                        continue block1;
                    }
                    log.info("isWriteBack validation is failer,not update:" + paramMap);
                    continue block1;
                }
            }
            if (!isUpdate) continue;
            updateList.add(bill);
            HashMap<String, Object> updateBillData = new HashMap<String, Object>(4);
            updateBillData.put("id", id);
            updateBillData.put("billno", billNo);
            updateBillDatas.add(updateBillData);
        }
        trackLog.info("sctm_scpo(load) -> " + DealServiceParamHelper.serialization(loadBillDatas) + ";(update) -> " + DealServiceParamHelper.serialization(updateBillDatas));
        return this.saveScPo(updateList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> batchUpdatePayAmountOnly(Map<Long, List<Map<String, Object>>> billIDMap) {
        if (DealServiceParamHelper.isNullValue(billIDMap)) {
            log.info("param exception mainbillid(sctm_scpo) is null");
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_MAINBILLID_ISNULL);
        }
        StringBuilder selectField = new StringBuilder();
        selectField.append("id").append(',').append("billno").append(',').append("supplier").append(',').append("totalallamount").append(',').append("paidallamount").append(',').append("billentry").append('.').append("entrysettleorg");
        Set<Long> ids = billIDMap.keySet();
        int size = ids.size();
        ArrayList<String> keys = new ArrayList<String>(size);
        for (Long l : ids) {
            keys.add("wbscpo#" + String.valueOf(l));
        }
        List<DLock> dLocks = LockHelper.createDLocks(keys);
        if (LockHelper.tryDLocks(dLocks, null)) {
            try {
                if (size <= 100) {
                    Map<String, Object> map = this.updatePayAmountOnly(billIDMap, selectField, ids);
                    return map;
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
                hashMap.put(SUCCESS, Boolean.TRUE);
                StringBuilder msg = new StringBuilder();
                ArrayList<Long> idList = new ArrayList<Long>(ids);
                while (!idList.isEmpty()) {
                    HashSet<Long> subIds = new HashSet<Long>(100);
                    while (!idList.isEmpty() && subIds.size() < 100) {
                        Long next = (Long)idList.get(0);
                        subIds.add(next);
                        idList.remove(next);
                    }
                    Map<String, Object> subResult = this.updatePayAmountOnly(billIDMap, selectField, subIds);
                    if (subResult == null) continue;
                    if (!((Boolean)subResult.get(SUCCESS)).booleanValue()) {
                        msg.append(subResult.get(MESSAGE));
                        continue;
                    }
                    hashMap.putAll(subResult);
                }
                HashMap<String, Object> hashMap2 = hashMap;
                return hashMap2;
            }
            finally {
                LockHelper.unDLocks(dLocks);
            }
        }
        trackLog.error(this.ERROR_LOCK_TIMEOUT);
        throw new KDException(this.ERROR_LOCK_TIMEOUT);
    }

    private Map<String, Object> updatePayAmountOnly(Map<Long, List<Map<String, Object>>> billIDMap, StringBuilder selectField, Set<Long> ids) {
        QFilter q = new QFilter("id", "in", ids);
        QFilter[] qFilters = new QFilter[]{q};
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sctm_scpo", (String)selectField.toString(), (QFilter[])qFilters);
        if (bills == null || bills.length == 0) {
            log.info("mainbillid(sctm_scpo) no exist in database :" + ids);
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_MAINBILLID_DATABASE_NOT_EXIST);
        }
        int length = bills.length;
        ArrayList loadBillDatas = new ArrayList(length);
        ArrayList updateBillDatas = new ArrayList(length);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(bills.length);
        for (DynamicObject bill : bills) {
            Long id = (Long)bill.getPkValue();
            String billNo = bill.getString("billno");
            HashMap<String, Object> loadBillData = new HashMap<String, Object>(4);
            loadBillData.put("id", id);
            loadBillData.put("billno", billNo);
            loadBillDatas.add(loadBillData);
            List<Map<String, Object>> paramList = billIDMap.get(id);
            if (DealServiceParamHelper.isNullValue(paramList)) continue;
            boolean isUpdate = false;
            for (Map<String, Object> paramMap : paramList) {
                BigDecimal amount = DealServiceParamHelper.getNotNullBigDecimal(paramMap.get(KEY_AMOUNT));
                if (ZERO.compareTo(amount) == 0) {
                    log.info("param validation failer, not update: amount is null or 0");
                    continue;
                }
                Long mainBillEntryID = (Long)paramMap.get(KEY_MAINBILLENTRYID);
                if (this.isWriteBack(paramMap, bill, mainBillEntryID)) {
                    BigDecimal oldPaidAllAmount = DealServiceParamHelper.getNotNullBigDecimal(bill.get("paidallamount"));
                    bill.set("paidallamount", (Object)oldPaidAllAmount.add(amount));
                    this.trackLogWarnByBigDecimal(bill, null, "paidallamount", ResManager.loadKDString((String)"\u5df2\u4ed8\u91d1\u989d", (String)"SctmFiServiceImpl_9", (String)"scmc-sctm-mservice", (Object[])new Object[0]), "totalallamount", ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"SctmFiServiceImpl_10", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
                    isUpdate = true;
                    continue;
                }
                log.info("isWriteBack validation is failer,not update:" + paramMap);
            }
            if (!isUpdate) continue;
            updateList.add(bill);
            HashMap<String, Object> updateBillData = new HashMap<String, Object>(4);
            updateBillData.put("id", id);
            updateBillData.put("billno", billNo);
            updateBillDatas.add(updateBillData);
        }
        trackLog.info("sctm_scpo(load) -> " + DealServiceParamHelper.serialization(loadBillDatas) + ";(update) -> " + DealServiceParamHelper.serialization(updateBillDatas));
        return this.saveScPo(updateList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> batchUpdatePayPlanJoinAmountOnly(Map<Long, List<Map<String, Object>>> billIDMap) {
        if (DealServiceParamHelper.isNullValue(billIDMap)) {
            log.info("param exception mainbillid(sctm_scpo) is null");
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_MAINBILLID_ISNULL);
        }
        StringBuilder selectField = new StringBuilder();
        selectField.append("id").append(',').append("billno").append(',').append("supplier").append(',').append("billentry_pay").append('.').append("seq").append(',').append("billentry_pay").append('.').append("payamount").append(',').append("billentry_pay").append('.').append("joinpayamount").append(',').append("billentry").append('.').append("entrysettleorg");
        Set<Long> ids = billIDMap.keySet();
        int size = ids.size();
        ArrayList<String> keys = new ArrayList<String>(size);
        for (Long l : ids) {
            keys.add("wbscpo#" + String.valueOf(l));
        }
        List<DLock> dLocks = LockHelper.createDLocks(keys);
        if (LockHelper.tryDLocks(dLocks, null)) {
            try {
                if (size <= 100) {
                    Map<String, Object> map = this.updatePayPlanJoinAmountOnly(billIDMap, selectField, ids);
                    return map;
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
                hashMap.put(SUCCESS, Boolean.TRUE);
                StringBuilder msg = new StringBuilder();
                ArrayList<Long> idList = new ArrayList<Long>(ids);
                while (!idList.isEmpty()) {
                    HashSet<Long> subIds = new HashSet<Long>(100);
                    while (!idList.isEmpty() && subIds.size() < 100) {
                        Long next = (Long)idList.get(0);
                        subIds.add(next);
                        idList.remove(next);
                    }
                    Map<String, Object> subResult = this.updatePayPlanJoinAmountOnly(billIDMap, selectField, subIds);
                    if (subResult == null) continue;
                    if (!((Boolean)subResult.get(SUCCESS)).booleanValue()) {
                        msg.append(subResult.get(MESSAGE));
                        continue;
                    }
                    hashMap.putAll(subResult);
                }
                HashMap<String, Object> hashMap2 = hashMap;
                return hashMap2;
            }
            finally {
                LockHelper.unDLocks(dLocks);
            }
        }
        trackLog.error(this.ERROR_LOCK_TIMEOUT);
        throw new KDException(this.ERROR_LOCK_TIMEOUT);
    }

    private Map<String, Object> updatePayPlanJoinAmountOnly(Map<Long, List<Map<String, Object>>> billIDMap, StringBuilder selectField, Set<Long> ids) {
        QFilter q = new QFilter("id", "in", ids);
        QFilter[] qFilters = new QFilter[]{q};
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sctm_scpo", (String)selectField.toString(), (QFilter[])qFilters);
        if (bills == null || bills.length == 0) {
            log.info("mainbillid(sctm_scpo) no exist in database :" + ids);
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_MAINBILLID_DATABASE_NOT_EXIST);
        }
        int length = bills.length;
        ArrayList loadBillDatas = new ArrayList(length);
        ArrayList updateBillDatas = new ArrayList(length);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(bills.length);
        for (DynamicObject bill : bills) {
            Long id = (Long)bill.getPkValue();
            String billNo = bill.getString("billno");
            HashMap<String, Object> loadBillData = new HashMap<String, Object>(4);
            loadBillData.put("id", id);
            loadBillData.put("billno", billNo);
            loadBillDatas.add(loadBillData);
            List<Map<String, Object>> paramList = billIDMap.get(id);
            if (DealServiceParamHelper.isNullValue(paramList)) continue;
            boolean isUpdate = false;
            block1: for (Map<String, Object> paramMap : paramList) {
                if (DealServiceParamHelper.isNullValue(paramMap.get(KEY_MAINBILLENTRYID))) {
                    log.info("param validation failer, not update: mainbillentryid is null");
                    continue;
                }
                Long mainBillEntryID = (Long)paramMap.get(KEY_MAINBILLENTRYID);
                if (DealServiceParamHelper.isNullValue(paramMap.get(KEY_AMOUNT))) {
                    log.info("param validation failer, not update: amount is null or 0");
                    continue;
                }
                BigDecimal amount = (BigDecimal)paramMap.get(KEY_AMOUNT);
                if (this.isWriteBack(paramMap, bill, null)) {
                    DynamicObjectCollection payEntrys = bill.getDynamicObjectCollection("billentry_pay");
                    for (DynamicObject payEntry : payEntrys) {
                        if (!mainBillEntryID.equals(payEntry.getPkValue())) continue;
                        BigDecimal oldJoinPaidAmount = DealServiceParamHelper.getNotNullBigDecimal(payEntry.get("joinpayamount"));
                        payEntry.set("joinpayamount", (Object)oldJoinPaidAmount.add(amount));
                        this.trackLogWarnByBigDecimal(bill, payEntry, "joinpayamount", ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212.\u5173\u8054\u4ed8\u6b3e\u91d1\u989d", (String)"SctmFiServiceImpl_11", (String)"scmc-sctm-mservice", (Object[])new Object[0]), "payamount", ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212.\u4ed8\u6b3e\u91d1\u989d", (String)"SctmFiServiceImpl_12", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
                        isUpdate = true;
                        continue block1;
                    }
                    continue;
                }
                log.info("isWriteBack validation is failer,not update:" + paramMap);
            }
            if (!isUpdate) continue;
            updateList.add(bill);
            HashMap<String, Object> updateBillData = new HashMap<String, Object>(4);
            updateBillData.put("id", id);
            updateBillData.put("billno", billNo);
            updateBillDatas.add(updateBillData);
        }
        trackLog.info("sctm_scpo(load) -> " + DealServiceParamHelper.serialization(loadBillDatas) + ";(update) -> " + DealServiceParamHelper.serialization(updateBillDatas));
        return this.saveScPo(updateList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> batchUpdatePreAmount(Map<Long, List<Map<String, Object>>> billIDMap) {
        if (DealServiceParamHelper.isNullValue(billIDMap)) {
            log.info("param exception mainbillid(sctm_scpo) is null");
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_MAINBILLID_ISNULL);
        }
        StringBuilder selectField = new StringBuilder();
        selectField.append("id").append(',').append("billno").append(',').append("supplier").append(',').append("totalallamount").append(',').append("paidallamount").append(',').append("paidpreallamount").append(',').append("billentry").append('.').append("entrysettleorg");
        Set<Long> ids = billIDMap.keySet();
        int size = ids.size();
        ArrayList<String> keys = new ArrayList<String>(size);
        for (Long l : ids) {
            keys.add("wbscpo#" + String.valueOf(l));
        }
        List<DLock> dLocks = LockHelper.createDLocks(keys);
        if (LockHelper.tryDLocks(dLocks, null)) {
            try {
                if (size <= 100) {
                    Map<String, Object> map = this.updatePreAmount(billIDMap, selectField, ids);
                    return map;
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
                hashMap.put(SUCCESS, Boolean.TRUE);
                StringBuilder msg = new StringBuilder();
                ArrayList<Long> idList = new ArrayList<Long>(ids);
                while (!idList.isEmpty()) {
                    HashSet<Long> subIds = new HashSet<Long>(100);
                    while (!idList.isEmpty() && subIds.size() < 100) {
                        Long next = (Long)idList.get(0);
                        subIds.add(next);
                        idList.remove(next);
                    }
                    Map<String, Object> subResult = this.updatePreAmount(billIDMap, selectField, subIds);
                    if (subResult == null) continue;
                    if (!((Boolean)subResult.get(SUCCESS)).booleanValue()) {
                        msg.append(subResult.get(MESSAGE));
                        continue;
                    }
                    hashMap.putAll(subResult);
                }
                HashMap<String, Object> hashMap2 = hashMap;
                return hashMap2;
            }
            finally {
                LockHelper.unDLocks(dLocks);
            }
        }
        trackLog.error(this.ERROR_LOCK_TIMEOUT);
        throw new KDException(this.ERROR_LOCK_TIMEOUT);
    }

    private Map<String, Object> updatePreAmount(Map<Long, List<Map<String, Object>>> billIDMap, StringBuilder selectField, Set<Long> ids) {
        QFilter q = new QFilter("id", "in", ids);
        QFilter[] qFilters = new QFilter[]{q};
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sctm_scpo", (String)selectField.toString(), (QFilter[])qFilters);
        if (bills == null || bills.length == 0) {
            log.info("mainbillid(sctm_scpo) no exist in database :" + ids);
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_MAINBILLID_DATABASE_NOT_EXIST);
        }
        int length = bills.length;
        ArrayList loadBillDatas = new ArrayList(length);
        ArrayList updateBillDatas = new ArrayList(length);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(bills.length);
        for (DynamicObject bill : bills) {
            Long id = (Long)bill.getPkValue();
            String billNo = bill.getString("billno");
            HashMap<String, Object> loadBillData = new HashMap<String, Object>(4);
            loadBillData.put("id", id);
            loadBillData.put("billno", billNo);
            loadBillDatas.add(loadBillData);
            List<Map<String, Object>> paramList = billIDMap.get(id);
            if (DealServiceParamHelper.isNullValue(paramList)) continue;
            boolean isUpdate = false;
            for (Map<String, Object> paramMap : paramList) {
                BigDecimal amount = DealServiceParamHelper.getNotNullBigDecimal(paramMap.get(KEY_AMOUNT));
                if (ZERO.compareTo(amount) == 0) {
                    log.info("param validation failer, not update: amount is null or 0");
                    continue;
                }
                Long mainBillEntryID = (Long)paramMap.get(KEY_MAINBILLENTRYID);
                if (this.isWriteBack(paramMap, bill, mainBillEntryID)) {
                    BigDecimal oldPaidAllAmount = DealServiceParamHelper.getNotNullBigDecimal(bill.get("paidallamount"));
                    BigDecimal oldPaidPreAllAmount = DealServiceParamHelper.getNotNullBigDecimal(bill.get("paidpreallamount"));
                    bill.set("paidallamount", (Object)oldPaidAllAmount.add(amount));
                    bill.set("paidpreallamount", (Object)oldPaidPreAllAmount.add(amount));
                    this.trackLogWarnByBigDecimal(bill, null, "paidallamount", ResManager.loadKDString((String)"\u5df2\u4ed8\u91d1\u989d", (String)"SctmFiServiceImpl_9", (String)"scmc-sctm-mservice", (Object[])new Object[0]), "totalallamount", ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"SctmFiServiceImpl_10", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
                    this.trackLogWarnByBigDecimal(bill, null, "paidpreallamount", ResManager.loadKDString((String)"\u5df2\u9884\u4ed8\u91d1\u989d", (String)"SctmFiServiceImpl_13", (String)"scmc-sctm-mservice", (Object[])new Object[0]), "totalallamount", ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"SctmFiServiceImpl_10", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
                    isUpdate = true;
                    continue;
                }
                log.info("isWriteBack validation is failer,not update:" + paramMap);
            }
            if (!isUpdate) continue;
            updateList.add(bill);
            HashMap<String, Object> updateBillData = new HashMap<String, Object>(4);
            updateBillData.put("id", id);
            updateBillData.put("billno", billNo);
            updateBillDatas.add(updateBillData);
        }
        trackLog.info("sctm_scpo(load) -> " + DealServiceParamHelper.serialization(loadBillDatas) + ";(update) -> " + DealServiceParamHelper.serialization(updateBillDatas));
        return this.saveScPo(updateList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> batchUpdatePayPlanPayAmount(Map<Long, List<Map<String, Object>>> billIDMap) {
        if (DealServiceParamHelper.isNullValue(billIDMap)) {
            log.info("param exception mainbillid(sctm_scpo) is null");
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_MAINBILLID_ISNULL);
        }
        StringBuilder selectField = new StringBuilder();
        selectField.append("id").append(',').append("billno").append(',').append("supplier").append(',').append("totalallamount").append(',').append("paidallamount").append(',').append("paidpreallamount").append(',').append("billentry_pay").append('.').append("seq").append(',').append("billentry_pay").append('.').append("payamount").append(',').append("billentry_pay").append('.').append("paidamount").append(',').append("billentry").append('.').append("entrysettleorg");
        Set<Long> ids = billIDMap.keySet();
        int size = ids.size();
        ArrayList<String> keys = new ArrayList<String>(size);
        for (Long l : ids) {
            keys.add("wbscpo#" + String.valueOf(l));
        }
        List<DLock> dLocks = LockHelper.createDLocks(keys);
        if (LockHelper.tryDLocks(dLocks, null)) {
            try {
                if (size <= 100) {
                    Map<String, Object> map = this.updatePayPlanPayAmount(billIDMap, selectField, ids);
                    return map;
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
                hashMap.put(SUCCESS, Boolean.TRUE);
                StringBuilder msg = new StringBuilder();
                ArrayList<Long> idList = new ArrayList<Long>(ids);
                while (!idList.isEmpty()) {
                    HashSet<Long> subIds = new HashSet<Long>(100);
                    while (!idList.isEmpty() && subIds.size() < 100) {
                        Long next = (Long)idList.get(0);
                        subIds.add(next);
                        idList.remove(next);
                    }
                    Map<String, Object> subResult = this.updatePayPlanPayAmount(billIDMap, selectField, subIds);
                    if (subResult == null) continue;
                    if (!((Boolean)subResult.get(SUCCESS)).booleanValue()) {
                        msg.append(subResult.get(MESSAGE));
                        continue;
                    }
                    hashMap.putAll(subResult);
                }
                HashMap<String, Object> hashMap2 = hashMap;
                return hashMap2;
            }
            finally {
                LockHelper.unDLocks(dLocks);
            }
        }
        trackLog.error(this.ERROR_LOCK_TIMEOUT);
        throw new KDException(this.ERROR_LOCK_TIMEOUT);
    }

    private Map<String, Object> updatePayPlanPayAmount(Map<Long, List<Map<String, Object>>> billIDMap, StringBuilder selectField, Set<Long> ids) {
        QFilter q = new QFilter("id", "in", ids);
        QFilter[] qFilters = new QFilter[]{q};
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sctm_scpo", (String)selectField.toString(), (QFilter[])qFilters);
        if (bills == null || bills.length == 0) {
            log.info("mainbillid(sctm_scpo) no exist in database :" + ids);
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_MAINBILLID_DATABASE_NOT_EXIST);
        }
        int length = bills.length;
        ArrayList loadBillDatas = new ArrayList(length);
        ArrayList updateBillDatas = new ArrayList(length);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(bills.length);
        for (DynamicObject bill : bills) {
            Long id = (Long)bill.getPkValue();
            String billNo = bill.getString("billno");
            HashMap<String, Object> loadBillData = new HashMap<String, Object>(4);
            loadBillData.put("id", id);
            loadBillData.put("billno", billNo);
            loadBillDatas.add(loadBillData);
            List<Map<String, Object>> paramList = billIDMap.get(id);
            if (DealServiceParamHelper.isNullValue(paramList)) continue;
            boolean isUpdate = false;
            block1: for (Map<String, Object> paramMap : paramList) {
                if (DealServiceParamHelper.isNullValue(paramMap.get(KEY_MAINBILLENTRYID))) {
                    log.info("param validation failer, not update: mainbillentryid is null");
                    continue;
                }
                Long mainBillEntryID = (Long)paramMap.get(KEY_MAINBILLENTRYID);
                BigDecimal amount = DealServiceParamHelper.getNotNullBigDecimal(paramMap.get(KEY_AMOUNT));
                if (ZERO.compareTo(amount) == 0) {
                    log.info("param validation failer, not update: amount is null or 0");
                    continue;
                }
                if (this.isWriteBack(paramMap, bill, null)) {
                    DynamicObjectCollection payEntrys = bill.getDynamicObjectCollection("billentry_pay");
                    for (DynamicObject payEntry : payEntrys) {
                        if (!mainBillEntryID.equals(payEntry.getPkValue())) continue;
                        BigDecimal oldPaidAllAmount = DealServiceParamHelper.getNotNullBigDecimal(bill.get("paidallamount"));
                        BigDecimal oldPaidPreAllAmount = DealServiceParamHelper.getNotNullBigDecimal(bill.get("paidpreallamount"));
                        BigDecimal oldPaidAmount = DealServiceParamHelper.getNotNullBigDecimal(payEntry.get("paidamount"));
                        bill.set("paidallamount", (Object)oldPaidAllAmount.add(amount));
                        bill.set("paidpreallamount", (Object)oldPaidPreAllAmount.add(amount));
                        payEntry.set("paidamount", (Object)oldPaidAmount.add(amount));
                        this.trackLogWarnByBigDecimal(bill, null, "paidallamount", ResManager.loadKDString((String)"\u5df2\u4ed8\u91d1\u989d", (String)"SctmFiServiceImpl_9", (String)"scmc-sctm-mservice", (Object[])new Object[0]), "totalallamount", ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"SctmFiServiceImpl_10", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
                        this.trackLogWarnByBigDecimal(bill, null, "paidpreallamount", ResManager.loadKDString((String)"\u5df2\u9884\u4ed8\u91d1\u989d", (String)"SctmFiServiceImpl_13", (String)"scmc-sctm-mservice", (Object[])new Object[0]), "totalallamount", ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"SctmFiServiceImpl_10", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
                        this.trackLogWarnByBigDecimal(bill, payEntry, "paidamount", ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212.\u5df2\u4ed8\u91d1\u989d", (String)"SctmFiServiceImpl_14", (String)"scmc-sctm-mservice", (Object[])new Object[0]), "payamount", ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212.\u4ed8\u6b3e\u91d1\u989d", (String)"SctmFiServiceImpl_12", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
                        isUpdate = true;
                        continue block1;
                    }
                    continue;
                }
                log.info("isWriteBack validation is failer,not update:" + paramMap);
            }
            if (!isUpdate) continue;
            updateList.add(bill);
            HashMap<String, Object> updateBillData = new HashMap<String, Object>(4);
            updateBillData.put("id", id);
            updateBillData.put("billno", billNo);
            updateBillDatas.add(updateBillData);
        }
        trackLog.info("sctm_scpo(load) -> " + DealServiceParamHelper.serialization(loadBillDatas) + ";(update) -> " + DealServiceParamHelper.serialization(updateBillDatas));
        return this.saveScPo(updateList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> batchUpdatePayPlanJoinAmount(Map<Long, List<Map<String, Object>>> billIDMap) {
        if (DealServiceParamHelper.isNullValue(billIDMap)) {
            log.info("param exception mainbillid(sctm_scpo) is null");
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_MAINBILLID_ISNULL);
        }
        StringBuilder selectField = new StringBuilder();
        selectField.append("id").append(',').append("billno").append(',').append("supplier").append(',').append("totalallamount").append(',').append("paidallamount").append(',').append("paidpreallamount").append(',').append("billentry_pay").append('.').append("seq").append(',').append("billentry_pay").append('.').append("payamount").append(',').append("billentry_pay").append('.').append("paidamount").append(',').append("billentry_pay").append('.').append("joinpayamount").append(',').append("billentry").append('.').append("entrysettleorg");
        Set<Long> ids = billIDMap.keySet();
        int size = ids.size();
        ArrayList<String> keys = new ArrayList<String>(size);
        for (Long l : ids) {
            keys.add("wbscpo#" + String.valueOf(l));
        }
        List<DLock> dLocks = LockHelper.createDLocks(keys);
        if (LockHelper.tryDLocks(dLocks, null)) {
            try {
                if (size <= 100) {
                    Map<String, Object> map = this.updatePayPlanJoinAmount(billIDMap, selectField, ids);
                    return map;
                }
                HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
                hashMap.put(SUCCESS, Boolean.TRUE);
                StringBuilder msg = new StringBuilder();
                ArrayList<Long> idList = new ArrayList<Long>(ids);
                while (!idList.isEmpty()) {
                    HashSet<Long> subIds = new HashSet<Long>(100);
                    while (!idList.isEmpty() && subIds.size() < 100) {
                        Long next = (Long)idList.get(0);
                        subIds.add(next);
                        idList.remove(next);
                    }
                    Map<String, Object> subResult = this.updatePayPlanJoinAmount(billIDMap, selectField, subIds);
                    if (subResult == null) continue;
                    if (!((Boolean)subResult.get(SUCCESS)).booleanValue()) {
                        msg.append(subResult.get(MESSAGE));
                        continue;
                    }
                    hashMap.putAll(subResult);
                }
                HashMap<String, Object> hashMap2 = hashMap;
                return hashMap2;
            }
            finally {
                LockHelper.unDLocks(dLocks);
            }
        }
        trackLog.error(this.ERROR_LOCK_TIMEOUT);
        throw new KDException(this.ERROR_LOCK_TIMEOUT);
    }

    private Map<String, Object> updatePayPlanJoinAmount(Map<Long, List<Map<String, Object>>> billIDMap, StringBuilder selectField, Set<Long> ids) {
        QFilter q = new QFilter("id", "in", ids);
        QFilter[] qFilters = new QFilter[]{q};
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sctm_scpo", (String)selectField.toString(), (QFilter[])qFilters);
        if (bills == null || bills.length == 0) {
            log.info("mainbillid(sctm_scpo) no exist in database :" + ids);
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_MAINBILLID_DATABASE_NOT_EXIST);
        }
        int length = bills.length;
        ArrayList loadBillDatas = new ArrayList(length);
        ArrayList updateBillDatas = new ArrayList(length);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(bills.length);
        for (DynamicObject bill : bills) {
            Long id = (Long)bill.getPkValue();
            String billNo = bill.getString("billno");
            HashMap<String, Object> loadBillData = new HashMap<String, Object>(4);
            loadBillData.put("id", id);
            loadBillData.put("billno", billNo);
            loadBillDatas.add(loadBillData);
            List<Map<String, Object>> paramList = billIDMap.get(id);
            if (DealServiceParamHelper.isNullValue(paramList)) continue;
            boolean isUpdate = false;
            block1: for (Map<String, Object> paramMap : paramList) {
                if (DealServiceParamHelper.isNullValue(paramMap.get(KEY_MAINBILLENTRYID))) {
                    log.info("param validation failer, not update: mainbillentryid is null");
                    continue;
                }
                Long mainBillEntryID = (Long)paramMap.get(KEY_MAINBILLENTRYID);
                BigDecimal amount = DealServiceParamHelper.getNotNullBigDecimal(paramMap.get(KEY_AMOUNT));
                if (ZERO.compareTo(amount) == 0) {
                    log.info("param validation failer, not update: amount is null or 0");
                    continue;
                }
                if (this.isWriteBack(paramMap, bill, null)) {
                    DynamicObjectCollection payEntrys = bill.getDynamicObjectCollection("billentry_pay");
                    for (DynamicObject payEntry : payEntrys) {
                        if (!mainBillEntryID.equals(payEntry.getPkValue())) continue;
                        BigDecimal oldPaidAllAmount = DealServiceParamHelper.getNotNullBigDecimal(bill.get("paidallamount"));
                        BigDecimal oldPaidPreAllAmount = DealServiceParamHelper.getNotNullBigDecimal(bill.get("paidpreallamount"));
                        BigDecimal oldPaidAmount = DealServiceParamHelper.getNotNullBigDecimal(payEntry.get("paidamount"));
                        BigDecimal oldJoinPaidAmount = DealServiceParamHelper.getNotNullBigDecimal(payEntry.get("joinpayamount"));
                        bill.set("paidallamount", (Object)oldPaidAllAmount.add(amount));
                        bill.set("paidpreallamount", (Object)oldPaidPreAllAmount.add(amount));
                        payEntry.set("paidamount", (Object)oldPaidAmount.add(amount));
                        payEntry.set("joinpayamount", (Object)oldJoinPaidAmount.add(amount));
                        this.trackLogWarnByBigDecimal(bill, null, "paidallamount", ResManager.loadKDString((String)"\u5df2\u4ed8\u91d1\u989d", (String)"SctmFiServiceImpl_9", (String)"scmc-sctm-mservice", (Object[])new Object[0]), "totalallamount", ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"SctmFiServiceImpl_10", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
                        this.trackLogWarnByBigDecimal(bill, null, "paidpreallamount", ResManager.loadKDString((String)"\u5df2\u9884\u4ed8\u91d1\u989d", (String)"SctmFiServiceImpl_13", (String)"scmc-sctm-mservice", (Object[])new Object[0]), "totalallamount", ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"SctmFiServiceImpl_10", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
                        this.trackLogWarnByBigDecimal(bill, payEntry, "paidamount", ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212.\u5df2\u4ed8\u91d1\u989d", (String)"SctmFiServiceImpl_14", (String)"scmc-sctm-mservice", (Object[])new Object[0]), "payamount", ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212.\u4ed8\u6b3e\u91d1\u989d", (String)"SctmFiServiceImpl_12", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
                        this.trackLogWarnByBigDecimal(bill, payEntry, "joinpayamount", ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212.\u5173\u8054\u4ed8\u6b3e\u91d1\u989d", (String)"SctmFiServiceImpl_11", (String)"scmc-sctm-mservice", (Object[])new Object[0]), "payamount", ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212.\u4ed8\u6b3e\u91d1\u989d", (String)"SctmFiServiceImpl_12", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
                        isUpdate = true;
                        continue block1;
                    }
                    continue;
                }
                log.info("isWriteBack validation is failer,not update:" + paramMap);
            }
            if (!isUpdate) continue;
            updateList.add(bill);
            HashMap<String, Object> updateBillData = new HashMap<String, Object>(4);
            updateBillData.put("id", id);
            updateBillData.put("billno", billNo);
            updateBillDatas.add(updateBillData);
        }
        trackLog.info("sctm_scpo(load) -> " + DealServiceParamHelper.serialization(loadBillDatas) + ";(update) -> " + DealServiceParamHelper.serialization(updateBillDatas));
        return this.saveScPo(updateList);
    }

    private Map<String, Object> saveScPo(List<DynamicObject> updateList) {
        if (DealServiceParamHelper.isNullValue(updateList)) {
            return DealServiceParamHelper.buildResult(Boolean.TRUE, ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u53cd\u5199\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u6761\u4ef6\u3002", (String)"SctmFiServiceImpl_15", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
        }
        try {
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
            log.info("sctm_scpo update success");
        }
        catch (Exception e) {
            String msg = "update sctm_scpo failer: " + e.getMessage();
            log.error(msg);
            log.error((Throwable)e);
            trackLog.error(msg);
            throw e;
        }
        return DealServiceParamHelper.buildResult(Boolean.TRUE, ResManager.loadKDString((String)"\u53cd\u5199\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u6210\u529f\u3002", (String)"SctmFiServiceImpl_16", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
    }

    private boolean isWriteBack(Map<String, Object> paramMap, DynamicObject bill, Long mainBillEntryID) {
        Long settleOrgID = (Long)paramMap.get(KEY_SETTLEORGID);
        Long entrySettleOrgIDValue = this.getEntrySettleOrgID(bill, mainBillEntryID);
        return entrySettleOrgIDValue != null && settleOrgID != null && settleOrgID.equals(entrySettleOrgIDValue);
    }

    private Long getEntrySettleOrgID(DynamicObject bill, Long mainBillEntryID) {
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        Long settleOrgID = null;
        for (DynamicObject entry : entrys) {
            if (entry == null || mainBillEntryID != null && !mainBillEntryID.equals(entry.getPkValue())) continue;
            settleOrgID = entry.get("entrysettleorg") instanceof DynamicObject ? (Long)entry.getDynamicObject("entrysettleorg").getPkValue() : null;
            break;
        }
        return settleOrgID;
    }

    private void trackLogWarnByBigDecimal(DynamicObject bill, DynamicObject entry, String wbBigDecimal, String wbFieldName, String bigDecimal, String fieldName) {
        StringBuilder result = new StringBuilder();
        if (bill != null && StringUtils.isNotBlank((CharSequence)wbBigDecimal) && StringUtils.isNotBlank((CharSequence)bigDecimal)) {
            if (entry != null) {
                BigDecimal wbBigDecimalV = DealServiceParamHelper.getNotNullBigDecimal(entry.get(wbBigDecimal));
                BigDecimal bigDecimalV = DealServiceParamHelper.getNotNullBigDecimal(entry.get(bigDecimal));
                if (wbBigDecimalV.compareTo(ZERO) < 0) {
                    result.append(ResManager.loadKDString((String)"\u8b66\u544a\u539f\u56e0\uff1a", (String)"SctmFiServiceImpl_17", (String)"scmc-sctm-mservice", (Object[])new Object[0])).append('\n');
                    String info1 = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u53cd\u5199\u540e\u7684\u503c\u4e3a\u201c%2$s\u201d\uff0c\u5c0f\u4e8e\u96f6\u3002", (String)"SctmFiServiceImpl_20", (String)"scmc-sctm-mservice", (Object[])new Object[0]), wbFieldName, wbBigDecimalV);
                    result.append(info1);
                    result.append(" ").append(ResManager.loadKDString((String)"\u53d1\u751f\u8b66\u544a\u7684\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u8be6\u60c5\uff08sctm_scpo\uff09-> ", (String)"SctmFiServiceImpl_21", (String)"scmc-sctm-mservice", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7 \uff1a", (String)"SctmFiServiceImpl_22", (String)"scmc-sctm-mservice", (Object[])new Object[0])).append(bill.getString("billno")).append("\uff0c").append(ResManager.loadKDString((String)"\u5206\u5f55\u5e8f\u53f7\uff1a", (String)"SctmFiServiceImpl_23", (String)"scmc-sctm-mservice", (Object[])new Object[0])).append(entry.getInt("seq")).append("\uff0c").append(ResManager.loadKDString((String)"\u5355\u636eID\uff1a", (String)"SctmFiServiceImpl_24", (String)"scmc-sctm-mservice", (Object[])new Object[0])).append(bill.getPkValue()).append("\uff0c").append(ResManager.loadKDString((String)"\u5206\u5f55ID\uff1a", (String)"SctmFiServiceImpl_25", (String)"scmc-sctm-mservice", (Object[])new Object[0])).append(entry.getPkValue());
                    trackLog.warn(result.toString());
                } else if (wbBigDecimalV.compareTo(bigDecimalV.multiply(MULTIPLE)) > 0) {
                    result.append(ResManager.loadKDString((String)"\u8b66\u544a\u539f\u56e0\uff1a", (String)"SctmFiServiceImpl_17", (String)"scmc-sctm-mservice", (Object[])new Object[0])).append('\n');
                    String info1 = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u53cd\u5199\u503c\u4e3a\u201c%2$s\u201d\uff0c\u5927\u4e8e\u5355\u636e\u5b57\u6bb5\u201c%3$s\u201d\u7684\u503c\u201c%4$s\u201d\u3002", (String)"SctmFiServiceImpl_18", (String)"scmc-sctm-mservice", (Object[])new Object[0]), wbFieldName, wbBigDecimalV, fieldName, bigDecimalV);
                    result.append(info1);
                    result.append(ResManager.loadKDString((String)"\u53d1\u751f\u8b66\u544a\u7684\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u8be6\u60c5\uff08sctm_scpo\uff09-> ", (String)"SctmFiServiceImpl_28", (String)"scmc-sctm-mservice", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7 \uff1a", (String)"SctmFiServiceImpl_22", (String)"scmc-sctm-mservice", (Object[])new Object[0])).append(bill.getString("billno")).append("\uff0c").append(ResManager.loadKDString((String)"\u5206\u5f55\u5e8f\u53f7\uff1a", (String)"SctmFiServiceImpl_23", (String)"scmc-sctm-mservice", (Object[])new Object[0])).append(entry.getInt("seq")).append("\uff0c").append(ResManager.loadKDString((String)"\u5355\u636eID\uff1a", (String)"SctmFiServiceImpl_24", (String)"scmc-sctm-mservice", (Object[])new Object[0])).append(bill.getPkValue()).append("\uff0c").append(ResManager.loadKDString((String)"\u5206\u5f55ID\uff1a", (String)"SctmFiServiceImpl_25", (String)"scmc-sctm-mservice", (Object[])new Object[0])).append(entry.getPkValue());
                    trackLog.warn(result.toString());
                }
            } else {
                BigDecimal wbBigDecimalV = DealServiceParamHelper.getNotNullBigDecimal(bill.get(wbBigDecimal));
                BigDecimal bigDecimalV = DealServiceParamHelper.getNotNullBigDecimal(bill.get(bigDecimal));
                if (wbBigDecimalV.compareTo(ZERO) < 0) {
                    result.append(ResManager.loadKDString((String)"\u8b66\u544a\u539f\u56e0\uff1a", (String)"SctmFiServiceImpl_17", (String)"scmc-sctm-mservice", (Object[])new Object[0])).append('\n');
                    String info1 = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u53cd\u5199\u540e\u7684\u503c\u4e3a\u201c%2$s\u201d\uff0c\u5c0f\u4e8e\u96f6\u3002", (String)"SctmFiServiceImpl_20", (String)"scmc-sctm-mservice", (Object[])new Object[0]), wbFieldName, wbBigDecimalV);
                    result.append(info1);
                    result.append(ResManager.loadKDString((String)"\u53d1\u751f\u8b66\u544a\u7684\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u8be6\u60c5\uff08sctm_scpo\uff09-> ", (String)"SctmFiServiceImpl_21", (String)"scmc-sctm-mservice", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7 \uff1a", (String)"SctmFiServiceImpl_22", (String)"scmc-sctm-mservice", (Object[])new Object[0])).append(bill.getString("billno")).append("\uff0c").append(ResManager.loadKDString((String)"\u5355\u636eID\uff1a", (String)"SctmFiServiceImpl_24", (String)"scmc-sctm-mservice", (Object[])new Object[0])).append(bill.getPkValue());
                    trackLog.warn(result.toString());
                } else if (wbBigDecimalV.compareTo(bigDecimalV.multiply(MULTIPLE)) > 0) {
                    result.append(ResManager.loadKDString((String)"\u8b66\u544a\u539f\u56e0\uff1a", (String)"SctmFiServiceImpl_17", (String)"scmc-sctm-mservice", (Object[])new Object[0])).append('\n');
                    String info1 = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u53cd\u5199\u503c\u4e3a\u201c%2$s\u201d\uff0c\u5927\u4e8e\u5355\u636e\u5b57\u6bb5\u201c%3$s\u201d\u7684\u503c\u201c%4$s\u201d\u3002", (String)"SctmFiServiceImpl_18", (String)"scmc-sctm-mservice", (Object[])new Object[0]), wbFieldName, wbBigDecimalV, fieldName, bigDecimalV);
                    result.append(info1);
                    result.append(ResManager.loadKDString((String)"\u53d1\u751f\u8b66\u544a\u7684\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u8be6\u60c5\uff08sctm_scpo\uff09-> ", (String)"SctmFiServiceImpl_28", (String)"scmc-sctm-mservice", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7 \uff1a", (String)"SctmFiServiceImpl_22", (String)"scmc-sctm-mservice", (Object[])new Object[0])).append(bill.getString("billno")).append("\uff0c").append(ResManager.loadKDString((String)"\u5355\u636eID\uff1a", (String)"SctmFiServiceImpl_24", (String)"scmc-sctm-mservice", (Object[])new Object[0])).append(bill.getPkValue());
                    trackLog.warn(result.toString());
                }
            }
        }
    }
}

