/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sctm.mservice;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.business.service.TrackLogService;
import kd.mpscmm.msbd.common.utils.DateUtils;
import kd.scmc.sctm.mservice.SctmPoServiceImpl;

public class SctmPoFiValidateService {
    private static final Log log = LogFactory.getLog(SctmPoFiValidateService.class);
    private static final TrackLogService trackLog = new TrackLogService(SctmPoFiValidateService.class, "sctm");

    public Map<String, String> verifyPayPrePayAmount(List<Map<String, Object>> paramList) {
        trackLog.startInfo(SerializationUtils.toJsonString(paramList));
        HashMap<String, String> result = new HashMap<String, String>(3);
        result.put("code", "0");
        result.put("errorInfo", "");
        if (paramList == null || paramList.isEmpty()) {
            return result;
        }
        HashSet<Long> payEntryIdSet = new HashSet<Long>(10);
        HashMap<Long, BigDecimal> refundPoAndAmount = new HashMap<Long, BigDecimal>(10);
        for (Map<String, Object> param : paramList) {
            Object coreBillType;
            Object paymentBizType;
            Object sourceBillType;
            if (param == null || param.isEmpty() || (sourceBillType = param.get("sourceBillType")) == null || !"sctm_scpo".equals(sourceBillType) || (paymentBizType = param.get("paymentBizType")) == null || !"202".equals(paymentBizType) || (coreBillType = param.get("coreBillType")) == null || !"sctm_scpo".equals(coreBillType)) continue;
            Object coreBillId = param.get("coreBillId");
            Object coreBillEntryId = param.get("coreBillEntryId");
            Object refundAmt = param.get("refundAmt");
            if (coreBillId == null || coreBillEntryId == null || refundAmt == null) continue;
            BigDecimal billSumrefundAmt = refundPoAndAmount.get(coreBillId) == null ? BigDecimal.ZERO : (BigDecimal)refundPoAndAmount.get(coreBillId);
            BigDecimal refundAmtDecimal = refundAmt instanceof BigDecimal ? (BigDecimal)refundAmt : new BigDecimal(refundAmt.toString());
            billSumrefundAmt = billSumrefundAmt.add(refundAmtDecimal.negate());
            refundPoAndAmount.put((Long)coreBillId, billSumrefundAmt);
            payEntryIdSet.add((Long)coreBillEntryId);
        }
        if (payEntryIdSet.isEmpty() || refundPoAndAmount.isEmpty()) {
            return result;
        }
        Map<Long, Map<String, Object>> poInfoMap = this.queryPo(payEntryIdSet, "sctm_scpo");
        if (poInfoMap.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u7684\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SctmPoFiValidateService_0", (String)"scmc-sctm-mservice", (Object[])new Object[0]);
            result.put("code", "1");
            result.put("errorInfo", msg);
            return result;
        }
        String errormsg = this.compareAmount(refundPoAndAmount, poInfoMap);
        if (StringUtils.isNotBlank((CharSequence)errormsg)) {
            result.put("code", "1");
            result.put("errorInfo", errormsg);
        }
        return result;
    }

    private Map<Long, Map<String, Object>> queryPo(Set<Long> payEntryIdSet, String scpoEntity) {
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(10);
        QFilter poPayEntryIdFilter = new QFilter("billentry_pay.id", "in", payEntryIdSet);
        QFilter isPrePayFilter = new QFilter("billentry_pay.isprepay", "=", (Object)Boolean.TRUE);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)scpoEntity, (String)"id,isallowoverpay,billentry_pay.id as payentryid , billentry_pay.payamount as prepayamount, billentry_pay.joinpayamount as joinpayamount", (QFilter[])new QFilter[]{isPrePayFilter, poPayEntryIdFilter}, null);){
            for (Row row : dataSet) {
                HashMap<Long, HashMap<String, BigDecimal>> payEntryInfos;
                Long id = row.getLong("id");
                HashMap<String, Serializable> poInfo = (HashMap<String, Serializable>)result.get(id);
                if (poInfo == null) {
                    poInfo = new HashMap<String, Serializable>(6);
                    poInfo.put("isallowoverpay", row.getBoolean("isallowoverpay"));
                    payEntryInfos = new HashMap<Long, HashMap<String, BigDecimal>>();
                } else {
                    payEntryInfos = (HashMap<Long, HashMap<String, BigDecimal>>)poInfo.get("payentryinfo");
                }
                HashMap<String, BigDecimal> payEntryInfo = new HashMap<String, BigDecimal>(3);
                payEntryInfo.put("prepayamount", row.getBigDecimal("prepayamount"));
                payEntryInfo.put("joinpayamount", row.getBigDecimal("joinpayamount"));
                payEntryInfos.put(row.getLong("payentryid"), payEntryInfo);
                poInfo.put("payentryinfo", payEntryInfos);
                result.put(id, poInfo);
            }
        }
        return result;
    }

    private String compareAmount(Map<Long, BigDecimal> refundPoAndAmount, Map<Long, Map<String, Object>> poInfoMap) {
        for (Map.Entry<Long, Map<String, Object>> poInfoEntry : poInfoMap.entrySet()) {
            BigDecimal sumRefundAmt;
            BigDecimal result;
            Long poId = poInfoEntry.getKey();
            Map<String, Object> poInfo = poInfoEntry.getValue();
            Object isallowoverpay = poInfo.get("isallowoverpay");
            if (isallowoverpay instanceof Boolean && ((Boolean)isallowoverpay).booleanValue()) continue;
            BigDecimal sumJoinPayAmount = BigDecimal.ZERO;
            BigDecimal sumPayAmount = BigDecimal.ZERO;
            Map payentryinfo = (Map)poInfo.get("payentryinfo");
            if (payentryinfo != null && !payentryinfo.isEmpty()) {
                for (Map.Entry entry : payentryinfo.entrySet()) {
                    Map onePayEntry = (Map)entry.getValue();
                    BigDecimal prepayamount = (BigDecimal)onePayEntry.get("prepayamount");
                    BigDecimal joinpayamount = (BigDecimal)onePayEntry.get("joinpayamount");
                    if (joinpayamount.compareTo(BigDecimal.ZERO) < 0) {
                        String msg = ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u5173\u8054\u7684\u4ed8\u6b3e\u5355\u53cd\u5199\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u6570\u636e\u5f02\u5e38\uff1a\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u5c0f\u4e8e\u96f6\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u3002", (String)"SctmPoFiValidateService_1", (String)"scmc-sctm-mservice", (Object[])new Object[0]);
                        return msg;
                    }
                    if (prepayamount.compareTo(joinpayamount) < 0) {
                        String msg = ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u5173\u8054\u7684\u4ed8\u6b3e\u5355\u53cd\u5199\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u6570\u636e\u5f02\u5e38\uff1a\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u4ed8\u6b3e\u91d1\u989d\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u3002", (String)"SctmPoFiValidateService_3", (String)"scmc-sctm-mservice", (Object[])new Object[0]);
                        return msg;
                    }
                    sumJoinPayAmount = sumJoinPayAmount.add(joinpayamount);
                    sumPayAmount = sumPayAmount.add(prepayamount);
                }
            }
            if ((result = (sumRefundAmt = refundPoAndAmount.get(poId) == null ? BigDecimal.ZERO : refundPoAndAmount.get(poId)).add(sumJoinPayAmount)).compareTo(sumPayAmount) <= 0) continue;
            String msg = ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u5173\u8054\u7684\u4ed8\u6b3e\u5355\u53cd\u5199\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u6570\u636e\u5f02\u5e38\uff1a\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u4ed8\u6b3e\u91d1\u989d\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u3002", (String)"SctmPoFiValidateService_3", (String)"scmc-sctm-mservice", (Object[])new Object[0]);
            return msg;
        }
        return null;
    }

    public Map<Long, String> payBillOverPayValService(List<Map<String, Object>> params) {
        trackLog.startInfo(SerializationUtils.toJsonString(params));
        Map<Long, String> result = new HashMap<Long, String>(10);
        if (params == null || params.isEmpty()) {
            return result;
        }
        List<Map<String, Object>> payBills = this.getValidPayBills(params);
        if (payBills.isEmpty()) {
            return result;
        }
        HashMap<Long, Set<Long>> queryScPoIds = new HashMap<Long, Set<Long>>(10);
        Map<String, CoreBillInfo> coreBillIdInfoMap = this.getCoreBillDemAndAmount(payBills, queryScPoIds);
        if (coreBillIdInfoMap.isEmpty()) {
            return result;
        }
        SctmPoServiceImpl queryService = new SctmPoServiceImpl();
        List<Map<String, Object>> queryScPoInfo = queryService.queryOverPayParamAndAmount(queryScPoIds);
        if (queryScPoInfo == null || queryScPoInfo.isEmpty()) {
            return null;
        }
        if ((coreBillIdInfoMap = this.filterCoreBillInfo(coreBillIdInfoMap, queryScPoInfo)).isEmpty()) {
            return result;
        }
        coreBillIdInfoMap = this.addCoreBillPaidAmount(coreBillIdInfoMap);
        if ((coreBillIdInfoMap = this.filterOverPayCoreInfo(coreBillIdInfoMap)).isEmpty()) {
            return result;
        }
        if ((coreBillIdInfoMap = this.processTolerance(coreBillIdInfoMap)).isEmpty()) {
            return null;
        }
        result = this.buildErrorMsg(coreBillIdInfoMap);
        return result;
    }

    private Map<Long, String> buildErrorMsg(Map<String, CoreBillInfo> coreBillIdInfoMap) {
        HashMap<Long, String> result = new HashMap<Long, String>(10);
        for (CoreBillInfo coreBillInfo : coreBillIdInfoMap.values()) {
            result.put(coreBillInfo.getPayBillId(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff0c\u6309\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u7684\u4ed8\u6b3e\u5355\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d\u8d85\u8fc7\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355%2$s\u7684\u4ef7\u7a0e\u5408\u8ba1\uff0c\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SctmPoFiValidateService_4", (String)"scmc-sctm-mservice", (Object[])new Object[0]), coreBillInfo.getPayBillNo(), coreBillInfo.getCoreBillNo()));
        }
        return result;
    }

    private Map<String, CoreBillInfo> processTolerance(Map<String, CoreBillInfo> coreBillIdInfoMap) {
        HashSet<String> overToleranceId = new HashSet<String>(16);
        ArrayList params = new ArrayList(16);
        Iterator<Map.Entry<String, CoreBillInfo>> iterator = coreBillIdInfoMap.entrySet().iterator();
        HashMap<Long, Long> supplierMasterIdMap = new HashMap<Long, Long>(10);
        HashMap<Long, Integer> currencyPrecisionMap = new HashMap<Long, Integer>(10);
        this.addSupplierMasterIdAndCurrencyPrecision(coreBillIdInfoMap, supplierMasterIdMap, currencyPrecisionMap);
        while (iterator.hasNext()) {
            Map.Entry<String, CoreBillInfo> next = iterator.next();
            CoreBillInfo coreBillInfo = next.getValue();
            String key = next.getKey();
            BigDecimal paidAmount = coreBillInfo.getPaidAmount();
            BigDecimal currentAmount = coreBillInfo.getCurrentAmount();
            BigDecimal coreTotalAllAmount = coreBillInfo.getCoreTotalAllAmount();
            HashMap<String, Object> param = new HashMap<String, Object>(10);
            param.put("pk", key);
            param.put("bd_supplier", supplierMasterIdMap.get(coreBillInfo.getCoreBillReceiveSupplierId()));
            param.put("controlvalue", paidAmount.add(currentAmount));
            param.put("contrastvalue", coreTotalAllAmount);
            param.put("bd_currency", coreBillInfo.getCoreBillSettleCurrency());
            param.put("precision", currencyPrecisionMap.get(coreBillInfo.getCoreBillSettleCurrency()));
            param.put("bos_org", coreBillInfo.getCoreBillSettleOrgId());
            params.add(param);
        }
        if (!params.isEmpty()) {
            Map results = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"ToleranceMatchService", (String)"getAllResult", (Object[])new Object[]{"cas_paybill", "sctm_scpo", "e_payableamt", "totalallamount", params});
            List overpks = (List)results.get("overpks");
            List failtomatch = (List)results.get("failtomatch");
            if (overpks != null && !overpks.isEmpty()) {
                overToleranceId.addAll(overpks);
            }
            if (failtomatch != null && !failtomatch.isEmpty()) {
                for (String failMatch : failtomatch) {
                    BigDecimal coreTotalAllAmount;
                    CoreBillInfo coreBillInfo = coreBillIdInfoMap.get(failMatch);
                    BigDecimal paidAmount = coreBillInfo.getPaidAmount() == null ? BigDecimal.ZERO : coreBillInfo.getPaidAmount();
                    BigDecimal currentAmount = coreBillInfo.getCurrentAmount() == null ? BigDecimal.ZERO : coreBillInfo.getCurrentAmount();
                    BigDecimal bigDecimal = coreTotalAllAmount = coreBillInfo.getCoreTotalAllAmount() == null ? BigDecimal.ZERO : coreBillInfo.getCoreTotalAllAmount();
                    if (paidAmount.add(currentAmount).compareTo(coreTotalAllAmount) <= 0) continue;
                    overToleranceId.add(failMatch);
                }
            }
        }
        this.retainCoreBillInfo(overToleranceId, coreBillIdInfoMap);
        return coreBillIdInfoMap;
    }

    private void addSupplierMasterIdAndCurrencyPrecision(Map<String, CoreBillInfo> coreBillIdInfoMap, Map<Long, Long> supplierMasterIdMap, Map<Long, Integer> currencyPrecisionMap) {
        HashSet supplierIds = new HashSet(10);
        HashSet currencyIds = new HashSet(10);
        coreBillIdInfoMap.values().forEach(coreBillInfo -> {
            supplierIds.add(coreBillInfo.getCoreBillReceiveSupplierId());
            currencyIds.add(coreBillInfo.getCoreBillSettleCurrency());
        });
        Map supplierDB = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIds)});
        Map currencyDB = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"id,amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "in", currencyIds)});
        if (supplierDB != null && !supplierDB.isEmpty()) {
            supplierDB.values().forEach(supplier -> supplierMasterIdMap.put(supplier.getLong("id"), supplier.getLong("masterid")));
        }
        if (currencyDB != null && !currencyDB.isEmpty()) {
            currencyDB.values().forEach(currency -> currencyPrecisionMap.put(currency.getLong("id"), currency.getInt("amtprecision")));
        }
    }

    private Map<String, CoreBillInfo> filterOverPayCoreInfo(Map<String, CoreBillInfo> coreBillIdInfoMap) {
        Iterator<Map.Entry<String, CoreBillInfo>> iterator = coreBillIdInfoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, CoreBillInfo> next = iterator.next();
            CoreBillInfo coreBillInfo = next.getValue();
            BigDecimal paidAmount = coreBillInfo.getPaidAmount();
            BigDecimal currentAmount = coreBillInfo.getCurrentAmount();
            BigDecimal coreTotalAllAmount = coreBillInfo.getCoreTotalAllAmount();
            if (paidAmount == null || currentAmount == null || coreTotalAllAmount == null || coreTotalAllAmount.compareTo(paidAmount.add(currentAmount)) < 0) continue;
            iterator.remove();
        }
        return coreBillIdInfoMap;
    }

    private Map<String, CoreBillInfo> addCoreBillPaidAmount(Map<String, CoreBillInfo> coreBillIdInfoMap) {
        HashSet<Long> coreBillIdSet = new HashSet<Long>(10);
        Date earliestCoreBillCreateTime = null;
        for (CoreBillInfo coreBillInfo : coreBillIdInfoMap.values()) {
            coreBillIdSet.add(coreBillInfo.getCoreBillId());
            Date coreBillCreateTime = coreBillInfo.getCoreBillCreateTime();
            if (coreBillCreateTime == null) continue;
            if (earliestCoreBillCreateTime == null) {
                earliestCoreBillCreateTime = coreBillCreateTime;
                continue;
            }
            if (!coreBillCreateTime.before(earliestCoreBillCreateTime)) continue;
            earliestCoreBillCreateTime = coreBillCreateTime;
        }
        Map<String, BigDecimal> payBillPaidAmount = this.queryPayBillPaidAmount(coreBillIdSet, earliestCoreBillCreateTime);
        for (Map.Entry<String, CoreBillInfo> entry : coreBillIdInfoMap.entrySet()) {
            String demKey = entry.getKey();
            CoreBillInfo coreBillInfo = entry.getValue();
            BigDecimal paidAmount = payBillPaidAmount.get(demKey) == null ? BigDecimal.ZERO : payBillPaidAmount.get(demKey);
            coreBillInfo.setPaidAmount(paidAmount);
        }
        return coreBillIdInfoMap;
    }

    private Map<String, BigDecimal> queryPayBillPaidAmount(Set<Long> coreBillIdSet, Date earliestCoreBillCreateTime) {
        HashMap<String, BigDecimal> paidAmount = new HashMap<String, BigDecimal>(10);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        filters.add(new QFilter("entry.e_corebillid", "in", coreBillIdSet));
        filters.add(new QFilter("billstatus", "not in", (Object)new String[]{"F", "G", "H", "A"}));
        filters.add(new QFilter("bizdate", ">=", (Object)DateUtils.getStartOfDay((Date)earliestCoreBillCreateTime)));
        List<String> queryFields = this.getQueryPayBillField();
        String selectStr = String.join((CharSequence)",", queryFields);
        try (DataSet payBillDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cas_paybill", (String)selectStr, (QFilter[])filters.toArray(new QFilter[0]), null);){
            DataSet sumPaidAmount = payBillDataSet.groupBy(new String[]{"corebillid", "settleorg", "payee"}).sum("e_payableamt-e_refundamt", "paidamount").finish().select("corebillid,settleorg,payee,paidamount");
            for (Row row : sumPaidAmount) {
                Long coreBillId = row.getLong("corebillid");
                Long settleOrgId = row.getLong("settleorg");
                Long payee = row.getLong("payee");
                BigDecimal paidamount = row.getBigDecimal("paidamount");
                paidAmount.put(this.getValidDemKey(settleOrgId, coreBillId, payee), paidamount);
            }
        }
        return paidAmount;
    }

    private List<String> getQueryPayBillField() {
        ArrayList<String> keys = new ArrayList<String>(10);
        keys.add("entry.e_corebillid as corebillid");
        keys.add("entry.settleorg as settleorg");
        keys.add("entry.e_payableamt as e_payableamt");
        keys.add("entry.e_refundamt as e_refundamt");
        keys.add("payee");
        return keys;
    }

    private Map<String, CoreBillInfo> getCoreBillDemAndAmount(List<Map<String, Object>> payBills, Map<Long, Set<Long>> coreIdSet) {
        HashMap<String, CoreBillInfo> coreBillDemAndPayAmountMap = new HashMap<String, CoreBillInfo>(10);
        for (Map<String, Object> payBill : payBills) {
            if (payBill == null) continue;
            Long payBillId = (Long)payBill.get("id");
            Long payee = (Long)payBill.get("payee");
            String payBillNo = (String)payBill.get("billno");
            List payBillEntry = (List)payBill.get("entry");
            if (payBillEntry == null || payBillEntry.isEmpty()) continue;
            for (Map payBillRow : payBillEntry) {
                Long coreBillId;
                String coreBillEntity = (String)payBillRow.get("e_corebilltype");
                if (coreBillEntity == null || !"sctm_scpo".equals(coreBillEntity) || (coreBillId = (Long)payBillRow.get("e_corebillid")) == null || coreBillId == 0L) continue;
                BigDecimal payableAmt = (BigDecimal)payBillRow.get("e_payableamt");
                BigDecimal refundAmt = (BigDecimal)payBillRow.get("e_refundamt");
                Long settleOrgId = 0L;
                Object settleorg = payBillRow.get("settleorg");
                if (settleorg != null) {
                    Long l = settleOrgId = settleorg instanceof DynamicObject ? (Long)((DynamicObject)settleorg).getPkValue() : (Long)settleorg;
                }
                if (payableAmt == null || refundAmt == null || settleOrgId == 0L) continue;
                String validDemKey = this.getValidDemKey(settleOrgId, coreBillId, payee);
                CoreBillInfo coreBillInfo = (CoreBillInfo)coreBillDemAndPayAmountMap.get(validDemKey);
                if (coreBillInfo == null) {
                    coreBillInfo = new CoreBillInfo(payBillId, payBillNo);
                }
                BigDecimal currentAmount = coreBillInfo.getCurrentAmount() == null ? BigDecimal.ZERO : coreBillInfo.getCurrentAmount();
                coreBillInfo.setCurrentAmount(currentAmount.add(payableAmt.subtract(refundAmt)));
                if (coreBillInfo.getPayBillId() == null) {
                    coreBillInfo.setPayBillId(payBillId);
                }
                if (coreBillInfo.getPayBillNo() == null) {
                    coreBillInfo.setPayBillNo(payBillNo);
                }
                if (coreBillInfo.getCoreBillId() == null) {
                    coreBillInfo.setCoreBillId(coreBillId);
                }
                if (coreBillInfo.getPayBillNo() == null) {
                    coreBillInfo.setPayBillNo(payBillNo);
                }
                coreBillDemAndPayAmountMap.put(validDemKey, coreBillInfo);
                coreIdSet.put(coreBillId, new HashSet(1));
            }
        }
        return coreBillDemAndPayAmountMap;
    }

    private List<Map<String, Object>> getValidPayBills(List<Map<String, Object>> params) {
        ArrayList<Map<String, Object>> payBills = new ArrayList<Map<String, Object>>(10);
        for (Map<String, Object> param : params) {
            Long payee;
            if (param == null || param.isEmpty() || (payee = (Long)param.get("payee")) == null || payee == 0L) continue;
            boolean hasCoreBillInfo = false;
            List payBillEntry = (List)param.get("entry");
            if (payBillEntry == null || payBillEntry.isEmpty()) continue;
            for (Map payBillRow : payBillEntry) {
                Long coreBillId = (Long)payBillRow.get("e_corebillid");
                if (coreBillId == null || coreBillId == 0L) continue;
                hasCoreBillInfo = true;
                break;
            }
            if (!hasCoreBillInfo) continue;
            payBills.add(param);
        }
        return payBills;
    }

    private Map<String, CoreBillInfo> filterCoreBillInfo(Map<String, CoreBillInfo> coreBillInfoMap, List<Map<String, Object>> queryScPoInfo) {
        HashSet<String> poDemKeySet = new HashSet<String>(10);
        for (Map<String, Object> poInfo : queryScPoInfo) {
            Long corePoReceivesupplier;
            Boolean isallowoverpay = (Boolean)poInfo.get("isallowoverpay");
            Long corePoId = (Long)poInfo.get("billid");
            Long settleCurrency = (Long)poInfo.get("settlecurrency");
            Long l = corePoReceivesupplier = poInfo.get("receivesupplier") == null ? Long.valueOf(0L) : (Long)poInfo.get("receivesupplier");
            List entryinfoList = (List)poInfo.get("entryinfo");
            if (entryinfoList == null || entryinfoList.isEmpty()) continue;
            Date createtime = (Date)poInfo.get("createtime");
            String coreBillNo = (String)poInfo.get("billno");
            for (Map entry : entryinfoList) {
                Long settleOrg = entry.get("settleorg") == null ? Long.valueOf(0L) : (Long)entry.get("settleorg");
                BigDecimal amountandtax = entry.get("amountandtax") == null ? BigDecimal.ZERO : (BigDecimal)entry.get("amountandtax");
                String validDemKey = this.getValidDemKey(settleOrg, corePoId, corePoReceivesupplier);
                poDemKeySet.add(validDemKey);
                if (isallowoverpay.booleanValue()) {
                    coreBillInfoMap.remove(validDemKey);
                    continue;
                }
                CoreBillInfo coreBillInfo = coreBillInfoMap.get(validDemKey);
                if (coreBillInfo == null) continue;
                BigDecimal coreTotalAllAmount = coreBillInfo.getCoreTotalAllAmount() == null ? BigDecimal.ZERO : coreBillInfo.getCoreTotalAllAmount();
                coreBillInfo.setCoreTotalAllAmount(coreTotalAllAmount.add(amountandtax));
                if (coreBillInfo.getCoreBillNo() == null) {
                    coreBillInfo.setCoreBillNo(coreBillNo);
                }
                if (coreBillInfo.getCoreBillCreateTime() == null) {
                    coreBillInfo.setCoreBillCreateTime(createtime);
                }
                if (coreBillInfo.getCoreBillSettleCurrency() == null) {
                    coreBillInfo.setCoreBillSettleCurrency(settleCurrency);
                }
                if (coreBillInfo.getCoreBillReceiveSupplierId() == null) {
                    coreBillInfo.setCoreBillReceiveSupplierId(corePoReceivesupplier);
                }
                if (coreBillInfo.getCoreBillSettleOrgId() != null) continue;
                coreBillInfo.setCoreBillSettleOrgId(settleOrg);
            }
        }
        if (!poDemKeySet.isEmpty() && !coreBillInfoMap.isEmpty()) {
            coreBillInfoMap = this.retainCoreBillInfo(poDemKeySet, coreBillInfoMap);
        }
        return coreBillInfoMap;
    }

    private Map<String, CoreBillInfo> retainCoreBillInfo(Set<String> poDemKeySet, Map<String, CoreBillInfo> coreBillInfoMap) {
        Iterator<Map.Entry<String, CoreBillInfo>> iterator = coreBillInfoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            String coreDemKey = iterator.next().getKey();
            if (poDemKeySet.contains(coreDemKey)) continue;
            iterator.remove();
        }
        return coreBillInfoMap;
    }

    private String getValidDemKey(Long settleOrgId, Long billId, Long receivesupplierId) {
        if (settleOrgId == null || billId == null || receivesupplierId == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(settleOrgId).append('_').append(billId).append('_').append(receivesupplierId);
        return sb.toString();
    }

    static class CoreBillInfo {
        private String payBillNo;
        private Long payBillId;
        private BigDecimal currentAmount;
        private BigDecimal paidAmount;
        private Long coreBillId;
        private Long coreBillSettleOrgId;
        private Long coreBillReceiveSupplierId;
        private String coreBillNo;
        private Long coreBillSettleCurrency;
        private BigDecimal coreTotalAllAmount;
        private Date coreBillCreateTime;

        public CoreBillInfo(Long payBillId, String payBillNo) {
            this.payBillId = payBillId;
            this.payBillNo = payBillNo;
        }

        public Long getPayBillId() {
            return this.payBillId;
        }

        public Long getCoreBillSettleCurrency() {
            return this.coreBillSettleCurrency;
        }

        public void setCoreBillSettleCurrency(Long coreBillSettleCurrency) {
            this.coreBillSettleCurrency = coreBillSettleCurrency;
        }

        public Date getCoreBillCreateTime() {
            return this.coreBillCreateTime;
        }

        public void setCoreBillCreateTime(Date coreBillCreateTime) {
            this.coreBillCreateTime = coreBillCreateTime;
        }

        public void setPayBillId(Long payBillId) {
            this.payBillId = payBillId;
        }

        public Long getCoreBillReceiveSupplierId() {
            return this.coreBillReceiveSupplierId;
        }

        public void setCoreBillReceiveSupplierId(Long coreBillReceiveSupplierId) {
            this.coreBillReceiveSupplierId = coreBillReceiveSupplierId;
        }

        public String getPayBillNo() {
            return this.payBillNo;
        }

        public void setPayBillNo(String payBillNo) {
            this.payBillNo = payBillNo;
        }

        public BigDecimal getCurrentAmount() {
            return this.currentAmount;
        }

        public void setCurrentAmount(BigDecimal currentAmount) {
            this.currentAmount = currentAmount;
        }

        public BigDecimal getPaidAmount() {
            return this.paidAmount;
        }

        public void setPaidAmount(BigDecimal paidAmount) {
            this.paidAmount = paidAmount;
        }

        public Long getCoreBillId() {
            return this.coreBillId;
        }

        public void setCoreBillId(Long coreBillId) {
            this.coreBillId = coreBillId;
        }

        public String getCoreBillNo() {
            return this.coreBillNo;
        }

        public void setCoreBillNo(String coreBillNo) {
            this.coreBillNo = coreBillNo;
        }

        public BigDecimal getCoreTotalAllAmount() {
            return this.coreTotalAllAmount;
        }

        public void setCoreTotalAllAmount(BigDecimal coreTotalAllAmount) {
            this.coreTotalAllAmount = coreTotalAllAmount;
        }

        public Long getCoreBillSettleOrgId() {
            return this.coreBillSettleOrgId;
        }

        public void setCoreBillSettleOrgId(Long coreBillSettleOrgId) {
            this.coreBillSettleOrgId = coreBillSettleOrgId;
        }
    }
}

