/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sctm.mservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class SctmPoServiceImpl {
    private static final Log log = LogFactory.getLog(SctmPoServiceImpl.class);

    public Map<Long, Map<String, Object>> querySctmPOQty(List<Long> poBillentryIds) {
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(10);
        if (CommonUtils.isNull(poBillentryIds)) {
            return result;
        }
        HashSet<Long> entryIdSet = new HashSet<Long>(poBillentryIds);
        QFilter poEntryPkFilter = new QFilter("billentry.id", "in", entryIdSet);
        DataSet rows = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sctm_scpo", (String)"billentry.material.masterid as materialmasterid,billentry.baseunit as baseunitid,billentry.baseqty as baseqty,billentry.receivebaseqtyup as receivebaseqtyup,id,billentry.id as entryid", (QFilter[])new QFilter[]{poEntryPkFilter}, null);
        for (Row row : rows) {
            Long materialId = row.getLong("materialmasterid");
            Long baseunitId = row.getLong("baseunitid");
            BigDecimal receivebaseqtyup = row.getBigDecimal("receivebaseqtyup");
            Long entryid = row.getLong("entryid");
            if (receivebaseqtyup == null || receivebaseqtyup.compareTo(BigDecimal.ZERO) == 0) {
                receivebaseqtyup = row.getBigDecimal("baseqty");
            }
            HashMap<String, Number> map = new HashMap<String, Number>(5);
            map.put("materialmasterid", materialId);
            map.put("baseunitid", baseunitId);
            map.put("receivebaseqtyup", receivebaseqtyup);
            result.put(entryid, map);
        }
        return result;
    }

    public List<Map<String, Object>> queryOverPayParamAndAmount(Map<Long, Set<Long>> poidAndEntryIdMap) {
        QFilter poidFilter;
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        log.info("\u67e5\u8be2\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u8d85\u989d\u4ed8\u6b3e\u53c2\u6570 \u5165\u53c2\u4e3a\uff1a" + poidAndEntryIdMap);
        if (CommonUtils.isNull(poidAndEntryIdMap)) {
            return result;
        }
        ArrayList<Long> hasNoEntryIdPoIds = new ArrayList<Long>(10);
        HashMap<Long, Set<Long>> hasEntryIdAndPoIdMap = new HashMap<Long, Set<Long>>(10);
        for (Map.Entry<Long, Set<Long>> entry : poidAndEntryIdMap.entrySet()) {
            Long poId = entry.getKey();
            if (poId == null || poId.compareTo(0L) == 0) continue;
            Set<Long> poEntryIds = entry.getValue();
            if (poEntryIds == null || poEntryIds.isEmpty()) {
                hasNoEntryIdPoIds.add(poId);
                continue;
            }
            hasEntryIdAndPoIdMap.put(poId, poEntryIds);
        }
        poidAndEntryIdMap = null;
        log.info("\u67e5\u8be2\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u8d85\u989d\u4ed8\u6b3e\u53c2\u6570 \u65e0\u5206\u5f55id\u4e3a\uff1a" + hasNoEntryIdPoIds);
        log.info("\u67e5\u8be2\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u8d85\u989d\u4ed8\u6b3e\u53c2\u6570 \u6709\u5206\u5f55id\u4e3a\uff1a" + hasEntryIdAndPoIdMap);
        if ((hasNoEntryIdPoIds == null || hasNoEntryIdPoIds.isEmpty()) && (hasEntryIdAndPoIdMap == null || hasEntryIdAndPoIdMap.isEmpty())) {
            return result;
        }
        DataSet dataSet = null;
        if (hasNoEntryIdPoIds != null && !hasNoEntryIdPoIds.isEmpty()) {
            poidFilter = new QFilter("id", "in", hasNoEntryIdPoIds);
            dataSet = this.queryPoDataSet(poidFilter, null);
        }
        if (hasEntryIdAndPoIdMap != null && !hasEntryIdAndPoIdMap.isEmpty()) {
            poidFilter = new QFilter("id", "in", hasEntryIdAndPoIdMap.keySet());
            DataSet hasEntryIdDataSet = this.queryPoDataSet(poidFilter, this.getHasEntryIdFilter(hasEntryIdAndPoIdMap));
            dataSet = dataSet != null ? dataSet.union(hasEntryIdDataSet).orderBy(new String[]{"id"}) : hasEntryIdDataSet;
        }
        result = this.addPoInfo(result, dataSet);
        return result;
    }

    private QFilter getHasEntryIdFilter(Map<Long, Set<Long>> hasEntryIdAndPoIdMap) {
        QFilter filter = null;
        Collection<Set<Long>> entryIdValues = hasEntryIdAndPoIdMap.values();
        if (hasEntryIdAndPoIdMap != null && !hasEntryIdAndPoIdMap.isEmpty()) {
            HashSet<Long> entryIds = new HashSet<Long>(10);
            for (Map.Entry<Long, Set<Long>> entry : hasEntryIdAndPoIdMap.entrySet()) {
                Set<Long> value;
                if (entry == null || (value = entry.getValue()) == null || value.isEmpty()) continue;
                entryIds.addAll(value);
            }
            filter = new QFilter("billentry.id", "in", entryIds);
        }
        return filter;
    }

    private List<Map<String, Object>> addPoInfo(List<Map<String, Object>> result, DataSet dataSet) {
        HashMap billInfos = new HashMap(10);
        for (Row row : dataSet) {
            Long poEntryId;
            Long id = row.getLong("id");
            Boolean isAllowOverPay = row.getBoolean("isallowoverpay") == null ? Boolean.TRUE : row.getBoolean("isallowoverpay");
            Long settleCurrency = row.getLong("settlecurrency");
            Long invoicesupplier = row.getLong("invoicesupplier");
            Long receivesupplier = row.getLong("receivesupplier");
            String billno = row.getString("billno");
            Date createtime = row.getDate("createtime");
            BigDecimal sumPrePayAmount = row.getBigDecimal("sumprepayamount") == null ? BigDecimal.ZERO : row.getBigDecimal("sumprepayamount");
            HashMap<String, Object> billInfo = (HashMap<String, Object>)billInfos.get(id);
            if (billInfo == null) {
                billInfo = new HashMap<String, Object>(10);
                billInfo.put("billid", id);
                billInfo.put("isallowoverpay", isAllowOverPay);
                billInfo.put("settlecurrency", settleCurrency);
                billInfo.put("invoicesupplier", invoicesupplier);
                billInfo.put("receivesupplier", receivesupplier);
                billInfo.put("sumprepayamount", sumPrePayAmount);
                billInfo.put("billno", billno);
                billInfo.put("createtime", createtime);
                billInfo.put("entryinfo", new ArrayList(10));
            }
            if ((poEntryId = row.getLong("entryid")) == null || poEntryId.compareTo(0L) == 0) continue;
            List entryinfoList = (List)billInfo.get("entryinfo");
            HashMap<String, Number> rowInfoMap = new HashMap<String, Number>(10);
            BigDecimal entryAmount = row.getBigDecimal("amount");
            rowInfoMap.put("entryid", poEntryId);
            rowInfoMap.put("settleorg", row.getLong("settleorg"));
            rowInfoMap.put("amount", entryAmount);
            rowInfoMap.put("amountandtax", row.getBigDecimal("amountandtax"));
            rowInfoMap.put("receivebaseqtyup", row.getBigDecimal("receivebaseqtyup"));
            rowInfoMap.put("baseqty", row.getBigDecimal("baseqty"));
            rowInfoMap.put("seq", row.getInteger("seq"));
            entryinfoList.add(rowInfoMap);
            billInfos.put(id, billInfo);
        }
        if (billInfos == null || billInfos.isEmpty()) {
            return result;
        }
        result.addAll(billInfos.values());
        return result;
    }

    private DataSet queryPoDataSet(QFilter poidFilter, QFilter poEntryIdFilter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(poidFilter);
        if (poEntryIdFilter != null) {
            filters.add(poEntryIdFilter);
        }
        DataSet poHeadDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sctm_scpo", (String)"id,isallowoverpay,invoicesupplier,receivesupplier,settlecurrency,billno,createtime", (QFilter[])new QFilter[]{poidFilter}, null);
        QFilter isPrePayFilter = new QFilter("billentry_pay.isprepay", "=", (Object)Boolean.TRUE);
        DataSet poPayPlanDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sctm_scpo", (String)"id,billentry_pay.payamount as prepayamount", (QFilter[])new QFilter[]{poidFilter, isPrePayFilter}, null);
        poPayPlanDataSet = poPayPlanDataSet.groupBy(new String[]{"id"}).sum("prepayamount").finish().select(new String[]{"id", "prepayamount as sumprepayamount"});
        DataSet headAndPrePayAmountDataSet = poHeadDataSet.leftJoin(poPayPlanDataSet).on("id", "id").select(new String[]{"id", "isallowoverpay", "invoicesupplier", "receivesupplier", "settlecurrency", "billno", "createtime"}, new String[]{"sumprepayamount"}).finish();
        DataSet billEntryDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"sctm_scpo", (String)"id,billentry.entrysettleorg as settleorg,billentry.amount as amount,billentry.amountandtax as amountandtax,billentry.baseqty as baseqty,billentry.receivebaseqtyup as receivebaseqtyup,billentry.id as entryid,billentry.seq as seq", (QFilter[])filters.toArray(new QFilter[0]), (String)"id");
        DataSet dataSet = headAndPrePayAmountDataSet.rightJoin(billEntryDataSet).on("id", "id").select(new String[]{"entryid", "receivebaseqtyup", "baseqty", "amountandtax", "amount", "settleorg", "seq"}, new String[]{"id", "sumprepayamount", "createtime", "isallowoverpay", "invoicesupplier", "receivesupplier", "settlecurrency", "billno"}).finish();
        dataSet = dataSet.orderBy(new String[]{"id"});
        return dataSet;
    }
}

