/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sctm.mservice.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dlock.DLock;
import kd.scmc.sctm.mservice.helper.DealServiceParamHelper;

public class LockHelper {
    public static List<DLock> createDLocks(List<String> keys) {
        if (DealServiceParamHelper.isNullValue(keys)) {
            return null;
        }
        int size = keys.size();
        ArrayList<DLock> dLocks = new ArrayList<DLock>(size);
        for (String key : keys) {
            DLock dLock = DLock.create((String)key);
            dLocks.add(dLock);
        }
        return dLocks;
    }

    public static boolean tryDLocks(List<DLock> dLocks, Long timeoutMillis) {
        boolean isTry = true;
        if (DealServiceParamHelper.isNullValue(dLocks)) {
            return isTry;
        }
        long time = 0L;
        time = timeoutMillis == null ? 60000L : timeoutMillis;
        for (DLock dLock : dLocks) {
            if (dLock.tryLock(time)) continue;
            isTry = false;
            break;
        }
        return isTry;
    }

    public static void unDLocks(List<DLock> dLocks) {
        if (DealServiceParamHelper.isNullValue(dLocks)) {
            return;
        }
        for (DLock dLock : dLocks) {
            dLock.unlock();
        }
    }
}

