/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sctm.mservice.kdtx.fi;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.business.helper.DefaultEcServiceIdempotentPropHelper;
import kd.mpscmm.msbd.business.service.TrackLogService;
import kd.scmc.sctm.mservice.SctmFiServiceImpl;
import kd.scmc.sctm.mservice.helper.DealServiceParamHelper;

public class WbPayAmount4SctmService
extends BaseECService
implements IdempotentService {
    private static final Log log = LogFactory.getLog(WbPayAmount4SctmService.class);
    private static final TrackLogService trackLog = new TrackLogService(WbPayAmount4SctmService.class, "sctm");
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final String ENTITY_CONM_PURCONTRACT = "conm_purcontract";
    private static final String ENTITY_AP_PAYAPPLY = "ap_payapply";
    private static final String KEY_LIST = "list";
    private static final String KEY_SETTLERELATION = "settleRelation";
    private static final String KEY_PAYBILL_PAYTYPE_BIZTYPE = "paybill_paytype_biztype";
    private static final String KEY_RECBILL_RECTYPE_BIZTYPE = "recbill_rectype_biztype";
    private static final String KEY_PAYBILL_BILLSTATUS = "paybill_billstatus";
    private static final String KEY_PAYBILL_SRCBILLENTITY = "paybill_srcbillentity";
    private static final String KEY_APBILL_MAINBILLENTITY = "apbill_mainbillentity";
    private static final String KEY_APBILL_MAINBILLID = "apbill_mainbillid";
    private static final String KEY_APBILL_MAINBILLENTRYID = "apbill_mainbillentryid";
    private static final String KEY_PAYBILL_MAINBILLENTITY = "paybill_mainbillentity";
    private static final String KEY_PAYBILL_MAINBILLID = "paybill_mainbillid";
    private static final String KEY_PAYBILL_MAINBILLENTRYID = "paybill_mainbillentryid";
    private static final String ENUM_SETTLETYPE_APPAY = "appaysettle";
    private static final String ENUM_SETTLETYPE_APREC = "aprecsettle";
    private static final String ENUM_SETTLETYPE_PAYREC = "payrecsettle";
    private static final String ENUM_SETTLETYPE_PAYSELF = "payself";
    private static final String ENUM_SETTLETYPE_APAR = "aparsettle";
    private static final String ENUM_SETTLETYPE_ARAP = "arapsettle";
    private static final String ENUM_SETTLETYPE_APTRANS = "paytrans";
    private static final String ENUM_SETTLETYPE_LIQ = "liqsettle";
    private static final String ENUM_PAYTYPE_BIZTYPE_PREPAY = "202";
    private static final String ENUM_PAYTYPE_BIZTYPE_OTHER = "other";
    private static final String ENUM_RECTYPE_BIZTYPE_REFUNDPREPAY = "103";
    private static final String ENUM_RECTYPE_BIZTYPE_OTHER = "other";
    private static final String ENUM_BILLSTATUS_REFUND = "I";
    private static final String ENUM_BILLSTATUS_BANKRENOTE = "F";
    private static final String ENUM_BILLSTATUS_OTHER = "other";
    private static final String KEY_MAINBILLENTITY = "mainbillentity";
    private static final String KEY_MAINBILLID = "mainbillid";
    private static final String KEY_MAINBILLENTRYID = "mainbillentryid";
    private static final String SUCCESS = "success";
    private static final String MESSAGE = "message";

    public DtxResponse doExecute(Object param, Object lastReturn) {
        log.info("scmc-sctm-WbPayAmountService begin\uff1a");
        if (!(param instanceof CommonParam)) {
            log.info("param exception");
            trackLog.endInfo("param exception");
            return DealServiceParamHelper.buildDtxResult(Boolean.FALSE, ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u5f02\u5e38", (String)"WbPayAmount4SctmService_0", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
        }
        Map paramMap = ((CommonParam)param).getAll();
        if (paramMap == null || paramMap.isEmpty()) {
            log.info("param exception is null");
            trackLog.endInfo("param exception is null");
            return DealServiceParamHelper.buildDtxResult(Boolean.FALSE, ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"WbPayAmount4SctmService_1", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
        }
        trackLog.startInfo(SerializationUtils.toJsonString((Object)paramMap));
        String settleType = (String)paramMap.get(KEY_SETTLERELATION);
        if (StringUtils.isBlank((CharSequence)settleType)) {
            log.info("param exception settletype is null");
            trackLog.endInfo("param exception settletype is null");
            return DealServiceParamHelper.buildDtxResult(Boolean.FALSE, ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u201c\u7ed3\u7b97\u7c7b\u578b\u201d\u4e3a\u7a7a\u3002", (String)"WbPayAmount4SctmService_2", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
        }
        List list = (List)paramMap.get(KEY_LIST);
        if (list == null || list.isEmpty()) {
            log.info("param exception list is null");
            trackLog.endInfo("param exception list is null");
            return DealServiceParamHelper.buildDtxResult(Boolean.FALSE, ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u5f02\u5e38\uff0clist\u96c6\u5408\u4e3a\u7a7a\u3002", (String)"WbPayAmount4SctmService_3", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
        }
        log.info("scmc-sctm-WbPayAmountService param : settletype:" + settleType + ",list:" + list);
        for (Map map : list) {
            Object billStatus;
            Object recTypeBizType;
            Object payTypeBizType = map.get(KEY_PAYBILL_PAYTYPE_BIZTYPE);
            if (payTypeBizType != null && !ENUM_PAYTYPE_BIZTYPE_PREPAY.equals(payTypeBizType)) {
                map.put(KEY_PAYBILL_PAYTYPE_BIZTYPE, "other");
            }
            if ((recTypeBizType = map.get(KEY_RECBILL_RECTYPE_BIZTYPE)) != null && !ENUM_RECTYPE_BIZTYPE_REFUNDPREPAY.equals(recTypeBizType)) {
                map.put(KEY_RECBILL_RECTYPE_BIZTYPE, "other");
            }
            if ((billStatus = map.get(KEY_PAYBILL_BILLSTATUS)) == null || ENUM_BILLSTATUS_BANKRENOTE.equals(billStatus) || ENUM_BILLSTATUS_REFUND.equals(billStatus)) continue;
            map.put(KEY_PAYBILL_BILLSTATUS, "other");
        }
        Map<String, Object> result = this.updatePurOrder(settleType, list);
        if (result == null || result.isEmpty()) {
            String msg = "execute PurFiServiceImpl exception\uff1aresult is null";
            trackLog.endInfo(msg);
            log.info("scmc-pm-WbApQtyAndAmountService end.");
            return DealServiceParamHelper.buildDtxResult(Boolean.FALSE, msg);
        }
        log.info("scmc-sctm-WbPayAmountService end.");
        trackLog.endInfo(SerializationUtils.toJsonString(result));
        return DealServiceParamHelper.buildDtxResult((Boolean)result.get(SUCCESS), (String)result.get(MESSAGE));
    }

    private Map<String, Object> updatePurOrder(String settleType, List<Map<String, Object>> list) {
        switch (settleType) {
            case "appaysettle": {
                return this.batchWbByApPay(list);
            }
            case "aprecsettle": {
                return this.batchWbByApRec(list);
            }
            case "payrecsettle": {
                return this.batchWbByPayRec(list);
            }
            case "payself": {
                return this.batchWbByPaySelf(list);
            }
            case "aparsettle": 
            case "arapsettle": 
            case "paytrans": 
            case "liqsettle": {
                return this.batchWbByApAr(list);
            }
        }
        log.info("param exception settletype is not right");
        return DealServiceParamHelper.buildResult(Boolean.FALSE, ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u5f02\u5e38\uff0c\u7ed3\u7b97\u7c7b\u578b\u4e0d\u5728\u6807\u51c6\u4ea7\u54c1\u9884\u7f6e\u8303\u56f4\u5185\u3002", (String)"WbPayAmount4SctmService_4", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
    }

    private Map<String, Object> batchWbByApPay(List<Map<String, Object>> list) {
        boolean isUpdate = false;
        Map<String, List<Map>> bizTypeMap = list.stream().filter(map -> map.get(KEY_PAYBILL_PAYTYPE_BIZTYPE) != null && "sctm_scpo".equals(map.get(KEY_APBILL_MAINBILLENTITY))).collect(Collectors.groupingBy(map -> (String)map.get(KEY_PAYBILL_PAYTYPE_BIZTYPE)));
        if (DealServiceParamHelper.isNullValue(bizTypeMap)) {
            log.info("param exception paybill_paytype_biztype is null");
            return DealServiceParamHelper.buildResult(Boolean.FALSE, ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u5f02\u5e38\uff0c\u4ed8\u6b3e\u5355\u7684\u4ed8\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"WbPayAmount4SctmService_5", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
        }
        SctmFiServiceImpl fiService = new SctmFiServiceImpl();
        for (Map.Entry<String, List<Map>> map2 : bizTypeMap.entrySet()) {
            ArrayList<Map<String, Object>> serviceParamList;
            String payTypeBizType = map2.getKey();
            List<Map> paramList = map2.getValue();
            if (DealServiceParamHelper.isNullValue(payTypeBizType) || DealServiceParamHelper.isNullValue(paramList)) continue;
            if (ENUM_PAYTYPE_BIZTYPE_PREPAY.equals(payTypeBizType)) {
                serviceParamList = new ArrayList<Map<String, Object>>(paramList.size());
                for (Map paramMap : paramList) {
                    Object payBillMainBillEntity = paramMap.get(KEY_PAYBILL_MAINBILLENTITY);
                    Object payBillMainBillId = paramMap.get(KEY_PAYBILL_MAINBILLID);
                    if (!DealServiceParamHelper.isNullValue(payBillMainBillId) && (DealServiceParamHelper.isNullValue(payBillMainBillId) || !ENTITY_CONM_PURCONTRACT.equals(payBillMainBillEntity))) continue;
                    paramMap.put(KEY_MAINBILLENTITY, paramMap.get(KEY_APBILL_MAINBILLENTITY));
                    paramMap.put(KEY_MAINBILLID, paramMap.get(KEY_APBILL_MAINBILLID));
                    paramMap.put(KEY_MAINBILLENTRYID, paramMap.get(KEY_APBILL_MAINBILLENTRYID));
                    serviceParamList.add(paramMap);
                }
                if (DealServiceParamHelper.isNullValue(serviceParamList)) continue;
                Map<String, Object> wbPreAmount = fiService.WbPreAmount(serviceParamList);
                if (Boolean.FALSE.equals(wbPreAmount.get(SUCCESS))) {
                    return wbPreAmount;
                }
                isUpdate = true;
                continue;
            }
            if (!"other".equals(payTypeBizType)) continue;
            serviceParamList = new ArrayList(paramList.size());
            for (Map paramMap : paramList) {
                paramMap.put(KEY_MAINBILLENTITY, paramMap.get(KEY_APBILL_MAINBILLENTITY));
                paramMap.put(KEY_MAINBILLID, paramMap.get(KEY_APBILL_MAINBILLID));
                paramMap.put(KEY_MAINBILLENTRYID, paramMap.get(KEY_APBILL_MAINBILLENTRYID));
                serviceParamList.add(paramMap);
            }
            if (DealServiceParamHelper.isNullValue(serviceParamList)) continue;
            Map<String, Object> wbPayAmount = fiService.WbPayAmountOnly(serviceParamList);
            if (Boolean.FALSE.equals(wbPayAmount.get(SUCCESS))) {
                return wbPayAmount;
            }
            isUpdate = true;
        }
        if (isUpdate) {
            return DealServiceParamHelper.buildResult(Boolean.TRUE, ResManager.loadKDString((String)"\u5e94\u4ed8\u4ed8\u6b3e\u7ed3\u7b97\u53cd\u5199\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u6210\u529f\u3002", (String)"WbPayAmount4SctmService_6", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
        }
        return DealServiceParamHelper.buildResult(Boolean.TRUE, ResManager.loadKDString((String)"\u5e94\u4ed8\u4ed8\u6b3e\u7ed3\u7b97\u53cd\u5199\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u4e0d\u6ee1\u8db3\u53cd\u5199\u6761\u4ef6\uff0c\u8df3\u8fc7", (String)"WbPayAmount4SctmService_7", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
    }

    private Map<String, Object> batchWbByApRec(List<Map<String, Object>> list) {
        boolean isUpdate = false;
        Map<String, List<Map>> bizTypeMap = list.stream().filter(map -> map.get(KEY_RECBILL_RECTYPE_BIZTYPE) != null && "sctm_scpo".equals(map.get(KEY_APBILL_MAINBILLENTITY))).collect(Collectors.groupingBy(map -> (String)map.get(KEY_RECBILL_RECTYPE_BIZTYPE)));
        if (DealServiceParamHelper.isNullValue(bizTypeMap)) {
            log.info("param exception recbill_rectype_biztype is null");
            return DealServiceParamHelper.buildResult(Boolean.FALSE, ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u5f02\uff0c\u5e38\u9000\u6b3e\u5355\u7684\u9000\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"WbPayAmount4SctmService_8", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
        }
        SctmFiServiceImpl fiService = new SctmFiServiceImpl();
        for (Map.Entry<String, List<Map>> map2 : bizTypeMap.entrySet()) {
            ArrayList<Map<String, Object>> serviceParamList;
            String recTypeBizType = map2.getKey();
            List<Map> paramList = map2.getValue();
            if (DealServiceParamHelper.isNullValue(recTypeBizType) || DealServiceParamHelper.isNullValue(paramList)) continue;
            if (ENUM_RECTYPE_BIZTYPE_REFUNDPREPAY.equals(recTypeBizType)) {
                serviceParamList = new ArrayList<Map<String, Object>>(paramList.size());
                for (Map paramMap : paramList) {
                    paramMap.put(KEY_MAINBILLENTITY, paramMap.get(KEY_APBILL_MAINBILLENTITY));
                    paramMap.put(KEY_MAINBILLID, paramMap.get(KEY_APBILL_MAINBILLID));
                    paramMap.put(KEY_MAINBILLENTRYID, paramMap.get(KEY_APBILL_MAINBILLENTRYID));
                    serviceParamList.add(paramMap);
                }
                if (DealServiceParamHelper.isNullValue(serviceParamList)) continue;
                Map<String, Object> wbPreAmount = fiService.WbPreAmount(serviceParamList);
                if (!((Boolean)wbPreAmount.get(SUCCESS)).booleanValue()) {
                    return wbPreAmount;
                }
                isUpdate = true;
                continue;
            }
            if (!"other".equals(recTypeBizType)) continue;
            serviceParamList = new ArrayList(paramList.size());
            for (Map paramMap : paramList) {
                paramMap.put(KEY_MAINBILLENTITY, paramMap.get(KEY_APBILL_MAINBILLENTITY));
                paramMap.put(KEY_MAINBILLID, paramMap.get(KEY_APBILL_MAINBILLID));
                paramMap.put(KEY_MAINBILLENTRYID, paramMap.get(KEY_APBILL_MAINBILLENTRYID));
                serviceParamList.add(paramMap);
            }
            if (DealServiceParamHelper.isNullValue(serviceParamList)) continue;
            Map<String, Object> wbPayAmount = fiService.WbPayAmountOnly(serviceParamList);
            if (Boolean.FALSE.equals(wbPayAmount.get(SUCCESS))) {
                return wbPayAmount;
            }
            isUpdate = true;
        }
        if (isUpdate) {
            return DealServiceParamHelper.buildResult(Boolean.TRUE, ResManager.loadKDString((String)"\u5e94\u4ed8\u9000\u6b3e\u7ed3\u7b97\u53cd\u5199\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u6210\u529f\u3002", (String)"WbPayAmount4SctmService_9", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
        }
        return DealServiceParamHelper.buildResult(Boolean.TRUE, ResManager.loadKDString((String)"\u5e94\u4ed8\u9000\u6b3e\u7ed3\u7b97\u53cd\u5199\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u4e0d\u6ee1\u8db3\u53cd\u5199\u6761\u4ef6\uff0c\u8df3\u8fc7", (String)"WbPayAmount4SctmService_10", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
    }

    private Map<String, Object> batchWbByPayRec(List<Map<String, Object>> list) {
        boolean isUpdate = false;
        Map<String, List<Map>> bizTypeMap = list.stream().filter(map -> map.get(KEY_PAYBILL_PAYTYPE_BIZTYPE) != null && "sctm_scpo".equals(map.get(KEY_PAYBILL_MAINBILLENTITY))).collect(Collectors.groupingBy(map -> (String)map.get(KEY_PAYBILL_PAYTYPE_BIZTYPE)));
        if (DealServiceParamHelper.isNullValue(bizTypeMap)) {
            log.info("param exception paybill_paytype_biztype is null");
            return DealServiceParamHelper.buildResult(Boolean.FALSE, ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u5f02\u5e38\uff0c\u4ed8\u6b3e\u5355\u7684\u4ed8\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"WbPayAmount4SctmService_5", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
        }
        SctmFiServiceImpl fiService = new SctmFiServiceImpl();
        List<Map> preParamList = bizTypeMap.get(ENUM_PAYTYPE_BIZTYPE_PREPAY);
        if (preParamList != null && !preParamList.isEmpty()) {
            Map<String, List<Map>> billStatusMap = preParamList.stream().filter(map -> map.get(KEY_PAYBILL_BILLSTATUS) != null).collect(Collectors.groupingBy(map -> (String)map.get(KEY_PAYBILL_BILLSTATUS)));
            if (DealServiceParamHelper.isNullValue(billStatusMap)) {
                log.info("param exception paybill_billstatus is null");
                return DealServiceParamHelper.buildResult(Boolean.FALSE, ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u5f02\u5e38\uff0c\u4ed8\u6b3e\u5355\u7684\u5355\u636e\u72b6\u6001\u4e3a\u7a7a\u3002", (String)"WbPayAmount4SctmService_11", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
            }
            for (Map.Entry<String, List<Map>> map2 : billStatusMap.entrySet()) {
                String billStatus = map2.getKey();
                List<Map> paramList = map2.getValue();
                if (DealServiceParamHelper.isNullValue(billStatus) || DealServiceParamHelper.isNullValue(paramList)) continue;
                if (ENUM_BILLSTATUS_BANKRENOTE.equals(billStatus) || ENUM_BILLSTATUS_REFUND.equals(billStatus)) {
                    Map<String, List<Map>> srcBillEntityMap = paramList.stream().filter(srcMap -> srcMap.get(KEY_PAYBILL_SRCBILLENTITY) != null).collect(Collectors.groupingBy(srcMap -> (String)srcMap.get(KEY_PAYBILL_SRCBILLENTITY)));
                    if (DealServiceParamHelper.isNullValue(srcBillEntityMap)) {
                        log.info("param exception paybill_srcbillentity is null");
                        return DealServiceParamHelper.buildResult(Boolean.FALSE, ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u5f02\u5e38\uff0c\u4ed8\u6b3e\u5355\u7684\u6765\u6e90\u5355\u636e\u5b9e\u4f53\u4e3a\u7a7a\u3002", (String)"WbPayAmount4SctmService_12", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
                    }
                    for (Map.Entry entry : srcBillEntityMap.entrySet()) {
                        Map<String, Object> wbPreAmount;
                        ArrayList<Map<String, Object>> serviceParamList;
                        String srcBillEntity = (String)entry.getKey();
                        List srcParamList = (List)entry.getValue();
                        if (DealServiceParamHelper.isNullValue(srcBillEntity) || DealServiceParamHelper.isNullValue(srcParamList)) continue;
                        if ("sctm_scpo".equals(srcBillEntity)) {
                            serviceParamList = new ArrayList<Map<String, Object>>(srcParamList.size());
                            for (Map paramMap : srcParamList) {
                                paramMap.put(KEY_MAINBILLENTITY, paramMap.get(KEY_PAYBILL_MAINBILLENTITY));
                                paramMap.put(KEY_MAINBILLID, paramMap.get(KEY_PAYBILL_MAINBILLID));
                                paramMap.put(KEY_MAINBILLENTRYID, paramMap.get(KEY_PAYBILL_MAINBILLENTRYID));
                                serviceParamList.add(paramMap);
                            }
                            if (DealServiceParamHelper.isNullValue(serviceParamList)) continue;
                            wbPreAmount = fiService.WbPayPlanJoinAmount(serviceParamList);
                            if (Boolean.FALSE.equals(wbPreAmount.get(SUCCESS))) {
                                return wbPreAmount;
                            }
                            isUpdate = true;
                            continue;
                        }
                        serviceParamList = new ArrayList(srcParamList.size());
                        for (Map paramMap : srcParamList) {
                            paramMap.put(KEY_MAINBILLENTITY, paramMap.get(KEY_PAYBILL_MAINBILLENTITY));
                            paramMap.put(KEY_MAINBILLID, paramMap.get(KEY_PAYBILL_MAINBILLID));
                            paramMap.put(KEY_MAINBILLENTRYID, paramMap.get(KEY_PAYBILL_MAINBILLENTRYID));
                            serviceParamList.add(paramMap);
                        }
                        if (DealServiceParamHelper.isNullValue(serviceParamList)) continue;
                        wbPreAmount = fiService.WbPayPlanPayAmount(serviceParamList);
                        if (Boolean.FALSE.equals(wbPreAmount.get(SUCCESS))) {
                            return wbPreAmount;
                        }
                        isUpdate = true;
                    }
                    continue;
                }
                if (!"other".equals(billStatus)) continue;
                ArrayList<Map<String, Object>> serviceParamList = new ArrayList<Map<String, Object>>(paramList.size());
                for (Map map3 : paramList) {
                    map3.put(KEY_MAINBILLENTITY, map3.get(KEY_PAYBILL_MAINBILLENTITY));
                    map3.put(KEY_MAINBILLID, map3.get(KEY_PAYBILL_MAINBILLID));
                    map3.put(KEY_MAINBILLENTRYID, map3.get(KEY_PAYBILL_MAINBILLENTRYID));
                    serviceParamList.add(map3);
                }
                if (DealServiceParamHelper.isNullValue(serviceParamList)) continue;
                Map<String, Object> wbPayAmount = fiService.WbPayPlanJoinAmount(serviceParamList);
                if (Boolean.FALSE.equals(wbPayAmount.get(SUCCESS))) {
                    return wbPayAmount;
                }
                isUpdate = true;
            }
        }
        if (isUpdate) {
            return DealServiceParamHelper.buildResult(Boolean.TRUE, ResManager.loadKDString((String)"\u4ed8\u6b3e\u51b2\u6536\u6b3e\u7ed3\u7b97\u53cd\u5199\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u6210\u529f\u3002", (String)"WbPayAmount4SctmService_13", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
        }
        return DealServiceParamHelper.buildResult(Boolean.TRUE, ResManager.loadKDString((String)"\u4ed8\u6b3e\u51b2\u6536\u6b3e\u7ed3\u7b97\u53cd\u5199\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u4e0d\u6ee1\u8db3\u53cd\u5199\u6761\u4ef6\uff0c\u8df3\u8fc7", (String)"WbPayAmount4SctmService_14", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
    }

    private Map<String, Object> batchWbByPaySelf(List<Map<String, Object>> list) {
        boolean isUpdate = false;
        Map<String, List<Map>> bizTypeMap = list.stream().filter(map -> map.get(KEY_PAYBILL_PAYTYPE_BIZTYPE) != null && "sctm_scpo".equals(map.get(KEY_PAYBILL_MAINBILLENTITY))).collect(Collectors.groupingBy(map -> (String)map.get(KEY_PAYBILL_PAYTYPE_BIZTYPE)));
        if (DealServiceParamHelper.isNullValue(bizTypeMap)) {
            log.info("param exception paybill_paytype_biztype is null");
            return DealServiceParamHelper.buildResult(Boolean.FALSE, ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u5f02\u5e38\uff0c\u4ed8\u6b3e\u5355\u7684\u4ed8\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"WbPayAmount4SctmService_5", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
        }
        SctmFiServiceImpl fiService = new SctmFiServiceImpl();
        List<Map> preParamList = bizTypeMap.get(ENUM_PAYTYPE_BIZTYPE_PREPAY);
        if (!DealServiceParamHelper.isNullValue(preParamList)) {
            ArrayList<Map<String, Object>> serviceParamList = new ArrayList<Map<String, Object>>(preParamList.size());
            for (Map paramMap : preParamList) {
                paramMap.put(KEY_MAINBILLENTITY, paramMap.get(KEY_PAYBILL_MAINBILLENTITY));
                paramMap.put(KEY_MAINBILLID, paramMap.get(KEY_PAYBILL_MAINBILLID));
                paramMap.put(KEY_MAINBILLENTRYID, paramMap.get(KEY_PAYBILL_MAINBILLENTRYID));
                serviceParamList.add(paramMap);
            }
            if (!DealServiceParamHelper.isNullValue(serviceParamList)) {
                Map<String, Object> wbPayAmount = fiService.WbPayPlanJoinAmount(serviceParamList);
                if (Boolean.FALSE.equals(wbPayAmount.get(SUCCESS))) {
                    return wbPayAmount;
                }
                isUpdate = true;
            }
        }
        if (isUpdate) {
            return DealServiceParamHelper.buildResult(Boolean.TRUE, ResManager.loadKDString((String)"\u4ed8\u6b3e\u7ea2\u84dd\u5bf9\u51b2\u7ed3\u7b97\u53cd\u5199\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u6210\u529f\u3002", (String)"WbPayAmount4SctmService_15", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
        }
        return DealServiceParamHelper.buildResult(Boolean.TRUE, ResManager.loadKDString((String)"\u4ed8\u6b3e\u7ea2\u84dd\u5bf9\u51b2\u7ed3\u7b97\u53cd\u5199\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u4e0d\u6ee1\u8db3\u53cd\u5199\u6761\u4ef6\uff0c\u8df3\u8fc7", (String)"WbPayAmount4SctmService_16", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
    }

    private Map<String, Object> batchWbByApAr(List<Map<String, Object>> list) {
        boolean isUpdate = false;
        SctmFiServiceImpl fiService = new SctmFiServiceImpl();
        ArrayList<Map<String, Object>> serviceParamList = new ArrayList<Map<String, Object>>(list.size());
        for (Map<String, Object> paramMap : list) {
            paramMap.put(KEY_MAINBILLENTITY, paramMap.get(KEY_APBILL_MAINBILLENTITY));
            paramMap.put(KEY_MAINBILLID, paramMap.get(KEY_APBILL_MAINBILLID));
            paramMap.put(KEY_MAINBILLENTRYID, paramMap.get(KEY_APBILL_MAINBILLENTRYID));
            serviceParamList.add(paramMap);
        }
        if (!DealServiceParamHelper.isNullValue(serviceParamList)) {
            Map<String, Object> wbPayAmount = fiService.WbPayAmountOnly(serviceParamList);
            if (Boolean.FALSE.equals(wbPayAmount.get(SUCCESS))) {
                return wbPayAmount;
            }
            isUpdate = true;
        }
        if (isUpdate) {
            return DealServiceParamHelper.buildResult(Boolean.TRUE, ResManager.loadKDString((String)"\u5e94\u4ed8\u51b2\u5e94\u6536\u3001\u5e94\u6536\u51b2\u5e94\u4ed8\u3001\u5e94\u4ed8\u8f6c\u4ed8\u3001\u672a\u6e05\u9879\u7ed3\u7b97\u7b49\u53cd\u5199\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u6210\u529f\u3002", (String)"WbPayAmount4SctmService_17", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
        }
        return DealServiceParamHelper.buildResult(Boolean.TRUE, ResManager.loadKDString((String)"\u5e94\u4ed8\u51b2\u5e94\u6536\u3001\u5e94\u6536\u51b2\u5e94\u4ed8\u3001\u5e94\u4ed8\u8f6c\u4ed8\u3001\u672a\u6e05\u9879\u7ed3\u7b97\u7b49\u53cd\u5199\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u4e0d\u6ee1\u8db3\u53cd\u5199\u6761\u4ef6\uff0c\u8df3\u8fc7", (String)"WbPayAmount4SctmService_18", (String)"scmc-sctm-mservice", (Object[])new Object[0]));
    }

    public IdempotentProperties getIdempotentProperties(Object param, Object lastReturn) {
        return DefaultEcServiceIdempotentPropHelper.generate((String)((Object)((Object)this)).getClass().getName(), (Object)param);
    }
}

