/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sctm.botp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PurOrder2PayApplyConvertPlugin
extends AbstractConvertPlugIn {
    private static final String ENTITY_PURORDERBILL = "sctm_scpo";
    private static final String DT = "billentry";
    public static final String ENTRYSETTLEORG = "entrysettleorg";
    public static final String ENTRYPAYORG = "entrypayorg";

    public void afterConvert(AfterConvertEventArgs e) {
        Map<Long, List<DynamicObject>> targetHeadFieldMap = this.getTargetHeadFieldMap(e);
        if (targetHeadFieldMap.isEmpty()) {
            return;
        }
        Map<Long, List<DynamicObject>> targetRowMap = this.getTargetRowMap(e);
        if (targetRowMap.isEmpty()) {
            return;
        }
        Map<Long, DynamicObject> srcBillData = this.getSrcBillData(targetRowMap.keySet());
        if (srcBillData.isEmpty()) {
            return;
        }
        this.addHeadFields(targetHeadFieldMap, srcBillData);
        this.addFields(targetRowMap, srcBillData);
    }

    private void addHeadFields(Map<Long, List<DynamicObject>> targetHeadFieldMap, Map<Long, DynamicObject> srcBillData) {
        for (Map.Entry<Long, DynamicObject> headMap : srcBillData.entrySet()) {
            DynamicObject billField = headMap.getValue();
            List<DynamicObject> list = targetHeadFieldMap.get(headMap.getKey());
            if (list == null) continue;
            this.batchHeadFieldSet(list, billField);
        }
    }

    private void batchHeadFieldSet(List<DynamicObject> list, DynamicObject billField) {
        String payorgKey = "payorg";
        String settleOrgKey = "settleorg";
        DynamicObject payOrg = billField.getDynamicObject(ENTRYPAYORG);
        DynamicObject settleOrg = billField.getDynamicObject(ENTRYSETTLEORG);
        for (DynamicObject dynamicObject : list) {
            dynamicObject.set(payorgKey, (Object)payOrg);
            dynamicObject.set(settleOrgKey, (Object)settleOrg);
        }
    }

    private void addFields(Map<Long, List<DynamicObject>> targetRowMap, Map<Long, DynamicObject> srcBillData) {
        for (Map.Entry<Long, DynamicObject> entry : srcBillData.entrySet()) {
            DynamicObject srcRowData = entry.getValue();
            List<DynamicObject> list = targetRowMap.get(entry.getKey());
            if (list == null) continue;
            this.batchSet(list, srcRowData);
        }
    }

    private void batchSet(List<DynamicObject> list, DynamicObject row) {
    }

    private Map<Long, DynamicObject> getSrcBillData(Set<Long> keySet) {
        QFilter qFilter = new QFilter("id", "in", keySet);
        DynamicObject[] loadBills = BusinessDataServiceHelper.load((String)ENTITY_PURORDERBILL, (String)this.getSelectProperties(), (QFilter[])qFilter.toArray());
        if (loadBills == null) {
            return Collections.emptyMap();
        }
        HashMap<Long, DynamicObject> srcBillData = new HashMap<Long, DynamicObject>(loadBills.length << 1);
        for (DynamicObject loadBill : loadBills) {
            Long billId = (Long)loadBill.getPkValue();
            DynamicObjectCollection entry = loadBill.getDynamicObjectCollection(DT);
            if (entry == null || entry.isEmpty()) continue;
            srcBillData.put(billId, (DynamicObject)entry.get(0));
        }
        return srcBillData;
    }

    private String getSelectProperties() {
        return "id,billentry.entrysettleorg,billentry.entrypayorg";
    }

    private Map<Long, List<DynamicObject>> getTargetRowMap(AfterConvertEventArgs e) {
        ExtendedDataEntity[] dataEntities;
        String payApplyBillEntryName = "entry";
        String payApplyMainBillIdKey = "e_corebillid";
        HashMap<Long, List<DynamicObject>> map = new HashMap<Long, List<DynamicObject>>(16);
        for (ExtendedDataEntity extendedDataEntity : dataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(this.getTgtMainType().toString())) {
            DynamicObject bill = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entry = bill.getDynamicObjectCollection(payApplyBillEntryName);
            if (entry == null) continue;
            for (DynamicObject row : entry) {
                long mainBillId = row.getLong(payApplyMainBillIdKey);
                if (mainBillId == 0L) continue;
                ArrayList<DynamicObject> rowList = (ArrayList<DynamicObject>)map.get(mainBillId);
                if (rowList == null) {
                    rowList = new ArrayList<DynamicObject>();
                }
                rowList.add(row);
                map.put(mainBillId, rowList);
            }
        }
        return map;
    }

    private Map<Long, List<DynamicObject>> getTargetHeadFieldMap(AfterConvertEventArgs e) {
        ExtendedDataEntity[] dataEntities;
        String payApplyMainBillIdKey = "sourcebillid";
        HashMap<Long, List<DynamicObject>> map = new HashMap<Long, List<DynamicObject>>(16);
        for (ExtendedDataEntity extendedDataEntity : dataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(this.getTgtMainType().toString())) {
            DynamicObject bill = extendedDataEntity.getDataEntity();
            long mainBillId = bill.getLong(payApplyMainBillIdKey);
            ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)map.get(mainBillId);
            if (list == null) {
                list = new ArrayList<DynamicObject>();
            }
            list.add(bill);
            map.put(mainBillId, list);
        }
        return map;
    }
}

