/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sctm.business;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.mpscmm.msbd.business.helper.BillQuantityHelper;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.mpscmm.msbd.common.enums.ChangeTypeEnum;
import kd.mpscmm.msbd.common.enums.OwnerTypeEnum;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.mspur.business.PoTplHelper;
import kd.scmc.sctm.business.ShowFormHelper;
import kd.scmc.sctm.common.enums.QtyType;
import kd.scmc.sctm.common.enums.SubType;
import kd.scmc.sctm.common.enums.WasteFormula;

public class ScPoHelper {
    private static final String ENTITY_SCBOM = "bd_scbom";

    public static void updateEntryBillStatus(DynamicObject bill, StatusEnum statusEnum) {
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        if (entry == null) {
            return;
        }
        for (DynamicObject row : entry) {
            row.set("subliststatus", (Object)statusEnum.getValue());
        }
    }

    public static void updateAllSubEntry(DynamicObject entryRow) {
        BigDecimal qty = BigDecimalUtil.getNotNull((Object)entryRow.getBigDecimal("qty"));
        BigDecimal baseQty = BigDecimalUtil.getNotNull((Object)entryRow.getBigDecimal("baseqty"));
        DynamicObjectCollection subEntry = entryRow.getDynamicObjectCollection("billentry_sub");
        if (subEntry == null) {
            return;
        }
        for (DynamicObject subEntryRow : subEntry) {
            ScPoHelper.updateSubEntryRow(subEntryRow, qty, baseQty);
        }
    }

    public static void updateAllSubQtyRatio(DynamicObject entryRow) {
        BigDecimal baseQty = BigDecimalUtil.getNotNull((Object)entryRow.getBigDecimal("baseqty"));
        DynamicObjectCollection subEntry = entryRow.getDynamicObjectCollection("billentry_sub");
        if (subEntry == null) {
            return;
        }
        for (DynamicObject subEntryRow : subEntry) {
            ScPoHelper.updateSubQtyRatio(subEntryRow, baseQty);
        }
    }

    public static Set<String> updateSubEntryRow(DynamicObject subEntryRow, BigDecimal qty, BigDecimal baseQty) {
        return ScPoHelper.batchSet(subEntryRow, ScPoHelper.calcSubEntryRow(subEntryRow, qty, baseQty));
    }

    public static Set<String> updateSubBaseQty(DynamicObject subEntryRow, BigDecimal baseQty) {
        return ScPoHelper.batchSet(subEntryRow, ScPoHelper.calcSubBaseQty(subEntryRow, subEntryRow.getDynamicObject("submaterial"), subEntryRow.getBigDecimal("subqty"), subEntryRow.getDynamicObject("subunit"), subEntryRow.getDynamicObject("subbaseunit"), baseQty));
    }

    public static Set<String> updateSubQtyRatio(DynamicObject subEntryRow, BigDecimal baseQty) {
        return ScPoHelper.batchSet(subEntryRow, ScPoHelper.calcSubQtyRatio(subEntryRow.getBigDecimal("subbaseqty"), baseQty));
    }

    public static Set<String> updateSubQtyUpDown(DynamicObject subEntryRow, boolean isBase) {
        return ScPoHelper.batchSet(subEntryRow, ScPoHelper.calcSubQtyUpDown(subEntryRow.getBoolean("iscontrolsubqty"), subEntryRow.getBigDecimal("subqty"), subEntryRow.getBigDecimal("subrateup"), subEntryRow.getBigDecimal("subratedown"), subEntryRow.getDynamicObject("subunit"), isBase));
    }

    public static Set<String> updateSubQtyUpDownByRate(DynamicObject subEntryRow, boolean isUp) {
        return ScPoHelper.batchSet(subEntryRow, ScPoHelper.calcSubQtyUpDownByRate(subEntryRow, isUp));
    }

    public static Set<String> updateSubDelGroupQty(DynamicObject row) {
        String subDelGroupQtyKey = "subdelgroupqty";
        BigDecimal baseQty = BigDecimalUtil.getNotNull((Object)row.getBigDecimal("baseqty"));
        BigDecimal minSubDelGroupQty = ScPoHelper.getMinSubDelGroupQty(row.getDynamicObjectCollection("billentry_sub"), baseQty);
        if (minSubDelGroupQty != null) {
            row.set(subDelGroupQtyKey, (Object)minSubDelGroupQty);
            return Collections.singleton(subDelGroupQtyKey);
        }
        return Collections.emptySet();
    }

    public static Set<String> updateSubUnit(DynamicObject subRow) {
        return ScPoHelper.batchSet(subRow, ScPoHelper.getDefaultSubUnit(subRow.getDynamicObject("submaterial")), false);
    }

    public static Map<String, Object> calcSubEntryRow(DynamicObject subEntryRow, BigDecimal qty, BigDecimal baseQty) {
        if (QtyType.VARIABLE.getValue().equals(subEntryRow.getString("qtytype"))) {
            BigDecimal subQty = ScPoHelper.getSubQty(subEntryRow, qty);
            Map<String, Object> map = ScPoHelper.calcSubQtyUpDown(subEntryRow.getBoolean("iscontrolsubqty"), subQty, subEntryRow.getBigDecimal("subrateup"), subEntryRow.getBigDecimal("subratedown"), subEntryRow.getDynamicObject("subunit"), false);
            Map<String, Object> baseMap = ScPoHelper.calcSubBaseQty(subEntryRow, subEntryRow.getDynamicObject("submaterial"), subQty, subEntryRow.getDynamicObject("subunit"), subEntryRow.getDynamicObject("subbaseunit"), baseQty);
            map.put("subqty", subQty);
            map.putAll(baseMap);
            return map;
        }
        return Collections.emptyMap();
    }

    public static Map<String, Object> calcSubQtyUpDown(boolean isControlSubQty, BigDecimal subQty, BigDecimal receiveRateUp, BigDecimal receiveRateDown, DynamicObject subUnit, boolean isBase) {
        String downKey;
        String upKey;
        if (isBase) {
            upKey = "subbaseqtyup";
            downKey = "subbaseqtydown";
        } else {
            upKey = "subqtyup";
            downKey = "subqtydown";
        }
        BigDecimal upValue = subQty;
        BigDecimal downValue = subQty;
        if (isControlSubQty && BigDecimalUtil.isNotBlank((BigDecimal)subQty)) {
            if (receiveRateUp != null) {
                upValue = PoTplHelper.getReceiveQtyUp((BigDecimal)subQty, (BigDecimal)receiveRateUp, (int)BillQuantityHelper.getPrecision((DynamicObject)subUnit), (RoundingMode)ScPoHelper.getSubQtyRoundingMode());
            }
            if (receiveRateDown != null) {
                downValue = PoTplHelper.getReceiveQtyDown((BigDecimal)subQty, (BigDecimal)receiveRateDown, (int)BillQuantityHelper.getPrecision((DynamicObject)subUnit), (RoundingMode)ScPoHelper.getSubQtyRoundingMode());
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put(upKey, upValue);
        map.put(downKey, downValue);
        return map;
    }

    public static Map<String, Object> calcSubQtyUpDownByRate(DynamicObject subEntryRow, boolean isUp) {
        String baseQtyKey;
        String qtyKey;
        String rateKey;
        if (isUp) {
            rateKey = "subrateup";
            qtyKey = "subqtyup";
            baseQtyKey = "subbaseqtyup";
        } else {
            rateKey = "subratedown";
            qtyKey = "subqtydown";
            baseQtyKey = "subbaseqtydown";
        }
        BigDecimal qtyValue = BigDecimalUtil.getNotNull((Object)subEntryRow.getBigDecimal("subqty"));
        BigDecimal baseQtyValue = BigDecimalUtil.getNotNull((Object)subEntryRow.getBigDecimal("subbaseqty"));
        boolean isControlSubQty = subEntryRow.getBoolean("iscontrolsubqty");
        BigDecimal rate = subEntryRow.getBigDecimal(rateKey);
        if (isControlSubQty && BigDecimalUtil.isNotBlank((BigDecimal)rate)) {
            qtyValue = PoTplHelper.getReceiveQtyUpDown((BigDecimal)qtyValue, (BigDecimal)rate, (int)BillQuantityHelper.getPrecision((DynamicObject)subEntryRow.getDynamicObject("subunit")), (RoundingMode)ScPoHelper.getSubQtyRoundingMode(), (boolean)isUp);
            baseQtyValue = PoTplHelper.getReceiveQtyUpDown((BigDecimal)baseQtyValue, (BigDecimal)rate, (int)BillQuantityHelper.getPrecision((DynamicObject)subEntryRow.getDynamicObject("subbaseunit")), (RoundingMode)ScPoHelper.getSubQtyRoundingMode(), (boolean)isUp);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put(qtyKey, qtyValue);
        map.put(baseQtyKey, baseQtyValue);
        return map;
    }

    public static Map<String, Object> calcSubBaseQty(DynamicObject subEntryRow, DynamicObject material, BigDecimal subQty, DynamicObject subUnit, DynamicObject subBaseUnit, BigDecimal baseQty) {
        BigDecimal subBaseQty = null;
        if (material != null && subUnit != null && subBaseUnit != null && BigDecimalUtil.isNotBlank((BigDecimal)subQty)) {
            if (subUnit.getPkValue().equals(subBaseUnit.getPkValue())) {
                subBaseQty = subQty;
            } else {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)material.getPkValue()), (Long)((Long)subUnit.getPkValue()), (Long)((Long)subBaseUnit.getPkValue()));
                if (muConv != null) {
                    int numerator = muConv.getInt("numerator");
                    int denominator = muConv.getInt("denominator");
                    if (denominator != 0) {
                        subBaseQty = subQty.multiply(new BigDecimal(numerator)).divide(new BigDecimal(denominator), ScPoHelper.getPrecision(subBaseUnit), ScPoHelper.getSubQtyRoundingMode());
                    }
                }
            }
        }
        Map<String, Object> map = ScPoHelper.calcSubQtyRatio(subBaseQty, baseQty);
        map.put("subbaseqty", subBaseQty);
        Map<String, Object> upDownMap = ScPoHelper.calcSubQtyUpDown(subEntryRow.getBoolean("iscontrolsubqty"), subBaseQty, subEntryRow.getBigDecimal("subrateup"), subEntryRow.getBigDecimal("subratedown"), subEntryRow.getDynamicObject("subbaseunit"), true);
        map.putAll(upDownMap);
        return map;
    }

    public static Map<String, Object> calcSubQtyRatio(BigDecimal subBaseQty, BigDecimal baseQty) {
        BigDecimal qtyRatio = null;
        if (BigDecimalUtil.isNotBlank((BigDecimal)baseQty) && BigDecimalUtil.isNotBlank((BigDecimal)subBaseQty)) {
            qtyRatio = BigDecimalUtil.divide((BigDecimal)subBaseQty, (BigDecimal)baseQty);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("qtyratio", qtyRatio);
        return map;
    }

    public static BigDecimal calcSubDelGroupQty(DynamicObject subRow, BigDecimal baseQty) {
        return ScPoHelper.calcSubDelGroupQty(baseQty, subRow.getBigDecimal("subbaseqty"), subRow.getBigDecimal("subdelbaseqty"), subRow.getDynamicObject("subbaseunit"));
    }

    public static BigDecimal calcSubDelGroupQty(BigDecimal baseQty, BigDecimal subBaseQty, BigDecimal subDelBaseQty, DynamicObject subBaseUnit) {
        if (BigDecimalUtil.isBlank((BigDecimal)subDelBaseQty) || BigDecimalUtil.isBlank((BigDecimal)baseQty) || BigDecimalUtil.isBlank((BigDecimal)subBaseQty)) {
            return BigDecimalUtil.ZERO;
        }
        return baseQty.multiply(subDelBaseQty).divide(subBaseQty, BillQuantityHelper.getPrecision((DynamicObject)subBaseUnit), BillQuantityHelper.getUnitRoundingMode((DynamicObject)subBaseUnit));
    }

    public static BigDecimal getMinSubDelGroupQty(DynamicObjectCollection subEntry, BigDecimal baseQty) {
        if (subEntry == null) {
            return null;
        }
        return subEntry.stream().filter(subRow -> !ChangeTypeEnum.isCancel((String)subRow.getString("subentrychangetype"))).map(subRow -> ScPoHelper.calcSubDelGroupQty(subRow, baseQty)).reduce(BigDecimal::min).orElse(BigDecimalUtil.ZERO);
    }

    public static int[] getSelectedRow(Control control) {
        if (control instanceof EntryGrid) {
            return ((EntryGrid)control).getSelectRows();
        }
        return new int[0];
    }

    public static List<Long> getSubListIds(EventObject args) {
        return ScPoHelper.getBillIdList(args, "sctm_scposublist");
    }

    public static List<Long> getSubListIds(OperateOption option) {
        return ScPoHelper.getBillIdList(option, "sctm_scposublist");
    }

    public static List<Long> getBillIdList(EventObject args, String billName) {
        return ScPoHelper.str2LongList(ScPoHelper.getCustomParam(args, billName));
    }

    public static List<Long> getBillIdList(OperateOption option, String billName) {
        return ScPoHelper.str2LongList(ScPoHelper.getCustomParam(option, billName));
    }

    public static Set<Long> getBillIdSet(OperateOption option, String billName) {
        return ScPoHelper.str2LongSet(ScPoHelper.getCustomParam(option, billName));
    }

    public static String getNoPushedMessage() {
        return ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"ScPoHelper_0", (String)"scmc-sctm", (Object[])new Object[0]);
    }

    public static String getQueryMaxMessage() {
        return ResManager.loadKDString((String)"\u8d85\u8fc7\u67e5\u8be2\u6570\u91cf\u4e0a\u9650\uff0c\u8bf7\u51cf\u5c11\u67e5\u8be2\u6570\u91cf\u3002", (String)"ScPoHelper_1", (String)"scmc-sctm", (Object[])new Object[0]);
    }

    public static FormShowParameter getImOutShowParameter(EventObject args) {
        List<Long> subListIds = ScPoHelper.getBillIdList(args, "im_osmaterialreqoutbill");
        if (subListIds.isEmpty()) {
            return null;
        }
        if (subListIds.size() == 1) {
            return ShowFormHelper.getBillShowParameter("im_osmaterialreqoutbill", subListIds.get(0), ShowFormHelper.DEFAULT_SHOW_TYPE, OperationStatus.EDIT);
        }
        return ShowFormHelper.getBillListShowParameter("im_osmaterialreqoutbill", subListIds);
    }

    public static FormShowParameter getSubTrackDownShowParameter(EventObject args) {
        List<Long> subListIds = ScPoHelper.getSubListIds(args);
        if (subListIds == null) {
            return null;
        }
        Map<String, List<Long>> billMap = ScPoHelper.getTrackDownBills(subListIds);
        List<Long> trackDownSubListIds = billMap.get("sctm_scposublist");
        if (trackDownSubListIds != null) {
            subListIds.addAll(trackDownSubListIds);
        }
        billMap.put("sctm_scposublist", subListIds);
        return ShowFormHelper.getMultiBillShowParameter(ResManager.loadKDString((String)"\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u53d1\u6599\u67e5\u8be2", (String)"ScPoHelper_2", (String)"scmc-sctm", (Object[])new Object[0]), billMap);
    }

    public static DynamicObject getDefaultUnit(DynamicObject material) {
        if (material == null) {
            return null;
        }
        return material.getDynamicObject("baseunit");
    }

    public static Map<String, Object> getDefaultSubUnit(DynamicObject material) {
        DynamicObject defaultUnit = ScPoHelper.getDefaultUnit(material);
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put("subbaseunit", defaultUnit);
        result.put("subunit", defaultUnit);
        return result;
    }

    public static String getCustomParam(EventObject eventObject, String key) {
        Object source = eventObject.getSource();
        if (source instanceof FormOperate) {
            return ScPoHelper.getCustomParam(((FormOperate)source).getOption(), key);
        }
        return null;
    }

    public static String getCustomParam(OperateOption option, String key) {
        return option.getVariableValue(key, null);
    }

    public static void setCustomParam(EventObject eventObject, String key, String value) {
        Object source = eventObject.getSource();
        if (source instanceof FormOperate) {
            ScPoHelper.setCustomParam(((FormOperate)source).getOption(), key, value);
        }
    }

    public static void setCustomParam(OperateOption option, String key, String value) {
        option.setVariableValue(key, value);
    }

    public static boolean isNotInput(DynamicObject row) {
        return SubType.isNotInput(row.getString("subtype"));
    }

    public static boolean isAudit(FormShowParameter showParameter) {
        if (showParameter instanceof BillShowParameter) {
            BillShowParameter billShowParameter = (BillShowParameter)showParameter;
            BillOperationStatus billStatus = billShowParameter.getBillStatus();
            return BillOperationStatus.AUDIT.equals((Object)billStatus);
        }
        return false;
    }

    public static boolean isExpenseItemLineType(DynamicObject lineType) {
        if (lineType == null) {
            return false;
        }
        DynamicObject attr = lineType.getDynamicObject("serviceattribute");
        if (attr == null) {
            return false;
        }
        return "3001".equals(attr.getString("number"));
    }

    public static boolean isInvOrg(Long orgId) {
        return OrgHelper.checkHasPermissionOrg((String)"sctm_scpo", (String)"05", (Long)orgId, (Long)RequestContext.get().getCurrUserId());
    }

    public static boolean canUpdateSubOwner(String ownerType) {
        return OwnerTypeEnum.OWNERTYPE_ORG.getValue().equals(ownerType);
    }

    public static String collection2Str(Collection<?> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        return list.stream().map(Object::toString).collect(Collectors.joining(","));
    }

    public static List<Long> str2LongList(String str) {
        if (str == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(str.split(",")).map(Long::parseLong).collect(Collectors.toList());
    }

    public static Set<Long> str2LongSet(String str) {
        if (str == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(str.split(",")).map(Long::parseLong).collect(Collectors.toSet());
    }

    private static Map<String, List<Long>> getTrackDownBills(List<Long> subListIds) {
        Map trackDownBills = BFTrackerServiceHelper.findTargetBills((String)"sctm_scposublist", (Long[])subListIds.toArray(new Long[0]));
        if (trackDownBills == null || trackDownBills.isEmpty()) {
            return new HashMap<String, List<Long>>(4);
        }
        LinkedHashMap<String, List<Long>> map = new LinkedHashMap<String, List<Long>>(trackDownBills.size() << 1);
        for (Map.Entry entry : trackDownBills.entrySet()) {
            map.put((String)entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        return map;
    }

    private static Set<String> batchSet(DynamicObject subEntryRow, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            subEntryRow.set(entry.getKey(), entry.getValue());
        }
        return map.keySet();
    }

    private static Set<String> batchSet(DynamicObject subEntryRow, Map<String, Object> map, boolean isCover) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            if (!isCover && subEntryRow.get(key) != null) continue;
            subEntryRow.set(key, entry.getValue());
        }
        return map.keySet();
    }

    private static BigDecimal getSubQty(DynamicObject subEntryRow, BigDecimal qty) {
        String wasteFormula = subEntryRow.getString("wasteformula");
        BigDecimal denominator = subEntryRow.getBigDecimal("qtydenominator");
        if (BigDecimalUtil.isBlank((BigDecimal)qty) || BigDecimalUtil.isBlank((BigDecimal)denominator)) {
            return null;
        }
        BigDecimal numerator = BigDecimalUtil.getNotNull((Object)subEntryRow.getBigDecimal("qtynumerator"));
        BigDecimal scrapRate = BigDecimalUtil.getNotNull((Object)subEntryRow.getBigDecimal("scraprate"));
        int precision = ScPoHelper.getPrecision(subEntryRow.getDynamicObject("subunit"));
        if (WasteFormula.A.getValue().equals(wasteFormula)) {
            if (BigDecimalUtil.equals((BigDecimal)BigDecimalUtil.ONE, (BigDecimal)scrapRate)) {
                return null;
            }
            return BigDecimalUtil.divide((BigDecimal)qty.multiply(numerator), (BigDecimal)denominator).divide(BigDecimalUtil.ONE.subtract(scrapRate), precision, ScPoHelper.getSubQtyRoundingMode());
        }
        if (WasteFormula.B.getValue().equals(wasteFormula)) {
            return BigDecimalUtil.getByGrowRate((BigDecimal)BigDecimalUtil.divide((BigDecimal)qty.multiply(numerator), (BigDecimal)denominator), (BigDecimal)scrapRate).setScale(precision, ScPoHelper.getSubQtyRoundingMode());
        }
        return null;
    }

    private static int getPrecision(DynamicObject unit) {
        return Math.min(BillQuantityHelper.getPrecision((DynamicObject)unit), 10);
    }

    private static RoundingMode getSubQtyRoundingMode() {
        return RoundingMode.UP;
    }

    public static Long getDefaultBom(Long materialMasterid, Long orgId) {
        if (materialMasterid == null || materialMasterid.compareTo(0L) == 0 || orgId == null || orgId.compareTo(0L) == 0) {
            return null;
        }
        QFilter materialFilter = new QFilter("material.id", "=", (Object)materialMasterid);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)ENTITY_SCBOM, (Long)orgId);
        Map boms = BusinessDataServiceHelper.loadFromCache((String)ENTITY_SCBOM, (String)"id,createtime", (QFilter[])new QFilter[]{materialFilter, enableFilter, statusFilter, orgFilter});
        Long defBomId = null;
        if (boms != null && !boms.isEmpty()) {
            Date lastCreateTime = null;
            ArrayList list = new ArrayList(boms.values());
            for (int i = 0; i < list.size(); ++i) {
                DynamicObject bom = (DynamicObject)list.get(i);
                if (bom == null) continue;
                Long id = bom.getLong("id");
                Date createtime = bom.getDate("createtime");
                if (createtime == null) continue;
                if (defBomId == null) {
                    defBomId = id;
                }
                if (lastCreateTime == null) {
                    lastCreateTime = createtime;
                    continue;
                }
                if (!createtime.after(lastCreateTime)) continue;
                lastCreateTime = createtime;
                defBomId = id;
            }
        }
        return defBomId;
    }
}

